/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.invite;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.interfaces.CategoryData;
import io.streamlayer.common.recyclerview.CategoryViewHolder;
import io.streamlayer.common.recyclerview.ShareInviteViewHolder;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemInviteTinodeBinding;
import io.streamlayer.sdk.messaging.invite.DiffUtil;
import io.streamlayer.sdk.messaging.invite.InviteContactsListener;
import io.streamlayer.sdk.model.invites.AnyListItem;
import io.streamlayer.sdk.model.invites.Category;
import io.streamlayer.sdk.model.invites.ShareInvite;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class InviteTinodeAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private InviteContactsListener listener;
    @NotNull
    private List<AnyListItem> listItems;
    @NotNull
    private Set<String> selectionIds;

    public InviteTinodeAdapter(@NotNull InviteContactsListener inviteContactsListener) {
        InviteTinodeAdapter inviteTinodeAdapter2 = this;
        Intrinsics.checkNotNullParameter((Object)inviteContactsListener, (String)"listener");
        inviteTinodeAdapter2.listener = inviteContactsListener;
        inviteTinodeAdapter2.listItems = new ArrayList<AnyListItem>();
        inviteTinodeAdapter2.selectionIds = SetsKt.emptySet();
    }

    public final void setItems(@NotNull List<? extends AnyListItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = androidx.recyclerview.widget.DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil(this.listItems, list));
        InviteTinodeAdapter inviteTinodeAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(DiffUtil(this.listItems, listItems))");
        inviteTinodeAdapter2.listItems.clear();
        inviteTinodeAdapter2.listItems.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)inviteTinodeAdapter2);
    }

    @NotNull
    public final Set<String> getSelectionIds() {
        return this.selectionIds;
    }

    public final void setSelectionIds(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.selectionIds = set;
    }

    public int getItemViewType(int n) {
        block5: {
            int n2;
            block3: {
                block4: {
                    block2: {
                        Object object = object.listItems.get(n);
                        if (!(object instanceof TinodeContact)) break block2;
                        n2 = 0;
                        break block3;
                    }
                    if (!(object instanceof Category)) break block4;
                    n2 = 1;
                    break block3;
                }
                if (!(object instanceof ShareInvite)) break block5;
                n2 = 2;
            }
            return n2;
        }
        throw new Exception("Unsupported View type");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            if (n != 1) {
                ShareInviteViewHolder shareInviteViewHolder;
                if (n != 2) throw new Exception("Unsupported View type");
                viewHolder = shareInviteViewHolder;
                InviteTinodeAdapter inviteTinodeAdapter2 = inviteTinodeAdapter3;
                InviteTinodeAdapter inviteTinodeAdapter3 = ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_share_invite);
                shareInviteViewHolder = new ShareInviteViewHolder((View)inviteTinodeAdapter3, inviteTinodeAdapter2.listener);
                return viewHolder;
            } else {
                CategoryViewHolder categoryViewHolder;
                viewHolder = categoryViewHolder;
                categoryViewHolder = new CategoryViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_category_view));
            }
            return viewHolder;
        } else {
            ViewHolder viewHolder2;
            viewHolder = viewHolder2;
            viewHolder2 = new ViewHolder(inviteTinodeAdapter3, ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_invite_tinode));
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof CategoryViewHolder) {
            ((CategoryViewHolder)viewHolder).bind((CategoryData)((Object)this.listItems.get(n)));
        } else if (viewHolder instanceof ViewHolder) {
            ((ViewHolder)viewHolder).bind((TinodeContact)this.listItems.get(n));
        } else if (viewHolder instanceof ShareInviteViewHolder) {
            ((ShareInviteViewHolder)viewHolder).bind((ShareInvite)this.listItems.get(n));
        }
    }

    public int getItemCount() {
        return this.listItems.size();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemInviteTinodeBinding binding;
        final /* synthetic */ InviteTinodeAdapter this$0;

        public ViewHolder(@NotNull InviteTinodeAdapter inviteTinodeAdapter2, View view2) {
            ViewHolder viewHolder = object;
            Intrinsics.checkNotNullParameter((Object)((Object)inviteTinodeAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            object.this$0 = inviteTinodeAdapter2;
            super(view2);
            Object object = SlrItemInviteTinodeBinding.bind(view2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bind(itemView)");
            viewHolder.binding = object;
        }

        private final void setItemChecked(boolean bl) {
            ViewHolder viewHolder = this;
            viewHolder.binding.messagingInviteCheck.setChecked(bl);
            viewHolder.binding.messagingInviteCheck.setSelected(bl);
        }

        private static final void bind$lambda-1$lambda-0(ViewHolder viewHolder, SlrItemInviteTinodeBinding slrItemInviteTinodeBinding, InviteTinodeAdapter inviteTinodeAdapter2, TinodeContact tinodeContact, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemInviteTinodeBinding, (String)"$this_with");
            Intrinsics.checkNotNullParameter((Object)((Object)inviteTinodeAdapter2), (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)tinodeContact, (String)"$data");
            viewHolder.setItemChecked(slrItemInviteTinodeBinding.messagingInviteCheck.isChecked() ^ true);
            inviteTinodeAdapter2.listener.tinodeSelection(tinodeContact);
        }

        public final void bind(@NotNull TinodeContact tinodeContact) {
            block4: {
                int n;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)tinodeContact, (String)"data");
                        SlrItemInviteTinodeBinding slrItemInviteTinodeBinding = object2.binding;
                        Object object = slrItemInviteTinodeBinding;
                        ViewHolder viewHolder = object2;
                        SlrItemInviteTinodeBinding slrItemInviteTinodeBinding2 = object;
                        InviteTinodeAdapter inviteTinodeAdapter2 = object2.this$0;
                        slrItemInviteTinodeBinding2.getRoot().setOnClickListener(arg_0 -> ViewHolder.bind$lambda-1$lambda-0((ViewHolder)((Object)object2), (SlrItemInviteTinodeBinding)object, inviteTinodeAdapter2, tinodeContact, arg_0));
                        Object object2 = slrItemInviteTinodeBinding2.messagingInviteAvatar;
                        SlrItemInviteTinodeBinding slrItemInviteTinodeBinding3 = object;
                        ViewHolder viewHolder2 = object2;
                        TinodeContact tinodeContact2 = tinodeContact;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"messagingInviteAvatar");
                        object2 = tinodeContact2.getChatName();
                        object = tinodeContact2.getPhotoData();
                        boolean bl = tinodeContact2.getOnline();
                        ProfileExtensionsKt.loadContactAvatarWithStatus((ImageView)viewHolder2, (String)object2, (String)object, bl);
                        slrItemInviteTinodeBinding3.messagingInviteName.setText((CharSequence)tinodeContact.getChatName());
                        viewHolder.setItemChecked(inviteTinodeAdapter2.getSelectionIds().contains(tinodeContact.getChatUserId()));
                        object2 = slrItemInviteTinodeBinding.messagingInviteStatus;
                        n = tinodeContact.getOnline();
                        if (n != 1) break block2;
                        n = R.string.slr_status_online;
                        break block3;
                    }
                    if (n != 0) break block4;
                    n = R.string.slr_status_offline;
                }
                object2.setText(n);
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
    }
}

