/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.advertising;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.advertising.AdvertisingType;
import io.streamlayer.sdk.model.advertising.AdvertisingVideo;
import io.streamlayer.sdk.model.sdksettings.SdkOverlayType;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
public final class AdvertisingData {
    @PrimaryKey(autoGenerate=true)
    private final int id;
    @ColumnInfo(name="parent_id")
    @NotNull
    private final String parentId;
    @NotNull
    private final String type;
    @ColumnInfo(name="template_id")
    @NotNull
    private final String templateId;
    @ColumnInfo(name="overlay_name")
    @NotNull
    private final String overlayName;
    @ColumnInfo(name="overlay_type")
    @NotNull
    private final SdkOverlayType overlayType;
    @ColumnInfo(name="advertising_type")
    @NotNull
    private final AdvertisingType advertisingType;
    private final int frequency;
    private final boolean enable;
    @NotNull
    private final List<AdvertisingImage> images;
    @NotNull
    private final List<AdvertisingVideo> videos;

    public AdvertisingData(int n, @NotNull String string2, @NotNull String string3, @NotNull String string4, @NotNull String string5, @NotNull SdkOverlayType sdkOverlayType, @NotNull AdvertisingType advertisingType, int n2, boolean bl, @NotNull List<AdvertisingImage> list, @NotNull List<AdvertisingVideo> list2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"templateId");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"overlayName");
        Intrinsics.checkNotNullParameter((Object)((Object)sdkOverlayType), (String)"overlayType");
        Intrinsics.checkNotNullParameter((Object)((Object)advertisingType), (String)"advertisingType");
        Intrinsics.checkNotNullParameter(list, (String)"images");
        Intrinsics.checkNotNullParameter(list2, (String)"videos");
        this.id = n;
        this.parentId = string2;
        this.type = string3;
        this.templateId = string4;
        this.overlayName = string5;
        this.overlayType = sdkOverlayType;
        this.advertisingType = advertisingType;
        this.frequency = n2;
        this.enable = bl;
        this.images = list;
        this.videos = list2;
    }

    public /* synthetic */ AdvertisingData(int n, String string2, String string3, String string4, String string5, SdkOverlayType sdkOverlayType, AdvertisingType advertisingType, int n2, boolean bl, List list, List list2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 0x200) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 0x400) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(n, string2, string3, string4, string5, sdkOverlayType, advertisingType, n2, bl, list, list2);
    }

    public static /* synthetic */ AdvertisingData copy$default(AdvertisingData advertisingData, int n, String string2, String string3, String string4, String string5, SdkOverlayType sdkOverlayType, AdvertisingType advertisingType, int n2, boolean bl, List list, List list2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = advertisingData.id;
        }
        if ((n3 & 2) != 0) {
            string2 = advertisingData.parentId;
        }
        if ((n3 & 4) != 0) {
            string3 = advertisingData.type;
        }
        if ((n3 & 8) != 0) {
            string4 = advertisingData.templateId;
        }
        if ((n3 & 0x10) != 0) {
            string5 = advertisingData.overlayName;
        }
        if ((n3 & 0x20) != 0) {
            sdkOverlayType = advertisingData.overlayType;
        }
        if ((n3 & 0x40) != 0) {
            advertisingType = advertisingData.advertisingType;
        }
        if ((n3 & 0x80) != 0) {
            n2 = advertisingData.frequency;
        }
        if ((n3 & 0x100) != 0) {
            bl = advertisingData.enable;
        }
        if ((n3 & 0x200) != 0) {
            list = advertisingData.images;
        }
        if ((n3 & 0x400) != 0) {
            list2 = advertisingData.videos;
        }
        return advertisingData.copy(n, string2, string3, string4, string5, sdkOverlayType, advertisingType, n2, bl, list, list2);
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getParentId() {
        return this.parentId;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getTemplateId() {
        return this.templateId;
    }

    @NotNull
    public final String getOverlayName() {
        return this.overlayName;
    }

    @NotNull
    public final SdkOverlayType getOverlayType() {
        return this.overlayType;
    }

    @NotNull
    public final AdvertisingType getAdvertisingType() {
        return this.advertisingType;
    }

    public final int getFrequency() {
        return this.frequency;
    }

    public final boolean getEnable() {
        return this.enable;
    }

    @NotNull
    public final List<AdvertisingImage> getImages() {
        return this.images;
    }

    @NotNull
    public final List<AdvertisingVideo> getVideos() {
        return this.videos;
    }

    public final int component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.parentId;
    }

    @NotNull
    public final String component3() {
        return this.type;
    }

    @NotNull
    public final String component4() {
        return this.templateId;
    }

    @NotNull
    public final String component5() {
        return this.overlayName;
    }

    @NotNull
    public final SdkOverlayType component6() {
        return this.overlayType;
    }

    @NotNull
    public final AdvertisingType component7() {
        return this.advertisingType;
    }

    public final int component8() {
        return this.frequency;
    }

    public final boolean component9() {
        return this.enable;
    }

    @NotNull
    public final List<AdvertisingImage> component10() {
        return this.images;
    }

    @NotNull
    public final List<AdvertisingVideo> component11() {
        return this.videos;
    }

    @NotNull
    public final AdvertisingData copy(int n, @NotNull String string2, @NotNull String string3, @NotNull String string4, @NotNull String string5, @NotNull SdkOverlayType sdkOverlayType, @NotNull AdvertisingType advertisingType, int n2, boolean bl, @NotNull List<AdvertisingImage> list, @NotNull List<AdvertisingVideo> list2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"templateId");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"overlayName");
        Intrinsics.checkNotNullParameter((Object)((Object)sdkOverlayType), (String)"overlayType");
        Intrinsics.checkNotNullParameter((Object)((Object)advertisingType), (String)"advertisingType");
        Intrinsics.checkNotNullParameter(list, (String)"images");
        Intrinsics.checkNotNullParameter(list2, (String)"videos");
        return new AdvertisingData(n, string2, string3, string4, string5, sdkOverlayType, advertisingType, n2, bl, list, list2);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdvertisingData(id=").append(this.id).append(", parentId=").append(this.parentId).append(", type=").append(this.type).append(", templateId=").append(this.templateId).append(", overlayName=").append(this.overlayName).append(", overlayType=").append((Object)this.overlayType).append(", advertisingType=").append((Object)this.advertisingType).append(", frequency=").append(this.frequency).append(", enable=").append(this.enable).append(", images=").append(this.images).append(", videos=").append(this.videos).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        AdvertisingData advertisingData = this;
        int n = (((((((Integer.hashCode(advertisingData.id) * 31 + this.parentId.hashCode()) * 31 + this.type.hashCode()) * 31 + this.templateId.hashCode()) * 31 + this.overlayName.hashCode()) * 31 + this.overlayType.hashCode()) * 31 + this.advertisingType.hashCode()) * 31 + Integer.hashCode(this.frequency)) * 31;
        int n2 = advertisingData.enable ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return ((n + n2) * 31 + ((Object)this.images).hashCode()) * 31 + ((Object)this.videos).hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdvertisingData)) {
            return false;
        }
        object = (AdvertisingData)object;
        if (this.id != ((AdvertisingData)object).id) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parentId, (Object)((AdvertisingData)object).parentId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((AdvertisingData)object).type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.templateId, (Object)((AdvertisingData)object).templateId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.overlayName, (Object)((AdvertisingData)object).overlayName)) {
            return false;
        }
        if (this.overlayType != ((AdvertisingData)object).overlayType) {
            return false;
        }
        if (this.advertisingType != ((AdvertisingData)object).advertisingType) {
            return false;
        }
        if (this.frequency != ((AdvertisingData)object).frequency) {
            return false;
        }
        if (this.enable != ((AdvertisingData)object).enable) {
            return false;
        }
        if (!Intrinsics.areEqual(this.images, ((AdvertisingData)object).images)) {
            return false;
        }
        return Intrinsics.areEqual(this.videos, ((AdvertisingData)object).videos);
    }
}

