/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.Index;
import com.google.gson.annotations.SerializedName;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity(indices={@Index(value={"chatMessageTopicId", "uuid", "date", "text"})}, primaryKeys={"chatMessageTopicId", "uuid"})
public final class ChatMessage {
    @ColumnInfo(name="chatMessageTopicId")
    @NotNull
    private final String topicId;
    @SerializedName(value="senderId")
    @NotNull
    private final String senderUserId;
    @SerializedName(value="seq")
    @ColumnInfo(name="remoteSeqId")
    private int seqId;
    @Nullable
    private final Date date;
    @NotNull
    private final String text;
    @SerializedName(value="x-slr-type")
    @NotNull
    private final String type;
    @SerializedName(value="x-slr-subtype")
    @NotNull
    private final String subtype;
    @SerializedName(value="x-slr-reply")
    @NotNull
    private final String replyTo;
    @NotNull
    private ChatMessageStatus status;
    @SerializedName(value="head")
    @Ignore
    @Nullable
    private Map<String, String> head;
    @ColumnInfo(name="uuid")
    @NotNull
    private String id;
    @Ignore
    @Nullable
    private TinodeContact sender;

    public ChatMessage(@NotNull String string2, @NotNull String string3, int n, @Nullable Date date, @NotNull String string4, @NotNull String string5, @NotNull String string6, @NotNull String string7, @NotNull ChatMessageStatus chatMessageStatus) {
        ChatMessage chatMessage = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"senderUserId");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"text");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string6, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)string7, (String)"replyTo");
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        this.topicId = string2;
        this.senderUserId = string3;
        this.seqId = n;
        this.date = date;
        this.text = string4;
        this.type = string5;
        this.subtype = string6;
        this.replyTo = string7;
        chatMessage.status = chatMessageStatus;
        String string8 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"randomUUID().toString()");
        chatMessage.id = string8;
    }

    public /* synthetic */ ChatMessage(String string2, String string3, int n, Date date, String string4, String string5, String string6, String string7, ChatMessageStatus chatMessageStatus, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            date = null;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "";
        }
        if ((n2 & 0x20) != 0) {
            string5 = "";
        }
        if ((n2 & 0x40) != 0) {
            string6 = "";
        }
        if ((n2 & 0x80) != 0) {
            string7 = "";
        }
        if ((n2 & 0x100) != 0) {
            chatMessageStatus = ChatMessageStatus.Uninitialized;
        }
        this(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    public static /* synthetic */ ChatMessage copy$default(ChatMessage chatMessage, String string2, String string3, int n, Date date, String string4, String string5, String string6, String string7, ChatMessageStatus chatMessageStatus, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = chatMessage.topicId;
        }
        if ((n2 & 2) != 0) {
            string3 = chatMessage.senderUserId;
        }
        if ((n2 & 4) != 0) {
            n = chatMessage.seqId;
        }
        if ((n2 & 8) != 0) {
            date = chatMessage.date;
        }
        if ((n2 & 0x10) != 0) {
            string4 = chatMessage.text;
        }
        if ((n2 & 0x20) != 0) {
            string5 = chatMessage.type;
        }
        if ((n2 & 0x40) != 0) {
            string6 = chatMessage.subtype;
        }
        if ((n2 & 0x80) != 0) {
            string7 = chatMessage.replyTo;
        }
        if ((n2 & 0x100) != 0) {
            chatMessageStatus = chatMessage.status;
        }
        return chatMessage.copy(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    @NotNull
    public final String getTopicId() {
        return this.topicId;
    }

    @NotNull
    public final String getSenderUserId() {
        return this.senderUserId;
    }

    public final int getSeqId() {
        return this.seqId;
    }

    public final void setSeqId(int n) {
        this.seqId = n;
    }

    @Nullable
    public final Date getDate() {
        return this.date;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final String getReplyTo() {
        return this.replyTo;
    }

    @NotNull
    public final ChatMessageStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"<set-?>");
        this.status = chatMessageStatus;
    }

    @Nullable
    public final Map<String, String> getHead() {
        return this.head;
    }

    public final void setHead(@Nullable Map<String, String> map2) {
        this.head = map2;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.id = string2;
    }

    @Nullable
    public final TinodeContact getSender() {
        return this.sender;
    }

    public final void setSender(@Nullable TinodeContact tinodeContact) {
        this.sender = tinodeContact;
    }

    @NotNull
    public final ChatMessage updateStatus(@NotNull ChatMessageStatus chatMessageStatus) {
        ChatMessage chatMessage = this;
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        chatMessage.setStatus(chatMessageStatus);
        return chatMessage;
    }

    @NotNull
    public final String component1() {
        return this.topicId;
    }

    @NotNull
    public final String component2() {
        return this.senderUserId;
    }

    public final int component3() {
        return this.seqId;
    }

    @Nullable
    public final Date component4() {
        return this.date;
    }

    @NotNull
    public final String component5() {
        return this.text;
    }

    @NotNull
    public final String component6() {
        return this.type;
    }

    @NotNull
    public final String component7() {
        return this.subtype;
    }

    @NotNull
    public final String component8() {
        return this.replyTo;
    }

    @NotNull
    public final ChatMessageStatus component9() {
        return this.status;
    }

    @NotNull
    public final ChatMessage copy(@NotNull String string2, @NotNull String string3, int n, @Nullable Date date, @NotNull String string4, @NotNull String string5, @NotNull String string6, @NotNull String string7, @NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"senderUserId");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"text");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string6, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)string7, (String)"replyTo");
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        return new ChatMessage(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    @NotNull
    public String toString() {
        return "ChatMessage(topicId=" + this.topicId + ", senderUserId=" + this.senderUserId + ", seqId=" + this.seqId + ", date=" + this.date + ", text=" + this.text + ", type=" + this.type + ", subtype=" + this.subtype + ", replyTo=" + this.replyTo + ", status=" + (Object)((Object)this.status) + ')';
    }

    public int hashCode() {
        ChatMessage chatMessage = this;
        int n = ((chatMessage.topicId.hashCode() * 31 + this.senderUserId.hashCode()) * 31 + Integer.hashCode(this.seqId)) * 31;
        Date date = chatMessage.date;
        int n2 = date == null ? 0 : date.hashCode();
        return (((((n + n2) * 31 + this.text.hashCode()) * 31 + this.type.hashCode()) * 31 + this.subtype.hashCode()) * 31 + this.replyTo.hashCode()) * 31 + this.status.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChatMessage)) {
            return false;
        }
        object = (ChatMessage)object;
        if (!Intrinsics.areEqual((Object)this.topicId, (Object)((ChatMessage)object).topicId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.senderUserId, (Object)((ChatMessage)object).senderUserId)) {
            return false;
        }
        if (this.seqId != ((ChatMessage)object).seqId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)((ChatMessage)object).date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((ChatMessage)object).text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((ChatMessage)object).type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subtype, (Object)((ChatMessage)object).subtype)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.replyTo, (Object)((ChatMessage)object).replyTo)) {
            return false;
        }
        return this.status == ((ChatMessage)object).status;
    }
}

