/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.TopicKt;
import io.streamlayer.sdk.model.messaging.TopicType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
public final class Topic {
    @PrimaryKey
    @NotNull
    private final String chatId;
    @NotNull
    private final String name;
    private int seq;
    private final int readSeq;
    private final int recvSeq;
    @Nullable
    private final Date updatedAt;
    @Nullable
    private final Date touchedAt;
    @Embedded
    @Nullable
    private final Access access;
    @NotNull
    private final TopicType type;
    @Nullable
    private String watchPartyStreamId;
    @Ignore
    @NotNull
    private List<TinodeContact> participants;
    @Ignore
    @Nullable
    private ChatMessage lastMessage;

    public Topic(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable Access access, @NotNull TopicType topicType) {
        Topic topic2 = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)topicType), (String)"type");
        this.chatId = string2;
        this.name = string3;
        this.seq = n;
        this.readSeq = n2;
        this.recvSeq = n3;
        this.updatedAt = date;
        this.touchedAt = date2;
        this.access = access;
        topic2.type = topicType;
        topic2.participants = CollectionsKt.emptyList();
    }

    public /* synthetic */ Topic(String string2, String string3, int n, int n2, int n3, Date date, Date date2, Access access, TopicType topicType, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            date = null;
        }
        if ((n4 & 0x40) != 0) {
            date2 = null;
        }
        if ((n4 & 0x80) != 0) {
            access = null;
        }
        if ((n4 & 0x100) != 0) {
            topicType = TopicType.CHAT;
        }
        this(string2, string3, n, n2, n3, date, date2, access, topicType);
    }

    public static /* synthetic */ Topic copy$default(Topic topic2, String string2, String string3, int n, int n2, int n3, Date date, Date date2, Access access, TopicType topicType, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string2 = topic2.chatId;
        }
        if ((n4 & 2) != 0) {
            string3 = topic2.name;
        }
        if ((n4 & 4) != 0) {
            n = topic2.seq;
        }
        if ((n4 & 8) != 0) {
            n2 = topic2.readSeq;
        }
        if ((n4 & 0x10) != 0) {
            n3 = topic2.recvSeq;
        }
        if ((n4 & 0x20) != 0) {
            date = topic2.updatedAt;
        }
        if ((n4 & 0x40) != 0) {
            date2 = topic2.touchedAt;
        }
        if ((n4 & 0x80) != 0) {
            access = topic2.access;
        }
        if ((n4 & 0x100) != 0) {
            topicType = topic2.type;
        }
        return topic2.copy(string2, string3, n, n2, n3, date, date2, access, topicType);
    }

    @NotNull
    public final String getChatId() {
        return this.chatId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    public final int getReadSeq() {
        return this.readSeq;
    }

    public final int getRecvSeq() {
        return this.recvSeq;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public final Date getTouchedAt() {
        return this.touchedAt;
    }

    @Nullable
    public final Access getAccess() {
        return this.access;
    }

    @NotNull
    public final TopicType getType() {
        return this.type;
    }

    @Nullable
    public final String getWatchPartyStreamId() {
        return this.watchPartyStreamId;
    }

    public final void setWatchPartyStreamId(@Nullable String string2) {
        this.watchPartyStreamId = string2;
    }

    public final boolean isOwner() {
        return TopicKt.isOwner(this.access);
    }

    public final boolean isWPTopic() {
        Object object = object.type;
        return object == TopicType.WP || object == TopicType.MANAGED_WP;
    }

    @NotNull
    public final List<TinodeContact> getParticipants() {
        return this.participants;
    }

    public final void setParticipants(@NotNull List<TinodeContact> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.participants = list;
    }

    @Nullable
    public final ChatMessage getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable ChatMessage chatMessage) {
        this.lastMessage = chatMessage;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        void var3_17;
        void var2_9;
        void var3_13;
        void var2_5;
        if (!(object instanceof Topic)) return false;
        object = (Topic)object;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Topic)object).name)) return false;
        if (!Intrinsics.areEqual((Object)this.chatId, (Object)((Topic)object).chatId)) return false;
        if (this.seq != ((Topic)object).seq) return false;
        if (this.readSeq != ((Topic)object).readSeq) return false;
        if (this.recvSeq != ((Topic)object).recvSeq) return false;
        ChatMessage chatMessage = this.lastMessage;
        if (chatMessage == null) {
            Object var2_3 = null;
        } else {
            Integer n = chatMessage.getSeqId();
        }
        ChatMessage chatMessage2 = ((Topic)object).lastMessage;
        if (chatMessage2 == null) {
            Object var3_11 = null;
        } else {
            Integer n = chatMessage2.getSeqId();
        }
        if (!Intrinsics.areEqual((Object)var2_5, (Object)var3_13)) return false;
        ChatMessage chatMessage3 = this.lastMessage;
        if (chatMessage3 == null) {
            Object var2_7 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage3.getStatus();
        }
        ChatMessage chatMessage4 = ((Topic)object).lastMessage;
        if (chatMessage4 == null) {
            Object var3_15 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage4.getStatus();
        }
        if (var2_9 != var3_17) return false;
        if (!Intrinsics.areEqual(this.participants, ((Topic)object).participants)) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final int component3() {
        return this.seq;
    }

    public final int component4() {
        return this.readSeq;
    }

    public final int component5() {
        return this.recvSeq;
    }

    @Nullable
    public final Date component6() {
        return this.updatedAt;
    }

    @Nullable
    public final Date component7() {
        return this.touchedAt;
    }

    @Nullable
    public final Access component8() {
        return this.access;
    }

    @NotNull
    public final TopicType component9() {
        return this.type;
    }

    @NotNull
    public final Topic copy(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable Access access, @NotNull TopicType topicType) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)topicType), (String)"type");
        return new Topic(string2, string3, n, n2, n3, date, date2, access, topicType);
    }

    @NotNull
    public String toString() {
        return "Topic(chatId=" + this.chatId + ", name=" + this.name + ", seq=" + this.seq + ", readSeq=" + this.readSeq + ", recvSeq=" + this.recvSeq + ", updatedAt=" + this.updatedAt + ", touchedAt=" + this.touchedAt + ", access=" + this.access + ", type=" + (Object)((Object)this.type) + ')';
    }

    public int hashCode() {
        Topic topic2 = this;
        int n = ((((topic2.chatId.hashCode() * 31 + this.name.hashCode()) * 31 + Integer.hashCode(this.seq)) * 31 + Integer.hashCode(this.readSeq)) * 31 + Integer.hashCode(this.recvSeq)) * 31;
        Date date = topic2.updatedAt;
        int n2 = date == null ? 0 : date.hashCode();
        n = (n + n2) * 31;
        Date date2 = this.touchedAt;
        int n3 = date2 == null ? 0 : date2.hashCode();
        n = (n + n3) * 31;
        Access access = this.access;
        int n4 = access == null ? 0 : access.hashCode();
        return (n + n4) * 31 + this.type.hashCode();
    }
}

