/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports;

import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.EventType;
import java.util.Date;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventSummary {
    private final long id;
    @NotNull
    private final EventType type;
    @Nullable
    private final String name;
    @NotNull
    private final Date scheduleDate;
    @NotNull
    private final String league;
    private final int homeScore;
    private final int awayScore;
    @NotNull
    private final EventTime eventTime;
    @NotNull
    private final EventTeam homeTeam;
    @NotNull
    private final EventTeam awayTeam;
    @NotNull
    private final EventStatus status;
    @NotNull
    private final List<EventPeriod> periods;
    private final int periodsCount;

    public EventSummary(long l, @NotNull EventType eventType, @Nullable String string2, @NotNull Date date, @NotNull String string3, int n, int n2, @NotNull EventTime eventTime, @NotNull EventTeam eventTeam, @NotNull EventTeam eventTeam2, @NotNull EventStatus eventStatus, @NotNull List<EventPeriod> list, int n3) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"type");
        Intrinsics.checkNotNullParameter((Object)date, (String)"scheduleDate");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"league");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)eventTeam, (String)"homeTeam");
        Intrinsics.checkNotNullParameter((Object)eventTeam2, (String)"awayTeam");
        Intrinsics.checkNotNullParameter((Object)((Object)eventStatus), (String)"status");
        Intrinsics.checkNotNullParameter(list, (String)"periods");
        this.id = l;
        this.type = eventType;
        this.name = string2;
        this.scheduleDate = date;
        this.league = string3;
        this.homeScore = n;
        this.awayScore = n2;
        this.eventTime = eventTime;
        this.homeTeam = eventTeam;
        this.awayTeam = eventTeam2;
        this.status = eventStatus;
        this.periods = list;
        this.periodsCount = n3;
    }

    public static /* synthetic */ EventSummary copy$default(EventSummary eventSummary2, long l, EventType eventType, String string2, Date date, String string3, int n, int n2, EventTime eventTime, EventTeam eventTeam, EventTeam eventTeam2, EventStatus eventStatus, List list, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            l = eventSummary2.id;
        }
        if ((n4 & 2) != 0) {
            eventType = eventSummary2.type;
        }
        if ((n4 & 4) != 0) {
            string2 = eventSummary2.name;
        }
        if ((n4 & 8) != 0) {
            date = eventSummary2.scheduleDate;
        }
        if ((n4 & 0x10) != 0) {
            string3 = eventSummary2.league;
        }
        if ((n4 & 0x20) != 0) {
            n = eventSummary2.homeScore;
        }
        if ((n4 & 0x40) != 0) {
            n2 = eventSummary2.awayScore;
        }
        if ((n4 & 0x80) != 0) {
            eventTime = eventSummary2.eventTime;
        }
        if ((n4 & 0x100) != 0) {
            eventTeam = eventSummary2.homeTeam;
        }
        if ((n4 & 0x200) != 0) {
            eventTeam2 = eventSummary2.awayTeam;
        }
        if ((n4 & 0x400) != 0) {
            eventStatus = eventSummary2.status;
        }
        if ((n4 & 0x800) != 0) {
            list = eventSummary2.periods;
        }
        if ((n4 & 0x1000) != 0) {
            n3 = eventSummary2.periodsCount;
        }
        return eventSummary2.copy(l, eventType, string2, date, string3, n, n2, eventTime, eventTeam, eventTeam2, eventStatus, list, n3);
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final EventType getType() {
        return this.type;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Date getScheduleDate() {
        return this.scheduleDate;
    }

    @NotNull
    public final String getLeague() {
        return this.league;
    }

    public final int getHomeScore() {
        return this.homeScore;
    }

    public final int getAwayScore() {
        return this.awayScore;
    }

    @NotNull
    public final EventTime getEventTime() {
        return this.eventTime;
    }

    @NotNull
    public final EventTeam getHomeTeam() {
        return this.homeTeam;
    }

    @NotNull
    public final EventTeam getAwayTeam() {
        return this.awayTeam;
    }

    @NotNull
    public final EventStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final List<EventPeriod> getPeriods() {
        return this.periods;
    }

    public final int getPeriodsCount() {
        return this.periodsCount;
    }

    @NotNull
    public final String getShortGameInfo() {
        Object object;
        String string2 = ((EventSummary)object).name;
        if (!(string2 == null || string2.length() == 0)) {
            object = ((EventSummary)object).name;
        } else {
            object = (((EventSummary)object).league + ' ' + ((EventSummary)object).homeTeam.getAlias() + " VS " + ((EventSummary)object).awayTeam.getAlias()).toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toUpperCase()");
        }
        return object;
    }

    public final long component1() {
        return this.id;
    }

    @NotNull
    public final EventType component2() {
        return this.type;
    }

    @Nullable
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final Date component4() {
        return this.scheduleDate;
    }

    @NotNull
    public final String component5() {
        return this.league;
    }

    public final int component6() {
        return this.homeScore;
    }

    public final int component7() {
        return this.awayScore;
    }

    @NotNull
    public final EventTime component8() {
        return this.eventTime;
    }

    @NotNull
    public final EventTeam component9() {
        return this.homeTeam;
    }

    @NotNull
    public final EventTeam component10() {
        return this.awayTeam;
    }

    @NotNull
    public final EventStatus component11() {
        return this.status;
    }

    @NotNull
    public final List<EventPeriod> component12() {
        return this.periods;
    }

    public final int component13() {
        return this.periodsCount;
    }

    @NotNull
    public final EventSummary copy(long l, @NotNull EventType eventType, @Nullable String string2, @NotNull Date date, @NotNull String string3, int n, int n2, @NotNull EventTime eventTime, @NotNull EventTeam eventTeam, @NotNull EventTeam eventTeam2, @NotNull EventStatus eventStatus, @NotNull List<EventPeriod> list, int n3) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"type");
        Intrinsics.checkNotNullParameter((Object)date, (String)"scheduleDate");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"league");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)eventTeam, (String)"homeTeam");
        Intrinsics.checkNotNullParameter((Object)eventTeam2, (String)"awayTeam");
        Intrinsics.checkNotNullParameter((Object)((Object)eventStatus), (String)"status");
        Intrinsics.checkNotNullParameter(list, (String)"periods");
        return new EventSummary(l, eventType, string2, date, string3, n, n2, eventTime, eventTeam, eventTeam2, eventStatus, list, n3);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EventSummary(id=").append(this.id).append(", type=").append((Object)this.type).append(", name=").append((Object)this.name).append(", scheduleDate=").append(this.scheduleDate).append(", league=").append(this.league).append(", homeScore=").append(this.homeScore).append(", awayScore=").append(this.awayScore).append(", eventTime=").append(this.eventTime).append(", homeTeam=").append(this.homeTeam).append(", awayTeam=").append(this.awayTeam).append(", status=").append((Object)this.status).append(", periods=");
        stringBuilder.append(this.periods).append(", periodsCount=").append(this.periodsCount).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        EventSummary eventSummary2 = this;
        int n = (Long.hashCode(eventSummary2.id) * 31 + this.type.hashCode()) * 31;
        String string2 = eventSummary2.name;
        int n2 = string2 == null ? 0 : string2.hashCode();
        return ((((((((((n + n2) * 31 + this.scheduleDate.hashCode()) * 31 + this.league.hashCode()) * 31 + Integer.hashCode(this.homeScore)) * 31 + Integer.hashCode(this.awayScore)) * 31 + this.eventTime.hashCode()) * 31 + this.homeTeam.hashCode()) * 31 + this.awayTeam.hashCode()) * 31 + this.status.hashCode()) * 31 + ((Object)this.periods).hashCode()) * 31 + Integer.hashCode(this.periodsCount);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EventSummary)) {
            return false;
        }
        object = (EventSummary)object;
        if (this.id != ((EventSummary)object).id) {
            return false;
        }
        if (this.type != ((EventSummary)object).type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((EventSummary)object).name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scheduleDate, (Object)((EventSummary)object).scheduleDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.league, (Object)((EventSummary)object).league)) {
            return false;
        }
        if (this.homeScore != ((EventSummary)object).homeScore) {
            return false;
        }
        if (this.awayScore != ((EventSummary)object).awayScore) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.eventTime, (Object)((EventSummary)object).eventTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.homeTeam, (Object)((EventSummary)object).homeTeam)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.awayTeam, (Object)((EventSummary)object).awayTeam)) {
            return false;
        }
        if (this.status != ((EventSummary)object).status) {
            return false;
        }
        if (!Intrinsics.areEqual(this.periods, ((EventSummary)object).periods)) {
            return false;
        }
        return this.periodsCount == ((EventSummary)object).periodsCount;
    }
}

