/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports.baseball;

import com.streamlayer.sports.baseball.Standings;
import com.streamlayer.sports.baseball.TeamStanding;
import io.streamlayer.sdk.model.sports.baseball.BaseballStandings;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamRank;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamStanding;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamStreak;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class BaseballStandingKt {
    @NotNull
    public static final BaseballStandings toDomain(@NotNull Standings object) {
        ArrayList<BaseballTeamStanding> arrayList;
        Standings standings2 = object;
        Intrinsics.checkNotNullParameter((Object)standings2, (String)"<this>");
        object = standings2.getStandingsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"standingsList");
        ArrayList<BaseballTeamStanding> arrayList2 = arrayList;
        arrayList = new ArrayList<BaseballTeamStanding>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TeamStanding teamStanding = (TeamStanding)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)teamStanding, (String)"it");
            arrayList2.add(BaseballStandingKt.toDomain(teamStanding));
        }
        return new BaseballStandings(arrayList2);
    }

    @NotNull
    public static final BaseballTeamStanding toDomain(@NotNull TeamStanding object) {
        TeamStanding teamStanding = object;
        Intrinsics.checkNotNullParameter((Object)teamStanding, (String)"<this>");
        long l = teamStanding.getId();
        object = teamStanding.getName();
        String string2 = teamStanding.getLogo();
        List list = teamStanding.getColorsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colorsList");
        List list2 = CollectionsKt.toList((Iterable)list);
        int n = teamStanding.getWins();
        int n2 = teamStanding.getLosses();
        double d = teamStanding.getPct();
        int n3 = teamStanding.getGamesBehind();
        TeamStanding.Streak streak = teamStanding.getStreak();
        Intrinsics.checkNotNullExpressionValue((Object)streak, (String)"streak");
        BaseballTeamStreak baseballTeamStreak = BaseballStandingKt.toDomain(streak);
        TeamStanding.Rank rank = teamStanding.getRank();
        Intrinsics.checkNotNullExpressionValue((Object)rank, (String)"rank");
        BaseballTeamRank baseballTeamRank = BaseballStandingKt.toDomain(rank);
        String string3 = teamStanding.getDivision();
        String string4 = teamStanding.getConference();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logo");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"division");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"conference");
        return new BaseballTeamStanding(l, n, n2, d, n3, (String)object, string2, list2, baseballTeamStreak, baseballTeamRank, string3, string4, null, 4096, null);
    }

    @NotNull
    public static final BaseballTeamRank toDomain(@NotNull TeamStanding.Rank rank) {
        Intrinsics.checkNotNullParameter((Object)rank, (String)"<this>");
        TeamStanding.Rank rank2 = rank;
        int n = rank2.getDivision();
        return new BaseballTeamRank(n, rank2.getConference());
    }

    @NotNull
    public static final BaseballTeamStreak toDomain(@NotNull TeamStanding.Streak streak) {
        Intrinsics.checkNotNullParameter((Object)streak, (String)"<this>");
        TeamStanding.Streak streak2 = streak;
        int n = streak2.getLosses();
        return new BaseballTeamStreak(n, streak2.getWins());
    }
}

