/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports.baseball;

import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamRank;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamStreak;
import java.util.Arrays;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BaseballTeamStanding
implements TeamStandings {
    private final long id;
    private final int wins;
    private final int losses;
    private final double percentage;
    private final int gamesBehind;
    @NotNull
    private final String teamName;
    @NotNull
    private final String teamIcon;
    @NotNull
    private final List<String> colors;
    @NotNull
    private final BaseballTeamStreak streak;
    @NotNull
    private final BaseballTeamRank rank;
    @NotNull
    private final String division;
    @NotNull
    private final String conference;
    @Nullable
    private final String league;

    public BaseballTeamStanding(long l, int n, int n2, double d, int n3, @NotNull String string2, @NotNull String string3, @NotNull List<String> list, @NotNull BaseballTeamStreak baseballTeamStreak, @NotNull BaseballTeamRank baseballTeamRank, @NotNull String string4, @NotNull String string5, @Nullable String string6) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"teamName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"teamIcon");
        Intrinsics.checkNotNullParameter(list, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)baseballTeamStreak, (String)"streak");
        Intrinsics.checkNotNullParameter((Object)baseballTeamRank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"division");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"conference");
        this.id = l;
        this.wins = n;
        this.losses = n2;
        this.percentage = d;
        this.gamesBehind = n3;
        this.teamName = string2;
        this.teamIcon = string3;
        this.colors = list;
        this.streak = baseballTeamStreak;
        this.rank = baseballTeamRank;
        this.division = string4;
        this.conference = string5;
        this.league = string6;
    }

    public /* synthetic */ BaseballTeamStanding(long l, int n, int n2, double d, int n3, String string2, String string3, List list, BaseballTeamStreak baseballTeamStreak, BaseballTeamRank baseballTeamRank, String string4, String string5, String string6, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x1000) != 0) {
            string6 = null;
        }
        this(l, n, n2, d, n3, string2, string3, list, baseballTeamStreak, baseballTeamRank, string4, string5, string6);
    }

    public static /* synthetic */ BaseballTeamStanding copy$default(BaseballTeamStanding baseballTeamStanding, long l, int n, int n2, double d, int n3, String string2, String string3, List list, BaseballTeamStreak baseballTeamStreak, BaseballTeamRank baseballTeamRank, String string4, String string5, String string6, int n4, Object object) {
        if ((n4 & 1) != 0) {
            l = baseballTeamStanding.getId();
        }
        if ((n4 & 2) != 0) {
            n = baseballTeamStanding.getWins();
        }
        if ((n4 & 4) != 0) {
            n2 = baseballTeamStanding.getLosses();
        }
        if ((n4 & 8) != 0) {
            d = baseballTeamStanding.getPercentage();
        }
        if ((n4 & 0x10) != 0) {
            n3 = baseballTeamStanding.getGamesBehind();
        }
        if ((n4 & 0x20) != 0) {
            string2 = baseballTeamStanding.getTeamName();
        }
        if ((n4 & 0x40) != 0) {
            string3 = baseballTeamStanding.getTeamIcon();
        }
        if ((n4 & 0x80) != 0) {
            list = baseballTeamStanding.getColors();
        }
        if ((n4 & 0x100) != 0) {
            baseballTeamStreak = baseballTeamStanding.streak;
        }
        if ((n4 & 0x200) != 0) {
            baseballTeamRank = baseballTeamStanding.rank;
        }
        if ((n4 & 0x400) != 0) {
            string4 = baseballTeamStanding.division;
        }
        if ((n4 & 0x800) != 0) {
            string5 = baseballTeamStanding.conference;
        }
        if ((n4 & 0x1000) != 0) {
            string6 = baseballTeamStanding.league;
        }
        return baseballTeamStanding.copy(l, n, n2, d, n3, string2, string3, list, baseballTeamStreak, baseballTeamRank, string4, string5, string6);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getWins() {
        return this.wins;
    }

    @Override
    public int getLosses() {
        return this.losses;
    }

    @Override
    public double getPercentage() {
        return this.percentage;
    }

    @Override
    public int getGamesBehind() {
        return this.gamesBehind;
    }

    @Override
    @NotNull
    public String getTeamName() {
        return this.teamName;
    }

    @Override
    @NotNull
    public String getTeamIcon() {
        return this.teamIcon;
    }

    @Override
    @NotNull
    public List<String> getColors() {
        return this.colors;
    }

    @NotNull
    public final BaseballTeamStreak getStreak() {
        return this.streak;
    }

    @NotNull
    public final BaseballTeamRank getRank() {
        return this.rank;
    }

    @NotNull
    public final String getDivision() {
        return this.division;
    }

    @NotNull
    public final String getConference() {
        return this.conference;
    }

    @Nullable
    public final String getLeague() {
        return this.league;
    }

    @Override
    @NotNull
    public String getStreakTitle() {
        String string2 = String.format("%d - %d", Arrays.copyOf(new Object[]{this.streak.getWins(), this.streak.getLosses()}, 2));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    @Override
    @NotNull
    public String formatPercentage() {
        BaseballTeamStanding baseballTeamStanding = string2;
        String string2 = String.format("%.1f", Arrays.copyOf(new Object[]{((BaseballTeamStanding)((Object)string2)).getPercentage()}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        int n = baseballTeamStanding.getPercentage() < 1.0 ? 1 : 0;
        return StringsKt.drop((String)string2, (int)n);
    }

    public final long component1() {
        return this.getId();
    }

    public final int component2() {
        return this.getWins();
    }

    public final int component3() {
        return this.getLosses();
    }

    public final double component4() {
        return this.getPercentage();
    }

    public final int component5() {
        return this.getGamesBehind();
    }

    @NotNull
    public final String component6() {
        return this.getTeamName();
    }

    @NotNull
    public final String component7() {
        return this.getTeamIcon();
    }

    @NotNull
    public final List<String> component8() {
        return this.getColors();
    }

    @NotNull
    public final BaseballTeamStreak component9() {
        return this.streak;
    }

    @NotNull
    public final BaseballTeamRank component10() {
        return this.rank;
    }

    @NotNull
    public final String component11() {
        return this.division;
    }

    @NotNull
    public final String component12() {
        return this.conference;
    }

    @Nullable
    public final String component13() {
        return this.league;
    }

    @NotNull
    public final BaseballTeamStanding copy(long l, int n, int n2, double d, int n3, @NotNull String string2, @NotNull String string3, @NotNull List<String> list, @NotNull BaseballTeamStreak baseballTeamStreak, @NotNull BaseballTeamRank baseballTeamRank, @NotNull String string4, @NotNull String string5, @Nullable String string6) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"teamName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"teamIcon");
        Intrinsics.checkNotNullParameter(list, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)baseballTeamStreak, (String)"streak");
        Intrinsics.checkNotNullParameter((Object)baseballTeamRank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"division");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"conference");
        return new BaseballTeamStanding(l, n, n2, d, n3, string2, string3, list, baseballTeamStreak, baseballTeamRank, string4, string5, string6);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BaseballTeamStanding(id=").append(this.getId()).append(", wins=").append(this.getWins()).append(", losses=").append(this.getLosses()).append(", percentage=").append(this.getPercentage()).append(", gamesBehind=").append(this.getGamesBehind()).append(", teamName=").append(this.getTeamName()).append(", teamIcon=").append(this.getTeamIcon()).append(", colors=").append(this.getColors()).append(", streak=").append(this.streak).append(", rank=").append(this.rank).append(", division=").append(this.division).append(", conference=");
        stringBuilder.append(this.conference).append(", league=").append((Object)this.league).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        BaseballTeamStanding baseballTeamStanding = this;
        int n = (((((((((((Long.hashCode(baseballTeamStanding.getId()) * 31 + Integer.hashCode(this.getWins())) * 31 + Integer.hashCode(this.getLosses())) * 31 + Double.hashCode(this.getPercentage())) * 31 + Integer.hashCode(this.getGamesBehind())) * 31 + this.getTeamName().hashCode()) * 31 + this.getTeamIcon().hashCode()) * 31 + ((Object)this.getColors()).hashCode()) * 31 + this.streak.hashCode()) * 31 + this.rank.hashCode()) * 31 + this.division.hashCode()) * 31 + this.conference.hashCode()) * 31;
        String string2 = baseballTeamStanding.league;
        int n2 = string2 == null ? 0 : string2.hashCode();
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseballTeamStanding)) {
            return false;
        }
        object = (BaseballTeamStanding)object;
        if (this.getId() != ((BaseballTeamStanding)object).getId()) {
            return false;
        }
        if (this.getWins() != ((BaseballTeamStanding)object).getWins()) {
            return false;
        }
        if (this.getLosses() != ((BaseballTeamStanding)object).getLosses()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPercentage(), (Object)((BaseballTeamStanding)object).getPercentage())) {
            return false;
        }
        if (this.getGamesBehind() != ((BaseballTeamStanding)object).getGamesBehind()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTeamName(), (Object)((BaseballTeamStanding)object).getTeamName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTeamIcon(), (Object)((BaseballTeamStanding)object).getTeamIcon())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getColors(), ((BaseballTeamStanding)object).getColors())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.streak, (Object)((BaseballTeamStanding)object).streak)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rank, (Object)((BaseballTeamStanding)object).rank)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.division, (Object)((BaseballTeamStanding)object).division)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.conference, (Object)((BaseballTeamStanding)object).conference)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.league, (Object)((BaseballTeamStanding)object).league);
    }
}

