/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports.baseball;

import io.streamlayer.sdk.model.sports.baseball.BaseballSummary;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamSummary;
import io.streamlayer.sdk.model.sports.baseball.Batting;
import io.streamlayer.sdk.model.sports.baseball.Hitting;
import io.streamlayer.sdk.model.sports.baseball.PitcherStatus;
import io.streamlayer.sdk.model.sports.baseball.PitcherSummary;
import io.streamlayer.sdk.model.sports.baseball.Pitching;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SummaryKt {
    @NotNull
    public static final BaseballSummary toDomain(@NotNull com.streamlayer.sports.baseball.BaseballSummary object, long l) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.baseball.BaseballSummary baseballSummary = object;
        com.streamlayer.sports.baseball.PitcherSummary pitcherSummary = baseballSummary.getAwayPitcher();
        Intrinsics.checkNotNullExpressionValue((Object)pitcherSummary, (String)"awayPitcher");
        object = SummaryKt.toDomain(pitcherSummary);
        com.streamlayer.sports.baseball.BaseballTeamSummary baseballTeamSummary = baseballSummary.getAwayStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)baseballTeamSummary, (String)"awayStatistics");
        BaseballTeamSummary baseballTeamSummary2 = SummaryKt.toDomain(baseballTeamSummary);
        com.streamlayer.sports.baseball.PitcherSummary pitcherSummary2 = baseballSummary.getHomePitcher();
        Intrinsics.checkNotNullExpressionValue((Object)pitcherSummary2, (String)"homePitcher");
        PitcherSummary pitcherSummary3 = SummaryKt.toDomain(pitcherSummary2);
        com.streamlayer.sports.baseball.BaseballTeamSummary baseballTeamSummary3 = baseballSummary.getHomeStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)baseballTeamSummary3, (String)"homeStatistics");
        BaseballTeamSummary baseballTeamSummary4 = SummaryKt.toDomain(baseballTeamSummary3);
        return new BaseballSummary(l, (PitcherSummary)object, baseballTeamSummary2, pitcherSummary3, baseballTeamSummary4);
    }

    @NotNull
    public static final BaseballTeamSummary toDomain(@NotNull com.streamlayer.sports.baseball.BaseballTeamSummary object) {
        ArrayList arrayList;
        ArrayList<Hitting> arrayList2;
        ArrayList<Batting> arrayList3;
        com.streamlayer.sports.baseball.BaseballTeamSummary baseballTeamSummary = object;
        Intrinsics.checkNotNullParameter((Object)baseballTeamSummary, (String)"<this>");
        Object object2 = baseballTeamSummary.getBattingList();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"battingList");
        ArrayList<Batting> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<Batting>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.sports.baseball.Batting batting = (com.streamlayer.sports.baseball.Batting)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)batting, (String)"it");
            arrayList4.add(SummaryKt.toDomain(batting));
        }
        object2 = object.getHittingList();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"hittingList");
        ArrayList<Hitting> arrayList5 = arrayList2;
        arrayList2 = new ArrayList<Hitting>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            com.streamlayer.sports.baseball.Hitting hitting = (com.streamlayer.sports.baseball.Hitting)object2.next();
            Intrinsics.checkNotNullExpressionValue((Object)hitting, (String)"it");
            arrayList5.add(SummaryKt.toDomain(hitting));
        }
        object = object.getPitchingList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pitchingList");
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            com.streamlayer.sports.baseball.Pitching pitching = (com.streamlayer.sports.baseball.Pitching)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)pitching, (String)"it");
            object2.add(SummaryKt.toDomain(pitching));
        }
        return new BaseballTeamSummary(arrayList4, arrayList5, (List<Pitching>)object2);
    }

    @NotNull
    public static final PitcherSummary toDomain(@NotNull com.streamlayer.sports.baseball.PitcherSummary object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.baseball.PitcherSummary pitcherSummary = object;
        com.streamlayer.sports.baseball.PitcherStatus pitcherStatus = pitcherSummary.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)pitcherStatus, (String)"status");
        object = SummaryKt.toDomain(pitcherStatus);
        int n = pitcherSummary.getLossRate();
        int n2 = pitcherSummary.getWinRate();
        com.streamlayer.sports.baseball.Pitching pitching = pitcherSummary.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)pitching, (String)"statistics");
        Pitching pitching2 = SummaryKt.toDomain(pitching);
        return new PitcherSummary((PitcherStatus)((Object)object), n, n2, pitching2);
    }

    @NotNull
    public static final PitcherStatus toDomain(@NotNull com.streamlayer.sports.baseball.PitcherStatus pitcherStatus) {
        Intrinsics.checkNotNullParameter((Object)pitcherStatus, (String)"<this>");
        return PitcherStatus.Companion.from(pitcherStatus.getNumber());
    }

    @NotNull
    public static final Batting toDomain(@NotNull com.streamlayer.sports.baseball.Batting object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.baseball.Batting batting = object;
        object = batting.getPlayerName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"playerName");
        String string2 = batting.getAtBat();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"atBat");
        String string3 = batting.getRuns();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"runs");
        String string4 = batting.getHits();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"hits");
        String string5 = batting.getBattingAverage();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"battingAverage");
        return new Batting((String)object, string2, string3, string4, string5);
    }

    @NotNull
    public static final Hitting toDomain(@NotNull com.streamlayer.sports.baseball.Hitting object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.baseball.Hitting hitting = object;
        object = hitting.getPlayerName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"playerName");
        String string2 = hitting.getHitsPerBat();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hitsPerBat");
        String string3 = hitting.getRuns();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"runs");
        String string4 = hitting.getRunBattedIn();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"runBattedIn");
        String string5 = hitting.getWalks();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"walks");
        String string6 = hitting.getBattingAverage();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"battingAverage");
        return new Hitting((String)object, string2, string3, string4, string5, string6);
    }

    @NotNull
    public static final Pitching toDomain(@NotNull com.streamlayer.sports.baseball.Pitching object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        com.streamlayer.sports.baseball.Pitching pitching = object;
        object = pitching.getPlayerName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"playerName");
        String string2 = pitching.getInningsPitched();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inningsPitched");
        String string3 = pitching.getHitsByPitch();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hitsByPitch");
        String string4 = pitching.getEarnedRuns();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"earnedRuns");
        String string5 = pitching.getWalks();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"walks");
        String string6 = pitching.getStrikeouts();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"strikeouts");
        return new Pitching((String)object, string2, string3, string4, string5, string6);
    }
}

