/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports.basketball;

import com.streamlayer.sports.basketball.Standings;
import com.streamlayer.sports.basketball.TeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballStandings;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamRank;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStreak;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class BasketballStandingKt {
    @NotNull
    public static final BasketballStandings toDomain(@NotNull Standings object) {
        ArrayList<BasketballTeamStanding> arrayList;
        Standings standings2 = object;
        Intrinsics.checkNotNullParameter((Object)standings2, (String)"<this>");
        object = standings2.getStandingsList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"standingsList");
        ArrayList<BasketballTeamStanding> arrayList2 = arrayList;
        arrayList = new ArrayList<BasketballTeamStanding>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            TeamStanding teamStanding = (TeamStanding)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)teamStanding, (String)"it");
            arrayList2.add(BasketballStandingKt.toDomain(teamStanding));
        }
        return new BasketballStandings(arrayList2);
    }

    @NotNull
    public static final BasketballTeamStanding toDomain(@NotNull TeamStanding object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        TeamStanding teamStanding = object;
        long l = teamStanding.getId();
        object = teamStanding.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        String string2 = teamStanding.getLogo();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"logo");
        List list = teamStanding.getColorsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colorsList");
        List list2 = CollectionsKt.toList((Iterable)list);
        int n = teamStanding.getWins();
        int n2 = teamStanding.getLosses();
        double d = teamStanding.getPct();
        int n3 = teamStanding.getGamesBehind();
        TeamStanding.Streak streak = teamStanding.getStreak();
        Intrinsics.checkNotNullExpressionValue((Object)streak, (String)"streak");
        BasketballTeamStreak basketballTeamStreak = BasketballStandingKt.toDomain(streak);
        TeamStanding.Rank rank = teamStanding.getRank();
        Intrinsics.checkNotNullExpressionValue((Object)rank, (String)"rank");
        BasketballTeamRank basketballTeamRank = BasketballStandingKt.toDomain(rank);
        String string3 = teamStanding.getDivision();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"division");
        String string4 = teamStanding.getConference();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"conference");
        return new BasketballTeamStanding(l, (String)object, string2, list2, n, n2, d, n3, basketballTeamStreak, basketballTeamRank, string3, string4, null, 4096, null);
    }

    @NotNull
    public static final BasketballTeamRank toDomain(@NotNull TeamStanding.Rank rank) {
        Intrinsics.checkNotNullParameter((Object)rank, (String)"<this>");
        TeamStanding.Rank rank2 = rank;
        int n = rank2.getDivision();
        return new BasketballTeamRank(n, rank2.getConference());
    }

    @NotNull
    public static final BasketballTeamStreak toDomain(@NotNull TeamStanding.Streak object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        TeamStanding.Streak streak = object;
        object = streak.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kind");
        return new BasketballTeamStreak((String)object, streak.getLength());
    }
}

