/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports.basketball;

import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamRank;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStreak;
import java.util.Arrays;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasketballTeamStanding
implements TeamStandings {
    private final long id;
    @NotNull
    private final String teamName;
    @NotNull
    private final String teamIcon;
    @NotNull
    private final List<String> colors;
    private final int wins;
    private final int losses;
    private final double percentage;
    private final int gamesBehind;
    @NotNull
    private final BasketballTeamStreak streak;
    @NotNull
    private final BasketballTeamRank rank;
    @NotNull
    private final String division;
    @NotNull
    private final String conference;
    @Nullable
    private final String league;

    public BasketballTeamStanding(long l, @NotNull String string2, @NotNull String string3, @NotNull List<String> list, int n, int n2, double d, int n3, @NotNull BasketballTeamStreak basketballTeamStreak, @NotNull BasketballTeamRank basketballTeamRank, @NotNull String string4, @NotNull String string5, @Nullable String string6) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"teamName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"teamIcon");
        Intrinsics.checkNotNullParameter(list, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)basketballTeamStreak, (String)"streak");
        Intrinsics.checkNotNullParameter((Object)basketballTeamRank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"division");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"conference");
        this.id = l;
        this.teamName = string2;
        this.teamIcon = string3;
        this.colors = list;
        this.wins = n;
        this.losses = n2;
        this.percentage = d;
        this.gamesBehind = n3;
        this.streak = basketballTeamStreak;
        this.rank = basketballTeamRank;
        this.division = string4;
        this.conference = string5;
        this.league = string6;
    }

    public /* synthetic */ BasketballTeamStanding(long l, String string2, String string3, List list, int n, int n2, double d, int n3, BasketballTeamStreak basketballTeamStreak, BasketballTeamRank basketballTeamRank, String string4, String string5, String string6, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x1000) != 0) {
            string6 = null;
        }
        this(l, string2, string3, list, n, n2, d, n3, basketballTeamStreak, basketballTeamRank, string4, string5, string6);
    }

    public static /* synthetic */ BasketballTeamStanding copy$default(BasketballTeamStanding basketballTeamStanding, long l, String string2, String string3, List list, int n, int n2, double d, int n3, BasketballTeamStreak basketballTeamStreak, BasketballTeamRank basketballTeamRank, String string4, String string5, String string6, int n4, Object object) {
        if ((n4 & 1) != 0) {
            l = basketballTeamStanding.getId();
        }
        if ((n4 & 2) != 0) {
            string2 = basketballTeamStanding.getTeamName();
        }
        if ((n4 & 4) != 0) {
            string3 = basketballTeamStanding.getTeamIcon();
        }
        if ((n4 & 8) != 0) {
            list = basketballTeamStanding.getColors();
        }
        if ((n4 & 0x10) != 0) {
            n = basketballTeamStanding.getWins();
        }
        if ((n4 & 0x20) != 0) {
            n2 = basketballTeamStanding.getLosses();
        }
        if ((n4 & 0x40) != 0) {
            d = basketballTeamStanding.getPercentage();
        }
        if ((n4 & 0x80) != 0) {
            n3 = basketballTeamStanding.getGamesBehind();
        }
        if ((n4 & 0x100) != 0) {
            basketballTeamStreak = basketballTeamStanding.streak;
        }
        if ((n4 & 0x200) != 0) {
            basketballTeamRank = basketballTeamStanding.rank;
        }
        if ((n4 & 0x400) != 0) {
            string4 = basketballTeamStanding.division;
        }
        if ((n4 & 0x800) != 0) {
            string5 = basketballTeamStanding.conference;
        }
        if ((n4 & 0x1000) != 0) {
            string6 = basketballTeamStanding.league;
        }
        return basketballTeamStanding.copy(l, string2, string3, list, n, n2, d, n3, basketballTeamStreak, basketballTeamRank, string4, string5, string6);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTeamName() {
        return this.teamName;
    }

    @Override
    @NotNull
    public String getTeamIcon() {
        return this.teamIcon;
    }

    @Override
    @NotNull
    public List<String> getColors() {
        return this.colors;
    }

    @Override
    public int getWins() {
        return this.wins;
    }

    @Override
    public int getLosses() {
        return this.losses;
    }

    @Override
    public double getPercentage() {
        return this.percentage;
    }

    @Override
    public int getGamesBehind() {
        return this.gamesBehind;
    }

    @NotNull
    public final BasketballTeamStreak getStreak() {
        return this.streak;
    }

    @NotNull
    public final BasketballTeamRank getRank() {
        return this.rank;
    }

    @NotNull
    public final String getDivision() {
        return this.division;
    }

    @NotNull
    public final String getConference() {
        return this.conference;
    }

    @Nullable
    public final String getLeague() {
        return this.league;
    }

    @Override
    @NotNull
    public String getStreakTitle() {
        String string2 = "%s%d";
        int n = 2;
        Object[] objectArray = new Object[2];
        int n2 = 0;
        Object object = StringsKt.firstOrNull((CharSequence)this.streak.getKind());
        object = object == null ? "" : Character.valueOf(Character.toUpperCase(((Character)object).charValue()));
        objectArray[n2] = object;
        objectArray[1] = this.streak.getLength();
        String string3 = String.format(string2, Arrays.copyOf(objectArray, n));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return string3;
    }

    @Override
    @NotNull
    public String formatPercentage() {
        BasketballTeamStanding basketballTeamStanding = string2;
        String string2 = String.format("%.3f", Arrays.copyOf(new Object[]{((BasketballTeamStanding)((Object)string2)).getPercentage()}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        int n = basketballTeamStanding.getPercentage() < 1.0 ? 1 : 0;
        return StringsKt.drop((String)string2, (int)n);
    }

    public final long component1() {
        return this.getId();
    }

    @NotNull
    public final String component2() {
        return this.getTeamName();
    }

    @NotNull
    public final String component3() {
        return this.getTeamIcon();
    }

    @NotNull
    public final List<String> component4() {
        return this.getColors();
    }

    public final int component5() {
        return this.getWins();
    }

    public final int component6() {
        return this.getLosses();
    }

    public final double component7() {
        return this.getPercentage();
    }

    public final int component8() {
        return this.getGamesBehind();
    }

    @NotNull
    public final BasketballTeamStreak component9() {
        return this.streak;
    }

    @NotNull
    public final BasketballTeamRank component10() {
        return this.rank;
    }

    @NotNull
    public final String component11() {
        return this.division;
    }

    @NotNull
    public final String component12() {
        return this.conference;
    }

    @Nullable
    public final String component13() {
        return this.league;
    }

    @NotNull
    public final BasketballTeamStanding copy(long l, @NotNull String string2, @NotNull String string3, @NotNull List<String> list, int n, int n2, double d, int n3, @NotNull BasketballTeamStreak basketballTeamStreak, @NotNull BasketballTeamRank basketballTeamRank, @NotNull String string4, @NotNull String string5, @Nullable String string6) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"teamName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"teamIcon");
        Intrinsics.checkNotNullParameter(list, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)basketballTeamStreak, (String)"streak");
        Intrinsics.checkNotNullParameter((Object)basketballTeamRank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"division");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"conference");
        return new BasketballTeamStanding(l, string2, string3, list, n, n2, d, n3, basketballTeamStreak, basketballTeamRank, string4, string5, string6);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BasketballTeamStanding(id=").append(this.getId()).append(", teamName=").append(this.getTeamName()).append(", teamIcon=").append(this.getTeamIcon()).append(", colors=").append(this.getColors()).append(", wins=").append(this.getWins()).append(", losses=").append(this.getLosses()).append(", percentage=").append(this.getPercentage()).append(", gamesBehind=").append(this.getGamesBehind()).append(", streak=").append(this.streak).append(", rank=").append(this.rank).append(", division=").append(this.division).append(", conference=");
        stringBuilder.append(this.conference).append(", league=").append((Object)this.league).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        BasketballTeamStanding basketballTeamStanding = this;
        int n = (((((((((((Long.hashCode(basketballTeamStanding.getId()) * 31 + this.getTeamName().hashCode()) * 31 + this.getTeamIcon().hashCode()) * 31 + ((Object)this.getColors()).hashCode()) * 31 + Integer.hashCode(this.getWins())) * 31 + Integer.hashCode(this.getLosses())) * 31 + Double.hashCode(this.getPercentage())) * 31 + Integer.hashCode(this.getGamesBehind())) * 31 + this.streak.hashCode()) * 31 + this.rank.hashCode()) * 31 + this.division.hashCode()) * 31 + this.conference.hashCode()) * 31;
        String string2 = basketballTeamStanding.league;
        int n2 = string2 == null ? 0 : string2.hashCode();
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BasketballTeamStanding)) {
            return false;
        }
        object = (BasketballTeamStanding)object;
        if (this.getId() != ((BasketballTeamStanding)object).getId()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTeamName(), (Object)((BasketballTeamStanding)object).getTeamName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTeamIcon(), (Object)((BasketballTeamStanding)object).getTeamIcon())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getColors(), ((BasketballTeamStanding)object).getColors())) {
            return false;
        }
        if (this.getWins() != ((BasketballTeamStanding)object).getWins()) {
            return false;
        }
        if (this.getLosses() != ((BasketballTeamStanding)object).getLosses()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPercentage(), (Object)((BasketballTeamStanding)object).getPercentage())) {
            return false;
        }
        if (this.getGamesBehind() != ((BasketballTeamStanding)object).getGamesBehind()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.streak, (Object)((BasketballTeamStanding)object).streak)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rank, (Object)((BasketballTeamStanding)object).rank)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.division, (Object)((BasketballTeamStanding)object).division)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.conference, (Object)((BasketballTeamStanding)object).conference)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.league, (Object)((BasketballTeamStanding)object).league);
    }
}

