/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.sports.hockey;

import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.model.sports.hockey.HockeyTeamRank;
import io.streamlayer.sdk.model.sports.hockey.HockeyTeamStreak;
import java.util.Arrays;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HockeyTeamStanding
implements TeamStandings {
    private final long id;
    @NotNull
    private final String teamName;
    @NotNull
    private final String teamIcon;
    @NotNull
    private final List<String> colors;
    private final int wins;
    private final int losses;
    private final double percentage;
    private final int gamesBehind;
    @NotNull
    private final HockeyTeamStreak streak;
    @NotNull
    private final HockeyTeamRank rank;
    @NotNull
    private final String division;
    @NotNull
    private final String conference;

    public HockeyTeamStanding(long l, @NotNull String string2, @NotNull String string3, @NotNull List<String> list, int n, int n2, double d, int n3, @NotNull HockeyTeamStreak hockeyTeamStreak, @NotNull HockeyTeamRank hockeyTeamRank, @NotNull String string4, @NotNull String string5) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"teamName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"teamIcon");
        Intrinsics.checkNotNullParameter(list, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)hockeyTeamStreak, (String)"streak");
        Intrinsics.checkNotNullParameter((Object)hockeyTeamRank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"division");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"conference");
        this.id = l;
        this.teamName = string2;
        this.teamIcon = string3;
        this.colors = list;
        this.wins = n;
        this.losses = n2;
        this.percentage = d;
        this.gamesBehind = n3;
        this.streak = hockeyTeamStreak;
        this.rank = hockeyTeamRank;
        this.division = string4;
        this.conference = string5;
    }

    public static /* synthetic */ HockeyTeamStanding copy$default(HockeyTeamStanding hockeyTeamStanding, long l, String string2, String string3, List list, int n, int n2, double d, int n3, HockeyTeamStreak hockeyTeamStreak, HockeyTeamRank hockeyTeamRank, String string4, String string5, int n4, Object object) {
        if ((n4 & 1) != 0) {
            l = hockeyTeamStanding.getId();
        }
        if ((n4 & 2) != 0) {
            string2 = hockeyTeamStanding.getTeamName();
        }
        if ((n4 & 4) != 0) {
            string3 = hockeyTeamStanding.getTeamIcon();
        }
        if ((n4 & 8) != 0) {
            list = hockeyTeamStanding.getColors();
        }
        if ((n4 & 0x10) != 0) {
            n = hockeyTeamStanding.getWins();
        }
        if ((n4 & 0x20) != 0) {
            n2 = hockeyTeamStanding.getLosses();
        }
        if ((n4 & 0x40) != 0) {
            d = hockeyTeamStanding.getPercentage();
        }
        if ((n4 & 0x80) != 0) {
            n3 = hockeyTeamStanding.getGamesBehind();
        }
        if ((n4 & 0x100) != 0) {
            hockeyTeamStreak = hockeyTeamStanding.streak;
        }
        if ((n4 & 0x200) != 0) {
            hockeyTeamRank = hockeyTeamStanding.rank;
        }
        if ((n4 & 0x400) != 0) {
            string4 = hockeyTeamStanding.division;
        }
        if ((n4 & 0x800) != 0) {
            string5 = hockeyTeamStanding.conference;
        }
        return hockeyTeamStanding.copy(l, string2, string3, list, n, n2, d, n3, hockeyTeamStreak, hockeyTeamRank, string4, string5);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTeamName() {
        return this.teamName;
    }

    @Override
    @NotNull
    public String getTeamIcon() {
        return this.teamIcon;
    }

    @Override
    @NotNull
    public List<String> getColors() {
        return this.colors;
    }

    @Override
    public int getWins() {
        return this.wins;
    }

    @Override
    public int getLosses() {
        return this.losses;
    }

    @Override
    public double getPercentage() {
        return this.percentage;
    }

    @Override
    public int getGamesBehind() {
        return this.gamesBehind;
    }

    @NotNull
    public final HockeyTeamStreak getStreak() {
        return this.streak;
    }

    @NotNull
    public final HockeyTeamRank getRank() {
        return this.rank;
    }

    @NotNull
    public final String getDivision() {
        return this.division;
    }

    @NotNull
    public final String getConference() {
        return this.conference;
    }

    @Override
    @NotNull
    public String getStreakTitle() {
        String string2 = "%s%d";
        int n = 2;
        Object[] objectArray = new Object[2];
        int n2 = 0;
        Object object = StringsKt.firstOrNull((CharSequence)this.streak.getKind());
        object = object == null ? "" : Character.valueOf(Character.toUpperCase(((Character)object).charValue()));
        objectArray[n2] = object;
        objectArray[1] = this.streak.getLength();
        String string3 = String.format(string2, Arrays.copyOf(objectArray, n));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return string3;
    }

    @Override
    @NotNull
    public String formatPercentage() {
        return String.valueOf(this.getPercentage());
    }

    public final long component1() {
        return this.getId();
    }

    @NotNull
    public final String component2() {
        return this.getTeamName();
    }

    @NotNull
    public final String component3() {
        return this.getTeamIcon();
    }

    @NotNull
    public final List<String> component4() {
        return this.getColors();
    }

    public final int component5() {
        return this.getWins();
    }

    public final int component6() {
        return this.getLosses();
    }

    public final double component7() {
        return this.getPercentage();
    }

    public final int component8() {
        return this.getGamesBehind();
    }

    @NotNull
    public final HockeyTeamStreak component9() {
        return this.streak;
    }

    @NotNull
    public final HockeyTeamRank component10() {
        return this.rank;
    }

    @NotNull
    public final String component11() {
        return this.division;
    }

    @NotNull
    public final String component12() {
        return this.conference;
    }

    @NotNull
    public final HockeyTeamStanding copy(long l, @NotNull String string2, @NotNull String string3, @NotNull List<String> list, int n, int n2, double d, int n3, @NotNull HockeyTeamStreak hockeyTeamStreak, @NotNull HockeyTeamRank hockeyTeamRank, @NotNull String string4, @NotNull String string5) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"teamName");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"teamIcon");
        Intrinsics.checkNotNullParameter(list, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)hockeyTeamStreak, (String)"streak");
        Intrinsics.checkNotNullParameter((Object)hockeyTeamRank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"division");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"conference");
        return new HockeyTeamStanding(l, string2, string3, list, n, n2, d, n3, hockeyTeamStreak, hockeyTeamRank, string4, string5);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HockeyTeamStanding(id=").append(this.getId()).append(", teamName=").append(this.getTeamName()).append(", teamIcon=").append(this.getTeamIcon()).append(", colors=").append(this.getColors()).append(", wins=").append(this.getWins()).append(", losses=").append(this.getLosses()).append(", percentage=").append(this.getPercentage()).append(", gamesBehind=").append(this.getGamesBehind()).append(", streak=").append(this.streak).append(", rank=").append(this.rank).append(", division=").append(this.division).append(", conference=");
        stringBuilder.append(this.conference).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return ((((((((((Long.hashCode(this.getId()) * 31 + this.getTeamName().hashCode()) * 31 + this.getTeamIcon().hashCode()) * 31 + ((Object)this.getColors()).hashCode()) * 31 + Integer.hashCode(this.getWins())) * 31 + Integer.hashCode(this.getLosses())) * 31 + Double.hashCode(this.getPercentage())) * 31 + Integer.hashCode(this.getGamesBehind())) * 31 + this.streak.hashCode()) * 31 + this.rank.hashCode()) * 31 + this.division.hashCode()) * 31 + this.conference.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HockeyTeamStanding)) {
            return false;
        }
        object = (HockeyTeamStanding)object;
        if (this.getId() != ((HockeyTeamStanding)object).getId()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTeamName(), (Object)((HockeyTeamStanding)object).getTeamName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTeamIcon(), (Object)((HockeyTeamStanding)object).getTeamIcon())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getColors(), ((HockeyTeamStanding)object).getColors())) {
            return false;
        }
        if (this.getWins() != ((HockeyTeamStanding)object).getWins()) {
            return false;
        }
        if (this.getLosses() != ((HockeyTeamStanding)object).getLosses()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPercentage(), (Object)((HockeyTeamStanding)object).getPercentage())) {
            return false;
        }
        if (this.getGamesBehind() != ((HockeyTeamStanding)object).getGamesBehind()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.streak, (Object)((HockeyTeamStanding)object).streak)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rank, (Object)((HockeyTeamStanding)object).rank)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.division, (Object)((HockeyTeamStanding)object).division)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.conference, (Object)((HockeyTeamStanding)object).conference);
    }
}

