/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.overlay;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.activity.OnBackPressedCallback;
import androidx.core.widget.ContentLoadingProgressBar;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.KeyboardDismissBackCallback;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.DialogUtil;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.base.InterfacesKt;
import io.streamlayer.sdk.base.StreamLayerBaseFragment;
import io.streamlayer.sdk.base.StreamLayerBaseFragmentKt;
import io.streamlayer.sdk.overlay.OverlayFragment;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OverlayFragment
extends StreamLayerBaseFragment {
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap<Integer, View>();
    @NotNull
    private final Lazy session$delegate = LazyKt.lazy((Function0)new Function0<Session>(this){
        final /* synthetic */ OverlayFragment this$0;
        {
            this.this$0 = overlayFragment;
            super(0);
        }

        @NotNull
        public final Session invoke() {
            return (Session)this.this$0.getKoin().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null);
        }
    });
    @Nullable
    private ContentLoadingProgressBar toolbarProgressCircle;
    @Nullable
    private Dialog progressDialog;

    public OverlayFragment(int n) {
        super(n);
    }

    @NotNull
    protected final Session getSession() {
        return (Session)this.session$delegate.getValue();
    }

    public void onViewCreated(@NotNull View view2, @Nullable Bundle bundle) {
        View view3 = view2;
        Intrinsics.checkNotNullParameter((Object)view3, (String)"view");
        super.onViewCreated(view3, bundle);
        this.toolbarProgressCircle = (ContentLoadingProgressBar)view2.findViewById(R.id.toolbarProgressCircle);
        bundle = (ImageView)view2.findViewById(R.id.toolbarAdSpace);
        if (bundle != null) {
            this.loadAdImage((ImageView)bundle);
        }
        this.overrideBackPress(view2);
    }

    @Override
    public void onDestroyView() {
        OverlayFragment overlayFragment = this;
        overlayFragment.onDestroyViewAction();
        overlayFragment.showLoader(false);
        super.onDestroyView();
        overlayFragment._$_clearFindViewByIdCache();
    }

    public void showError(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"errorMessage");
        Toast.makeText((Context)this.requireContext(), (CharSequence)string2, (int)0).show();
    }

    public void showError(int n) {
        Toast.makeText((Context)this.requireContext(), (int)n, (int)0).show();
    }

    public void showShortInfo(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"info");
        Toast.makeText((Context)this.requireContext(), (CharSequence)string2, (int)0).show();
    }

    public void showProgressCircle(boolean bl) {
        ContentLoadingProgressBar contentLoadingProgressBar = this.toolbarProgressCircle;
        if (contentLoadingProgressBar == null) {
            contentLoadingProgressBar = null;
        } else if (bl) {
            contentLoadingProgressBar.show();
        } else {
            contentLoadingProgressBar.hide();
        }
        if (contentLoadingProgressBar == null) {
            this.showLoader(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showLoader(boolean bl) {
        if (bl) {
            Dialog dialog = this.progressDialog;
            if (dialog != null && dialog.isShowing()) {
                return;
            }
            boolean bl2 = false;
            if (bl2) {
                return;
            }
            if (this.progressDialog == null) {
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                this.progressDialog = DialogUtil.INSTANCE.buildLoaderDialog(context);
            }
            if ((this = this.progressDialog) == null) {
                return;
            }
            this.show();
            return;
        }
        Dialog dialog = this.progressDialog;
        if (dialog == null) {
            return;
        }
        dialog.dismiss();
        this.progressDialog = null;
    }

    public void hideKeyboard(@NotNull View view2) {
        View view3 = view2;
        Intrinsics.checkNotNullParameter((Object)view3, (String)"view");
        ViewExtensionsKt.hideKeyboard(view3);
    }

    public void overrideBackPress(@Nullable View view2) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity != null && (fragmentActivity = fragmentActivity.getOnBackPressedDispatcher()) != null) {
            Function0<Unit> function0;
            KeyboardDismissBackCallback keyboardDismissBackCallback;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            fragmentActivity = this.getViewLifecycleOwner();
            KeyboardDismissBackCallback keyboardDismissBackCallback2 = keyboardDismissBackCallback;
            Function0<Unit> function02 = function0;
            function0 = new Function0<Unit>(view2, this){
                final /* synthetic */ View $view;
                final /* synthetic */ OverlayFragment this$0;
                {
                    this.$view = view2;
                    this.this$0 = overlayFragment;
                    super(0);
                }

                public final void invoke() {
                    View view2 = object.$view;
                    if (view2 != null) {
                        ViewExtensionsKt.hideKeyboard(view2);
                    }
                    Object object = InterfacesKt.findSdkHost(object.this$0);
                    if (object != null && (object = object.getNavigator()) != null) {
                        object.popBackStack();
                    }
                }
            };
            keyboardDismissBackCallback = new KeyboardDismissBackCallback(view2, function02);
            fragmentActivity2.addCallback((LifecycleOwner)fragmentActivity, (OnBackPressedCallback)keyboardDismissBackCallback2);
        }
    }

    public boolean canShowAdImage() {
        return true;
    }

    public void onDestroyViewAction() {
        View view2 = this.getView();
        if (view2 != null) {
            this.hideKeyboard(view2);
        }
    }

    protected final void loadAdImage(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"adImageView");
        if (this.canShowAdImage()) {
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(imageView, this, null){
                int label;
                final /* synthetic */ ImageView $adImageView;
                final /* synthetic */ OverlayFragment this$0;
                {
                    this.$adImageView = imageView;
                    this.this$0 = overlayFragment;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    int n = this.label;
                    if (n != 0) {
                        if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        ResultKt.throwOnFailure((Object)object);
                    } else {
                        ResultKt.throwOnFailure((Object)object);
                        CoilExtensionsKt.clear(this.$adImageView, loadAdImage.1.INSTANCE);
                        this.label = 1;
                        if (DelayKt.delay((long)100L, (Continuation)this) == object2) {
                            return object2;
                        }
                    }
                    object = InterfacesKt.findSdkHost(this.this$0);
                    if (object == null || (object = object.getCurrentSponsorUrl()) == null) return Unit.INSTANCE;
                    ViewExtensionsKt.loadUrl$default(this.$adImageView, (String)object, false, null, null, 14, null);
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    loadAdImage.1 v0 = this_;
                    loadAdImage.1 this_ = v0.$adImageView;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            };
            BuildersKt.launch$default((CoroutineScope)StreamLayerBaseFragmentKt.getUiScope(this), null, null, (Function2)function22, (int)3, null);
        }
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 != null) return view2;
        if ((this = this.getView()) == null) return null;
        view2 = this.findViewById(n);
        if (view2 == null) return null;
        map2.put(n, view2);
        return view2;
    }
}

