/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.predictions.leaderboard;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.paging.PagingDataAdapter;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import coil.ImageLoader;
import coil.request.ImageRequest;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.views.AcronymDrawable;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.databinding.SlrPredictionsLeaderboardItemBinding;
import io.streamlayer.sdk.model.predictions.LeaderboardLeader;
import io.streamlayer.sdk.predictions.leaderboard.LeadersComparator;
import io.streamlayer.sdk.predictions.view.ShapesKt;
import java.text.DecimalFormat;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LeaderboardAdapter
extends PagingDataAdapter<LeaderboardLeader, LeaderItemViewHolder> {
    @NotNull
    private final Function1<LeaderboardLeader, Unit> selectLeader;

    public LeaderboardAdapter(@NotNull Function1<? super LeaderboardLeader, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"selectLeader");
        super((DiffUtil.ItemCallback)LeadersComparator.INSTANCE, null, null, 6, null);
        this.selectLeader = function1;
    }

    @NotNull
    public LeaderItemViewHolder onCreateViewHolder(@NotNull ViewGroup object, int n) {
        ViewGroup viewGroup = object;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        object = SlrPredictionsLeaderboardItemBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), object, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return new LeaderItemViewHolder((SlrPredictionsLeaderboardItemBinding)object);
    }

    public void onBindViewHolder(@NotNull LeaderItemViewHolder leaderItemViewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)leaderItemViewHolder), (String)"holder");
        leaderItemViewHolder.bind((LeaderboardLeader)this.getItem(n));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class LeaderItemViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrPredictionsLeaderboardItemBinding binding;

        public LeaderItemViewHolder(SlrPredictionsLeaderboardItemBinding slrPredictionsLeaderboardItemBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)LeaderboardAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrPredictionsLeaderboardItemBinding, (String)"binding");
            super((View)slrPredictionsLeaderboardItemBinding.getRoot());
            this.binding = slrPredictionsLeaderboardItemBinding;
        }

        private static final void bind$lambda-0(LeaderboardAdapter leaderboardAdapter, LeaderboardLeader leaderboardLeader, View view2) {
            LeaderboardAdapter leaderboardAdapter2 = leaderboardAdapter;
            Intrinsics.checkNotNullParameter((Object)((Object)leaderboardAdapter2), (String)"this$0");
            leaderboardAdapter2.selectLeader.invoke((Object)leaderboardLeader);
        }

        public final void bind(@Nullable LeaderboardLeader object) {
            int n;
            LeaderItemViewHolder leaderItemViewHolder = leaderItemViewHolder4;
            Context context = leaderItemViewHolder.binding.getRoot().getContext();
            ConstraintLayout constraintLayout = leaderItemViewHolder.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            boolean bl = object != null;
            ViewExtensionsKt.visibleIf((View)constraintLayout, bl);
            if (object == null) {
                return;
            }
            LeaderboardLeader leaderboardLeader = object;
            LeaderItemViewHolder leaderItemViewHolder2 = leaderItemViewHolder4;
            ConstraintLayout constraintLayout2 = leaderItemViewHolder2.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.root");
            ViewExtensionsKt.visible((View)constraintLayout2);
            leaderItemViewHolder2.binding.getRoot().setOnClickListener(arg_0 -> LeaderItemViewHolder.bind$lambda-0(leaderItemViewHolder4.LeaderboardAdapter.this, (LeaderboardLeader)object, arg_0));
            leaderItemViewHolder2.binding.itemText.setText((CharSequence)((LeaderboardLeader)object).getName());
            constraintLayout = leaderItemViewHolder2.binding.userIcon;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.userIcon");
            Object object2 = leaderboardLeader.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout.getContext(), (String)"fun ImageView.load(\n    \u2026ri, imageLoader, builder)");
            ImageLoader imageLoader = (ImageLoader)StreamLayer.INSTANCE.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ImageLoader.class), null, null);
            Context context2 = constraintLayout.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            constraintLayout = new ImageRequest.Builder(context2).data(object2).target((ImageView)constraintLayout);
            String string2 = leaderboardLeader.getName();
            if (string2 == null) {
                string2 = "";
            }
            LeaderItemViewHolder leaderItemViewHolder3 = leaderItemViewHolder4;
            ConstraintLayout constraintLayout3 = constraintLayout;
            Object object3 = object2;
            ((AcronymDrawable)((Object)object3))(string2, 0.0f, false, null, null, null, null, 126, null);
            constraintLayout3.error((Drawable)object3);
            imageLoader.enqueue(constraintLayout3.build());
            leaderItemViewHolder3.binding.rankText.setText((CharSequence)String.valueOf(((LeaderboardLeader)object).getRank()));
            leaderItemViewHolder3.binding.scoreText.setText((CharSequence)new DecimalFormat("#,###").format((Object)((LeaderboardLeader)object).getScore()));
            constraintLayout = leaderItemViewHolder3.binding.scoreText;
            int n2 = ((LeaderboardLeader)object).getRank() > 3 ? R.color.slr_white_alpha_50 : R.color.slr_white;
            constraintLayout.setTextColor(ContextCompat.getColor((Context)context, (int)n2));
            LeaderItemViewHolder leaderItemViewHolder4 = leaderItemViewHolder4.binding.itemLayout;
            object = ((LeaderboardLeader)object).getSelected() ? ShapesKt.createRoundRect6(ContextCompat.getColor((Context)context, (int)R.color.slr_predictions_selected_blue), ContextCompat.getColor((Context)context, (int)R.color.slr_blue10)) : ((n = ((LeaderboardLeader)object).getRank()) != 1 ? (n != 2 ? (n != 3 ? null : ShapesKt.createFilledRoundRect6(ContextCompat.getColor((Context)context, (int)R.color.slr_blue20))) : ShapesKt.createFilledRoundRect6(ContextCompat.getColor((Context)context, (int)R.color.slr_blue60))) : ShapesKt.createFilledRoundRect6(ContextCompat.getColor((Context)context, (int)R.color.slr_predictions_selected_blue)));
            leaderItemViewHolder4.setBackground((Drawable)object);
        }
    }
}

