/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import io.streamlayer.sdk.model.notifications.Notification;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Dao
public interface NotificationDao {
    @Insert(onConflict=5)
    public void saveNotifications(@NotNull List<Notification> var1);

    @Insert(onConflict=1)
    public long saveNotification(@NotNull Notification var1);

    @Update
    public void updateNotifications(@NotNull List<Notification> var1);

    @Query(value="SELECT * FROM Notification ORDER BY Notification.id DESC, Notification.date DESC")
    @NotNull
    public Flow<List<Notification>> getNotifications();

    @Delete
    @Nullable
    public Object deleteNotifications(@NotNull List<Notification> var1, @NotNull Continuation<? super Unit> var2);

    @Delete
    @Nullable
    public Object deleteNotification(@NotNull Notification var1, @NotNull Continuation<? super Unit> var2);

    public void deleteAllNotifications();

    @Query(value="DELETE FROM Notification")
    public void safeDeleteAllNotifications();

    @Query(value="DELETE FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    public void deleteNotification(@NotNull String var1);

    @Query(value="SELECT * FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    @Nullable
    public Notification getNotification(@NotNull String var1);

    @Query(value="DELETE FROM Notification WHERE _type = :type")
    public void deleteNotificationsByType(@NotNull String var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class DefaultImpls {
        public static void deleteAllNotifications(@NotNull NotificationDao notificationDao) {
            Intrinsics.checkNotNullParameter((Object)notificationDao, (String)"this");
            new Thread(() -> DefaultImpls.deleteAllNotifications$lambda-0(notificationDao)).start();
        }

        private static void deleteAllNotifications$lambda-0(NotificationDao notificationDao) {
            NotificationDao notificationDao2 = notificationDao;
            Intrinsics.checkNotNullParameter((Object)notificationDao2, (String)"this$0");
            notificationDao2.safeDeleteAllNotifications();
        }
    }
}

