/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.tinodecontacts;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Dao
public interface TinodeContactDao {
    @Insert(onConflict=1)
    @Nullable
    public Object saveTinodeContacts(@NotNull List<TinodeContact> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(onConflict=5)
    @Nullable
    public Object insertTinodeContacts(@NotNull List<TinodeContact> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * FROM TinodeContact WHERE chatName LIKE '%' || :query || '%'")
    @NotNull
    public Flow<List<TinodeContact>> queryTinodeContacts(@NotNull String var1);

    @Query(value="SELECT * FROM TinodeContact")
    @NotNull
    public Flow<List<TinodeContact>> getAllTinodeContacts();

    @Query(value="SELECT * FROM TinodeContact WHERE chatUserId = :chatUserId")
    @Nullable
    public Object getTinodeContact(@NotNull String var1, @NotNull Continuation<? super TinodeContact> var2);

    @Delete
    public void deleteTinodeContacts(@NotNull List<TinodeContact> var1);

    @Query(value="DELETE FROM TinodeContact")
    public void deleteTinodeContacts();

    @Query(value="UPDATE TinodeContact SET online = :online")
    @Nullable
    public Object setTinodeContactPresences(boolean var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT COUNT(*) FROM TinodeContact")
    @NotNull
    public Flow<Integer> getTinodeContactsCount();

    @Insert(onConflict=1)
    @Nullable
    public Object saveTinodeContact(@NotNull TinodeContact var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="UPDATE TinodeContact SET online = :online WHERE chatUserId =:chatUserId")
    @Nullable
    public Object setTinodeContactOnline(@NotNull String var1, boolean var2, @NotNull Continuation<? super Unit> var3);

    @Query(value="UPDATE TinodeContact SET externalId = :externalId, bypassId = :bypassId  WHERE chatUserId =:chatUserId")
    @Nullable
    public Object setTinodeContactIds(@NotNull String var1, @Nullable String var2, @Nullable String var3, @NotNull Continuation<? super Unit> var4);
}

