/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.baseball.BaseballPlayByPlayStatistics;
import io.streamlayer.sdk.model.sports.baseball.BaseballPlayByPlayStatisticsDetails;
import io.streamlayer.sdk.statistics.baseball.DetailsItem;
import io.streamlayer.sdk.statistics.baseball.HeaderItem;
import io.streamlayer.sdk.statistics.baseball.PlayByPlayItem;
import io.streamlayer.sdk.statistics.baseball.SummaryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BaseballPlayByPlayAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @Nullable
    private EventSummary summary;
    @NotNull
    private List<? extends PlayByPlayItem> data = CollectionsKt.emptyList();

    public final void setSummary(@NotNull EventSummary eventSummary2) {
        EventSummary eventSummary3 = eventSummary2;
        Intrinsics.checkNotNullParameter((Object)eventSummary3, (String)"eventSummary");
        this.summary = eventSummary3;
        if (this.data.isEmpty() ^ true) {
            this.notifyDataSetChanged();
        }
    }

    public final void setData(@NotNull List<BaseballPlayByPlayStatistics> arrayList) {
        ArrayList<? extends PlayByPlayItem> arrayList2;
        ArrayList<? extends PlayByPlayItem> arrayList3 = arrayList;
        Intrinsics.checkNotNullParameter(arrayList3, (String)"statistics");
        arrayList = arrayList2;
        arrayList2 = new ArrayList<PlayByPlayItem>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            SummaryItem summaryItem;
            ArrayList arrayList4;
            BaseballPlayByPlayStatistics baseballPlayByPlayStatistics;
            BaseballPlayByPlayStatistics baseballPlayByPlayStatistics2 = baseballPlayByPlayStatistics = (BaseballPlayByPlayStatistics)iterator.next();
            Object object = baseballPlayByPlayStatistics2.getTeam();
            Object object2 = baseballPlayByPlayStatistics2.getInning();
            Object object3 = baseballPlayByPlayStatistics2.getPlayText();
            arrayList.add(new HeaderItem((EventTeam)object, (String)object2, (String)object3));
            object = baseballPlayByPlayStatistics.getDetails();
            object2 = arrayList4;
            arrayList4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (BaseballPlayByPlayStatisticsDetails)object.next();
                object2.add(new DetailsItem((BaseballPlayByPlayStatisticsDetails)object3));
            }
            ArrayList<? extends PlayByPlayItem> arrayList5 = arrayList;
            arrayList5.addAll((Collection<? extends PlayByPlayItem>)object2);
            object = summaryItem;
            BaseballPlayByPlayStatistics baseballPlayByPlayStatistics3 = baseballPlayByPlayStatistics;
            int n = baseballPlayByPlayStatistics3.getRuns();
            int n2 = baseballPlayByPlayStatistics3.getErrors();
            int n3 = baseballPlayByPlayStatistics3.getHits();
            summaryItem = new SummaryItem(n, n2, n3);
            arrayList5.add((PlayByPlayItem)object);
        }
        this.data = arrayList;
        if (this.summary != null) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            if (n != 1) {
                SummaryViewHolder summaryViewHolder;
                if (n != 2) throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported viewType: ", (Object)n));
                viewHolder = summaryViewHolder;
                summaryViewHolder = new SummaryViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_play_by_play_summary));
                return viewHolder;
            } else {
                DetailsViewHolder detailsViewHolder;
                viewHolder = detailsViewHolder;
                detailsViewHolder = new DetailsViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_play_by_play_detail));
            }
            return viewHolder;
        } else {
            HeaderViewHolder headerViewHolder;
            viewHolder = headerViewHolder;
            headerViewHolder = new HeaderViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_play_by_play_header));
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        return this.data.get(n).getViewType();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof HeaderViewHolder && object instanceof HeaderItem) {
            ((HeaderViewHolder)viewHolder).bind((HeaderItem)object);
        } else if (viewHolder instanceof DetailsViewHolder && object instanceof DetailsItem) {
            ((DetailsViewHolder)viewHolder).bind((DetailsItem)object);
        } else if (viewHolder instanceof SummaryViewHolder && object instanceof SummaryItem) {
            ((SummaryViewHolder)viewHolder).bind((SummaryItem)object);
        }
    }

    public final class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        public HeaderViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)BaseballPlayByPlayAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void bind(@NotNull HeaderItem object) {
            HeaderViewHolder headerViewHolder = headerViewHolder2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"item");
            HeaderViewHolder headerViewHolder2 = headerViewHolder.itemView;
            BaseballPlayByPlayAdapter baseballPlayByPlayAdapter = headerViewHolder.BaseballPlayByPlayAdapter.this;
            HeaderViewHolder headerViewHolder3 = headerViewHolder2;
            ImageView imageView = (ImageView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayTeamLogo);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slBaseballPlayByPlayTeamLogo");
            ViewExtensionsKt.loadUrl$default(imageView, ((HeaderItem)object).getTeam().getLogo(), false, null, null, 12, null);
            ((TextView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayTeamName)).setText((CharSequence)headerViewHolder2.getContext().getString(R.string.slr_statistics_baseball_play_by_play_play_team_name, new Object[]{((HeaderItem)object).getTeam().getName(), ((HeaderItem)object).getInning()}));
            ((TextView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayPlayText)).setText((CharSequence)headerViewHolder2.getContext().getString(R.string.slr_statistics_baseball_play_by_play_play_text, new Object[]{((HeaderItem)object).getPlayText(), ((HeaderItem)object).getTeam().getAlias()}));
            object = (TextView)headerViewHolder3.findViewById(R.id.slBaseballPlayByPlayPointsHome);
            Object object2 = baseballPlayByPlayAdapter.summary;
            object2 = object2 == null || (object2 = ((EventSummary)object2).getHomeTeam()) == null ? null : ((EventTeam)object2).getAlias();
            object.setText((CharSequence)object2);
            headerViewHolder2 = (TextView)headerViewHolder2.findViewById(R.id.slBaseballPlayByPlayPointsAway);
            object = baseballPlayByPlayAdapter.summary;
            object = object == null || (object = ((EventSummary)object).getAwayTeam()) == null ? null : ((EventTeam)object).getAlias();
            headerViewHolder2.setText((CharSequence)object);
        }
    }

    public final class DetailsViewHolder
    extends RecyclerView.ViewHolder {
        public DetailsViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)BaseballPlayByPlayAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull DetailsItem detailsItem) {
            DetailsViewHolder detailsViewHolder = baseballPlayByPlayStatisticsDetails;
            DetailsItem detailsItem2 = detailsItem;
            Intrinsics.checkNotNullParameter((Object)detailsItem2, (String)"detailsItem");
            BaseballPlayByPlayStatisticsDetails baseballPlayByPlayStatisticsDetails = detailsItem2.component1();
            View view2 = detailsViewHolder.itemView;
            ((TextView)view2.findViewById(R.id.slBaseballPlayByPlayPlayText)).setText((CharSequence)baseballPlayByPlayStatisticsDetails.getPlayText());
            ((TextView)view2.findViewById(R.id.slBaseballPlayByPlayPointsHome)).setText((CharSequence)String.valueOf(baseballPlayByPlayStatisticsDetails.getScoreHome()));
            ((TextView)view2.findViewById(R.id.slBaseballPlayByPlayPointsAway)).setText((CharSequence)String.valueOf(baseballPlayByPlayStatisticsDetails.getScoreAway()));
        }
    }

    public final class SummaryViewHolder
    extends RecyclerView.ViewHolder {
        public SummaryViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)BaseballPlayByPlayAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull SummaryItem summaryItem) {
            Intrinsics.checkNotNullParameter((Object)summaryItem, (String)"summaryItem");
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = summaryItem.getRuns();
            objectArray2[1] = summaryItem.getHits();
            objectArray[2] = summaryItem.getErrors();
            ((TextView)objectArray2.itemView.findViewById(R.id.slBaseballPlayByPlaySummary)).setText((CharSequence)objectArray2.itemView.getContext().getString(R.string.slr_statistics_baseball_play_by_play_summary, objectArray));
        }
    }
}

