/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.basketball.playbyplay;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.statistics.common.model.PlayByPlayStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasketballPlayByPlayAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_STATISTIC = 1;
    @Nullable
    private Long homeTeamId;
    @NotNull
    private List<Object> items;

    public BasketballPlayByPlayAdapter() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    private final void findHomeTeamId(List<? extends PlayByPlayStatistics> object) {
        object = object.iterator();
        while (object.hasNext()) {
            PlayByPlayStatistics playByPlayStatistics = (PlayByPlayStatistics)object.next();
            if (!playByPlayStatistics.getScoring() || this.homeTeamId != null || playByPlayStatistics.getHomeScore() <= 0) continue;
            this.homeTeamId = playByPlayStatistics.getTeam().getId();
        }
    }

    public final void setItems(@NotNull List<? extends PlayByPlayStatistics> iterator) {
        LinkedHashMap linkedHashMap;
        Iterator<Map.Entry<Integer, List>> iterator2 = iterator;
        Intrinsics.checkNotNullParameter(iterator, (String)"listItems");
        this.items.clear();
        this.findHomeTeamId((List<? extends PlayByPlayStatistics>)((Object)iterator));
        iterator = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        Iterator iterator3 = iterator2.iterator();
        while (iterator3.hasNext()) {
            PlayByPlayStatistics object = (PlayByPlayStatistics)iterator3.next();
            List list = (List)((LinkedHashMap)((Object)iterator)).get(object.getEventTime().getPeriod());
            if (list == null) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
            }
            list.add(object);
            if (((HashMap)((Object)iterator)).containsKey(object.getEventTime().getPeriod())) continue;
            iterator.put(object.getEventTime().getPeriod(), list);
        }
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            BasketballPlayByPlayAdapter basketballPlayByPlayAdapter = this;
            Map.Entry entry = iterator.next();
            int n = ((Number)entry.getKey()).intValue();
            List list = (List)entry.getValue();
            basketballPlayByPlayAdapter.items.add(new HeaderItem(n));
            basketballPlayByPlayAdapter.items.addAll(list);
        }
        this.notifyDataSetChanged();
    }

    @Nullable
    public final Object getItem(int n) {
        return CollectionsKt.getOrNull(this.items, (int)n);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.items.get(n);
                    if (!(object instanceof HeaderItem)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof PlayByPlayStatistics)) break block4;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported item type at data[" + n + ']');
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof BasketballPlayByPlayHeaderViewHolder) {
            ((BasketballPlayByPlayHeaderViewHolder)viewHolder).bind((HeaderItem)this.items.get(n));
        } else if (viewHolder instanceof BasketballPlayByPlayViewHolder) {
            ((BasketballPlayByPlayViewHolder)viewHolder).bind((PlayByPlayStatistics)this.items.get(n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder;
            if (n != 1) throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported viewType: ", (Object)n));
            viewHolder = basketballPlayByPlayViewHolder;
            basketballPlayByPlayViewHolder = new BasketballPlayByPlayViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_basketball_play_by_play));
            return viewHolder;
        } else {
            BasketballPlayByPlayHeaderViewHolder basketballPlayByPlayHeaderViewHolder;
            viewHolder = basketballPlayByPlayHeaderViewHolder;
            basketballPlayByPlayHeaderViewHolder = new BasketballPlayByPlayHeaderViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_basketball_play_by_play_header));
        }
        return viewHolder;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public static final class HeaderItem {
        private final int period;

        public HeaderItem(int n) {
            this.period = n;
        }

        public static /* synthetic */ HeaderItem copy$default(HeaderItem headerItem, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = headerItem.period;
            }
            return headerItem.copy(n);
        }

        public final int getPeriod() {
            return this.period;
        }

        public final int component1() {
            return this.period;
        }

        @NotNull
        public final HeaderItem copy(int n) {
            return new HeaderItem(n);
        }

        @NotNull
        public String toString() {
            return "HeaderItem(period=" + this.period + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.period);
        }

        public boolean equals(@Nullable Object object) {
            if (headerItem2 == object) {
                return true;
            }
            if (!(object instanceof HeaderItem)) {
                return false;
            }
            HeaderItem headerItem = headerItem2;
            HeaderItem headerItem2 = (HeaderItem)object;
            return headerItem.period == headerItem2.period;
        }
    }

    public final class BasketballPlayByPlayHeaderViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<HeaderItem> {
        public BasketballPlayByPlayHeaderViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)BasketballPlayByPlayAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        @Override
        public void bind(@NotNull HeaderItem headerItem) {
            Intrinsics.checkNotNullParameter((Object)headerItem, (String)"data");
            ((TextView)this.itemView.findViewById(R.id.slBasketballPlayByPlayHeaderTV)).setText((CharSequence)this.itemView.getContext().getString(R.string.slr_s_quarter, new Object[]{OtherExtensionsKt.toOrdinalString(headerItem.getPeriod())}));
        }
    }

    public final class BasketballPlayByPlayViewHolder
    extends GenericAdapter.GenericViewHolder<PlayByPlayStatistics> {
        public BasketballPlayByPlayViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)BasketballPlayByPlayAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        private final void formatPlayText(TextView textView, boolean bl) {
            if (bl) {
                TextView textView2 = textView;
                textView2.setTypeface(textView2.getTypeface(), 1);
                textView2.setTextColor(ContextCompat.getColor((Context)textView2.getContext(), (int)R.color.slr_amber));
            } else {
                TextView textView3 = textView;
                textView3.setTypeface(textView3.getTypeface(), 0);
                textView3.setTextColor(ContextCompat.getColor((Context)textView3.getContext(), (int)R.color.slr_white_alpha_80));
            }
        }

        private final Spannable formatCurrentScore(PlayByPlayStatistics object, Context context) {
            String string2 = String.format("%d - %d", Arrays.copyOf(new Object[]{object.getHomeScore(), object.getAwayScore()}, 2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            if (object.getScoring()) {
                Long l = BasketballPlayByPlayAdapter.this.homeTeamId;
                long l2 = object.getTeam().getId();
                if (l != null && l == l2) {
                    object = String.format("%d -", Arrays.copyOf(new Object[]{object.getHomeScore()}, 1));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(format, *args)");
                } else {
                    object = String.format("- %d", Arrays.copyOf(new Object[]{object.getAwayScore()}, 1));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(format, *args)");
                }
                return this.spanText(string2, (String)object, context);
            }
            return new SpannableString((CharSequence)string2);
        }

        private final Spannable spanText(String string2, String string3, Context context) {
            TypefaceSpan typefaceSpan;
            ForegroundColorSpan foregroundColorSpan;
            SpannableString spannableString;
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder = spannableString;
            String string4 = string2;
            String string5 = string2;
            basketballPlayByPlayViewHolder(string2);
            basketballPlayByPlayViewHolder = foregroundColorSpan;
            foregroundColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.slr_white));
            string2 = typefaceSpan;
            typefaceSpan = new TypefaceSpan("sans-serif-black");
            int n = StringsKt.indexOf$default((CharSequence)string5, (String)string3, (int)0, (boolean)false, (int)6, null);
            int n2 = StringsKt.indexOf$default((CharSequence)string4, (String)string3, (int)0, (boolean)false, (int)6, null) + string3.length();
            spannableString.setSpan((Object)basketballPlayByPlayViewHolder, n, n2, 18);
            spannableString.setSpan((Object)string2, n, n2, 18);
            return spannableString;
        }

        @Override
        public void bind(@NotNull PlayByPlayStatistics playByPlayStatistics) {
            View view2;
            Intrinsics.checkNotNullParameter((Object)playByPlayStatistics, (String)"data");
            View view3 = view2 = basketballPlayByPlayViewHolder2.itemView;
            ImageView imageView = (ImageView)view3.findViewById(R.id.slBasketballPlayByPlayTeamLogoIV);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slBasketballPlayByPlayTeamLogoIV");
            ViewExtensionsKt.loadUrl$default(imageView, playByPlayStatistics.getTeam().getLogo(), false, null, null, 14, null);
            ((TextView)view3.findViewById(R.id.slBasketballPlayByPlayTimeTV)).setText((CharSequence)playByPlayStatistics.eventTimeFormat());
            ((TextView)view3.findViewById(R.id.slBasketballPlayByPlayInfoTV)).setText((CharSequence)playByPlayStatistics.getPlayText());
            TextView textView = (TextView)view3.findViewById(R.id.slBasketballPlayByPlayInfoTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"slBasketballPlayByPlayInfoTV");
            basketballPlayByPlayViewHolder2.formatPlayText(textView, playByPlayStatistics.getScoring());
            TextView textView2 = (TextView)view2.findViewById(R.id.slBasketballPlayByPlayScoreTV);
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder = basketballPlayByPlayViewHolder2;
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder2 = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)basketballPlayByPlayViewHolder2), (String)"context");
            textView2.setText((CharSequence)basketballPlayByPlayViewHolder.formatCurrentScore(playByPlayStatistics, (Context)basketballPlayByPlayViewHolder2));
        }
    }
}

