/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.common;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemScoresDateBinding;
import io.streamlayer.sdk.statistics.common.ScheduleDatesDiffUtil;
import io.streamlayer.sdk.statistics.common.model.ScoresScheduleDate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class ScoreDateAdapter
extends RecyclerView.Adapter<VH> {
    @NotNull
    private final Function1<ScoresScheduleDate, Unit> onClick;
    @NotNull
    private final List<ScoresScheduleDate> items;

    public ScoreDateAdapter(@NotNull Function1<? super ScoresScheduleDate, Unit> function1) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(function1, (String)"onClick");
        object.onClick = function1;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    public final void setData(@NotNull List<ScoresScheduleDate> list) {
        Intrinsics.checkNotNullParameter(list, (String)"items");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ScheduleDatesDiffUtil(this.items, list));
        ScoreDateAdapter scoreDateAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(ScheduleDa\u2026fUtil(this.items, items))");
        scoreDateAdapter.items.clear();
        scoreDateAdapter.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)scoreDateAdapter);
    }

    @NotNull
    public VH onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        ScoreDateAdapter scoreDateAdapter = object;
        Object object = SlrItemScoresDateBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return scoreDateAdapter.new VH((SlrItemScoresDateBinding)object);
    }

    public void onBindViewHolder(@NotNull VH vH, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)vH), (String)"holder");
        vH.bind(this.items.get(vH.getAbsoluteAdapterPosition()));
    }

    public int getItemCount() {
        return this.items.size();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class VH
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemScoresDateBinding binding;

        public VH(SlrItemScoresDateBinding slrItemScoresDateBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)ScoreDateAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemScoresDateBinding, (String)"binding");
            super((View)slrItemScoresDateBinding.root);
            this.binding = slrItemScoresDateBinding;
        }

        private static final void bind$lambda-1$lambda-0(ScoreDateAdapter scoreDateAdapter, ScoresScheduleDate scoresScheduleDate, View view2) {
            ScoreDateAdapter scoreDateAdapter2 = scoreDateAdapter;
            Intrinsics.checkNotNullParameter((Object)((Object)scoreDateAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)scoresScheduleDate, (String)"$item");
            scoreDateAdapter2.onClick.invoke((Object)scoresScheduleDate);
            scoreDateAdapter2.notifyDataSetChanged();
        }

        @NotNull
        public final SlrItemScoresDateBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull ScoresScheduleDate scoresScheduleDate) {
            Intrinsics.checkNotNullParameter((Object)scoresScheduleDate, (String)"item");
            SlrItemScoresDateBinding slrItemScoresDateBinding = vH.binding;
            ScoreDateAdapter scoreDateAdapter = vH.ScoreDateAdapter.this;
            ConstraintLayout constraintLayout = slrItemScoresDateBinding.root;
            VH vH = scoresScheduleDate.isSelected() ? vH.itemView.getContext().getResources().getDrawable(R.drawable.slr_shape_rect_rounded_blue, null) : null;
            SlrItemScoresDateBinding slrItemScoresDateBinding2 = slrItemScoresDateBinding;
            constraintLayout.setBackground((Drawable)vH);
            slrItemScoresDateBinding2.root.setOnClickListener(arg_0 -> VH.bind$lambda-1$lambda-0(scoreDateAdapter, scoresScheduleDate, arg_0));
            slrItemScoresDateBinding2.slDay.setText((CharSequence)scoresScheduleDate.getDate());
            slrItemScoresDateBinding2.slScoreWeekDay.setText((CharSequence)scoresScheduleDate.getDayOfWeek());
        }
    }
}

