/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.common;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.TeamStandings;
import io.streamlayer.sdk.model.sports.baseball.BaseballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.hockey.HockeyTeamStanding;
import io.streamlayer.sdk.statistics.common.SectionViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class StandingsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TYPE_SECTION = 0;
    private static final int TYPE_ITEM = 1;
    @NotNull
    private final Type type;
    @NotNull
    private List<? extends Object> data;

    public StandingsAdapter(@NotNull Type type2) {
        StandingsAdapter standingsAdapter = this;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        standingsAdapter.type = type2;
        standingsAdapter.data = CollectionsKt.emptyList();
    }

    public final void setData(@NotNull Map<String, ? extends List<? extends TeamStandings>> object) {
        ArrayList arrayList;
        Map<String, ? extends List<? extends TeamStandings>> map2 = object;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        object = arrayList;
        arrayList = new ArrayList();
        Iterator<Map.Entry<String, ? extends List<? extends TeamStandings>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object;
            Map.Entry<String, ? extends List<? extends TeamStandings>> entry = iterator.next();
            Object object3 = entry;
            object3 = object3.getValue();
            object2.add(entry.getKey());
            object2.addAll(object3);
        }
        this.data = object;
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.data.get(n);
                    if (!(object instanceof String)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof TeamStandings)) break block4;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported item type at data[" + n + ']');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        if (n != 0) {
            StandingViewHolder standingViewHolder;
            if (n != 1) throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported viewType: ", (Object)n));
            viewHolder = standingViewHolder;
            standingViewHolder = new StandingViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_standing_values));
            return viewHolder;
        } else {
            SectionViewHolder sectionViewHolder;
            viewHolder = sectionViewHolder;
            sectionViewHolder = new SectionViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_standing_labels));
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof SectionViewHolder && object instanceof String) {
            ((SectionViewHolder)viewHolder).bind((String)object);
        } else if (viewHolder instanceof StandingViewHolder && object instanceof TeamStandings) {
            ((StandingViewHolder)viewHolder).bind((TeamStandings)object);
        }
    }

    public static enum Type {
        Baseball,
        Basketball;

    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    public final class StandingViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final String percentageFormat;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StandingViewHolder(View view2) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)StandingsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            int n = WhenMappings.$EnumSwitchMapping$0[StandingsAdapter.this.type.ordinal()];
            if (n != 1) {
                if (n != 2) throw new NoWhenBranchMatchedException();
                string2 = "%.1f";
            } else {
                string2 = "%.3f";
            }
            this.percentageFormat = string2;
        }

        private final String formatPercentage(double d) {
            Object object = String.format(object.percentageFormat, Arrays.copyOf(new Object[]{d}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
            int n = d < 1.0 ? 1 : 0;
            return StringsKt.drop((String)object, (int)n);
        }

        public final void bind(@NotNull TeamStandings object) {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)object, (String)"standings");
            View view2 = ((RecyclerView.ViewHolder)object2).itemView;
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsTeamName)).setText((CharSequence)object.getTeamName());
            ImageView imageView = (ImageView)view2.findViewById(R.id.slStandingsTeamIcon);
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slStandingsTeamIcon");
            ViewExtensionsKt.loadUrl$default(imageView, object.getTeamIcon(), false, R.drawable.slr_ic_team_placeholder, null, 8, null);
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValueWins)).setText((CharSequence)String.valueOf(object.getWins()));
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValueLosses)).setText((CharSequence)String.valueOf(object.getLosses()));
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValuePercentage)).setText((CharSequence)((StandingViewHolder)((Object)object2)).formatPercentage(object.getPercentage()));
            ((AppCompatTextView)view2.findViewById(R.id.slStandingsValueGamesBehind)).setText((CharSequence)String.valueOf(object.getGamesBehind()));
            if (object instanceof BasketballTeamStanding) {
                TeamStandings teamStandings = object;
                object2 = (AppCompatTextView)view2.findViewById(R.id.slStandingsValueStreak);
                object = "%s%d";
                int n = 2;
                Object[] objectArray = new Object[2];
                int n2 = 0;
                BasketballTeamStanding basketballTeamStanding = (BasketballTeamStanding)teamStandings;
                Object object3 = StringsKt.firstOrNull((CharSequence)basketballTeamStanding.getStreak().getKind());
                object3 = object3 == null ? "" : Character.valueOf(Character.toUpperCase(((Character)object3).charValue()));
                objectArray[n2] = object3;
                objectArray[1] = basketballTeamStanding.getStreak().getLength();
                String string2 = String.format((String)object, Arrays.copyOf(objectArray, n));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                object2.setText((CharSequence)string2);
            } else if (object instanceof BaseballTeamStanding) {
                AppCompatTextView appCompatTextView = (AppCompatTextView)view2.findViewById(R.id.slStandingsValueStreak);
                Object[] objectArray = new Object[2];
                object2 = (BaseballTeamStanding)object;
                objectArray[0] = ((BaseballTeamStanding)object2).getStreak().getWins();
                objectArray[1] = ((BaseballTeamStanding)object2).getStreak().getLosses();
                String string3 = String.format("%d - %d", Arrays.copyOf(objectArray, 2));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                appCompatTextView.setText((CharSequence)string3);
            } else if (object instanceof HockeyTeamStanding) {
                TeamStandings teamStandings = object;
                object2 = (AppCompatTextView)view2.findViewById(R.id.slStandingsValueStreak);
                object = "%s%d";
                int n = 2;
                Object[] objectArray = new Object[2];
                int n3 = 0;
                HockeyTeamStanding hockeyTeamStanding = (HockeyTeamStanding)teamStandings;
                Object object4 = StringsKt.firstOrNull((CharSequence)hockeyTeamStanding.getStreak().getKind());
                object4 = object4 == null ? "" : Character.valueOf(Character.toUpperCase(((Character)object4).charValue()));
                objectArray[n3] = object4;
                objectArray[1] = hockeyTeamStanding.getStreak().getLength();
                String string4 = String.format((String)object, Arrays.copyOf(objectArray, n));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
                object2.setText((CharSequence)string4);
            }
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                nArray[Type.Basketball.ordinal()] = 1;
                nArray[Type.Baseball.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

