/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.golf;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemStatisticsGolfSummaryPlayerBinding;
import io.streamlayer.sdk.databinding.SlrItemStatisticsGolfSummaryProjectedCutBinding;
import io.streamlayer.sdk.model.sports.golf.Player;
import io.streamlayer.sdk.statistics.golf.Summary;
import java.util.ArrayList;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

final class PlayerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final List<Summary.Item> items;

    public PlayerAdapter() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int n) {
        block4: {
            int n2;
            block3: {
                block2: {
                    Object object = object.items.get(n);
                    if (!(object instanceof Summary.Item.Player)) break block2;
                    n2 = 0;
                    break block3;
                }
                if (!(object instanceof Summary.Item.ProjectedCut)) break block4;
                n2 = -1;
            }
            return n2;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        void var2_4;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"parent");
        if (var2_4 != -1) {
            PlayerViewHolder playerViewHolder;
            if (var2_4 != false) throw new Exception("Unsupported View type");
            viewHolder = playerViewHolder;
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding = SlrItemStatisticsGolfSummaryPlayerBinding.inflate(LayoutInflater.from((Context)var1_3.getContext()), (ViewGroup)var1_3, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemStatisticsGolfSummaryPlayerBinding, (String)"inflate(\n               \u2026  false\n                )");
            playerViewHolder = new PlayerViewHolder(this, slrItemStatisticsGolfSummaryPlayerBinding);
            return viewHolder;
        } else {
            ProjectedCutViewHolder projectedCutViewHolder;
            viewHolder = projectedCutViewHolder;
            SlrItemStatisticsGolfSummaryProjectedCutBinding slrItemStatisticsGolfSummaryProjectedCutBinding = SlrItemStatisticsGolfSummaryProjectedCutBinding.inflate(LayoutInflater.from((Context)var1_3.getContext()), (ViewGroup)var1_3, false);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemStatisticsGolfSummaryProjectedCutBinding, (String)"inflate(\n               \u2026  false\n                )");
            projectedCutViewHolder = new ProjectedCutViewHolder(slrItemStatisticsGolfSummaryProjectedCutBinding);
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        RecyclerView.ViewHolder viewHolder2 = viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewHolder2, (String)"holder");
        if (viewHolder2 instanceof PlayerViewHolder) {
            ((PlayerViewHolder)viewHolder).bind(((Summary.Item.Player)this.items.get(n)).getValue());
        }
    }

    public final void setItems(@NotNull List<? extends Summary.Item> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ItemDiffUtil(this.items, list));
        PlayerAdapter playerAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(ItemDiffUtil(items, list))");
        playerAdapter2.items.clear();
        playerAdapter2.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)playerAdapter2);
    }

    public final class PlayerViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemStatisticsGolfSummaryPlayerBinding binding;
        final /* synthetic */ PlayerAdapter this$0;

        public PlayerViewHolder(@NotNull PlayerAdapter playerAdapter2, SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding) {
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding2 = slrItemStatisticsGolfSummaryPlayerBinding;
            Intrinsics.checkNotNullParameter((Object)((Object)playerAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsGolfSummaryPlayerBinding, (String)"binding");
            this.this$0 = playerAdapter2;
            super((View)slrItemStatisticsGolfSummaryPlayerBinding.getRoot());
            this.binding = slrItemStatisticsGolfSummaryPlayerBinding;
            slrItemStatisticsGolfSummaryPlayerBinding2.slPositionTV.setTextColor(this.getColor(R.attr.slrGolfPlayerDefaultColor, R.color.slr_white_alpha_50));
            slrItemStatisticsGolfSummaryPlayerBinding2.slThruTV.setTextColor(this.getColor(R.attr.slrGolfPlayerDefaultColor, R.color.slr_white_alpha_50));
            slrItemStatisticsGolfSummaryPlayerBinding2.slStatusTV.setTextColor(this.getColor(R.attr.slrGolfPlayerDefaultColor, R.color.slr_white_alpha_50));
        }

        /*
         * Enabled aggressive block sorting
         */
        private final int getPositiveOrNegativeColor(String string2) {
            int n;
            if (string2 != null && StringsKt.startsWith$default((String)string2, (String)"-", (boolean)false, (int)2, null)) {
                n = this.getColor(R.attr.slrGolfPlayerNegativeColor, R.color.slr_red);
                return n;
            }
            n = this.getColor(R.attr.slrGolfPlayerPositiveColor, R.color.slr_blue);
            return n;
        }

        private final int getColor(int n, int n2) {
            PlayerViewHolder playerViewHolder = playerViewHolder.binding.getRoot();
            Context context = playerViewHolder.getContext();
            Context context2 = playerViewHolder.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            return ContextCompat.getColor((Context)context, (int)ViewExtensionsKt.resoleAttributeResId(context2, n, n2));
        }

        public final void bind(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding = playerViewHolder.binding;
            Player.Status status = player.getStatus();
            MaterialTextView materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slPositionTV;
            int[] nArray = WhenMappings.$EnumSwitchMapping$0;
            int n = WhenMappings.$EnumSwitchMapping$0[status.ordinal()];
            Object object = n != 1 ? (n != 2 ? (n != 3 ? player.getPosition() : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_withdrawn_pos)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_missed_cut_pos)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_disqualified_pos);
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding2 = slrItemStatisticsGolfSummaryPlayerBinding;
            materialTextView.setText((CharSequence)object);
            slrItemStatisticsGolfSummaryPlayerBinding2.slNameTV.setText((CharSequence)player.getDisplayName2());
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding2.slTotalTV;
            object = Player.Status.NORMAL;
            String string2 = status == object ? player.getTopar() : null;
            materialTextView.setText((CharSequence)string2);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTotalTV;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slTotalTV");
            boolean bl = status == object;
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding3 = slrItemStatisticsGolfSummaryPlayerBinding;
            ViewExtensionsKt.visibleIfElse$default((View)materialTextView, bl, 0, 2, null);
            slrItemStatisticsGolfSummaryPlayerBinding3.slTotalTV.setTextColor(playerViewHolder.getPositiveOrNegativeColor(player.getTopar()));
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding3.slThruTV;
            String string3 = status == object ? player.getThru() : null;
            materialTextView.setText((CharSequence)string3);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slThruTV;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slThruTV");
            boolean bl2 = status == object;
            ViewExtensionsKt.visibleIfElse$default((View)materialTextView, bl2, 0, 2, null);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTodayTV;
            String string4 = status == object ? player.getToday() : null;
            materialTextView.setText((CharSequence)string4);
            materialTextView = slrItemStatisticsGolfSummaryPlayerBinding.slTodayTV;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slTodayTV");
            boolean bl3 = status == object;
            SlrItemStatisticsGolfSummaryPlayerBinding slrItemStatisticsGolfSummaryPlayerBinding4 = slrItemStatisticsGolfSummaryPlayerBinding;
            ViewExtensionsKt.visibleIfElse$default((View)materialTextView, bl3, 0, 2, null);
            slrItemStatisticsGolfSummaryPlayerBinding4.slTodayTV.setTextColor(playerViewHolder.getPositiveOrNegativeColor(player.getToday()));
            PlayerViewHolder playerViewHolder = slrItemStatisticsGolfSummaryPlayerBinding4.slStatusTV;
            int n2 = nArray[status.ordinal()];
            Object object2 = n2 != 1 ? (n2 != 2 ? (n2 != 3 ? null : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_withdrawn)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_missed_cut)) : slrItemStatisticsGolfSummaryPlayerBinding.getRoot().getContext().getString(R.string.slr_statistics_golf_disqualified);
            playerViewHolder.setText((CharSequence)object2);
            playerViewHolder = slrItemStatisticsGolfSummaryPlayerBinding.slStatusTV;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)playerViewHolder), (String)"slStatusTV");
            boolean bl4 = status != object;
            ViewExtensionsKt.visibleIf((View)playerViewHolder, bl4);
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Player.Status.values().length];
                nArray[Player.Status.DISQUALIFIED.ordinal()] = 1;
                nArray[Player.Status.MISSED_CUT.ordinal()] = 2;
                nArray[Player.Status.WITHDRAWN.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public final class ProjectedCutViewHolder
    extends RecyclerView.ViewHolder {
        public ProjectedCutViewHolder(SlrItemStatisticsGolfSummaryProjectedCutBinding slrItemStatisticsGolfSummaryProjectedCutBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)PlayerAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsGolfSummaryProjectedCutBinding, (String)"binding");
            super((View)slrItemStatisticsGolfSummaryProjectedCutBinding.getRoot());
        }
    }

    private static final class ItemDiffUtil
    extends DiffUtil.Callback {
        @NotNull
        private final List<Summary.Item> oldList;
        @NotNull
        private final List<Summary.Item> newList;

        public ItemDiffUtil(@NotNull List<? extends Summary.Item> list, @NotNull List<? extends Summary.Item> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldList");
            Intrinsics.checkNotNullParameter(list2, (String)"newList");
            this.oldList = list;
            this.newList = list2;
        }

        @NotNull
        public final List<Summary.Item> getOldList() {
            return this.oldList;
        }

        @NotNull
        public final List<Summary.Item> getNewList() {
            return this.newList;
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int n, int n2) {
            Summary.Item item = object.oldList.get(n);
            Object object = object.newList.get(n);
            return item instanceof Summary.Item.Player && object instanceof Summary.Item.Player && Intrinsics.areEqual((Object)((Summary.Item.Player)item).getValue().getId(), (Object)((Summary.Item.Player)object).getValue().getId()) || item instanceof Summary.Item.ProjectedCut && object instanceof Summary.Item.ProjectedCut;
        }

        public boolean areContentsTheSame(int n, int n2) {
            Summary.Item item = object.oldList.get(n);
            Object object = object.newList.get(n);
            return item instanceof Summary.Item.Player && object instanceof Summary.Item.Player && Intrinsics.areEqual((Object)((Summary.Item.Player)item).getValue(), (Object)((Summary.Item.Player)object).getValue()) || item instanceof Summary.Item.ProjectedCut && object instanceof Summary.Item.ProjectedCut;
        }
    }
}

