/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.hockey.boxscore;

import android.view.View;
import android.widget.TextView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.hockey.HockeyPlayerScores;
import java.util.Arrays;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class HockeyBoxScorePlayerScoresAdapter
extends GenericAdapter<HockeyPlayerScores> {
    @NotNull
    private final PlayerType type;
    private final boolean positionVisible;

    public HockeyBoxScorePlayerScoresAdapter(@NotNull PlayerType playerType, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)((Object)playerType), (String)"type");
        this.type = playerType;
        this.positionVisible = bl;
    }

    @Override
    protected int getLayoutId(int n) {
        return R.layout.slr_item_hockey_boxcore_player_scores;
    }

    @Override
    @NotNull
    protected GenericAdapter.GenericViewHolder<HockeyPlayerScores> getViewHolder(@NotNull View view2, int n) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        HockeyBoxScorePlayerScoresAdapter hockeyBoxScorePlayerScoresAdapter = object;
        Object object = hockeyBoxScorePlayerScoresAdapter.type;
        n = hockeyBoxScorePlayerScoresAdapter.positionVisible ? 1 : 0;
        return new BoxScorePlayerScoresViewHolder(view2, (PlayerType)((Object)object), n != 0);
    }

    public static enum PlayerType {
        Field,
        Goaltender;

    }

    public static final class BoxScorePlayerScoresViewHolder
    extends GenericAdapter.GenericViewHolder<HockeyPlayerScores> {
        @NotNull
        private final PlayerType type;
        private final boolean positionVisible;

        public BoxScorePlayerScoresViewHolder(@NotNull View view2, @NotNull PlayerType playerType, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            Intrinsics.checkNotNullParameter((Object)((Object)playerType), (String)"type");
            super(view2);
            this.type = playerType;
            this.positionVisible = bl;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final String formatScore(Integer n) {
            void var0_4;
            void var1_5;
            if (var1_5 != null) {
                void v0 = var1_5;
                v0.intValue();
                String string2 = v0.toString();
                if (string2 != null) return var0_4;
            }
            String string3 = "-";
            return var0_4;
        }

        private final String formatScore(Double d) {
            String string2;
            if (d != null) {
                Object object = String.format("%.2f", Arrays.copyOf(new Object[]{d}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(this, *args)");
                int n = d < 1.0 ? 1 : 0;
                string2 = StringsKt.drop((String)object, (int)n);
            } else {
                string2 = "-";
            }
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void bind(@NotNull HockeyPlayerScores object) {
            String string2;
            Integer n;
            Integer n2;
            Integer n3;
            BoxScorePlayerScoresViewHolder boxScorePlayerScoresViewHolder = boxScorePlayerScoresViewHolder6;
            Intrinsics.checkNotNullParameter((Object)object, (String)"data");
            ((TextView)boxScorePlayerScoresViewHolder.itemView.findViewById(R.id.slHockeyBoxScorePlayerPositionTV)).setText((CharSequence)((HockeyPlayerScores)object).getPosition());
            TextView textView = (TextView)boxScorePlayerScoresViewHolder.itemView.findViewById(R.id.slHockeyBoxScorePlayerPositionTV);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"itemView.slHockeyBoxScorePlayerPositionTV");
            ViewExtensionsKt.visibleIf((View)textView, boxScorePlayerScoresViewHolder6.positionVisible);
            ((TextView)boxScorePlayerScoresViewHolder.itemView.findViewById(R.id.slHockeyBoxScorePlayerNameTV)).setText((CharSequence)((HockeyPlayerScores)object).getName());
            TextView textView2 = (TextView)boxScorePlayerScoresViewHolder.itemView.findViewById(R.id.slHockeyBoxScorePlayerGoalsShotsAgainstTV);
            PlayerType playerType = boxScorePlayerScoresViewHolder.type;
            int[] nArray = WhenMappings.$EnumSwitchMapping$0;
            int n4 = WhenMappings.$EnumSwitchMapping$0[playerType.ordinal()];
            if (n4 != 1) {
                if (n4 != 2) throw new NoWhenBranchMatchedException();
                n3 = ((HockeyPlayerScores)object).getGoals();
            } else {
                n3 = ((HockeyPlayerScores)object).getGoals();
            }
            BoxScorePlayerScoresViewHolder boxScorePlayerScoresViewHolder2 = boxScorePlayerScoresViewHolder6;
            textView2.setText((CharSequence)boxScorePlayerScoresViewHolder6.formatScore(n3));
            textView2 = (TextView)boxScorePlayerScoresViewHolder2.itemView.findViewById(R.id.slHockeyBoxScorePlayerAssistsGoalsAgainstTV);
            int n5 = nArray[boxScorePlayerScoresViewHolder2.type.ordinal()];
            if (n5 != 1) {
                if (n5 != 2) throw new NoWhenBranchMatchedException();
                n2 = ((HockeyPlayerScores)object).getAssists();
            } else {
                n2 = ((HockeyPlayerScores)object).getAssists();
            }
            BoxScorePlayerScoresViewHolder boxScorePlayerScoresViewHolder3 = boxScorePlayerScoresViewHolder6;
            textView2.setText((CharSequence)boxScorePlayerScoresViewHolder6.formatScore(n2));
            textView2 = (TextView)boxScorePlayerScoresViewHolder3.itemView.findViewById(R.id.slHockeyBoxScorePlayerShotsSavesTV);
            int n6 = nArray[boxScorePlayerScoresViewHolder3.type.ordinal()];
            if (n6 != 1) {
                if (n6 != 2) throw new NoWhenBranchMatchedException();
                n = ((HockeyPlayerScores)object).getShots();
            } else {
                n = ((HockeyPlayerScores)object).getShots();
            }
            BoxScorePlayerScoresViewHolder boxScorePlayerScoresViewHolder4 = boxScorePlayerScoresViewHolder6;
            textView2.setText((CharSequence)boxScorePlayerScoresViewHolder6.formatScore(n));
            textView2 = (TextView)boxScorePlayerScoresViewHolder4.itemView.findViewById(R.id.slHockeyBoxScorePenaltyInfractionMinutesSavesPercentageTV);
            int n7 = nArray[boxScorePlayerScoresViewHolder4.type.ordinal()];
            if (n7 != 1) {
                if (n7 != 2) throw new NoWhenBranchMatchedException();
                string2 = boxScorePlayerScoresViewHolder6.formatScore(0.27);
            } else {
                string2 = boxScorePlayerScoresViewHolder6.formatScore(((HockeyPlayerScores)object).getPenaltyInfractionMinutes());
            }
            BoxScorePlayerScoresViewHolder boxScorePlayerScoresViewHolder5 = boxScorePlayerScoresViewHolder6;
            textView2.setText((CharSequence)string2);
            BoxScorePlayerScoresViewHolder boxScorePlayerScoresViewHolder6 = (TextView)boxScorePlayerScoresViewHolder5.itemView.findViewById(R.id.slHockeyBoxScoreTimeOnIceTV);
            int n8 = nArray[boxScorePlayerScoresViewHolder5.type.ordinal()];
            if (n8 != 1) {
                if (n8 != 2) throw new NoWhenBranchMatchedException();
                object = ((HockeyPlayerScores)object).getTimeOnIce();
            } else {
                object = ((HockeyPlayerScores)object).getTimeOnIce();
            }
            boxScorePlayerScoresViewHolder6.setText((CharSequence)object);
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PlayerType.values().length];
                nArray[PlayerType.Field.ordinal()] = 1;
                nArray[PlayerType.Goaltender.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

