/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.soccer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemStatisticsSoccerGameEventBinding;
import io.streamlayer.sdk.statistics.soccer.SoccerEventDiffUtil;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEvent;
import io.streamlayer.sdk.statistics.soccer.models.SoccerGameEventType;
import java.util.ArrayList;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

final class SoccerGameAdapter
extends RecyclerView.Adapter<VH> {
    @NotNull
    private final List<SoccerGameEvent> items;

    public SoccerGameAdapter() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    public final void updateData(@NotNull List<SoccerGameEvent> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new SoccerEventDiffUtil(this.items, list));
        SoccerGameAdapter soccerGameAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(SoccerEventDiffUtil(items, list))");
        soccerGameAdapter.items.clear();
        soccerGameAdapter.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)soccerGameAdapter);
    }

    public final void setData(@NotNull List<SoccerGameEvent> list) {
        SoccerGameAdapter soccerGameAdapter = this;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        soccerGameAdapter.items.clear();
        soccerGameAdapter.items.addAll(list);
        soccerGameAdapter.notifyDataSetChanged();
    }

    @NotNull
    public VH onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        SoccerGameAdapter soccerGameAdapter = object;
        Object object = SlrItemStatisticsSoccerGameEventBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return soccerGameAdapter.new VH((SlrItemStatisticsSoccerGameEventBinding)object);
    }

    public void onBindViewHolder(@NotNull VH vH, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)vH), (String)"holder");
        vH.bind(this.items.get(vH.getAbsoluteAdapterPosition()));
    }

    public int getItemCount() {
        return this.items.size();
    }

    public final class VH
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemStatisticsSoccerGameEventBinding binding;

        public VH(SlrItemStatisticsSoccerGameEventBinding slrItemStatisticsSoccerGameEventBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)SoccerGameAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemStatisticsSoccerGameEventBinding, (String)"binding");
            super((View)slrItemStatisticsSoccerGameEventBinding.getRoot());
            this.binding = slrItemStatisticsSoccerGameEventBinding;
        }

        @NotNull
        public final SlrItemStatisticsSoccerGameEventBinding getBinding() {
            return this.binding;
        }

        public final void bind(@NotNull SoccerGameEvent soccerGameEvent) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)soccerGameEvent, (String)"item");
            SlrItemStatisticsSoccerGameEventBinding slrItemStatisticsSoccerGameEventBinding = object.binding;
            AppCompatImageView appCompatImageView = slrItemStatisticsSoccerGameEventBinding.slGameEventIV;
            switch (WhenMappings.$EnumSwitchMapping$0[soccerGameEvent.getType().ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 7: {
                    object = null;
                    break;
                }
                case 6: {
                    object = ContextCompat.getDrawable((Context)object.itemView.getContext(), (int)R.drawable.slr_ic_soccer_yellow_card);
                    break;
                }
                case 5: {
                    object = ContextCompat.getDrawable((Context)object.itemView.getContext(), (int)R.drawable.slr_ic_soccer_red_card);
                    break;
                }
                case 4: {
                    object = ContextCompat.getDrawable((Context)object.itemView.getContext(), (int)R.drawable.slr_ic_soccer_half_time);
                    break;
                }
                case 3: {
                    object = ContextCompat.getDrawable((Context)object.itemView.getContext(), (int)R.drawable.slr_ic_soccer_field);
                    break;
                }
                case 2: {
                    object = ContextCompat.getDrawable((Context)object.itemView.getContext(), (int)R.drawable.slr_ic_soccer_ball);
                    break;
                }
                case 1: {
                    object = ContextCompat.getDrawable((Context)object.itemView.getContext(), (int)R.drawable.slr_ic_game_change_player);
                }
            }
            appCompatImageView.setImageDrawable((Drawable)object);
            object = soccerGameEvent.getClubImage();
            if (object != null) {
                AppCompatImageView appCompatImageView2 = slrItemStatisticsSoccerGameEventBinding.slClubIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView2, (String)"slClubIV");
                ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView2, (String)object, false, null, null, 14, null);
            }
            SlrItemStatisticsSoccerGameEventBinding slrItemStatisticsSoccerGameEventBinding2 = slrItemStatisticsSoccerGameEventBinding;
            slrItemStatisticsSoccerGameEventBinding2.slGameMessageTV.setText((CharSequence)soccerGameEvent.getEventMessage());
            slrItemStatisticsSoccerGameEventBinding2.slGameTimeTV.setText((CharSequence)soccerGameEvent.eventTimeFormat());
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SoccerGameEventType.values().length];
                nArray[SoccerGameEventType.SUBSTITUTION.ordinal()] = 1;
                nArray[SoccerGameEventType.GOAL.ordinal()] = 2;
                nArray[SoccerGameEventType.FULL_TIME.ordinal()] = 3;
                nArray[SoccerGameEventType.HALF_TIME.ordinal()] = 4;
                nArray[SoccerGameEventType.RED_CARD.ordinal()] = 5;
                nArray[SoccerGameEventType.YELLOW_CARD.ordinal()] = 6;
                nArray[SoccerGameEventType.NONE.ordinal()] = 7;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

