/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModelStoreOwner;
import coil.ImageLoader;
import coil.request.ImageRequest;
import io.streamlayer.common.extensions.FragmentExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.VideoPlayer;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.base.StreamLayerBaseActivity;
import io.streamlayer.sdk.databinding.SlrTwPlayerActivityBinding;
import io.streamlayer.sdk.databinding.SlrTwitterAccountInfoBinding;
import io.streamlayer.sdk.koin.KoinExtKt;
import io.streamlayer.sdk.model.analytics.CommonCategory;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.repository.analytics.AnalyticsRepo;
import io.streamlayer.sdk.twitter.TweetPlayerActivity;
import io.streamlayer.sdk.twitter.TweetPlayerActivity$special$;
import io.streamlayer.sdk.twitter.TweetViewModel;
import io.streamlayer.sdk.twitter.view.internal.media.TweetPlayerViewModel;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.qualifier.Qualifier;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TweetPlayerActivity
extends StreamLayerBaseActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INPUT_VIDEO = "INPUT_VIDEO";
    @NotNull
    private static final String INPUT_ACCOUNT_NAME = "ACCOUNT_NAME";
    @NotNull
    private static final String INPUT_ACCOUNT_IMAGE = "ACCOUNT_IMAGE";
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap<Integer, View>();
    @NotNull
    private final Lazy playerViewModel$delegate;
    @NotNull
    private final Lazy viewModel$delegate;
    private SlrTwPlayerActivityBinding binding;
    @Nullable
    private VideoPlayerView playerView;
    private boolean backPressed;
    @NotNull
    private playerListener.1 playerListener;

    public TweetPlayerActivity() {
        Function0<ViewModelStoreOwner> function0;
        Function0<ViewModelStoreOwner> function02;
        Function0<ViewModelStoreOwner> function03 = function02;
        function02 = new Function0<ViewModelStoreOwner>((ViewModelStoreOwner)this){
            final /* synthetic */ ViewModelStoreOwner $this_injectViewModel;
            {
                this.$this_injectViewModel = viewModelStoreOwner;
                super(0);
            }

            @NotNull
            public final ViewModelStoreOwner invoke() {
                return this.$this_injectViewModel;
            }
        };
        this.playerViewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)new Function0<TweetPlayerViewModel>((ViewModelStoreOwner)this, null, (Function0)function03, null){
            final /* synthetic */ ViewModelStoreOwner $this_injectViewModel;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $owner;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_injectViewModel = viewModelStoreOwner;
                this.$qualifier = qualifier;
                this.$owner = function0;
                this.$parameters = function02;
                super(0);
            }

            @NotNull
            public final TweetPlayerViewModel invoke() {
                special$$inlined$injectViewModel$default$1 v0 = this_;
                special$$inlined$injectViewModel$default$1 this_ = v0.$qualifier;
                ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)v0.$owner.invoke();
                Function0 function0 = v0.$parameters;
                return KoinExtKt.getViewModel(this_.$this_injectViewModel, (Qualifier)this_, viewModelStoreOwner, Reflection.getOrCreateKotlinClass(TweetPlayerViewModel.class), (Function0<? extends ParametersHolder>)function0);
            }
        });
        function03 = function0;
        function0 = new /* invalid duplicate definition of identical inner class */;
        this.viewModel$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)new Function0<TweetViewModel>((ViewModelStoreOwner)this, null, (Function0)function03, null){
            final /* synthetic */ ViewModelStoreOwner $this_injectViewModel;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $owner;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_injectViewModel = viewModelStoreOwner;
                this.$qualifier = qualifier;
                this.$owner = function0;
                this.$parameters = function02;
                super(0);
            }

            @NotNull
            public final TweetViewModel invoke() {
                special$$inlined$injectViewModel$default$2 v0 = this_;
                special$$inlined$injectViewModel$default$2 this_ = v0.$qualifier;
                ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)v0.$owner.invoke();
                Function0 function0 = v0.$parameters;
                return KoinExtKt.getViewModel(this_.$this_injectViewModel, (Qualifier)this_, viewModelStoreOwner, Reflection.getOrCreateKotlinClass(TweetViewModel.class), (Function0<? extends ParametersHolder>)function0);
            }
        });
        this.playerListener = new VideoPlayer.Listener(this){
            final /* synthetic */ TweetPlayerActivity this$0;
            {
                this.this$0 = tweetPlayerActivity;
            }

            public void onPlayerStateChanged(@NotNull VideoPlayer.State state2) {
                Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
                TweetVideo tweetVideo = TweetPlayerActivity.access$getItem(this.this$0);
                if (Intrinsics.areEqual((Object)tweetVideo.getMediaType(), (Object)"video") && state2 == VideoPlayer.State.ENDED && (this = TweetVideoPlayerCache.DefaultImpls.getPlayer$default(this.this$0.getPlayerViewModel$sdk_originalRelease(), tweetVideo, false, 2, null)) != null) {
                    Object object = this;
                    object.seekTo(0L);
                    object.play();
                }
            }

            public void onPlayerError(@Nullable Throwable serializable) {
                if (serializable != null) {
                    TweetPlayerActivity tweetPlayerActivity = this.this$0;
                    SLRLog.INSTANCE.e("TweetPlayerActivity", Intrinsics.stringPlus((String)"onPlayerError ", (Object)serializable.getMessage()));
                    if (serializable instanceof IOException) {
                        TweetPlayerActivity tweetPlayerActivity2 = tweetPlayerActivity;
                        serializable = TweetPlayerActivity.access$getItem(tweetPlayerActivity2);
                        VideoPlayer videoPlayer = TweetVideoPlayerCache.DefaultImpls.getPlayer$default(tweetPlayerActivity2.getPlayerViewModel$sdk_originalRelease(), (TweetVideo)serializable, false, 2, null);
                        if (videoPlayer != null) {
                            VideoPlayer videoPlayer2 = videoPlayer;
                            videoPlayer2.pause();
                            videoPlayer2.removeListener(this);
                        }
                        TweetPlayerActivity tweetPlayerActivity3 = tweetPlayerActivity;
                        tweetPlayerActivity3.getPlayerViewModel$sdk_originalRelease().releasePlayer((TweetVideo)serializable);
                        ViewExtensionsKt.toast(tweetPlayerActivity3, tweetPlayerActivity3.getString(R.string.slr_video_is_not_available));
                        tweetPlayerActivity3.onBackPressed();
                    }
                }
            }
        };
    }

    @VisibleForTesting
    public static /* synthetic */ void getPlayerViewModel$sdk_originalRelease$annotations() {
    }

    private final TweetViewModel getViewModel() {
        return (TweetViewModel)this.viewModel$delegate.getValue();
    }

    private final TweetVideo getItem() {
        Serializable serializable = this.getIntent().getSerializableExtra(INPUT_VIDEO);
        if (serializable != null) {
            return (TweetVideo)serializable;
        }
        throw new NullPointerException("null cannot be cast to non-null type io.streamlayer.sdk.twitter.view.internal.media.TweetVideo");
    }

    private final VideoPlayerView getPlayerView(TweetVideo tweetVideo) {
        Object object = this.playerView;
        if (object == null) {
            object = this.getPlayerViewModel$sdk_originalRelease().getVideoPlayerView((Context)this, VideoPlayerView.Type.SURFACE);
            if (object == null) {
                tweetVideo = null;
                object = tweetVideo;
            } else {
                VideoPlayerView videoPlayerView = object;
                videoPlayerView.setShowControls(tweetVideo.getShowVideoControls());
                videoPlayerView.setResizeMode(VideoPlayerView.ResizeMode.FIT);
                tweetVideo = videoPlayerView.getView();
                tweetVideo.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                SlrTwPlayerActivityBinding slrTwPlayerActivityBinding = this.binding;
                if (slrTwPlayerActivityBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    slrTwPlayerActivityBinding = null;
                }
                slrTwPlayerActivityBinding.container.addView((View)tweetVideo, 0);
            }
            this.playerView = object;
        }
        return object;
    }

    private static final void onCreate$lambda-2(TweetPlayerActivity tweetPlayerActivity, View view2) {
        TweetPlayerActivity tweetPlayerActivity2 = tweetPlayerActivity;
        Intrinsics.checkNotNullParameter((Object)((Object)tweetPlayerActivity2), (String)"this$0");
        AnalyticsRepo.DefaultImpls.triggerInteractionEvent$default(tweetPlayerActivity2.getViewModel(), null, CommonCategory.TWITTER, 1, null);
        tweetPlayerActivity2.onBackPressed();
    }

    public static final /* synthetic */ TweetVideo access$getItem(TweetPlayerActivity tweetPlayerActivity) {
        return tweetPlayerActivity.getItem();
    }

    @NotNull
    public final TweetPlayerViewModel getPlayerViewModel$sdk_originalRelease() {
        return (TweetPlayerViewModel)this.playerViewModel$delegate.getValue();
    }

    public void onCreate(@Nullable Bundle object) {
        TweetPlayerActivity tweetPlayerActivity = object2;
        super.onCreate((Bundle)object);
        if (!OtherExtensionsKt.isScreenPortrait((Context)tweetPlayerActivity)) {
            Window window = object2.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
            ViewExtensionsKt.fullScreen(window, ViewExtensionsKt.getWindowController((FragmentActivity)object2));
        }
        TweetPlayerActivity tweetPlayerActivity2 = object2;
        SlrTwPlayerActivityBinding slrTwPlayerActivityBinding = SlrTwPlayerActivityBinding.inflate(tweetPlayerActivity2.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)slrTwPlayerActivityBinding, (String)"inflate(layoutInflater)");
        tweetPlayerActivity2.binding = slrTwPlayerActivityBinding;
        if (!OtherExtensionsKt.isScreenPortrait((Context)tweetPlayerActivity2)) {
            FragmentExtensionsKt.setFullScreen(object2);
        }
        if ((object = object2.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            object = null;
        }
        TweetPlayerActivity tweetPlayerActivity3 = object2;
        tweetPlayerActivity3.setContentView((View)((SlrTwPlayerActivityBinding)object).getRoot());
        TweetVideo tweetVideo = tweetPlayerActivity3.getItem();
        object = tweetVideo;
        TweetPlayerActivity tweetPlayerActivity4 = object2;
        object = TweetVideoPlayerCache.DefaultImpls.getPlayer$default(tweetPlayerActivity4.getPlayerViewModel$sdk_originalRelease(), (TweetVideo)object, false, 2, null);
        tweetPlayerActivity4.getPlayerViewModel$sdk_originalRelease().setReleaseOnCleared(false);
        VideoPlayerView videoPlayerView = tweetPlayerActivity3.getPlayerView(tweetVideo);
        if (videoPlayerView != null && object != null) {
            videoPlayerView.setVideoPlayer((VideoPlayer)object);
        }
        if ((object = object2.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            object = null;
        }
        ((SlrTwPlayerActivityBinding)object).slrCloseIcon.setOnClickListener(arg_0 -> TweetPlayerActivity.onCreate$lambda-2((TweetPlayerActivity)((Object)object2), arg_0));
        object = object2.binding;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            object = null;
        }
        SlrTwitterAccountInfoBinding slrTwitterAccountInfoBinding = ((SlrTwPlayerActivityBinding)object).accountInfo;
        slrTwitterAccountInfoBinding.slrFullNameView.setText((CharSequence)object2.getIntent().getStringExtra(INPUT_ACCOUNT_NAME));
        object = slrTwitterAccountInfoBinding.slrAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slrAvatarView");
        Object object2 = object2.getIntent().getStringExtra(INPUT_ACCOUNT_IMAGE);
        Intrinsics.checkNotNullExpressionValue((Object)object.getContext(), (String)"fun ImageView.load(\n    \u2026ri, imageLoader, builder)");
        ImageLoader imageLoader = (ImageLoader)StreamLayer.INSTANCE.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ImageLoader.class), null, null);
        Context context = object.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        imageLoader.enqueue(new ImageRequest.Builder(context).data(object2).target((ImageView)object).build());
    }

    protected void onResume() {
        TweetPlayerActivity tweetPlayerActivity = this;
        super.onResume();
        tweetPlayerActivity.getViewModel().appInForegroundChanged(true);
        TweetVideo tweetVideo = tweetPlayerActivity.getItem();
        VideoPlayer videoPlayer = TweetVideoPlayerCache.DefaultImpls.getPlayer$default(tweetPlayerActivity.getPlayerViewModel$sdk_originalRelease(), tweetVideo, false, 2, null);
        if (videoPlayer != null) {
            videoPlayer.addListener(this.playerListener);
            if (Intrinsics.areEqual((Object)tweetVideo.getMediaType(), (Object)"video")) {
                VideoPlayer videoPlayer2 = videoPlayer;
                long l = videoPlayer2.getCurrentPosition();
                long l2 = videoPlayer2.getDuration();
                if (1L <= l2 && l2 <= l) {
                    videoPlayer.seekTo(0L);
                }
            }
            videoPlayer.play();
        }
    }

    protected void onPause() {
        TweetPlayerActivity tweetPlayerActivity = this;
        super.onPause();
        tweetPlayerActivity.getViewModel().appInForegroundChanged(false);
        VideoPlayer videoPlayer = TweetVideoPlayerCache.DefaultImpls.getPlayer$default(tweetPlayerActivity.getPlayerViewModel$sdk_originalRelease(), this.getItem(), false, 2, null);
        if (videoPlayer != null) {
            videoPlayer.removeListener(this.playerListener);
            if (!this.backPressed) {
                videoPlayer.pause();
            }
        }
    }

    public void onBackPressed() {
        TweetPlayerActivity tweetPlayerActivity = this;
        tweetPlayerActivity.backPressed = true;
        super.onBackPressed();
        tweetPlayerActivity.overridePendingTransition(0, R.anim.slr_slide_out);
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Override
    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final void start(@NotNull Context context, @NotNull TweetVideo tweetVideo, @NotNull Tweet tweet) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
            Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
            Companion companion = this = intent;
            companion(context, TweetPlayerActivity.class);
            companion.putExtra(TweetPlayerActivity.INPUT_VIDEO, tweetVideo);
            this.putExtra(TweetPlayerActivity.INPUT_ACCOUNT_NAME, tweet.getMetaData().getAccount());
            intent.putExtra(TweetPlayerActivity.INPUT_ACCOUNT_IMAGE, StringsKt.replace$default((String)tweet.getMetaData().getAccountImage(), (String)"_normal", (String)"_reasonably_small", (boolean)false, (int)4, null));
            context.startActivity(intent);
        }
    }
}

