/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.databinding.SlrItemTweetBinding;
import io.streamlayer.sdk.model.analytics.InteractionActionType;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.twitter.TweetLocation;
import io.streamlayer.sdk.twitter.TweetUI;
import io.streamlayer.sdk.twitter.view.TweetBaseView;
import io.streamlayer.sdk.twitter.view.TweetView;
import io.streamlayer.sdk.twitter.view.internal.format.TweetFormatter;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoController;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class TweetsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private final TweetFormatter tweetFormatter;
    @NotNull
    private final TweetVideoController tweetVideoController;
    @NotNull
    private final Function1<InteractionActionType, Unit> interactionListener;
    @NotNull
    private final Function1<Context, VideoPlayerView> videoPlayerViewBuilder;
    @NotNull
    private final Function2<TweetUI, TweetLocation, Unit> showPopup;
    @NotNull
    private final List<TweetUI> items;

    public TweetsAdapter(@NotNull TweetFormatter tweetFormatter, @NotNull TweetVideoController tweetVideoController2, @NotNull Function1<? super InteractionActionType, Unit> function1, @NotNull Function1<? super Context, ? extends VideoPlayerView> function12, @NotNull Function2<? super TweetUI, ? super TweetLocation, Unit> function2) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)tweetFormatter, (String)"tweetFormatter");
        Intrinsics.checkNotNullParameter((Object)tweetVideoController2, (String)"tweetVideoController");
        Intrinsics.checkNotNullParameter(function1, (String)"interactionListener");
        Intrinsics.checkNotNullParameter(function12, (String)"videoPlayerViewBuilder");
        Intrinsics.checkNotNullParameter(function2, (String)"showPopup");
        object.tweetFormatter = tweetFormatter;
        object.tweetVideoController = tweetVideoController2;
        object.interactionListener = function1;
        object.videoPlayerViewBuilder = function12;
        object.showPopup = function2;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.items = object;
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        TweetsAdapter tweetsAdapter2 = object;
        Object object = SlrItemTweetBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.f\u2026.context), parent, false)");
        return tweetsAdapter2.new ViewHolder((SlrItemTweetBinding)object);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void onBindViewHolder(@NotNull ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        viewHolder.bind(this.items.get(n));
    }

    public void onViewRecycled(@NotNull ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)viewHolder);
        viewHolder.release();
    }

    public final void setItems(@NotNull List<TweetUI> list) {
        Intrinsics.checkNotNullParameter(list, (String)"items");
        TweetsAdapter tweetsAdapter2 = this;
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)tweetsAdapter2.new TweetsDiffUtil(tweetsAdapter2.items, list));
        TweetsAdapter tweetsAdapter3 = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(TweetsDiffUtil(this.items, items))");
        tweetsAdapter3.items.clear();
        tweetsAdapter3.items.addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)tweetsAdapter3);
    }

    @NotNull
    public final List<TweetUI> getItems(int n, int n2) {
        return n < this.items.size() && n2 <= this.items.size() ? this.items.subList(n, n2) : CollectionsKt.emptyList();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final SlrItemTweetBinding binding;

        public ViewHolder(SlrItemTweetBinding slrItemTweetBinding) {
            Intrinsics.checkNotNullParameter((Object)((Object)((ViewHolder)((Object)tweetView)).TweetsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemTweetBinding, (String)"binding");
            super((View)slrItemTweetBinding.getRoot());
            ((ViewHolder)((Object)tweetView)).binding = slrItemTweetBinding;
            TweetView tweetView = slrItemTweetBinding.getRoot();
            tweetView.setInteractionListener((Function1<? super InteractionActionType, Unit>)((ViewHolder)((Object)tweetView)).TweetsAdapter.this.interactionListener);
            tweetView.setVideoController(((ViewHolder)((Object)tweetView)).TweetsAdapter.this.tweetVideoController);
            tweetView.setVideoPlayerViewBuilder((Function1<? super Context, ? extends VideoPlayerView>)((ViewHolder)((Object)tweetView)).TweetsAdapter.this.videoPlayerViewBuilder);
            Context context = tweetView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (!OtherExtensionsKt.isScreenPortrait(context)) {
                TweetView tweetView2 = tweetView;
                tweetView2.setBackground(ContextCompat.getDrawable((Context)tweetView2.getContext(), (int)R.drawable.slr_shape_rect_rounded_8));
                tweetView2.setBackgroundTintList(ContextCompat.getColorStateList((Context)tweetView2.getContext(), (int)R.color.slr_tweet_bg_landscape));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)tweetView2), (String)"");
                int n = ViewExtensionsKt.getDp(8.0f);
                tweetView2.setPadding(n, n, n, n);
            } else {
                TweetView tweetView3 = tweetView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)tweetView3), (String)"");
                int n = ViewExtensionsKt.getDp(16.0f);
                tweetView3.setPadding(n, n, n, n);
            }
        }

        private static final void bind$lambda-1(TweetsAdapter tweetsAdapter2, TweetUI tweetUI, ViewHolder viewHolder, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)tweetsAdapter2), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)tweetUI, (String)"$item");
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"this$1");
            tweetsAdapter2.showPopup.invoke((Object)tweetUI, (Object)viewHolder.binding.getRoot().getTweetLocation());
        }

        public final void bind(@NotNull TweetUI tweetUI) {
            ViewHolder viewHolder = this;
            Intrinsics.checkNotNullParameter((Object)tweetUI, (String)"item");
            TweetView tweetView = viewHolder.binding.getRoot();
            Object object = tweetView;
            TweetUI tweetUI2 = tweetUI;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.root");
            object = tweetUI2.getTweet();
            TweetVideo tweetVideo = tweetUI2.getVideo();
            TweetBaseView.showTweet$default(tweetView, (Tweet)object, tweetVideo, TweetsAdapter.this.tweetFormatter, null, 8, null);
            viewHolder.binding.getRoot().setOnClickListener(arg_0 -> ViewHolder.bind$lambda-1(TweetsAdapter.this, tweetUI, this, arg_0));
        }

        public final void release() {
            this.binding.getRoot().release();
        }
    }

    public final class TweetsDiffUtil
    extends DiffUtil.Callback {
        @NotNull
        private final List<TweetUI> oldItems;
        @NotNull
        private final List<TweetUI> newItems;

        public TweetsDiffUtil(@NotNull List<TweetUI> list, List<TweetUI> list2) {
            Intrinsics.checkNotNullParameter((Object)((Object)TweetsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter(list, (String)"oldItems");
            Intrinsics.checkNotNullParameter(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            TweetUI tweetUI = ((TweetsDiffUtil)((Object)tweetUI)).newItems.get(n2);
            return Intrinsics.areEqual((Object)((TweetsDiffUtil)((Object)tweetUI)).oldItems.get(n).getTweet().getId(), (Object)tweetUI.getTweet().getId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            TweetUI tweetUI = ((TweetsDiffUtil)((Object)tweetUI2)).oldItems.get(n);
            TweetUI tweetUI2 = ((TweetsDiffUtil)((Object)tweetUI2)).newItems.get(n2);
            return Intrinsics.areEqual((Object)tweetUI.getTweet(), (Object)tweetUI2.getTweet()) && Intrinsics.areEqual((Object)tweetUI.getVideo(), (Object)tweetUI2.getVideo());
        }
    }
}

