/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import coil.ImageLoader;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.twitter.Input;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TweetPhotoView
extends ViewGroup
implements View.OnClickListener {
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    @NotNull
    private final AppCompatImageView[] imageViews;
    @NotNull
    private List<TweetMedia> mediaEntities;
    private final int mediaDividerSize;
    private int imageCount;
    @Nullable
    private Function1<? super Input, Unit> onPhotoClicked;
    public Tweet tweet;
    @Nullable
    private Function0<Unit> onMediaLoaded;

    @JvmOverloads
    public TweetPhotoView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        this.imageViews = new AppCompatImageView[4];
        this.mediaEntities = CollectionsKt.emptyList();
        this.mediaDividerSize = ViewExtensionsKt.getDp(1.0f);
    }

    public /* synthetic */ TweetPhotoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final Size measureImages(int n, int n2) {
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getSize((int)n2);
        int n3 = this.mediaDividerSize;
        int n4 = (n - n3) / 2;
        n3 = (n2 - n3) / 2;
        switch (this.imageCount) {
            default: {
                break;
            }
            case 4: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n3);
                tweetPhotoView.measureImageView(1, n4, n3);
                tweetPhotoView.measureImageView(2, n4, n3);
                tweetPhotoView.measureImageView(3, n4, n3);
                break;
            }
            case 3: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n2);
                tweetPhotoView.measureImageView(1, n4, n3);
                tweetPhotoView.measureImageView(2, n4, n3);
                break;
            }
            case 2: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n2);
                tweetPhotoView.measureImageView(1, n4, n2);
                break;
            }
            case 1: {
                this.measureImageView(0, n, n2);
            }
        }
        return Size.Companion.fromSize(n, n2);
    }

    private final void measureImageView(int n, int n2, int n3) {
        TweetPhotoView tweetPhotoView = tweetPhotoView.imageViews[n];
        if (tweetPhotoView != null) {
            int n4 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
            tweetPhotoView.measure(n4, View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
        }
    }

    private final void layoutImages() {
        TweetPhotoView tweetPhotoView = this;
        int n = tweetPhotoView.getMeasuredWidth();
        TweetPhotoView tweetPhotoView2 = this;
        int n2 = tweetPhotoView2.getMeasuredHeight();
        int n3 = tweetPhotoView2.mediaDividerSize;
        int n4 = (n - n3) / 2;
        int n5 = n3;
        n3 = (n2 - n3) / 2;
        int n6 = n4 + n5;
        switch (tweetPhotoView.imageCount) {
            default: {
                break;
            }
            case 4: {
                TweetPhotoView tweetPhotoView3 = this;
                TweetPhotoView tweetPhotoView4 = this;
                tweetPhotoView4.layoutImage(0, 0, 0, n4, n3);
                int n7 = n3 + tweetPhotoView4.mediaDividerSize;
                tweetPhotoView3.layoutImage(2, 0, n7, n4, n2);
                tweetPhotoView3.layoutImage(1, n6, 0, n, n3);
                n7 = n3 + tweetPhotoView3.mediaDividerSize;
                this.layoutImage(3, n6, n7, n, n2);
                break;
            }
            case 3: {
                TweetPhotoView tweetPhotoView5 = this;
                tweetPhotoView5.layoutImage(0, 0, 0, n4, n2);
                tweetPhotoView5.layoutImage(1, n6, 0, n, n3);
                int n8 = n3 + tweetPhotoView5.mediaDividerSize;
                this.layoutImage(2, n6, n8, n, n2);
                break;
            }
            case 2: {
                TweetPhotoView tweetPhotoView6 = this;
                tweetPhotoView6.layoutImage(0, 0, 0, n4, n2);
                this.layoutImage(1, n4 + tweetPhotoView6.mediaDividerSize, 0, n, n2);
                break;
            }
            case 1: {
                this.layoutImage(0, 0, 0, n, n2);
            }
        }
    }

    private final void layoutImage(int n, int n2, int n3, int n4, int n5) {
        TweetPhotoView tweetPhotoView = tweetPhotoView.imageViews[n];
        if (tweetPhotoView != null) {
            if (tweetPhotoView.getLeft() == n2 && tweetPhotoView.getTop() == n3 && tweetPhotoView.getRight() == n4 && tweetPhotoView.getBottom() == n5) {
                return;
            }
            tweetPhotoView.layout(n2, n3, n4, n5);
        }
    }

    private final void clearImageViews() {
        AppCompatImageView[] appCompatImageViewArray = this.imageViews;
        int n = this.imageViews.length;
        for (int i = 0; i < n; ++i) {
            AppCompatImageView appCompatImageView = appCompatImageViewArray[i];
            if (appCompatImageView == null) continue;
            ViewExtensionsKt.gone((View)appCompatImageView);
        }
        this.imageCount = 0;
    }

    private final void initializeImageViews(List<TweetMedia> list) {
        int n;
        this.imageCount = n = Math.min(4, list.size());
        int n2 = 0;
        while (n2 < n) {
            TweetPhotoView tweetPhotoView = this;
            int n3 = n2;
            AppCompatImageView appCompatImageView = this.getOrCreateImageView(n2++);
            tweetPhotoView.setMediaImage((ImageView)appCompatImageView, tweetPhotoView.getSizedImagePath(list.get(n3)));
        }
    }

    private final AppCompatImageView getOrCreateImageView(int n) {
        AppCompatImageView appCompatImageView = this.imageViews[n];
        if (appCompatImageView == null) {
            AppCompatImageView appCompatImageView2;
            appCompatImageView = appCompatImageView2;
            appCompatImageView(this.getContext());
            appCompatImageView.setLayoutParams(this.generateDefaultLayoutParams());
            appCompatImageView.setOnClickListener((View.OnClickListener)this);
            this.imageViews[n] = appCompatImageView;
            this.addView((View)appCompatImageView2, n);
        } else {
            TweetPhotoView tweetPhotoView = this;
            tweetPhotoView.measureImageView(n, 0, 0);
            tweetPhotoView.layoutImage(n, 0, 0, 0, 0);
        }
        AppCompatImageView appCompatImageView3 = appCompatImageView;
        appCompatImageView.setVisibility(0);
        appCompatImageView3.setTag((Object)n);
        return appCompatImageView3;
    }

    private final String getSizedImagePath(TweetMedia tweetMedia) {
        return this.imageCount > 1 ? Intrinsics.stringPlus((String)tweetMedia.getMediaUrlHttps(), (Object)":small") : tweetMedia.getMediaUrlHttps();
    }

    private final void setMediaImage(ImageView imageView, String string2) {
        ImageView imageView2 = imageView;
        imageView2.setScaleType(ImageView.ScaleType.CENTER_CROP);
        Intrinsics.checkNotNullExpressionValue((Object)imageView2.getContext(), (String)"fun ImageView.load(\n    \u2026ri, imageLoader, builder)");
        ImageLoader imageLoader = (ImageLoader)StreamLayer.INSTANCE.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ImageLoader.class), null, null);
        Context context = imageView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        ImageRequest.Builder builder = new ImageRequest.Builder(context).data((Object)string2).target(imageView);
        builder.error(R.drawable.slr_ic_tw_photo_error_dark);
        TweetPhotoView tweetPhotoView = this;
        builder.listener(new ImageRequest.Listener(imageView, tweetPhotoView, tweetPhotoView){
            final /* synthetic */ ImageView $imageView$inlined;
            final /* synthetic */ TweetPhotoView this$0;
            {
                this.$imageView$inlined = imageView;
                this.this$0 = tweetPhotoView;
            }

            public void onStart(@NotNull ImageRequest imageRequest) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
            }

            public void onCancel(@NotNull ImageRequest imageRequest) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
            }

            public void onError(@NotNull ImageRequest imageRequest, @NotNull Throwable throwable) {
                Function0<Unit> function0 = function02;
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                function0.$imageView$inlined.setScaleType(ImageView.ScaleType.FIT_CENTER);
                Function0<Unit> function02 = function0.this$0.getOnMediaLoaded();
                if (function02 != null) {
                    function02.invoke();
                }
            }

            public void onSuccess(@NotNull ImageRequest imageRequest, @NotNull ImageResult.Metadata metadata) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Function0<Unit> function0 = function0.this$0.getOnMediaLoaded();
                if (function0 != null) {
                    function0.invoke();
                }
            }
        });
        imageLoader.enqueue(builder.build());
    }

    @JvmOverloads
    public TweetPhotoView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public TweetPhotoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Nullable
    public final Function1<Input, Unit> getOnPhotoClicked() {
        return this.onPhotoClicked;
    }

    public final void setOnPhotoClicked(@Nullable Function1<? super Input, Unit> function1) {
        this.onPhotoClicked = function1;
    }

    @NotNull
    public final Tweet getTweet() {
        Object object = object.tweet;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tweet");
        return null;
    }

    public final void setTweet(@NotNull Tweet tweet) {
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"<set-?>");
        this.tweet = tweet;
    }

    @Nullable
    public final Function0<Unit> getOnMediaLoaded() {
        return this.onMediaLoaded;
    }

    public final void setOnMediaLoaded(@Nullable Function0<Unit> function0) {
        this.onMediaLoaded = function0;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.imageCount > 0) {
            this.layoutImages();
        }
    }

    protected void onMeasure(int n, int n2) {
        Size size = this.imageCount > 0 ? this.measureImages(n, n2) : Size.Companion.getEMPTY();
        Size size2 = size;
        int n3 = size2.getWidth();
        this.setMeasuredDimension(n3, size2.getHeight());
    }

    public void onClick(@NotNull View object) {
        View view2 = object;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        object = view2.getTag();
        if (object != null) {
            int n = (Integer)object;
            Object object2 = object4.onPhotoClicked;
            if (object2 != null) {
                ArrayList<String> arrayList;
                Object object3 = object4.mediaEntities;
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    arrayList2.add(((TweetMedia)object3.next()).getMediaUrlHttps());
                }
                Function1<? super Input, Unit> function1 = object2;
                TweetPhotoView tweetPhotoView = object4;
                Object object4 = tweetPhotoView.getTweet().getMetaData().getAccount();
                object2 = StringsKt.replace$default((String)tweetPhotoView.getTweet().getMetaData().getAccountImage(), (String)"_normal", (String)"_reasonably_small", (boolean)false, (int)4, null);
                function1.invoke((Object)new Input(n, (List<String>)arrayList2, (String)object4, (String)object2));
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public final void setMedia(@NotNull List<TweetMedia> list) {
        List<TweetMedia> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"mediaEntities");
        if (list2.isEmpty()) {
            return;
        }
        if (Intrinsics.areEqual(list, function0.mediaEntities)) {
            Function0<Unit> function0 = function0.onMediaLoaded;
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
        Function0<Unit> function0 = function0;
        function0.mediaEntities = list;
        super.clearImageViews();
        super.initializeImageViews(list);
        function0.requestLayout();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 == null) {
                view2 = null;
            } else {
                map2.put(n, view2);
            }
        }
        return view2;
    }

    private static final class Size {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Size EMPTY = new Size(0, 0, 3, null);
        private final int width;
        private final int height;

        private Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public /* synthetic */ Size(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            this(n, n2);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final Size getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final Size fromSize(int n, int n2) {
                Object object;
                n = Math.max(n, 0);
                n2 = Math.max(n2, 0);
                if (n == 0 && n2 == 0) {
                    object = ((Companion)object).getEMPTY();
                } else {
                    Size size;
                    object = size;
                    size = new Size(n, n2, null);
                }
                return object;
            }
        }
    }
}

