/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

import android.text.TextUtils;
import android.util.LruCache;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetHashtag;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.model.social.TweetSymbol;
import io.streamlayer.sdk.model.social.TweetUrl;
import io.streamlayer.sdk.model.social.TweetUserMention;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedMediaEntity;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedText;
import io.streamlayer.sdk.twitter.view.internal.format.FormattedUrlEntity;
import io.streamlayer.sdk.twitter.view.internal.format.HtmlEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class TweetFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DEFAULT_CACHE_SIZE = 20;
    @NotNull
    private final LruCache<Long, FormattedText> cache;

    public TweetFormatter() {
        LruCache lruCache;
        TweetFormatter tweetFormatter = lruCache;
        lruCache = new LruCache(20);
        v1.cache = tweetFormatter;
    }

    private final FormattedText format(Tweet tweet) {
        FormattedText formattedText;
        FormattedText formattedText2 = formattedText;
        TweetFormatter tweetFormatter = this;
        formattedText2();
        tweetFormatter.convertEntities(formattedText2, tweet);
        tweetFormatter.format(formattedText2, tweet);
        return formattedText;
    }

    private final void convertEntities(FormattedText formattedText, Tweet object3) {
        for (TweetUrl tweetUrl : ((Tweet)object3).getMetaData().getEntities().getUrls()) {
            formattedText.getUrlEntities().add(FormattedUrlEntity.Companion.from(tweetUrl));
        }
        for (TweetMedia tweetMedia : ((Tweet)object3).getMetaData().getEntities().getMedia()) {
            formattedText.getMediaEntities().add(new FormattedMediaEntity(tweetMedia));
        }
        for (TweetHashtag tweetHashtag : ((Tweet)object3).getMetaData().getEntities().getHashtags()) {
            formattedText.getHashtagEntities().add(FormattedUrlEntity.Companion.from(tweetHashtag));
        }
        for (TweetUserMention tweetUserMention : ((Tweet)object3).getMetaData().getEntities().getUserMentions()) {
            formattedText.getMentionEntities().add(FormattedUrlEntity.Companion.from(tweetUserMention));
        }
        for (TweetSymbol tweetSymbol : ((Tweet)object3).getMetaData().getEntities().getSymbols()) {
            formattedText.getSymbolEntities().add(FormattedUrlEntity.Companion.from(tweetSymbol));
        }
    }

    private final void format(FormattedText formattedText, Tweet list) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)((Tweet)((Object)list)).getText())) {
            return;
        }
        TweetFormatter tweetFormatter = stringBuilder2;
        HtmlEntities.Unescaped unescaped = HtmlEntities.HTML40.unescape(((Tweet)((Object)list)).getText());
        list = unescaped;
        TweetFormatter tweetFormatter2 = stringBuilder2;
        List<FormattedUrlEntity> list2 = list;
        TweetFormatter tweetFormatter3 = stringBuilder2;
        List<FormattedUrlEntity> list3 = list;
        TweetFormatter tweetFormatter4 = stringBuilder2;
        List<FormattedUrlEntity> list4 = list;
        TweetFormatter tweetFormatter5 = stringBuilder2;
        List<FormattedUrlEntity> list5 = list;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(((HtmlEntities.Unescaped)((Object)list)).unescaped);
        list = formattedText.getUrlEntities();
        tweetFormatter5.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list5)).indices);
        list = formattedText.getMediaEntities();
        tweetFormatter4.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list4)).indices);
        list = formattedText.getHashtagEntities();
        tweetFormatter3.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list3)).indices);
        list = formattedText.getMentionEntities();
        tweetFormatter2.adjustIndicesForEscapedChars(list, ((HtmlEntities.Unescaped)((Object)list2)).indices);
        list = formattedText.getSymbolEntities();
        tweetFormatter.adjustIndicesForEscapedChars(list, unescaped.indices);
        tweetFormatter.adjustIndicesForSupplementaryChars(stringBuilder2, formattedText);
        formattedText.setText(stringBuilder2.toString());
    }

    private final void adjustIndicesForEscapedChars(List<? extends FormattedUrlEntity> list, List<int[]> list2) {
        if (list != null && list2 != null && !list2.isEmpty()) {
            int n = list2.size();
            int n2 = 0;
            int n3 = 0;
            for (FormattedUrlEntity formattedUrlEntity : list) {
                int n4 = 0;
                int n5 = n3;
                n3 = n2;
                int n6 = n4;
                n4 = n5;
                while (n2 < n) {
                    int[] nArray = list2.get(n2);
                    int n7 = nArray[0];
                    int n8 = nArray[1];
                    n7 = n8 - n7;
                    if (n8 < formattedUrlEntity.getStart()) {
                        n4 += n7;
                        ++n3;
                    } else if (n8 < formattedUrlEntity.getEnd()) {
                        n6 += n7;
                    }
                    ++n2;
                }
                FormattedUrlEntity formattedUrlEntity2 = formattedUrlEntity;
                n2 = n4 + n6;
                formattedUrlEntity2.setStart(formattedUrlEntity2.getStart() - n2);
                formattedUrlEntity2.setEnd(formattedUrlEntity2.getEnd() - n2);
                int n7 = n3;
                n3 = n4;
                n2 = n7;
            }
            return;
        }
    }

    private final void adjustIndicesForSupplementaryChars(StringBuilder stringBuilder, FormattedText formattedText) {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        int n = stringBuilder.length() - 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = n3 + 1;
            if (Character.isHighSurrogate(stringBuilder.charAt(n3)) && Character.isLowSurrogate(stringBuilder.charAt(n4))) {
                arrayList2.add(n2);
            }
            n2 = n4;
        }
        this.adjustEntitiesWithOffsets(formattedText.getUrlEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getMediaEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getHashtagEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getMentionEntities(), arrayList2);
        this.adjustEntitiesWithOffsets(formattedText.getSymbolEntities(), arrayList2);
    }

    private final void adjustEntitiesWithOffsets(List<? extends FormattedUrlEntity> object, List<Integer> list) {
        if (object != null && list != null) {
            Iterator<? extends FormattedUrlEntity> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (FormattedUrlEntity)iterator.next();
                int n = ((FormattedUrlEntity)object).getStart();
                int n2 = 0;
                Iterator<Integer> iterator2 = list.iterator();
                while (iterator2.hasNext() && ((Number)iterator2.next()).intValue() - n2 <= n) {
                    ++n2;
                }
                Object object2 = object;
                ((FormattedUrlEntity)object2).setStart(((FormattedUrlEntity)object2).getStart() + n2);
                ((FormattedUrlEntity)object2).setEnd(((FormattedUrlEntity)object2).getEnd() + n2);
            }
            return;
        }
    }

    @NotNull
    public final FormattedText formatTweetText(@NotNull Tweet object) {
        Tweet tweet = object;
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"tweet");
        Long l = StringsKt.toLongOrNull((String)tweet.getId());
        long l2 = l == null ? 0L : l;
        FormattedText formattedText = (FormattedText)this.cache.get((Object)l2);
        if (formattedText != null) {
            return formattedText;
        }
        if (!TextUtils.isEmpty((CharSequence)((FormattedText)(object = this.format((Tweet)object))).getText())) {
            this.cache.put((Object)l2, object);
        }
        return object;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

