/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

import android.text.TextUtils;
import java.util.Arrays;
import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TweetUtils {
    @NotNull
    public static final TweetUtils INSTANCE = new TweetUtils();
    @NotNull
    private static final String UNKNOWN_SCREEN_NAME = "twitter_unknown";
    @NotNull
    private static final String TWITTER_URL = "https://twitter.com/";
    @NotNull
    private static final String TWITTER_KIT_REF = "ref_src=twsrc%%5Etwitterkit";
    @NotNull
    private static final String TWEET_URL = "https://twitter.com/%s/status/%d?ref_src=twsrc%%5Etwitterkit";
    @NotNull
    private static final String HASHTAG_URL = "https://twitter.com/hashtag/%s?ref_src=twsrc%%5Etwitterkit";
    @NotNull
    private static final String PROFILE_URL = "https://twitter.com/%s?ref_src=twsrc%%5Etwitterkit";
    @NotNull
    private static final String SYMBOL_URL = "https://twitter.com/search?q=%%24%s&ref_src=twsrc%%5Etwitterkit";

    private TweetUtils() {
    }

    @NotNull
    public final String getProfilePermalink(@Nullable String string2) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            object = String.format(Locale.US, PROFILE_URL, Arrays.copyOf(new Object[]{UNKNOWN_SCREEN_NAME}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(locale, format, *args)");
        } else {
            object = String.format(Locale.US, PROFILE_URL, Arrays.copyOf(new Object[]{string2}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(locale, format, *args)");
        }
        return object;
    }

    @NotNull
    public final String getHashtagPermalink(@Nullable String string2) {
        String string3 = String.format(Locale.US, HASHTAG_URL, Arrays.copyOf(new Object[]{string2}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        return string3;
    }

    @NotNull
    public final String getSymbolPermalink(@Nullable String string2) {
        String string3 = String.format(Locale.US, SYMBOL_URL, Arrays.copyOf(new Object[]{string2}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        return string3;
    }
}

