/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import io.streamlayer.common.media.MediaProvider;
import io.streamlayer.sdk.VideoPlayer;
import io.streamlayer.sdk.VideoPlayerProvider;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoComponent;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TweetPlayerViewModel
extends ViewModel
implements TweetVideoPlayerCache {
    @NotNull
    private final TweetVideoComponent tweetVideoComponent;
    @NotNull
    private MediaProvider mediaProvider;
    private boolean releaseOnCleared;
    @Nullable
    private TweetVideo tweetVideo;

    public TweetPlayerViewModel(@NotNull TweetVideoComponent tweetVideoComponent, @NotNull MediaProvider mediaProvider) {
        Intrinsics.checkNotNullParameter((Object)tweetVideoComponent, (String)"tweetVideoComponent");
        Intrinsics.checkNotNullParameter((Object)mediaProvider, (String)"mediaProvider");
        this.tweetVideoComponent = tweetVideoComponent;
        this.mediaProvider = mediaProvider;
        this.releaseOnCleared = true;
    }

    @Override
    @Nullable
    public VideoPlayer getPlayer(@NotNull TweetVideo tweetVideo, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        return this.tweetVideoComponent.getPlayer(tweetVideo, bl);
    }

    @Override
    public void release() {
        this.tweetVideoComponent.release();
    }

    @Override
    public void releasePlayer(@NotNull TweetVideo tweetVideo) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        this.tweetVideoComponent.releasePlayer(tweetVideo);
    }

    public final boolean getReleaseOnCleared() {
        return this.releaseOnCleared;
    }

    public final void setReleaseOnCleared(boolean bl) {
        this.releaseOnCleared = bl;
    }

    @Nullable
    public final TweetVideo getTweetVideo() {
        return this.tweetVideo;
    }

    public final void setTweetVideo(@Nullable TweetVideo tweetVideo) {
        this.tweetVideo = tweetVideo;
    }

    @Nullable
    public final VideoPlayerView getVideoPlayerView(@NotNull Context context, @NotNull VideoPlayerView.Type type2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        VideoPlayerProvider videoPlayerProvider = ((TweetPlayerViewModel)((Object)videoPlayerProvider)).mediaProvider.getVideoPlayerProvider();
        return videoPlayerProvider == null ? null : videoPlayerProvider.getVideoPlayerView(context, type2);
    }

    protected void onCleared() {
        TweetPlayerViewModel tweetPlayerViewModel = this;
        super.onCleared();
        if (tweetPlayerViewModel.releaseOnCleared) {
            this.release();
        }
    }
}

