/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.notifications;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.text.Layout;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.savedstate.ViewKt;
import com.google.android.material.imageview.ShapeableImageView;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.utils.OtherUtilsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemNotificationBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationCustomBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationFactoidBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationFactoidTweetBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationPredictionsResultBinding;
import io.streamlayer.sdk.databinding.SlrItemNotificationWatchPartyBinding;
import io.streamlayer.sdk.databinding.SlrPredictionsBannerBinding;
import io.streamlayer.sdk.main.notifications.NotificationViewsKt;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider;
import io.streamlayer.sdk.main.notifications.NotificationViewsProvider$BaseNotificationView$showAnimate$lambda-8$;
import io.streamlayer.sdk.main.notifications.NotificationsLayout;
import io.streamlayer.sdk.main.notifications.NotificationsLayoutKt;
import io.streamlayer.sdk.main.notifications.PredictionsResultState;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.predictions.QuestionNotification;
import io.streamlayer.sdk.model.predictions.TweetOptions;
import io.streamlayer.sdk.predictions.view.ExtensionsKt;
import io.streamlayer.sdk.predictions.view.PredictionsResultNotificationAnimation;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\b\u0000\u0018\u00002\u00020\u0001:\f !\"#$%&'()*+B\u0017\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00128\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00158\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0017\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "", "Landroid/view/ViewGroup;", "parent", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "getNotificationView", "view", "", "addToPool", "clearPool", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "listener", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;", "Landroid/content/res/Resources;", "resources", "Landroid/content/res/Resources;", "Ljava/util/LinkedList;", "notificationViewsPool", "Ljava/util/LinkedList;", "", "bottomMargin", "I", "startMargin", "overlayHeight", "getOverlayHeight", "()I", "setOverlayHeight", "(I)V", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationsLayout$NotificationViewAction;Landroid/content/res/Resources;)V", "BaseNotificationPredictionsView", "BaseNotificationView", "NotificationCustomViewHolder", "NotificationFactoidTweetView", "NotificationFactoidView", "NotificationFriendJoinToChatView", "NotificationPredictionsBannerView", "NotificationPredictionsResultView", "NotificationPredictionsView", "NotificationTouchListener", "NotificationView", "NotificationWatchPartyView", "sdk_originalRelease"})
public final class NotificationViewsProvider {
    @NotNull
    private final NotificationsLayout.NotificationViewAction listener;
    @NotNull
    private final Resources resources;
    @NotNull
    private final LinkedList<NotificationsLayout.BaseNotificationView> notificationViewsPool;
    private final int bottomMargin;
    private final int startMargin;
    private int overlayHeight;

    public NotificationViewsProvider(@NotNull NotificationsLayout.NotificationViewAction notificationViewAction2, @NotNull Resources resources) {
        NotificationViewsProvider notificationViewsProvider = this;
        Intrinsics.checkNotNullParameter((Object)notificationViewAction2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.listener = notificationViewAction2;
        notificationViewsProvider.resources = resources;
        notificationViewsProvider.notificationViewsPool = new LinkedList();
        this.bottomMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        this.startMargin = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin_small);
    }

    public static final /* synthetic */ int access$getStartMargin$p(NotificationViewsProvider notificationViewsProvider) {
        return notificationViewsProvider.startMargin;
    }

    public final int getOverlayHeight() {
        return this.overlayHeight;
    }

    public final void setOverlayHeight(int n) {
        this.overlayHeight = n;
    }

    @NotNull
    public final NotificationsLayout.BaseNotificationView getNotificationView(@NotNull ViewGroup object, @NotNull Notification notification) {
        Object object2;
        block11: {
            block10: {
                Notification notification2 = notification;
                Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification = LayoutInflater.from((Context)object.getContext());
                switch (WhenMappings.$EnumSwitchMapping$0[notification2.getType().ordinal()]) {
                    default: {
                        NotificationView notificationView;
                        if (!((NotificationViewsProvider)this).notificationViewsPool.isEmpty()) break;
                        object2 = notificationView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationView = (NotificationViewsProvider)this.new NotificationView((SlrItemNotificationBinding)object);
                        break block10;
                    }
                    case 8: {
                        NotificationCustomViewHolder notificationCustomViewHolder;
                        object2 = notificationCustomViewHolder;
                        object = SlrItemNotificationCustomBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                        notificationCustomViewHolder = (NotificationViewsProvider)this.new NotificationCustomViewHolder((SlrItemNotificationCustomBinding)object);
                        break block11;
                    }
                    case 7: {
                        NotificationFactoidTweetView notificationFactoidTweetView;
                        object2 = notificationFactoidTweetView;
                        object = SlrItemNotificationFactoidTweetBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationFactoidTweetView = (NotificationViewsProvider)this.new NotificationFactoidTweetView((SlrItemNotificationFactoidTweetBinding)object);
                        break block11;
                    }
                    case 6: {
                        NotificationFactoidView notificationFactoidView;
                        object2 = notificationFactoidView;
                        object = SlrItemNotificationFactoidBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationFactoidView = new NotificationFactoidView((NotificationViewsProvider)this, (SlrItemNotificationFactoidBinding)object);
                        break block11;
                    }
                    case 5: {
                        NotificationPredictionsBannerView notificationPredictionsBannerView;
                        object2 = notificationPredictionsBannerView;
                        object = SlrPredictionsBannerBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsBannerView = (NotificationViewsProvider)this.new NotificationPredictionsBannerView((SlrPredictionsBannerBinding)object);
                        break block11;
                    }
                    case 4: {
                        NotificationPredictionsResultView notificationPredictionsResultView;
                        object2 = notificationPredictionsResultView;
                        object = SlrItemNotificationPredictionsResultBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsResultView = new NotificationPredictionsResultView((NotificationViewsProvider)this, (SlrItemNotificationPredictionsResultBinding)object);
                        break block11;
                    }
                    case 3: {
                        NotificationPredictionsView notificationPredictionsView;
                        object2 = notificationPredictionsView;
                        object = SlrItemNotificationPredictionsBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationPredictionsView = (NotificationViewsProvider)this.new NotificationPredictionsView((SlrItemNotificationPredictionsBinding)object);
                        break block11;
                    }
                    case 2: {
                        NotificationWatchPartyView notificationWatchPartyView;
                        object2 = notificationWatchPartyView;
                        object = SlrItemNotificationWatchPartyBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(inflater, parent, false)");
                        notificationWatchPartyView = (NotificationViewsProvider)this.new NotificationWatchPartyView((SlrItemNotificationWatchPartyBinding)object);
                        break block11;
                    }
                    case 1: {
                        NotificationFriendJoinToChatView notificationFriendJoinToChatView;
                        object2 = notificationFriendJoinToChatView;
                        object = SlrItemNotificationBinding.inflate((LayoutInflater)notification, object, false);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(\n               \u2026  false\n                )");
                        notificationFriendJoinToChatView = (NotificationViewsProvider)this.new NotificationFriendJoinToChatView((SlrItemNotificationBinding)object);
                        break block11;
                    }
                }
                object2 = this = ((NotificationViewsProvider)this).notificationViewsPool.removeFirst();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                if (no\u2026moveFirst()\n            }");
        }
        return object2;
    }

    public final void addToPool(@NotNull NotificationsLayout.BaseNotificationView baseNotificationView) {
        Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"view");
        if (!this.notificationViewsPool.contains(baseNotificationView)) {
            this.notificationViewsPool.addLast(baseNotificationView);
        }
    }

    public final void clearPool(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        Iterator iterator = this.notificationViewsPool.iterator();
        while (iterator.hasNext()) {
            viewGroup.removeView(((NotificationsLayout.BaseNotificationView)iterator.next()).getBinding().getRoot());
        }
        this.notificationViewsPool.clear();
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016R\u0019\u0010\t\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u00020\r8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationTouchListener;", "Landroid/view/View$OnTouchListener;", "Landroid/view/View;", "view", "Landroid/view/MotionEvent;", "motionEvent", "", "onTouch", "Lio/streamlayer/sdk/model/notifications/Notification;", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "getNotification", "()Lio/streamlayer/sdk/model/notifications/Notification;", "", "dY", "F", "y1", "y2", "swipeThreshold", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/Notification;)V", "sdk_originalRelease"})
    public final class NotificationTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final Notification notification;
        private float dY;
        private float y1;
        private float y2;
        private final float swipeThreshold;

        public NotificationTouchListener(Notification notification) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            this.notification = notification;
            this.swipeThreshold = 50.0f;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        public boolean onTouch(@NotNull View view2, @NotNull MotionEvent motionEvent) {
            MotionEvent motionEvent2 = motionEvent;
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
            Intrinsics.checkNotNullParameter((Object)motionEvent2, (String)"motionEvent");
            int n = motionEvent2.getAction();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        view2.setY(motionEvent.getRawY() + this.dY);
                    }
                } else {
                    NotificationTouchListener notificationTouchListener;
                    this.y2 = view2.getY();
                    if (Math.abs(Math.abs(notificationTouchListener.y1) - Math.abs(this.y2)) < this.swipeThreshold) {
                        if (NotificationViewsKt.access$isClickable(this.notification)) {
                            NotificationViewsProvider.this.listener.onExpand(this.notification, view2);
                        }
                    } else {
                        float f;
                        float f2 = this.y2;
                        if (f < this.y1 && Math.abs(Math.abs(f2) - Math.abs(this.y1)) > this.swipeThreshold) {
                            NotificationViewsProvider.this.listener.onHide(this.notification, view2);
                        } else {
                            float f3;
                            float f4 = this.y1;
                            if (f3 < this.y2 && Math.abs(Math.abs(f4) - Math.abs(this.y2)) > this.swipeThreshold) {
                                NotificationViewsProvider.this.listener.hideAll();
                            }
                        }
                    }
                }
            } else {
                this.dY = view2.getY() - motionEvent.getRawY();
                this.y1 = view2.getY();
            }
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\tH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0016R\u001d\u0010\u0011\u001a\u00020\u000e8D@\u0004X\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationsLayout$BaseNotificationView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "", "prepareView", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "setConstraintParams", "", "getLandscapeWidth", "Lkotlin/Function0;", "onEnd", "showAnimate", "", "isPortrait$delegate", "Lkotlin/Lazy;", "isPortrait", "()Z", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;)V", "sdk_originalRelease"})
    public abstract class BaseNotificationView
    implements NotificationsLayout.BaseNotificationView {
        @NotNull
        private final Lazy isPortrait$delegate;
        final /* synthetic */ NotificationViewsProvider this$0;

        public BaseNotificationView(NotificationViewsProvider notificationViewsProvider) {
            NotificationViewsProvider notificationViewsProvider2 = notificationViewsProvider;
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider2, (String)"this$0");
            this.this$0 = notificationViewsProvider2;
            this.isPortrait$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
                final /* synthetic */ BaseNotificationView this$0;
                {
                    this.this$0 = baseNotificationView;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    Context context = this.this$0.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    return OtherExtensionsKt.isScreenPortrait(context);
                }
            });
        }

        private static final void prepareView$lambda-1(BaseNotificationView baseNotificationView, ConstraintLayout constraintLayout, NotificationViewsProvider notificationViewsProvider) {
            BaseNotificationView baseNotificationView2 = baseNotificationView;
            Intrinsics.checkNotNullParameter((Object)baseNotificationView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"$parent");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            View view2 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewExtensionsKt.invisible(view2);
            View view3 = baseNotificationView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
                layoutParams.width = n;
                view3.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private static final void showAnimate$lambda-8$lambda-4(View view2, ValueAnimator object) {
            View view3 = view2;
            Intrinsics.checkNotNullParameter((Object)view3, (String)"$view");
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            if (layoutParams != null) {
                if ((object = object.getAnimatedValue()) != null) {
                    layoutParams.width = (Integer)object;
                    view2.setLayoutParams(layoutParams);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        protected final boolean isPortrait() {
            return (Boolean)this.isPortrait$delegate.getValue();
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> BaseNotificationView.prepareView$lambda-1(this, constraintLayout, this.this$0));
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n, this.this$0.bottomMargin);
        }

        public int getLandscapeWidth() {
            return this.this$0.resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            BaseNotificationView baseNotificationView = notificationViewsProvider;
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            View view2 = baseNotificationView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            int n = baseNotificationView.isPortrait() ? constraintLayout.getWidth() - ViewExtensionsKt.getDp(16.0f) : ((BaseNotificationView)((Object)notificationViewsProvider)).getLandscapeWidth();
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
            NotificationViewsProvider notificationViewsProvider = ((BaseNotificationView)((Object)notificationViewsProvider)).this$0;
            valueAnimator.setDuration(400L);
            valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.addUpdateListener(arg_0 -> BaseNotificationView.showAnimate$lambda-8$lambda-4(view2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"");
            valueAnimator.addListener(new Animator.AnimatorListener(view2){
                final /* synthetic */ View $view$inlined;
                {
                    this.$view$inlined = view2;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    BaseNotificationView$showAnimate$lambda-8$$inlined$doOnStart$1 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    ViewExtensionsKt.visible(v0.$view$inlined);
                    v0.$view$inlined.animate().alpha(1.0f).translationX(-20.0f).setStartDelay(200L).setDuration(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).withEndAction(new Runnable(this.$view$inlined){
                        final /* synthetic */ View $view;
                        {
                            this.$view = view2;
                        }

                        public final void run() {
                            this.$view.animate().translationX(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                        }
                    }).start();
                }
            });
            valueAnimator.addListener(new Animator.AnimatorListener(view2, function0, notificationViewsProvider){
                final /* synthetic */ View $view$inlined;
                final /* synthetic */ Function0 $onEnd$inlined;
                final /* synthetic */ NotificationViewsProvider this$0;
                {
                    this.$view$inlined = view2;
                    this.$onEnd$inlined = function0;
                    this.this$0 = notificationViewsProvider;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    animator = this.$view$inlined;
                    ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                    if (layoutParams != null) {
                        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                        int n = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n2 = marginLayoutParams.topMargin;
                        int n3 = NotificationViewsProvider.access$getStartMargin$p(this.this$0);
                        int n4 = marginLayoutParams.bottomMargin;
                        marginLayoutParams.setMargins(n, n2, n3, n4);
                        animator.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
                        Function0 function0 = this.$onEnd$inlined;
                        if (function0 != null) {
                            function0.invoke();
                        }
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                }
            });
            valueAnimator.start();
        }

        @Override
        public void clear() {
            NotificationsLayout.BaseNotificationView.DefaultImpls.clear(this);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u00020\u00078\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationWatchPartyView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationWatchPartyBinding;)V", "sdk_originalRelease"})
    public final class NotificationWatchPartyView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationWatchPartyBinding binding;

        public NotificationWatchPartyView(SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationWatchPartyBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationWatchPartyBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationWatchPartyBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            NotificationWatchPartyView notificationWatchPartyView = this;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding = notificationWatchPartyView.getBinding();
            NotificationViewsProvider notificationViewsProvider = notificationWatchPartyView.NotificationViewsProvider.this;
            SlrItemNotificationWatchPartyBinding slrItemNotificationWatchPartyBinding2 = slrItemNotificationWatchPartyBinding;
            slrItemNotificationWatchPartyBinding2.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            slrItemNotificationWatchPartyBinding2.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            if (WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] == 1) {
                slrItemNotificationWatchPartyBinding = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationWatchPartyBinding, (String)"slNotifIconIV");
                Object object = notification.getNotificationIcon();
                object = object == null ? null : ((NotificationIcon)object).getAvatarUrl();
                Object object2 = notification.getNotificationIcon();
                object2 = object2 == null ? null : ((NotificationIcon)object2).getAvatarName();
                ProfileExtensionsKt.loadUserAvatar$default((ImageView)slrItemNotificationWatchPartyBinding, (String)object, (String)object2, null, 4, null);
            } else {
                AppCompatImageView appCompatImageView = slrItemNotificationWatchPartyBinding.slNotifIconIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                CoilExtensionsKt.clear((ImageView)appCompatImageView, bind.1.1.INSTANCE);
            }
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.WatchParty.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0096\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0007\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0003J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0003J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u001c\u0010\u0010\u001a\u00020\u000f8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Landroid/view/View;", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "", "setPadding", "", "getIcon", "getColor", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "bind", "clear", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "sdk_originalRelease"})
    public class NotificationView
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationBinding binding;

        public NotificationView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationBinding;
        }

        private final void setPadding(View view2, NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n = ViewExtensionsKt.getDp(4.0f);
                }
            }
            int n2 = n;
            view2.setPadding(n2, n2, n2, n2);
        }

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    n = 0;
                    break;
                }
                case 9: 
                case 15: {
                    n = R.drawable.slr_ic_watch_party_centered;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = R.drawable.slr_ic_profile;
                    break;
                }
                case 5: {
                    n = R.drawable.slr_ic_betting;
                    break;
                }
                case 3: {
                    n = R.drawable.slr_ic_twitter;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n = R.drawable.slr_ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 16: {
                    n = 0;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n = 17170445;
                    break;
                }
                case 9: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 5: {
                    n = R.color.slr_orange;
                    break;
                }
                case 4: {
                    n = R.color.slr_primaryBlue;
                    break;
                }
                case 3: {
                    n = R.color.slr_twitter;
                    break;
                }
                case 2: {
                    Context context = this.getBinding().getRoot().getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                    n = ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrNotificationIconColor, R.color.slr_primaryBlue);
                    break;
                }
                case 1: {
                    n = R.color.slr_primaryBlue;
                }
            }
            return n;
        }

        public static final /* synthetic */ void access$setPadding(NotificationView notificationView, View view2, NotificationType notificationType) {
            notificationView.setPadding(view2, notificationType);
        }

        public static final /* synthetic */ int access$getIcon(NotificationView notificationView, NotificationType notificationType) {
            return notificationView.getIcon(notificationType);
        }

        @Override
        @NotNull
        public SlrItemNotificationBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            NotificationViewsProvider notificationViewsProvider = NotificationViewsProvider.this;
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)notification.getTitle());
            Object object = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"slNotifTitleTV");
            String string2 = notification.getTitle();
            boolean bl = string2 == null || string2.length() == 0;
            ViewExtensionsKt.visibleIf((View)object, bl ^ true);
            slrItemNotificationBinding.slNotifDescriptionTV.setText((CharSequence)notification.getDescription());
            object = notification.getDescription();
            boolean bl2 = object == null || object.length() == 0;
            bl2 ^= true;
            Object object2 = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifTitleTV");
            ViewGroup.LayoutParams layoutParams = object2.getLayoutParams();
            if (layoutParams != null) {
                Unit unit;
                layoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                int n = bl2 ? 0 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.topToTop = n;
                n = bl2 ? ViewExtensionsKt.getDp(4.0f) : 0;
                layoutParams.topMargin = n;
                n = bl2 ? -1 : slrItemNotificationBinding.slNotifIconIV.getId();
                layoutParams.bottomToBottom = n;
                object2.setLayoutParams(layoutParams);
                AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifDescriptionTV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifDescriptionTV");
                ViewExtensionsKt.visibleIf((View)appCompatTextView, bl2);
                Object object3 = notification.getNotificationIcon();
                if (object3 == null) {
                    unit = null;
                } else {
                    if (((NotificationIcon)object3).getAvatarName() != null) {
                        object2 = slrItemNotificationBinding.slNotifIconIV;
                        NotificationIcon notificationIcon = object3;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = notificationIcon.getAvatarUrl();
                        ProfileExtensionsKt.loadUserAvatar$default((ImageView)object2, (String)object3, notificationIcon.getAvatarName(), null, 4, null);
                    } else if (((NotificationIcon)object3).getAvatarUrl() != null) {
                        Function1<Boolean, Unit> function1;
                        AppCompatImageView appCompatImageView = slrItemNotificationBinding.slNotifIconIV;
                        object2 = appCompatImageView;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"slNotifIconIV");
                        object3 = ((NotificationIcon)object3).getAvatarUrl();
                        Intrinsics.checkNotNull((Object)object3);
                        object2 = this.getIcon(notification.getType());
                        Object object4 = object3;
                        object3 = function1;
                        function1 = new Function1<Boolean, Unit>(this, slrItemNotificationBinding, notification){
                            final /* synthetic */ NotificationView this$0;
                            final /* synthetic */ SlrItemNotificationBinding $this_with;
                            final /* synthetic */ Notification $data;
                            {
                                this.this$0 = notificationView;
                                this.$this_with = slrItemNotificationBinding;
                                this.$data = notification;
                                super(1);
                            }

                            public final void invoke(boolean bl) {
                                if (!bl) {
                                    AppCompatImageView appCompatImageView = this.$this_with.slNotifIconIV;
                                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                                    NotificationView.access$setPadding(this.this$0, (View)appCompatImageView, this.$data.getType());
                                }
                            }
                        };
                        ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object4, false, (Integer)object2, (Function1)object3, 2, null);
                    }
                    slrItemNotificationBinding.slNotifIconIV.setBackgroundTintList(null);
                    unit = Unit.INSTANCE;
                }
                if (unit == null) {
                    SlrItemNotificationBinding slrItemNotificationBinding2 = slrItemNotificationBinding = slrItemNotificationBinding.slNotifIconIV;
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding2, (String)"");
                    CoilExtensionsKt.clear((ImageView)slrItemNotificationBinding2, (Function1<? super ImageView, Unit>)new Function1<ImageView, Unit>(this, notification){
                        final /* synthetic */ NotificationView this$0;
                        final /* synthetic */ Notification $data;
                        {
                            this.this$0 = notificationView;
                            this.$data = notification;
                            super(1);
                        }

                        public final void invoke(@NotNull ImageView imageView) {
                            Intrinsics.checkNotNullParameter((Object)imageView, (String)"$this$clear");
                            imageView.setImageResource(NotificationView.access$getIcon(this.this$0, this.$data.getType()));
                        }
                    });
                    this.setPadding((View)slrItemNotificationBinding, notification.getType());
                    slrItemNotificationBinding.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)slrItemNotificationBinding.getContext(), (int)this.getColor(notification.getType()))));
                    Intrinsics.checkNotNullExpressionValue((Object)slrItemNotificationBinding, (String)"run {\n                  \u2026      }\n                }");
                }
                this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        @Override
        public void clear() {
            SlrItemNotificationBinding slrItemNotificationBinding = this.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText(null);
            AppCompatTextView appCompatTextView = slrItemNotificationBinding.slNotifTitleTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slNotifTitleTV");
            ViewExtensionsKt.gone((View)appCompatTextView);
            slrItemNotificationBinding.slNotifDescriptionTV.setText(null);
            AppCompatTextView appCompatTextView2 = slrItemNotificationBinding.slNotifDescriptionTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView2, (String)"slNotifDescriptionTV");
            ViewExtensionsKt.gone((View)appCompatTextView2);
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NotificationType.values().length];
                nArray[NotificationType.Universal.ordinal()] = 1;
                nArray[NotificationType.Chat.ordinal()] = 2;
                nArray[NotificationType.Twitter.ordinal()] = 3;
                nArray[NotificationType.Alert.ordinal()] = 4;
                nArray[NotificationType.Inplay.ordinal()] = 5;
                nArray[NotificationType.ArrivingFriend.ordinal()] = 6;
                nArray[NotificationType.JoinToChat.ordinal()] = 7;
                nArray[NotificationType.WaveReply.ordinal()] = 8;
                nArray[NotificationType.CreateNewWatchParty.ordinal()] = 9;
                nArray[NotificationType.Prediction.ordinal()] = 10;
                nArray[NotificationType.PredictionResult.ordinal()] = 11;
                nArray[NotificationType.PredictionOnboarding.ordinal()] = 12;
                nArray[NotificationType.Factoid.ordinal()] = 13;
                nArray[NotificationType.FactoidTweet.ordinal()] = 14;
                nArray[NotificationType.WatchParty.ordinal()] = 15;
                nArray[NotificationType.Custom.ordinal()] = 16;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationFriendJoinToChatView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "item", "", "bind", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Lkotlin/Function0;", "onEnd", "showAnimate", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "setConstraintParams", "prepareView", "Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;", "binding", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationBinding;)V", "sdk_originalRelease"})
    public final class NotificationFriendJoinToChatView
    extends NotificationView {
        public NotificationFriendJoinToChatView(SlrItemNotificationBinding slrItemNotificationBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationBinding, (String)"binding");
            super(slrItemNotificationBinding);
        }

        private static final void showAnimate$lambda-2(NotificationFriendJoinToChatView notificationFriendJoinToChatView) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView;
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView2, (String)"this$0");
            ConstraintLayout constraintLayout = notificationFriendJoinToChatView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            ViewExtensionsKt.visible((View)constraintLayout);
        }

        private static final void prepareView$lambda-5(NotificationFriendJoinToChatView notificationFriendJoinToChatView, NotificationViewsProvider notificationViewsProvider) {
            Intrinsics.checkNotNullParameter((Object)notificationFriendJoinToChatView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$1");
            notificationFriendJoinToChatView = notificationFriendJoinToChatView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)notificationFriendJoinToChatView, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = notificationFriendJoinToChatView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = notificationViewsProvider.resources.getDimensionPixelSize(R.dimen.slr_overlay_content_landscape_width) - ViewExtensionsKt.getDp(12.0f);
                notificationFriendJoinToChatView.setLayoutParams(layoutParams);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        @Override
        public void bind(@NotNull Notification notification) {
            StyleSpan styleSpan;
            SpannableStringBuilder spannableStringBuilder;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = notificationFriendJoinToChatView3;
            Notification notification2 = notification;
            Intrinsics.checkNotNullParameter((Object)notification2, (String)"item");
            super.bind(notification2);
            SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
            NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = notificationFriendJoinToChatView3;
            SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder2;
            SpannableStringBuilder spannableStringBuilder4 = spannableStringBuilder2;
            spannableStringBuilder4();
            NotificationFriendJoinToChatView notificationFriendJoinToChatView3 = styleSpan;
            styleSpan = new StyleSpan(1);
            int n = spannableStringBuilder4.length();
            spannableStringBuilder3.append((CharSequence)notification.getTitle());
            int n2 = spannableStringBuilder3.length();
            spannableStringBuilder3.setSpan((Object)notificationFriendJoinToChatView3, n, n2, 17);
            notificationFriendJoinToChatView3 = spannableStringBuilder.append((CharSequence)Intrinsics.stringPlus((String)" ", (Object)notificationFriendJoinToChatView2.NotificationViewsProvider.this.resources.getText(R.string.slr_messaging_chat_friend_joined_template)));
            SlrItemNotificationBinding slrItemNotificationBinding = notificationFriendJoinToChatView.getBinding();
            slrItemNotificationBinding.slNotifTitleTV.setText((CharSequence)((Object)notificationFriendJoinToChatView3));
            slrItemNotificationBinding.getRoot().setOnTouchListener(null);
            slrItemNotificationBinding.slNotification.setBackground(ContextCompat.getDrawable((Context)slrItemNotificationBinding.getRoot().getContext(), (int)R.drawable.slr_bg_notification_friend_arrived));
            slrItemNotificationBinding.slNotifIconIV.setBackground(null);
            slrItemNotificationBinding.slNotifTitleTV.setTextColor(ContextCompat.getColor((Context)slrItemNotificationBinding.getRoot().getContext(), (int)R.color.slr_white));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().animate().translationX(0.0f).setDuration(400L).withStartAction(() -> NotificationFriendJoinToChatView.showAnimate$lambda-2(this)).start();
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            constraintSet.setTranslationZ(this.getBinding().getRoot().getId(), 20.0f);
            constraintSet.setTranslationX(this.getBinding().getRoot().getId(), (float)constraintLayout.getWidth());
            if (this.isPortrait()) {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(75.0f));
                NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            } else {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(60.0f));
            }
            NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), 0);
        }

        @Override
        public void prepareView(@NotNull ConstraintLayout constraintLayout) {
            NotificationFriendJoinToChatView notificationFriendJoinToChatView = this;
            ConstraintLayout constraintLayout2 = constraintLayout;
            Intrinsics.checkNotNullParameter((Object)constraintLayout2, (String)"parent");
            super.prepareView(constraintLayout2);
            if (!notificationFriendJoinToChatView.isPortrait()) {
                NotificationFriendJoinToChatView notificationFriendJoinToChatView2 = this;
                this.getBinding().getRoot().post(() -> NotificationFriendJoinToChatView.prepareView$lambda-5(notificationFriendJoinToChatView2, notificationFriendJoinToChatView2.NotificationViewsProvider.this));
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00a6\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b#\u0010$J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0004J\u001a\u0010\f\u001a\u00020\u00072\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nH\u0004R\u0019\u0010\u000e\u001a\u00020\r8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016R\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\u0016R\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001e\u0010\u0016R\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010\u0016R\u001e\u0010!\u001a\u0004\u0018\u00010\u00128\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\u0014\u001a\u0004\b\"\u0010\u0016\u00a8\u0006%"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "", "setConstraintParams", "showAnimatePortrait", "Lkotlin/Function0;", "onEnd", "showAnimateLandscape", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getType", "()Lio/streamlayer/sdk/model/notifications/NotificationType;", "Landroid/view/View;", "slNotification", "Landroid/view/View;", "getSlNotification", "()Landroid/view/View;", "slCircle", "getSlCircle", "slFullRoundRect", "getSlFullRoundRect", "slText", "getSlText", "slNotificationIcon", "getSlNotificationIcon", "slRightIcon", "getSlRightIcon", "slLeftSide", "getSlLeftSide", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/model/notifications/NotificationType;)V", "sdk_originalRelease"})
    public abstract class BaseNotificationPredictionsView
    extends BaseNotificationView {
        @NotNull
        private final NotificationType type;
        @Nullable
        private final View slNotification;
        @Nullable
        private final View slCircle;
        @Nullable
        private final View slFullRoundRect;
        @Nullable
        private final View slText;
        @Nullable
        private final View slNotificationIcon;
        @Nullable
        private final View slRightIcon;
        @Nullable
        private final View slLeftSide;

        public BaseNotificationPredictionsView(NotificationType notificationType) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)notificationType), (String)"type");
            super(NotificationViewsProvider.this);
            this.type = notificationType;
        }

        public static /* synthetic */ void showAnimateLandscape$default(BaseNotificationPredictionsView baseNotificationPredictionsView, Function0 function0, int n, Object object) {
            if (object == null) {
                if ((n & 1) != 0) {
                    function0 = null;
                }
                baseNotificationPredictionsView.showAnimateLandscape((Function0<Unit>)function0);
                return;
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showAnimateLandscape");
        }

        private static final void showAnimateLandscape$lambda-4$lambda-3(ValueAnimator object, BaseNotificationPredictionsView baseNotificationPredictionsView, float f, int n, int n2, ValueAnimator valueAnimator) {
            block4: {
                block6: {
                    int n3;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)baseNotificationPredictionsView, (String)"this$0");
                        object = object.getAnimatedValue();
                        if (object == null) break block4;
                        n3 = (Integer)object;
                        valueAnimator = baseNotificationPredictionsView.getSlCircle();
                        if (valueAnimator == null) break block5;
                        ViewGroup.LayoutParams layoutParams = valueAnimator.getLayoutParams();
                        if (layoutParams == null) break block6;
                        layoutParams.height = n3;
                        valueAnimator.setLayoutParams(layoutParams);
                    }
                    if ((baseNotificationPredictionsView = baseNotificationPredictionsView.getSlCircle()) != null) {
                        baseNotificationPredictionsView.setTranslationY(f * (1.0f - (float)(n3 - n) / (float)(n2 - n)));
                    }
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimateLandscape$lambda-7$lambda-6(BaseNotificationPredictionsView baseNotificationPredictionsView, ValueAnimator object, ValueAnimator valueAnimator) {
            BaseNotificationPredictionsView baseNotificationPredictionsView2 = baseNotificationPredictionsView;
            Intrinsics.checkNotNullParameter((Object)baseNotificationPredictionsView2, (String)"this$0");
            baseNotificationPredictionsView = baseNotificationPredictionsView2.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)baseNotificationPredictionsView, (String)"binding.root");
            valueAnimator = baseNotificationPredictionsView.getLayoutParams();
            if (valueAnimator != null) {
                if ((object = object.getAnimatedValue()) != null) {
                    valueAnimator.width = (Integer)object;
                    baseNotificationPredictionsView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private static final void showAnimateLandscape$lambda-9$lambda-8(BaseNotificationPredictionsView baseNotificationPredictionsView, ValueAnimator object, ValueAnimator valueAnimator) {
            block3: {
                block2: {
                    BaseNotificationPredictionsView baseNotificationPredictionsView2 = baseNotificationPredictionsView;
                    Intrinsics.checkNotNullParameter((Object)baseNotificationPredictionsView2, (String)"this$0");
                    baseNotificationPredictionsView = baseNotificationPredictionsView2.getSlFullRoundRect();
                    if (baseNotificationPredictionsView == null) break block2;
                    if ((object = object.getAnimatedValue()) == null) break block3;
                    baseNotificationPredictionsView.setAlpha(((Float)object).floatValue());
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }

        private static final void showAnimateLandscape$lambda-12$lambda-11(BaseNotificationPredictionsView baseNotificationPredictionsView, ValueAnimator object, ValueAnimator valueAnimator) {
            block3: {
                block4: {
                    block2: {
                        BaseNotificationPredictionsView baseNotificationPredictionsView2 = baseNotificationPredictionsView;
                        Intrinsics.checkNotNullParameter((Object)baseNotificationPredictionsView2, (String)"this$0");
                        baseNotificationPredictionsView = baseNotificationPredictionsView2.getSlLeftSide();
                        if (baseNotificationPredictionsView == null) break block2;
                        valueAnimator = baseNotificationPredictionsView.getLayoutParams();
                        if (valueAnimator == null) break block3;
                        if ((object = object.getAnimatedValue()) == null) break block4;
                        valueAnimator.width = (Integer)object;
                        baseNotificationPredictionsView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    }
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }

        private static final void showAnimateLandscape$lambda-14$lambda-13(BaseNotificationPredictionsView baseNotificationPredictionsView, ValueAnimator object, ValueAnimator valueAnimator) {
            block3: {
                block5: {
                    block7: {
                        block9: {
                            block8: {
                                block6: {
                                    Object object2;
                                    block4: {
                                        block2: {
                                            BaseNotificationPredictionsView baseNotificationPredictionsView2 = baseNotificationPredictionsView;
                                            Intrinsics.checkNotNullParameter((Object)baseNotificationPredictionsView2, (String)"this$0");
                                            valueAnimator = baseNotificationPredictionsView2.getSlNotificationIcon();
                                            if (valueAnimator == null) break block2;
                                            object2 = object.getAnimatedValue();
                                            if (object2 == null) break block3;
                                            valueAnimator.setAlpha(((Float)object2).floatValue());
                                        }
                                        if ((valueAnimator = baseNotificationPredictionsView.getSlNotificationIcon()) == null) break block4;
                                        object2 = object.getAnimatedValue();
                                        if (object2 == null) break block5;
                                        valueAnimator.setAlpha(((Float)object2).floatValue());
                                    }
                                    if ((valueAnimator = baseNotificationPredictionsView.getSlRightIcon()) == null) break block6;
                                    object2 = object.getAnimatedValue();
                                    if (object2 == null) break block7;
                                    valueAnimator.setAlpha(((Float)object2).floatValue());
                                }
                                if ((baseNotificationPredictionsView = baseNotificationPredictionsView.getSlRightIcon()) == null) break block8;
                                if ((object = object.getAnimatedValue()) == null) break block9;
                                baseNotificationPredictionsView.setAlpha(((Float)object).floatValue());
                            }
                            return;
                        }
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }

        private static final void showAnimateLandscape$lambda-18$lambda-17(AnimatorSet animatorSet2, DynamicAnimation dynamicAnimation, boolean bl, float f, float f2) {
            AnimatorSet animatorSet3 = animatorSet2;
            Intrinsics.checkNotNullParameter((Object)animatorSet3, (String)"$animatorSet");
            animatorSet3.start();
        }

        @NotNull
        public final NotificationType getType() {
            return this.type;
        }

        @Nullable
        public View getSlNotification() {
            return this.slNotification;
        }

        @Nullable
        public View getSlCircle() {
            return this.slCircle;
        }

        @Nullable
        public View getSlFullRoundRect() {
            return this.slFullRoundRect;
        }

        @Nullable
        public View getSlText() {
            return this.slText;
        }

        @Nullable
        public View getSlNotificationIcon() {
            return this.slNotificationIcon;
        }

        @Nullable
        public View getSlRightIcon() {
            return this.slRightIcon;
        }

        @Nullable
        public View getSlLeftSide() {
            return this.slLeftSide;
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout constraintLayout, @NotNull ConstraintSet constraintSet) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            boolean bl = NotificationViewsKt.isLikePrediction(this.type);
            BaseNotificationPredictionsView baseNotificationPredictionsView = this;
            NotificationViewsProvider notificationViewsProvider = baseNotificationPredictionsView.NotificationViewsProvider.this;
            int n = baseNotificationPredictionsView.getBinding().getRoot().getId();
            float f = bl ? 30.0f : 20.0f;
            constraintSet.setTranslationZ(n, f);
            if (bl) {
                NotificationsLayoutKt.setStartSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            }
            if (bl && this.isPortrait() || !bl) {
                NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            }
            Context context = this.getBinding().getRoot().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
            if (OtherExtensionsKt.isScreenPortrait(context) && bl && this.getType() != NotificationType.Factoid && this.getType() != NotificationType.FactoidTweet) {
                NotificationsLayoutKt.setTopSide(constraintSet, this.getBinding().getRoot().getId(), ViewExtensionsKt.getDp(22.0f));
            } else {
                int n2 = this.getBinding().getRoot().getId();
                NotificationsLayoutKt.setBottomSide(constraintSet, n2, notificationViewsProvider.bottomMargin);
            }
        }

        protected final void showAnimatePortrait() {
            View view2 = this.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.root");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams != null) {
                BaseNotificationPredictionsView baseNotificationPredictionsView = this;
                ((ViewGroup.MarginLayoutParams)layoutParams).height = -2;
                view2.setLayoutParams((ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams));
                baseNotificationPredictionsView.getBinding().getRoot().setAlpha(0.0f);
                baseNotificationPredictionsView.getBinding().getRoot().setTranslationX(-((float)this.getBinding().getRoot().getContext().getResources().getDisplayMetrics().widthPixels));
                View view3 = baseNotificationPredictionsView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"binding.root");
                ViewExtensionsKt.visible(view3);
                baseNotificationPredictionsView.getBinding().getRoot().animate().setDuration(500L).alpha(1.0f).translationX(0.0f).start();
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }

        protected final void showAnimateLandscape(@Nullable Function0<Unit> springAnimation) {
            SpringAnimation springAnimation2;
            AnimatorSet animatorSet2;
            AnimatorSet animatorSet3;
            ValueAnimator valueAnimator;
            ValueAnimator valueAnimator2;
            ValueAnimator valueAnimator3;
            ValueAnimator valueAnimator4;
            View view2 = baseNotificationPredictionsView3.getSlNotification();
            if (view2 != null) {
                ViewExtensionsKt.invisible(view2);
            }
            view2 = baseNotificationPredictionsView3.getSlNotificationIcon();
            if (view2 != null) {
                ViewExtensionsKt.invisible(view2);
            }
            view2 = baseNotificationPredictionsView3.getSlLeftSide();
            if (view2 != null) {
                ViewExtensionsKt.invisible(view2);
            }
            view2 = baseNotificationPredictionsView3.getSlFullRoundRect();
            if (view2 != null) {
                ViewExtensionsKt.invisible(view2);
            }
            view2 = baseNotificationPredictionsView3.getSlText();
            if (view2 != null) {
                ViewExtensionsKt.invisible(view2);
            }
            view2 = baseNotificationPredictionsView3.getSlRightIcon();
            if (view2 != null) {
                ViewExtensionsKt.invisible(view2);
            }
            BaseNotificationPredictionsView baseNotificationPredictionsView = baseNotificationPredictionsView3;
            int n = baseNotificationPredictionsView.getLandscapeWidth();
            int n2 = (int)baseNotificationPredictionsView.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_predictions_notification_height);
            View view3 = baseNotificationPredictionsView.getSlCircle();
            int n3 = view3 == null ? 0 : view3.getHeight();
            BaseNotificationPredictionsView baseNotificationPredictionsView2 = baseNotificationPredictionsView3;
            float f = (float)(n2 - n3) / (float)2;
            float f2 = 0.8f;
            int n4 = (int)baseNotificationPredictionsView2.getBinding().getRoot().getContext().getResources().getDimension(R.dimen.slr_predictions_notification_result_left_width);
            ValueAnimator valueAnimator5 = ValueAnimator.ofInt((int[])new int[]{n3, n2});
            valueAnimator5.setDuration(200L);
            valueAnimator5.addUpdateListener(arg_0 -> BaseNotificationPredictionsView.showAnimateLandscape$lambda-4$lambda-3(valueAnimator5, baseNotificationPredictionsView3, f, n3, n2, arg_0));
            ValueAnimator valueAnimator6 = valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{n3, n});
            valueAnimator6.setDuration(600L);
            valueAnimator6.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(baseNotificationPredictionsView3, f2){
                final /* synthetic */ BaseNotificationPredictionsView this$0;
                final /* synthetic */ float $startAlpha;
                {
                    this.this$0 = baseNotificationPredictionsView;
                    this.$startAlpha = f;
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    block8: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                            animator = this.this$0.getSlCircle();
                            if (animator != null) {
                                ViewExtensionsKt.gone((View)animator);
                            }
                            animator = this.this$0.getSlNotification();
                            if (animator == null) break block7;
                            ViewGroup.LayoutParams layoutParams = animator.getLayoutParams();
                            if (layoutParams == null) break block8;
                            layoutParams.width = 0;
                            animator.setLayoutParams(layoutParams);
                        }
                        if ((animator = this.this$0.getSlNotification()) != null) {
                            ViewExtensionsKt.visible((View)animator);
                        }
                        animator = this.this$0.getSlFullRoundRect();
                        if (animator != null) {
                            ViewExtensionsKt.visible((View)animator);
                        }
                        animator = this.this$0.getSlFullRoundRect();
                        if (animator != null) {
                            animator.setAlpha(this.$startAlpha);
                        }
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                }
            });
            valueAnimator4.addUpdateListener(arg_0 -> BaseNotificationPredictionsView.showAnimateLandscape$lambda-7$lambda-6(baseNotificationPredictionsView3, valueAnimator6, arg_0));
            valueAnimator4.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            ValueAnimator valueAnimator7 = valueAnimator3 = ValueAnimator.ofFloat((float[])new float[]{f2, 0.0f});
            valueAnimator7.setDuration(600L);
            valueAnimator7.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(baseNotificationPredictionsView3){
                final /* synthetic */ BaseNotificationPredictionsView this$0;
                {
                    this.this$0 = baseNotificationPredictionsView;
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                    showAnimateLandscape.alphaAnimation.1.1 this_ = this_.this$0.getSlFullRoundRect();
                    if (this_ != null) {
                        ViewExtensionsKt.visible((View)this_);
                    }
                }

                public void onAnimationEnd(@Nullable Animator animator, boolean bl) {
                    showAnimateLandscape.alphaAnimation.1.1 this_ = this_.this$0.getSlFullRoundRect();
                    if (this_ != null) {
                        ViewExtensionsKt.gone((View)this_);
                    }
                }
            });
            valueAnimator3.addUpdateListener(arg_0 -> BaseNotificationPredictionsView.showAnimateLandscape$lambda-9$lambda-8(baseNotificationPredictionsView3, valueAnimator7, arg_0));
            ValueAnimator valueAnimator8 = valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{0, n4});
            valueAnimator8.setDuration(600L);
            valueAnimator8.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(baseNotificationPredictionsView3){
                final /* synthetic */ BaseNotificationPredictionsView this$0;
                {
                    this.this$0 = baseNotificationPredictionsView;
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"var1");
                    showAnimateLandscape.leftRectAnimation.1.1 this_ = this_.this$0.getSlLeftSide();
                    if (this_ != null) {
                        ViewExtensionsKt.visible((View)this_);
                    }
                }

                public void onAnimationEnd(@Nullable Animator animator, boolean bl) {
                    animator = this_.this$0.getSlNotificationIcon();
                    if (animator != null) {
                        ViewExtensionsKt.visible((View)animator);
                    }
                    showAnimateLandscape.leftRectAnimation.1.1 this_ = this_.this$0.getSlRightIcon();
                    if (this_ != null) {
                        ViewExtensionsKt.visible((View)this_);
                    }
                }
            });
            valueAnimator2.addUpdateListener(arg_0 -> BaseNotificationPredictionsView.showAnimateLandscape$lambda-12$lambda-11(baseNotificationPredictionsView3, valueAnimator8, arg_0));
            valueAnimator2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            ValueAnimator valueAnimator9 = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            valueAnimator9.setDuration(400L);
            valueAnimator.addUpdateListener(arg_0 -> BaseNotificationPredictionsView.showAnimateLandscape$lambda-14$lambda-13(baseNotificationPredictionsView3, valueAnimator9, arg_0));
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(baseNotificationPredictionsView3){
                final /* synthetic */ BaseNotificationPredictionsView this$0;
                {
                    this.this$0 = baseNotificationPredictionsView;
                }

                public void onAnimationEnd(@Nullable Animator animator, boolean bl) {
                    showAnimateLandscape.iconsAnimation.1.2 this_ = this_.this$0.getSlText();
                    if (this_ != null) {
                        ViewExtensionsKt.visible((View)this_);
                    }
                }
            });
            valueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            AnimatorSet animatorSet4 = animatorSet3;
            animatorSet3 = new AnimatorSet();
            Animator[] animatorArray = new Animator[3];
            animatorArray[0] = valueAnimator5;
            animatorArray[1] = valueAnimator4;
            valueAnimator4 = animatorSet2;
            new AnimatorSet().playTogether(new Animator[]{valueAnimator3, valueAnimator2, valueAnimator});
            animatorArray[2] = valueAnimator4;
            animatorSet3.playSequentially(animatorArray);
            animatorSet3.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((Function0<Unit>)springAnimation){
                final /* synthetic */ Function0<Unit> $onEnd;
                {
                    this.$onEnd = function0;
                }

                public void onAnimationEnd(@Nullable Animator animator, boolean bl) {
                    Function0<Unit> function0 = function0.$onEnd;
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            });
            springAnimation = springAnimation2;
            springAnimation2 = new SpringAnimation((Object)baseNotificationPredictionsView3.getSlCircle(), (FloatPropertyCompat)DynamicAnimation.TRANSLATION_Y, f);
            valueAnimator4 = baseNotificationPredictionsView2.getSlCircle();
            if (valueAnimator4 != null) {
                ViewExtensionsKt.visible((View)valueAnimator4);
            }
            BaseNotificationPredictionsView baseNotificationPredictionsView3 = baseNotificationPredictionsView3.getSlCircle();
            if (baseNotificationPredictionsView3 != null) {
                baseNotificationPredictionsView3.setAlpha(f2);
            }
            SpringAnimation springAnimation3 = springAnimation;
            springAnimation3.getSpring().setStiffness(200.0f);
            springAnimation3.getSpring().setDampingRatio(0.5f);
            springAnimation3.setStartVelocity((float)ViewExtensionsKt.getDp(700.0f));
            springAnimation3.start();
            springAnimation.addEndListener((arg_0, arg_1, arg_2, arg_3) -> BaseNotificationPredictionsView.showAnimateLandscape$lambda-18$lambda-17(animatorSet4, arg_0, arg_1, arg_2, arg_3));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tH\u0016R\u001c\u0010\r\u001a\u00020\f8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0016\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0019\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0013\u001a\u0004\b\u0018\u0010\u0015R\u001d\u0010\u001c\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u001b\u0010\u0015R\u001d\u0010\u001f\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001e\u0010\u0015R\u001d\u0010\"\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0013\u001a\u0004\b!\u0010\u0015R\u001d\u0010%\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0013\u001a\u0004\b$\u0010\u0015R\u001d\u0010(\u001a\u00020\u00118V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0013\u001a\u0004\b'\u0010\u0015\u00a8\u0006+"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Lkotlin/Function0;", "onEnd", "showAnimate", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;", "Landroid/view/View;", "slNotification$delegate", "Lkotlin/Lazy;", "getSlNotification", "()Landroid/view/View;", "slNotification", "slCircle$delegate", "getSlCircle", "slCircle", "slFullRoundRect$delegate", "getSlFullRoundRect", "slFullRoundRect", "slText$delegate", "getSlText", "slText", "slNotificationIcon$delegate", "getSlNotificationIcon", "slNotificationIcon", "slRightIcon$delegate", "getSlRightIcon", "slRightIcon", "slLeftSide$delegate", "getSlLeftSide", "slLeftSide", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationPredictionsBinding binding;
        @NotNull
        private final Lazy slNotification$delegate;
        @NotNull
        private final Lazy slCircle$delegate;
        @NotNull
        private final Lazy slFullRoundRect$delegate;
        @NotNull
        private final Lazy slText$delegate;
        @NotNull
        private final Lazy slNotificationIcon$delegate;
        @NotNull
        private final Lazy slRightIcon$delegate;
        @NotNull
        private final Lazy slLeftSide$delegate;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NotificationPredictionsView(SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsBinding, (String)"binding");
            super(NotificationType.Prediction);
            this.binding = slrItemNotificationPredictionsBinding;
            if (!this.isPortrait()) {
                NotificationViewsProvider.this = this.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)NotificationViewsProvider.this, (String)"binding.root");
                slrItemNotificationPredictionsBinding = NotificationViewsProvider.this.getLayoutParams();
                if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
                ((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding).width = this.getBinding().getRoot().getContext().getResources().getDimensionPixelSize(R.dimen.slr_predictions_notification_landscape_width);
                NotificationViewsProvider.this.setLayoutParams((ViewGroup.LayoutParams)slrItemNotificationPredictionsBinding);
                NotificationViewsProvider.this = this.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)NotificationViewsProvider.this, (String)"binding.slNotification");
                slrItemNotificationPredictionsBinding = NotificationViewsProvider.this.getLayoutParams();
                if (slrItemNotificationPredictionsBinding == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                NotificationViewsProvider notificationViewsProvider2 = NotificationViewsProvider.this;
                NotificationViewsProvider.this = (ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding;
                ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).topToTop = -1;
                ((ConstraintLayout.LayoutParams)slrItemNotificationPredictionsBinding).bottomToBottom = 0;
                notificationViewsProvider2.setLayoutParams((ViewGroup.LayoutParams)NotificationViewsProvider.this);
            }
            NotificationPredictionsView notificationPredictionsView = this;
            notificationPredictionsView.slNotification$delegate = LazyKt.lazy((Function0)new Function0<ConstraintLayout>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final ConstraintLayout invoke() {
                    return this.this$0.getBinding().slNotification;
                }
            });
            notificationPredictionsView.slCircle$delegate = LazyKt.lazy((Function0)new Function0<ConstraintLayout>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final ConstraintLayout invoke() {
                    return this.this$0.getBinding().slCircle;
                }
            });
            notificationPredictionsView.slFullRoundRect$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slFullRoundRect;
                }
            });
            notificationPredictionsView.slText$delegate = LazyKt.lazy((Function0)new Function0<TextView>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final TextView invoke() {
                    return this.this$0.getBinding().slrQuestionText;
                }
            });
            notificationPredictionsView.slNotificationIcon$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slNotificationIcon;
                }
            });
            notificationPredictionsView.slRightIcon$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slRightArrow;
                }
            });
            notificationPredictionsView.slLeftSide$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsView this$0;
                {
                    this.this$0 = notificationPredictionsView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slLeftSide;
                }
            });
        }

        private static final void showAnimate$lambda-6(NotificationPredictionsView notificationPredictionsView) {
            NotificationPredictionsView notificationPredictionsView2 = notificationPredictionsView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsView2, (String)"this$0");
            if (!notificationPredictionsView2.isPortrait()) {
                NotificationPredictionsView notificationPredictionsView3 = notificationPredictionsView;
                ConstraintLayout constraintLayout = notificationPredictionsView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                BaseNotificationPredictionsView.showAnimateLandscape$default(notificationPredictionsView3, null, 1, null);
            } else {
                NotificationPredictionsView notificationPredictionsView4 = notificationPredictionsView;
                ConstraintLayout constraintLayout = notificationPredictionsView4.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                ViewExtensionsKt.visible((View)constraintLayout);
                notificationPredictionsView4.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsBinding getBinding() {
            return this.binding;
        }

        @Override
        @NotNull
        public View getSlNotification() {
            Object object = this.slNotification$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slNotification>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlCircle() {
            Object object = this.slCircle$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slCircle>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlFullRoundRect() {
            Object object = this.slFullRoundRect$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slFullRoundRect>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlText() {
            Object object = this.slText$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slText>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlNotificationIcon() {
            Object object = this.slNotificationIcon$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slNotificationIcon>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlRightIcon() {
            Object object = this.slRightIcon$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slRightIcon>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlLeftSide() {
            Object object = this.slLeftSide$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slLeftSide>(...)");
            return (View)object;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            block10: {
                block11: {
                    block12: {
                        NotificationViewsProvider notificationViewsProvider;
                        block9: {
                            NotificationPredictionsView notificationPredictionsView = slrItemNotificationPredictionsBinding;
                            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
                            SlrItemNotificationPredictionsBinding slrItemNotificationPredictionsBinding = notificationPredictionsView.getBinding();
                            notificationViewsProvider = notificationPredictionsView.NotificationViewsProvider.this;
                            slrItemNotificationPredictionsBinding.slrQuestionText.setText((CharSequence)notification.getTitle());
                            Object object = QuestionNotification.Companion.deserialize(notification.getDataJson());
                            String string2 = object == null ? null : ((QuestionNotification)object).getImage();
                            if (string2 != null) {
                                ImageView imageView = slrItemNotificationPredictionsBinding.slNotificationIcon;
                                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"slNotificationIcon");
                                ExtensionsKt.load(imageView, string2);
                            } else {
                                slrItemNotificationPredictionsBinding.slNotificationIcon.setImageResource(0);
                            }
                            if (object == null || (object = ((QuestionNotification)object).getIndicatorColor()) == null) break block9;
                            Object object2 = object;
                            try {
                                object = Result.constructor-impl((Object)Color.parseColor((String)object2));
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            if (Result.isFailure-impl((Object)object)) {
                                object = null;
                            }
                            if ((object = (Integer)object) == null) break block9;
                            int n = ((Number)object).intValue();
                            string2 = slrItemNotificationPredictionsBinding.slLeftSide.getBackground();
                            if (string2 == null) break block10;
                            ((LayerDrawable)string2).getDrawable(0).setTint(n);
                            string2 = slrItemNotificationPredictionsBinding.slFullRoundRect.getBackground();
                            if (string2 == null) break block11;
                            ((GradientDrawable)string2).setTint(n);
                            string2 = slrItemNotificationPredictionsBinding.slCircle.getBackground();
                            if (string2 == null) break block12;
                            ((GradientDrawable)string2).setTint(n);
                        }
                        slrItemNotificationPredictionsBinding.getRoot().setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                        return;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                }
                throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
            }
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationPredictionsView.showAnimate$lambda-6(this));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u001c\u0010\u000f\u001a\u00020\u000e8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsBannerView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "", "getLandscapeWidth", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Landroidx/constraintlayout/widget/ConstraintSet;", "constraintSet", "setConstraintParams", "Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrPredictionsBannerBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsBannerView
    extends BaseNotificationView {
        @NotNull
        private final SlrPredictionsBannerBinding binding;

        public NotificationPredictionsBannerView(SlrPredictionsBannerBinding slrPredictionsBannerBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrPredictionsBannerBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrPredictionsBannerBinding;
        }

        @Override
        @NotNull
        public SlrPredictionsBannerBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            this.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_onboarding_landscape_width);
        }

        @Override
        public void setConstraintParams(@NotNull ConstraintLayout object, @NotNull ConstraintSet constraintSet) {
            NotificationPredictionsBannerView notificationPredictionsBannerView = this;
            NotificationPredictionsBannerView notificationPredictionsBannerView2 = this;
            Intrinsics.checkNotNullParameter((Object)object, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)constraintSet, (String)"constraintSet");
            object = notificationPredictionsBannerView2.NotificationViewsProvider.this;
            constraintSet.setTranslationZ(notificationPredictionsBannerView2.getBinding().getRoot().getId(), 30.0f);
            int n = notificationPredictionsBannerView.getBinding().getRoot().getId();
            int n2 = notificationPredictionsBannerView.isPortrait() ? 0 : ViewExtensionsKt.getDp(20.0f);
            NotificationsLayoutKt.setStartSide(constraintSet, n, n2);
            NotificationsLayoutKt.setEndSide(constraintSet, this.getBinding().getRoot().getId(), 0);
            int n3 = this.getBinding().getRoot().getId();
            NotificationsLayoutKt.setBottomSide(constraintSet, n3, ((NotificationViewsProvider)object).bottomMargin);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b0\u00101J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\b\u0010\u0007\u001a\u00020\u0003H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0013H\u0016R\u001c\u0010\u0017\u001a\u00020\u00168\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0004\u001a\u00020\u00038\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001dR\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\u001d\u0010#\u001a\u00020\u001e8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001d\u0010&\u001a\u00020\u001e8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\"R\u001d\u0010)\u001a\u00020\u001e8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010 \u001a\u0004\b(\u0010\"R\u001d\u0010,\u001a\u00020\u001e8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010 \u001a\u0004\b+\u0010\"R\u001d\u0010/\u001a\u00020\u001e8V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010 \u001a\u0004\b.\u0010\"\u00a8\u00062"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationPredictionsResultView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/main/notifications/PredictionsResultState;", "state", "", "saveChangedState", "getState", "", "win", "startStateController", "applyState", "resetVisibility", "applyFinalVisibility", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "bind", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Lkotlin/Function0;", "onEnd", "showAnimate", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;", "shouldAnimate", "Z", "Lio/streamlayer/sdk/main/notifications/PredictionsResultState;", "Landroid/view/View;", "slNotification$delegate", "Lkotlin/Lazy;", "getSlNotification", "()Landroid/view/View;", "slNotification", "slCircle$delegate", "getSlCircle", "slCircle", "slFullRoundRect$delegate", "getSlFullRoundRect", "slFullRoundRect", "slNotificationIcon$delegate", "getSlNotificationIcon", "slNotificationIcon", "slLeftSide$delegate", "getSlLeftSide", "slLeftSide", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationPredictionsResultBinding;)V", "sdk_originalRelease"})
    public final class NotificationPredictionsResultView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationPredictionsResultBinding binding;
        private boolean shouldAnimate;
        private PredictionsResultState state;
        private boolean win;
        @NotNull
        private final Lazy slNotification$delegate;
        @NotNull
        private final Lazy slCircle$delegate;
        @NotNull
        private final Lazy slFullRoundRect$delegate;
        @NotNull
        private final Lazy slNotificationIcon$delegate;
        @NotNull
        private final Lazy slLeftSide$delegate;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationPredictionsResultView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationPredictionsResultBinding slrItemNotificationPredictionsResultBinding) {
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationPredictionsResultBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            super(NotificationType.PredictionResult);
            notificationPredictionsResultView.binding = slrItemNotificationPredictionsResultBinding;
            notificationPredictionsResultView.slNotification$delegate = LazyKt.lazy((Function0)new Function0<ConstraintLayout>(this){
                final /* synthetic */ NotificationPredictionsResultView this$0;
                {
                    this.this$0 = notificationPredictionsResultView;
                    super(0);
                }

                @NotNull
                public final ConstraintLayout invoke() {
                    return this.this$0.getBinding().slNotification;
                }
            });
            notificationPredictionsResultView.slCircle$delegate = LazyKt.lazy((Function0)new Function0<ConstraintLayout>(this){
                final /* synthetic */ NotificationPredictionsResultView this$0;
                {
                    this.this$0 = notificationPredictionsResultView;
                    super(0);
                }

                @NotNull
                public final ConstraintLayout invoke() {
                    return this.this$0.getBinding().slCircle;
                }
            });
            notificationPredictionsResultView.slFullRoundRect$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsResultView this$0;
                {
                    this.this$0 = notificationPredictionsResultView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slFullRoundRect;
                }
            });
            notificationPredictionsResultView.slNotificationIcon$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsResultView this$0;
                {
                    this.this$0 = notificationPredictionsResultView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slNotificationIcon;
                }
            });
            notificationPredictionsResultView.slLeftSide$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationPredictionsResultView this$0;
                {
                    this.this$0 = notificationPredictionsResultView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slLeftSide;
                }
            });
        }

        private final void saveChangedState(PredictionsResultState predictionsResultState) {
            ConstraintLayout constraintLayout = notificationPredictionsResultView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            NotificationPredictionsResultView notificationPredictionsResultView = ViewKt.findViewTreeSavedStateRegistryOwner((View)constraintLayout);
            if (notificationPredictionsResultView != null && (notificationPredictionsResultView = notificationPredictionsResultView.getSavedStateRegistry()) != null) {
                notificationPredictionsResultView.unregisterSavedStateProvider("predictions_result_state");
                notificationPredictionsResultView.registerSavedStateProvider("predictions_result_state", () -> NotificationPredictionsResultView.saveChangedState$lambda-2$lambda-1(predictionsResultState));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final PredictionsResultState getState() {
            int n;
            ConstraintLayout constraintLayout = notificationPredictionsResultView.getBinding().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
            NotificationPredictionsResultView notificationPredictionsResultView = ViewKt.findViewTreeSavedStateRegistryOwner((View)constraintLayout);
            if (notificationPredictionsResultView != null && (notificationPredictionsResultView = notificationPredictionsResultView.getSavedStateRegistry()) != null && (notificationPredictionsResultView = notificationPredictionsResultView.consumeRestoredStateForKey("predictions_result_state")) != null) {
                n = notificationPredictionsResultView.getInt("predictions_result_state");
                return PredictionsResultState.values()[n];
            }
            n = 0;
            return PredictionsResultState.values()[n];
        }

        private final void startStateController(PredictionsResultState predictionsResultState, boolean bl) {
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            notificationPredictionsResultView.applyState(predictionsResultState);
            notificationPredictionsResultView.getBinding().getRoot().postDelayed(() -> NotificationPredictionsResultView.startStateController$lambda-9(this, predictionsResultState, bl), 5000L);
        }

        private final void applyState(PredictionsResultState predictionsResultState) {
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            notificationPredictionsResultView.resetVisibility();
            if (notificationPredictionsResultView.isPortrait()) {
                this.applyFinalVisibility(predictionsResultState);
            } else {
                new PredictionsResultNotificationAnimation(this.getBinding()).create(predictionsResultState).start();
            }
            NotificationPredictionsResultView notificationPredictionsResultView2 = this;
            PredictionsResultState predictionsResultState2 = predictionsResultState;
            try {
                notificationPredictionsResultView2.saveChangedState(predictionsResultState2);
                Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }

        private final void resetVisibility() {
            Object[] objectArray = new View[10];
            Object[] objectArray2 = objectArray;
            NotificationPredictionsResultView notificationPredictionsResultView = object;
            NotificationPredictionsResultView notificationPredictionsResultView2 = object;
            NotificationPredictionsResultView notificationPredictionsResultView3 = object;
            NotificationPredictionsResultView notificationPredictionsResultView4 = object;
            NotificationPredictionsResultView notificationPredictionsResultView5 = object;
            NotificationPredictionsResultView notificationPredictionsResultView6 = object;
            NotificationPredictionsResultView notificationPredictionsResultView7 = object;
            NotificationPredictionsResultView notificationPredictionsResultView8 = object;
            NotificationPredictionsResultView notificationPredictionsResultView9 = object;
            Object object = ((NotificationPredictionsResultView)object).getBinding().slRightIcon;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slRightIcon");
            objectArray2[0] = object;
            object = notificationPredictionsResultView9.getBinding().slWrongIcon;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slWrongIcon");
            objectArray2[1] = object;
            object = notificationPredictionsResultView8.getBinding().slQuestionTextTitle;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slQuestionTextTitle");
            objectArray2[2] = object;
            object = notificationPredictionsResultView7.getBinding().slCorrectAnswerTitle;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slCorrectAnswerTitle");
            objectArray2[3] = object;
            object = notificationPredictionsResultView6.getBinding().slYourAnswerTitle;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slYourAnswerTitle");
            objectArray2[4] = object;
            object = notificationPredictionsResultView5.getBinding().slQuestionText;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slQuestionText");
            objectArray2[5] = object;
            object = notificationPredictionsResultView4.getBinding().slCorrectAnswerText;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slCorrectAnswerText");
            objectArray2[6] = object;
            object = notificationPredictionsResultView3.getBinding().slYourAnswerText;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slYourAnswerText");
            objectArray2[7] = object;
            object = notificationPredictionsResultView2.getBinding().slCongratulations;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slCongratulations");
            objectArray2[8] = object;
            object = notificationPredictionsResultView.getBinding().slLooseText;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.slLooseText");
            objectArray[9] = object;
            object = CollectionsKt.listOf((Object[])objectArray).iterator();
            while (object.hasNext()) {
                ViewExtensionsKt.invisible((View)object.next());
            }
        }

        private final void applyFinalVisibility(PredictionsResultState predictionsResultState) {
            Iterator iterator = ((NotificationPredictionsResultView)((Object)iterator)).getBinding();
            switch (WhenMappings.$EnumSwitchMapping$0[predictionsResultState.ordinal()]) {
                default: {
                    break;
                }
                case 5: {
                    Object[] objectArray = new View[2];
                    iterator = ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slLooseText;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"slLooseText");
                    objectArray[0] = iterator;
                    iterator = ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slWrongIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"slWrongIcon");
                    objectArray[1] = iterator;
                    iterator = CollectionsKt.listOf((Object[])objectArray).iterator();
                    while (iterator.hasNext()) {
                        ViewExtensionsKt.visible((View)iterator.next());
                    }
                    break;
                }
                case 4: {
                    Object[] objectArray = new View[2];
                    iterator = ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slCongratulations;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"slCongratulations");
                    objectArray[0] = iterator;
                    iterator = ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slRightIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"slRightIcon");
                    objectArray[1] = iterator;
                    iterator = CollectionsKt.listOf((Object[])objectArray).iterator();
                    while (iterator.hasNext()) {
                        ViewExtensionsKt.visible((View)iterator.next());
                    }
                    break;
                }
                case 3: {
                    for (TextView textView : CollectionsKt.listOf((Object[])new TextView[]{((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slCorrectAnswerTitle, ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slCorrectAnswerText})) {
                        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"it");
                        ViewExtensionsKt.visible((View)textView);
                    }
                    break;
                }
                case 2: {
                    for (TextView textView : CollectionsKt.listOf((Object[])new TextView[]{((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slYourAnswerTitle, ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slYourAnswerText})) {
                        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"it");
                        ViewExtensionsKt.visible((View)textView);
                    }
                    break;
                }
                case 1: {
                    for (TextView textView : CollectionsKt.listOf((Object[])new TextView[]{((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slQuestionTextTitle, ((SlrItemNotificationPredictionsResultBinding)((Object)iterator)).slQuestionText})) {
                        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"it");
                        ViewExtensionsKt.visible((View)textView);
                    }
                }
            }
        }

        private static final Bundle saveChangedState$lambda-2$lambda-1(PredictionsResultState predictionsResultState) {
            Intrinsics.checkNotNullParameter((Object)((Object)predictionsResultState), (String)"$state");
            Bundle bundle = new Bundle();
            bundle.putInt("predictions_result_state", predictionsResultState.ordinal());
            return bundle;
        }

        private static final void startStateController$lambda-9(NotificationPredictionsResultView notificationPredictionsResultView, PredictionsResultState predictionsResultState, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)predictionsResultState), (String)"$state");
            notificationPredictionsResultView.shouldAnimate = true;
            predictionsResultState = predictionsResultState.next(bl);
            if (predictionsResultState != null) {
                notificationPredictionsResultView.startStateController(predictionsResultState, bl);
            }
        }

        private static final void showAnimate$lambda-18(NotificationPredictionsResultView notificationPredictionsResultView) {
            NotificationPredictionsResultView notificationPredictionsResultView2 = notificationPredictionsResultView;
            Intrinsics.checkNotNullParameter((Object)notificationPredictionsResultView2, (String)"this$0");
            if (!notificationPredictionsResultView2.isPortrait()) {
                NotificationPredictionsResultView notificationPredictionsResultView3 = notificationPredictionsResultView;
                ConstraintLayout constraintLayout = notificationPredictionsResultView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                if (notificationPredictionsResultView3.shouldAnimate) {
                    Function0<Unit> function0;
                    Function0<Unit> function02 = function0;
                    function0 = new Function0<Unit>(notificationPredictionsResultView){
                        final /* synthetic */ NotificationPredictionsResultView this$0;
                        {
                            this.this$0 = notificationPredictionsResultView;
                            super(0);
                        }

                        public final void invoke() {
                            NotificationPredictionsResultView notificationPredictionsResultView = this.this$0;
                            PredictionsResultState predictionsResultState = NotificationPredictionsResultView.access$getState$p(notificationPredictionsResultView);
                            if (predictionsResultState == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"state");
                                predictionsResultState = null;
                            }
                            NotificationPredictionsResultView.access$startStateController(notificationPredictionsResultView, predictionsResultState, NotificationPredictionsResultView.access$getWin$p(this.this$0));
                        }
                    };
                    notificationPredictionsResultView.showAnimateLandscape(function02);
                } else {
                    PredictionsResultState predictionsResultState = notificationPredictionsResultView.state;
                    if (predictionsResultState == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
                        predictionsResultState = null;
                    }
                    NotificationPredictionsResultView notificationPredictionsResultView4 = notificationPredictionsResultView;
                    notificationPredictionsResultView4.startStateController(predictionsResultState, notificationPredictionsResultView.win);
                    ConstraintLayout constraintLayout2 = notificationPredictionsResultView4.getBinding().slNotification;
                    Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.slNotification");
                    ViewExtensionsKt.visible((View)constraintLayout2);
                }
            } else {
                PredictionsResultState predictionsResultState = notificationPredictionsResultView.state;
                if (predictionsResultState == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"state");
                    predictionsResultState = null;
                }
                NotificationPredictionsResultView notificationPredictionsResultView5 = notificationPredictionsResultView;
                notificationPredictionsResultView5.startStateController(predictionsResultState, notificationPredictionsResultView.win);
                ConstraintLayout constraintLayout = notificationPredictionsResultView5.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                ViewExtensionsKt.visible((View)constraintLayout);
                notificationPredictionsResultView5.showAnimatePortrait();
            }
        }

        public static final /* synthetic */ void access$startStateController(NotificationPredictionsResultView notificationPredictionsResultView, PredictionsResultState predictionsResultState, boolean bl) {
            notificationPredictionsResultView.startStateController(predictionsResultState, bl);
        }

        public static final /* synthetic */ PredictionsResultState access$getState$p(NotificationPredictionsResultView notificationPredictionsResultView) {
            return notificationPredictionsResultView.state;
        }

        public static final /* synthetic */ boolean access$getWin$p(NotificationPredictionsResultView notificationPredictionsResultView) {
            return notificationPredictionsResultView.win;
        }

        @Override
        @NotNull
        public SlrItemNotificationPredictionsResultBinding getBinding() {
            return this.binding;
        }

        @Override
        @NotNull
        public View getSlNotification() {
            Object object = this.slNotification$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slNotification>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlCircle() {
            Object object = this.slCircle$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slCircle>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlFullRoundRect() {
            Object object = this.slFullRoundRect$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slFullRoundRect>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlNotificationIcon() {
            Object object = this.slNotificationIcon$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slNotificationIcon>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlLeftSide() {
            Object object = this.slLeftSide$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slLeftSide>(...)");
            return (View)object;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull Notification object) {
            void var1_4;
            String string2;
            String string3;
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)object, (String)"data");
            this.state = this.getState();
            Object object2 = QuestionNotification.Companion.deserialize(((Notification)object).getDataJson());
            boolean bl2 = object2 == null || (bl = ((QuestionNotification)object2).isRight()) == null ? false : bl;
            this.win = bl2;
            if (object2 != null && (string3 = ((QuestionNotification)object2).getImage()) != null) {
                NotificationPredictionsResultView notificationPredictionsResultView = this;
                ImageView imageView = notificationPredictionsResultView.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slNotificationIcon");
                ExtensionsKt.load(imageView, string3);
                ImageView imageView2 = notificationPredictionsResultView.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.slNotificationIcon");
                ViewExtensionsKt.visible((View)imageView2);
            }
            if (object2 != null && (string2 = ((QuestionNotification)object2).getSmallImage()) != null) {
                NotificationPredictionsResultView notificationPredictionsResultView = this;
                ImageView imageView = notificationPredictionsResultView.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slNotificationIcon");
                ExtensionsKt.load(imageView, string2);
                ImageView imageView3 = notificationPredictionsResultView.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"binding.slNotificationIcon");
                ViewExtensionsKt.visible((View)imageView3);
            }
            TextView textView = this.getBinding().slYourAnswerText;
            String string4 = object2 == null ? null : ((QuestionNotification)object2).getYourAnswer();
            NotificationPredictionsResultView notificationPredictionsResultView = this;
            textView.setText((CharSequence)string4);
            notificationPredictionsResultView.getBinding().slCorrectAnswerText.setText((CharSequence)((Notification)object).getTitle());
            notificationPredictionsResultView.getBinding().slQuestionText.setText((CharSequence)((Notification)object).getDescription());
            if (object2 != null && (object2 = ((QuestionNotification)object2).getIndicatorColor()) != null) {
                Object object3 = object2;
                try {
                    object2 = Result.constructor-impl((Object)Color.parseColor((String)object3));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object2)) {
                    object2 = null;
                }
                if ((object2 = (Integer)object2) != null) {
                    int n = ((Number)object2).intValue();
                    textView = this.getBinding().slLeftSide.getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)textView).getDrawable(0).setTint(n);
                    textView = this.getBinding().slLeftSide2.getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)textView).getDrawable(0).setTint(n);
                    textView = this.getBinding().slWrongIcon.getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)textView).setTint(n);
                    textView = this.getBinding().slRightIcon.getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)textView).setTint(n);
                    textView = this.getSlCircle().getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)textView).setTint(n);
                    textView = this.getSlFullRoundRect().getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)textView).setTint(n);
                }
                TextView textView2 = this.getBinding().slCorrectAnswerTitle;
                Context context = this.getBinding().getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                textView2.setTextColor(ColorStateList.valueOf((int)ExtensionsKt.colorByAttribute(context, R.attr.slrPredictionsSelectionAnswerColor, R.color.slr_predictions_selected_blue)));
            }
            NotificationPredictionsResultView notificationPredictionsResultView2 = this;
            notificationPredictionsResultView2.getBinding().getRoot().setOnTouchListener((View.OnTouchListener)this.this$0.new NotificationTouchListener((Notification)object));
            notificationPredictionsResultView2.resetVisibility();
            PredictionsResultState predictionsResultState = notificationPredictionsResultView2.state;
            if (predictionsResultState == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"state");
                Object var1_3 = null;
            }
            if (var1_4 == PredictionsResultState.QUESTION) {
                this.shouldAnimate = true;
            }
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationPredictionsResultView.showAnimate$lambda-18(this));
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PredictionsResultState.values().length];
                nArray[PredictionsResultState.QUESTION.ordinal()] = 1;
                nArray[PredictionsResultState.YOUR_ANSWER.ordinal()] = 2;
                nArray[PredictionsResultState.RIGHT_ANSWER.ordinal()] = 3;
                nArray[PredictionsResultState.WIN.ordinal()] = 4;
                nArray[PredictionsResultState.LOOSE.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eH\u0016R\u001c\u0010\u0012\u001a\u00020\u00118\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001d\u001a\u00020\u00168V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010 \u001a\u00020\u00168V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001a\u001a\u0004\b\u001f\u0010\u001cR\u001d\u0010#\u001a\u00020\u00168V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001a\u001a\u0004\b\"\u0010\u001cR\u001d\u0010&\u001a\u00020\u00168V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001a\u001a\u0004\b%\u0010\u001cR\u001d\u0010)\u001a\u00020\u00168V@\u0016X\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001a\u001a\u0004\b(\u0010\u001cR\u0016\u0010+\u001a\u00020\u00168V@\u0016X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001c\u00a8\u0006."}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationFactoidView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Landroid/widget/TextView;", "", "getEllipsizedLength", "(Landroid/widget/TextView;)Ljava/lang/Integer;", "getLandscapeWidth", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Lkotlin/Function0;", "onEnd", "showAnimate", "Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidBinding;", "Landroid/view/View;", "imageView", "Landroid/view/View;", "slNotification$delegate", "Lkotlin/Lazy;", "getSlNotification", "()Landroid/view/View;", "slNotification", "slCircle$delegate", "getSlCircle", "slCircle", "slFullRoundRect$delegate", "getSlFullRoundRect", "slFullRoundRect", "slText$delegate", "getSlText", "slText", "slLeftSide$delegate", "getSlLeftSide", "slLeftSide", "getSlNotificationIcon", "slNotificationIcon", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidBinding;)V", "sdk_originalRelease"})
    public final class NotificationFactoidView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationFactoidBinding binding;
        @Nullable
        private View imageView;
        @NotNull
        private final Lazy slNotification$delegate;
        @NotNull
        private final Lazy slCircle$delegate;
        @NotNull
        private final Lazy slFullRoundRect$delegate;
        @NotNull
        private final Lazy slText$delegate;
        @NotNull
        private final Lazy slLeftSide$delegate;
        final /* synthetic */ NotificationViewsProvider this$0;

        public NotificationFactoidView(@NotNull NotificationViewsProvider notificationViewsProvider, SlrItemNotificationFactoidBinding slrItemNotificationFactoidBinding) {
            NotificationFactoidView notificationFactoidView = this;
            Intrinsics.checkNotNullParameter((Object)notificationViewsProvider, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationFactoidBinding, (String)"binding");
            this.this$0 = notificationViewsProvider;
            super(NotificationType.Factoid);
            notificationFactoidView.binding = slrItemNotificationFactoidBinding;
            notificationFactoidView.slNotification$delegate = LazyKt.lazy((Function0)new Function0<ConstraintLayout>(this){
                final /* synthetic */ NotificationFactoidView this$0;
                {
                    this.this$0 = notificationFactoidView;
                    super(0);
                }

                @NotNull
                public final ConstraintLayout invoke() {
                    return this.this$0.getBinding().slNotification;
                }
            });
            notificationFactoidView.slCircle$delegate = LazyKt.lazy((Function0)new Function0<ConstraintLayout>(this){
                final /* synthetic */ NotificationFactoidView this$0;
                {
                    this.this$0 = notificationFactoidView;
                    super(0);
                }

                @NotNull
                public final ConstraintLayout invoke() {
                    return this.this$0.getBinding().slCircle;
                }
            });
            notificationFactoidView.slFullRoundRect$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationFactoidView this$0;
                {
                    this.this$0 = notificationFactoidView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slFullRoundRect;
                }
            });
            notificationFactoidView.slText$delegate = LazyKt.lazy((Function0)new Function0<TextView>(this){
                final /* synthetic */ NotificationFactoidView this$0;
                {
                    this.this$0 = notificationFactoidView;
                    super(0);
                }

                @NotNull
                public final TextView invoke() {
                    return this.this$0.getBinding().slText;
                }
            });
            notificationFactoidView.slLeftSide$delegate = LazyKt.lazy((Function0)new Function0<ImageView>(this){
                final /* synthetic */ NotificationFactoidView this$0;
                {
                    this.this$0 = notificationFactoidView;
                    super(0);
                }

                @NotNull
                public final ImageView invoke() {
                    return this.this$0.getBinding().slLeftSide;
                }
            });
        }

        private final Integer getEllipsizedLength(TextView textView) {
            Object object;
            TextView textView2 = textView;
            int n = textView2.getText().length();
            Layout layout2 = textView.getLayout();
            int n2 = textView.getLayout().getLineCount();
            int n3 = n - layout2.getEllipsisCount(n2 - 1);
            try {
                object = Result.constructor-impl((Object)n3);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (Integer)object;
        }

        private static final void bind$lambda-5(NotificationFactoidView object, Notification notification, String string2) {
            NotificationFactoidView notificationFactoidView = object;
            Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"$data");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"$tapForMore");
            TextView textView = notificationFactoidView.getBinding().slText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
            Integer n = notificationFactoidView.getEllipsizedLength(textView);
            int n2 = n == null ? ((NotificationFactoidView)object).getBinding().slText.length() : n.intValue();
            if (n2 < ((NotificationFactoidView)object).getBinding().slText.getText().length()) {
                String string3;
                String string4 = notification.getTitle();
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = notification.getDescription()) == null) {
                    string3 = "";
                }
                if (n2 - string2.length() > string4.length()) {
                    SpannableString spannableString;
                    NotificationFactoidView notificationFactoidView2 = object;
                    String string5 = string3.substring(0, n2 - string4.length() - 2 - string2.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = Intrinsics.stringPlus((String)string5, (Object)"\u2026");
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    charSequenceArray[0] = OtherUtilsKt.bold(new SpannableString((CharSequence)Intrinsics.stringPlus((String)notification.getTitle(), (Object)" ")));
                    notification = spannableString;
                    spannableString = new SpannableString((CharSequence)object);
                    charSequenceArray[1] = notification;
                    charSequenceArray[2] = OtherUtilsKt.bold(new SpannableString((CharSequence)string2));
                    notificationFactoidView2.getBinding().slText.setText(TextUtils.concat((CharSequence[])charSequenceArray));
                } else {
                    NotificationFactoidView notificationFactoidView3 = object;
                    String string6 = string4.substring(0, n2 - 2 - string2.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = Intrinsics.stringPlus((String)string6, (Object)"\u2026");
                    notificationFactoidView3.getBinding().slText.setText(TextUtils.concat((CharSequence[])new CharSequence[]{OtherUtilsKt.bold(new SpannableString((CharSequence)object)), OtherUtilsKt.bold(new SpannableString((CharSequence)string2))}));
                }
            }
        }

        private static final void showAnimate$lambda-7(NotificationFactoidView notificationFactoidView) {
            NotificationFactoidView notificationFactoidView2 = notificationFactoidView;
            Intrinsics.checkNotNullParameter((Object)notificationFactoidView2, (String)"this$0");
            if (!notificationFactoidView2.isPortrait()) {
                NotificationFactoidView notificationFactoidView3 = notificationFactoidView;
                ConstraintLayout constraintLayout = notificationFactoidView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                BaseNotificationPredictionsView.showAnimateLandscape$default(notificationFactoidView3, null, 1, null);
            } else {
                NotificationFactoidView notificationFactoidView4 = notificationFactoidView;
                ConstraintLayout constraintLayout = notificationFactoidView4.getBinding().slNotification;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.slNotification");
                ViewExtensionsKt.visible((View)constraintLayout);
                notificationFactoidView4.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationFactoidBinding getBinding() {
            return this.binding;
        }

        @Override
        @NotNull
        public View getSlNotification() {
            Object object = this.slNotification$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slNotification>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlCircle() {
            Object object = this.slCircle$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slCircle>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlFullRoundRect() {
            Object object = this.slFullRoundRect$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slFullRoundRect>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlText() {
            Object object = this.slText$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slText>(...)");
            return (View)object;
        }

        @Override
        @NotNull
        public View getSlNotificationIcon() {
            View view2 = this.imageView;
            if (view2 == null) {
                view2 = this.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"binding.slNotificationIcon");
            }
            return view2;
        }

        @Override
        @NotNull
        public View getSlLeftSide() {
            Object object = this.slLeftSide$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-slLeftSide>(...)");
            return (View)object;
        }

        @Override
        public int getLandscapeWidth() {
            return this.this$0.resources.getDimensionPixelSize(R.dimen.slr_notification_factoid_landscape_width);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull Notification notification) {
            SpannableString spannableString;
            SpannableString spannableString2;
            TextView textView;
            Object object;
            String string2;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            QuestionNotification questionNotification = QuestionNotification.Companion.deserialize(notification.getDataJson());
            if (questionNotification != null && (string2 = questionNotification.getImage()) != null) {
                NotificationFactoidView notificationFactoidView = this;
                ShapeableImageView shapeableImageView = notificationFactoidView.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"binding.slNotificationIcon");
                ExtensionsKt.load((ImageView)shapeableImageView, string2);
                ShapeableImageView shapeableImageView2 = notificationFactoidView.getBinding().slNotificationIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView2, (String)"binding.slNotificationIcon");
                ViewExtensionsKt.visible((View)shapeableImageView2);
                notificationFactoidView.imageView = notificationFactoidView.getBinding().slNotificationIcon;
            }
            if (questionNotification != null && (string2 = questionNotification.getSmallImage()) != null) {
                NotificationFactoidView notificationFactoidView = this;
                ShapeableImageView shapeableImageView = notificationFactoidView.getBinding().slNotificationSmallIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"binding.slNotificationSmallIcon");
                ExtensionsKt.load((ImageView)shapeableImageView, string2);
                ShapeableImageView shapeableImageView3 = notificationFactoidView.getBinding().slNotificationSmallIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView3, (String)"binding.slNotificationSmallIcon");
                ViewExtensionsKt.visible((View)shapeableImageView3);
                notificationFactoidView.imageView = notificationFactoidView.getBinding().slNotificationSmallIcon;
            }
            if ((questionNotification == null ? null : questionNotification.getImage()) == null && (questionNotification == null ? null : questionNotification.getSmallImage()) == null) {
                Context context = this.getBinding().getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                int n = ViewExtensionsKt.resoleAttributeResId(context, R.attr.slrFactoidDefaultIcon, -1);
                if (n != -1) {
                    NotificationFactoidView notificationFactoidView = this;
                    notificationFactoidView.getBinding().slNotificationDefaultIcon.setImageResource(n);
                    ImageView imageView = notificationFactoidView.getBinding().slNotificationDefaultIcon;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.slNotificationDefaultIcon");
                    ViewExtensionsKt.visible((View)imageView);
                    notificationFactoidView.imageView = notificationFactoidView.getBinding().slNotificationDefaultIcon;
                }
            }
            if (questionNotification != null && (object = questionNotification.getIndicatorColor()) != null) {
                String string3 = object;
                try {
                    object = Result.constructor-impl((Object)Color.parseColor((String)string3));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object)) {
                    object = null;
                }
                if ((object = (Integer)object) != null) {
                    int n = ((Number)object).intValue();
                    textView = this.getBinding().slLeftSide.getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)textView).getDrawable(0).setTint(n);
                    textView = this.getSlCircle().getBackground();
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                    }
                    ((GradientDrawable)textView).setTint(n);
                }
            }
            NotificationFactoidView notificationFactoidView = this;
            Object object2 = notificationFactoidView.getBinding().getRoot().getContext().getString(R.string.slr_factoid_tap_for_more);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"binding.root.context.get\u2026slr_factoid_tap_for_more)");
            textView = notificationFactoidView.getBinding().slText;
            CharSequence[] charSequenceArray = new CharSequence[3];
            CharSequence[] charSequenceArray2 = charSequenceArray;
            charSequenceArray[0] = OtherUtilsKt.bold(new SpannableString((CharSequence)Intrinsics.stringPlus((String)notification.getTitle(), (Object)" ")));
            SpannableString spannableString3 = spannableString2;
            spannableString2 = new SpannableString((CharSequence)notification.getDescription());
            charSequenceArray[1] = spannableString3;
            int n = 2;
            Object object3 = questionNotification != null && questionNotification.getClickable() ? object2 : "";
            SpannableString spannableString4 = spannableString;
            spannableString4((CharSequence)object3);
            charSequenceArray2[n] = OtherUtilsKt.bold(spannableString4);
            textView.setText(TextUtils.concat((CharSequence[])charSequenceArray2));
            if (questionNotification != null && questionNotification.getClickable()) {
                NotificationFactoidView notificationFactoidView2 = this;
                questionNotification = this.getBinding().slText;
                object2 = () -> NotificationFactoidView.bind$lambda-5(notificationFactoidView2, notification, (String)object2);
                Context context = notificationFactoidView2.getBinding().getRoot().getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.root.context");
                long l = OtherExtensionsKt.isScreenPortrait(context) ? 0L : 400L;
                questionNotification.postDelayed((Runnable)object2, l);
            }
            this.getBinding().slNotification.setOnTouchListener((View.OnTouchListener)this.this$0.new NotificationTouchListener(notification));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationFactoidView.showAnimate$lambda-7(this));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bH\u0016R\u001c\u0010\u000f\u001a\u00020\u000e8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationFactoidTweetView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationPredictionsView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "", "getLandscapeWidth", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Landroidx/constraintlayout/widget/ConstraintLayout;", "parent", "Lkotlin/Function0;", "onEnd", "showAnimate", "Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidTweetBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidTweetBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidTweetBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationFactoidTweetBinding;)V", "sdk_originalRelease"})
    public final class NotificationFactoidTweetView
    extends BaseNotificationPredictionsView {
        @NotNull
        private final SlrItemNotificationFactoidTweetBinding binding;

        public NotificationFactoidTweetView(SlrItemNotificationFactoidTweetBinding slrItemNotificationFactoidTweetBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationFactoidTweetBinding, (String)"binding");
            super(NotificationType.FactoidTweet);
            this.binding = slrItemNotificationFactoidTweetBinding;
        }

        private static final void showAnimate$lambda-9$lambda-8$lambda-7(ValueAnimator object, NotificationFactoidTweetView notificationFactoidTweetView, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)notificationFactoidTweetView, (String)"this$0");
            object = object.getAnimatedValue();
            if (object != null) {
                int n = (Integer)object;
                notificationFactoidTweetView = notificationFactoidTweetView.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)notificationFactoidTweetView, (String)"binding.root");
                valueAnimator = notificationFactoidTweetView.getLayoutParams();
                if (valueAnimator != null) {
                    valueAnimator.width = n;
                    notificationFactoidTweetView.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }

        private static final void showAnimate$lambda-9(NotificationFactoidTweetView notificationFactoidTweetView) {
            NotificationFactoidTweetView notificationFactoidTweetView2 = notificationFactoidTweetView;
            Intrinsics.checkNotNullParameter((Object)notificationFactoidTweetView2, (String)"this$0");
            if (!notificationFactoidTweetView2.isPortrait()) {
                NotificationFactoidTweetView notificationFactoidTweetView3 = notificationFactoidTweetView;
                ConstraintLayout constraintLayout = notificationFactoidTweetView3.getBinding().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ViewExtensionsKt.visible((View)constraintLayout);
                TextView textView = notificationFactoidTweetView3.getBinding().slText;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
                ViewExtensionsKt.gone((View)textView);
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, notificationFactoidTweetView.getLandscapeWidth()});
                valueAnimator.setDuration(300L);
                valueAnimator.addUpdateListener(arg_0 -> NotificationFactoidTweetView.showAnimate$lambda-9$lambda-8$lambda-7(valueAnimator, notificationFactoidTweetView, arg_0));
                valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(notificationFactoidTweetView){
                    final /* synthetic */ NotificationFactoidTweetView this$0;
                    {
                        this.this$0 = notificationFactoidTweetView;
                    }

                    public void onAnimationEnd(@Nullable Animator animator, boolean bl) {
                        TextView textView = this.this$0.getBinding().slText;
                        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.slText");
                        ViewExtensionsKt.visible((View)textView);
                    }
                });
                valueAnimator.start();
            } else {
                notificationFactoidTweetView.showAnimatePortrait();
            }
        }

        @Override
        @NotNull
        public SlrItemNotificationFactoidTweetBinding getBinding() {
            return this.binding;
        }

        @Override
        public int getLandscapeWidth() {
            return NotificationViewsProvider.this.resources.getDimensionPixelSize(R.dimen.slr_notification_factoid_landscape_width);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull Notification notification) {
            Drawable drawable2;
            void var6_18;
            TweetOptions tweetOptions;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
            Object object3 = QuestionNotification.Companion.deserialize(notification.getDataJson());
            if (object3 != null && (object2 = ((QuestionNotification)object3).getImage()) != null) {
                NotificationFactoidTweetView notificationFactoidTweetView = this;
                ShapeableImageView shapeableImageView = notificationFactoidTweetView.getBinding().slIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"binding.slIcon");
                ExtensionsKt.load((ImageView)shapeableImageView, (String)object2);
                ShapeableImageView shapeableImageView2 = notificationFactoidTweetView.getBinding().slIcon;
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView2, (String)"binding.slIcon");
                ViewExtensionsKt.visible((View)shapeableImageView2);
            }
            if (object3 != null && (object2 = ((QuestionNotification)object3).getIndicatorColor()) != null) {
                String string2 = object2;
                try {
                    object2 = Result.constructor-impl((Object)Color.parseColor((String)string2));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object2)) {
                    object2 = null;
                }
                if ((object2 = (Integer)object2) != null) {
                    int n = ((Number)object2).intValue();
                    object = this.getBinding().slrLeftSide.getBackground();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
                    }
                    ((LayerDrawable)object).getDrawable(0).setTint(n);
                }
            }
            boolean bl = object3 != null && (tweetOptions = ((QuestionNotification)object3).getTweetOptions()) != null && tweetOptions.getVerified();
            object = new CharSequence[2];
            int n = 0;
            String string3 = "@";
            object3 = object3 == null || (object3 = ((QuestionNotification)object3).getTweetOptions()) == null ? null : ((TweetOptions)object3).getAccount();
            object3 = Intrinsics.stringPlus((String)string3, (Object)object3);
            if (object3 == null) {
                object3 = "";
            }
            SpannableString spannableString = new SpannableString((CharSequence)object3);
            object[n] = spannableString;
            int n2 = 1;
            if (bl) {
                String string4 = "   \u00b7 ";
            } else {
                String string5 = " \u00b7 ";
            }
            SpannableString spannableString2 = new SpannableString((CharSequence)Intrinsics.stringPlus((String)var6_18, (Object)notification.getDescription()));
            if (bl && (drawable2 = ContextCompat.getDrawable((Context)this.getBinding().getRoot().getContext(), (int)R.drawable.slr_ic_twitter_verified)) != null) {
                ImageSpan imageSpan;
                int n3 = ViewExtensionsKt.getDp(12.0f);
                int n4 = ViewExtensionsKt.getDp(12.0f);
                drawable2.setBounds(0, 0, n3, n4);
                ImageSpan imageSpan2 = imageSpan;
                imageSpan = new ImageSpan(drawable2, 1);
                spannableString2.setSpan((Object)imageSpan2, 1, 2, 17);
            }
            Drawable drawable3 = object;
            drawable3[n2] = spannableString2;
            CharSequence charSequence = TextUtils.concat((CharSequence[])drawable3);
            if (this.isPortrait()) {
                this.getBinding().slText.setText(charSequence);
            } else {
                TextView textView = this.getBinding().slTitle;
                if (textView != null) {
                    textView.setText((CharSequence)notification.getTitle());
                }
                textView = this.getBinding().slTitle;
                if (textView != null) {
                    object = notification.getTitle();
                    boolean bl2 = object == null || object.length() == 0;
                    ViewExtensionsKt.visibleIf((View)textView, bl2 ^ true);
                }
                this.getBinding().slText.setText(charSequence);
            }
            this.getBinding().slNotification.setOnTouchListener((View.OnTouchListener)new NotificationTouchListener(notification));
        }

        @Override
        public void showAnimate(@NotNull ConstraintLayout constraintLayout, @Nullable Function0<Unit> function0) {
            Intrinsics.checkNotNullParameter((Object)constraintLayout, (String)"parent");
            this.getBinding().getRoot().post(() -> NotificationFactoidTweetView.showAnimate$lambda-9(this));
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u001c\u0010\b\u001a\u00020\u00078\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$NotificationCustomViewHolder;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider$BaseNotificationView;", "Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;", "Lio/streamlayer/sdk/model/notifications/Notification;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "getBinding", "()Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;", "<init>", "(Lio/streamlayer/sdk/main/notifications/NotificationViewsProvider;Lio/streamlayer/sdk/databinding/SlrItemNotificationCustomBinding;)V", "sdk_originalRelease"})
    public final class NotificationCustomViewHolder
    extends BaseNotificationView {
        @NotNull
        private final SlrItemNotificationCustomBinding binding;

        public NotificationCustomViewHolder(SlrItemNotificationCustomBinding slrItemNotificationCustomBinding) {
            Intrinsics.checkNotNullParameter((Object)NotificationViewsProvider.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)slrItemNotificationCustomBinding, (String)"binding");
            super(NotificationViewsProvider.this);
            this.binding = slrItemNotificationCustomBinding;
        }

        @Override
        @NotNull
        public SlrItemNotificationCustomBinding getBinding() {
            return this.binding;
        }

        @Override
        public void bind(@NotNull Notification notification) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"data");
                    Object object = notificationCustomViewHolder.getBinding().getRoot().getContext();
                    NotificationBuilder notificationBuilder = notification.getCustomBuilder();
                    if (notificationBuilder == null) break block7;
                    NotificationViewsProvider notificationViewsProvider = notificationCustomViewHolder.NotificationViewsProvider.this;
                    Object object2 = LayoutInflater.from((Context)object);
                    if (notificationBuilder.getLayoutId() != null) {
                        Integer n = notificationBuilder.getLayoutId();
                        Intrinsics.checkNotNull((Object)n);
                        object = object2.inflate(n.intValue(), (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                    } else {
                        object2 = SlrItemNotificationBinding.inflate(object2, (ViewGroup)notificationCustomViewHolder.getBinding().getRoot(), false);
                        object2.slNotifTitleTV.setText((CharSequence)notificationBuilder.getTitle());
                        object2.slNotifDescriptionTV.setText((CharSequence)notificationBuilder.getDescription());
                        Integer n = notificationBuilder.getIconBackgroundColor();
                        if (n != null) {
                            int n2 = n;
                            object2.slNotifIconIV.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)object, (int)n2)));
                        }
                        object = notificationBuilder.getIconUrl();
                        if (object != null) {
                            AppCompatImageView appCompatImageView = object2.slNotifIconIV;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slNotifIconIV");
                            ViewExtensionsKt.loadUrl$default((ImageView)appCompatImageView, (String)object, false, null, null, 14, null);
                        }
                        object = notificationCustomViewHolder.getBinding().getRoot();
                    }
                    Context context = object;
                    notificationCustomViewHolder.getBinding().getRoot().addView((View)object);
                    context.setOnTouchListener((View.OnTouchListener)notificationViewsProvider.new NotificationTouchListener(notification));
                    NotificationCustomViewHolder notificationCustomViewHolder = context.getLayoutParams();
                    if (notificationCustomViewHolder == null) break block8;
                    Object object3 = object;
                    notificationCustomViewHolder = (FrameLayout.LayoutParams)notificationCustomViewHolder;
                    v4.gravity = 80;
                    object3.setLayoutParams((ViewGroup.LayoutParams)notificationCustomViewHolder);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"view");
                    notificationBuilder.bindView((View)object);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.JoinToChat.ordinal()] = 1;
            nArray[NotificationType.WatchParty.ordinal()] = 2;
            nArray[NotificationType.Prediction.ordinal()] = 3;
            nArray[NotificationType.PredictionResult.ordinal()] = 4;
            nArray[NotificationType.PredictionOnboarding.ordinal()] = 5;
            nArray[NotificationType.Factoid.ordinal()] = 6;
            nArray[NotificationType.FactoidTweet.ordinal()] = 7;
            nArray[NotificationType.Custom.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

