/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chats;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.extensions.CoilExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.recyclerview.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemMessagingChatBinding;
import io.streamlayer.sdk.messaging.chats.Chat;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0006\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003J\u0016\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0014R$\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;", "Lio/streamlayer/common/recyclerview/GenericAdapter;", "Lio/streamlayer/sdk/messaging/chats/Chat;", "Lkotlin/Function1;", "", "listener", "setOnChatSelectedListener", "", "listItems", "setItems", "", "viewType", "getLayoutId", "Landroid/view/View;", "view", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "getViewHolder", "onChatSelectedListener", "Lkotlin/jvm/functions/Function1;", "<init>", "()V", "ChatsDiffCallback", "ViewHolder", "sdk_originalRelease"})
public final class MessagingChatsAdapter
extends GenericAdapter<Chat> {
    @Nullable
    private Function1<? super Chat, Unit> onChatSelectedListener;

    public final void setOnChatSelectedListener(@NotNull Function1<? super Chat, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"listener");
        this.onChatSelectedListener = function1;
    }

    @Override
    public void setItems(@NotNull List<Chat> list) {
        Intrinsics.checkNotNullParameter(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ChatsDiffCallback(this.getListItems(), list));
        MessagingChatsAdapter messagingChatsAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(ChatsDiffC\u2026is.listItems, listItems))");
        messagingChatsAdapter.getListItems().clear();
        messagingChatsAdapter.getListItems().addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)messagingChatsAdapter);
    }

    @Override
    protected int getLayoutId(int n) {
        return R.layout.slr_item_messaging_chat;
    }

    @Override
    @NotNull
    protected GenericAdapter.GenericViewHolder<Chat> getViewHolder(@NotNull View view2, int n) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        return new ViewHolder(view2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u0016\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ViewHolder;", "Lio/streamlayer/common/recyclerview/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/messaging/chats/Chat;", "data", "", "bind", "Lio/streamlayer/sdk/databinding/SlrItemMessagingChatBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemMessagingChatBinding;", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class ViewHolder
    extends GenericAdapter.GenericViewHolder<Chat> {
        @NotNull
        private final SlrItemMessagingChatBinding binding;

        public ViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)MessagingChatsAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            SlrItemMessagingChatBinding slrItemMessagingChatBinding = SlrItemMessagingChatBinding.bind(view2);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemMessagingChatBinding, (String)"bind(itemView)");
            this.binding = slrItemMessagingChatBinding;
            view2.setOnClickListener(arg_0 -> ViewHolder._init_$lambda-0(MessagingChatsAdapter.this, this, arg_0));
        }

        private static final void _init_$lambda-0(MessagingChatsAdapter messagingChatsAdapter, ViewHolder viewHolder, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)messagingChatsAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"this$1");
            view2 = messagingChatsAdapter.onChatSelectedListener;
            if (view2 != null) {
                view2.invoke(messagingChatsAdapter.getItem(viewHolder.getLayoutPosition() - 1));
            }
        }

        @Override
        public void bind(@NotNull Chat chat) {
            Intrinsics.checkNotNullParameter((Object)chat, (String)"data");
            Object object = object2.binding.chatAvatar;
            if (chat.isP2PChat()) {
                AppCompatImageView appCompatImageView = object;
                Chat chat2 = chat;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                object = chat2.getChatName();
                String string2 = chat2.getChatAvatar();
                boolean bl = chat2.isP2POnline();
                ProfileExtensionsKt.loadContactAvatarWithStatus((ImageView)appCompatImageView, (String)object, string2, bl);
            } else {
                String string3 = chat.getChatAvatar();
                if (!(string3 == null || string3.length() == 0)) {
                    object.setBackground(null);
                    if (StringsKt.contains$default((CharSequence)chat.getChatAvatar(), (CharSequence)"http", (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                        ProfileExtensionsKt.loadUserAvatar$default((ImageView)object, chat.getChatAvatar(), null, null, 4, null);
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                        ProfileExtensionsKt.loadUserAvatar$default((ImageView)object, null, chat.getChatAvatar(), null, 4, null);
                    }
                } else {
                    Function1<ImageView, Unit> function1;
                    AppCompatImageView appCompatImageView = object;
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"");
                    object = function1;
                    function1 = new Function1<ImageView, Unit>(chat){
                        final /* synthetic */ Chat $data;
                        {
                            this.$data = chat;
                            super(1);
                        }

                        public final void invoke(@NotNull ImageView imageView) {
                            ImageView imageView2 = imageView;
                            Intrinsics.checkNotNullParameter((Object)imageView2, (String)"$this$clear");
                            imageView2.setBackgroundResource(R.drawable.slr_shape_circle);
                            imageView.setImageResource(this.$data.getChatResId());
                        }
                    };
                    CoilExtensionsKt.clear((ImageView)appCompatImageView, (Function1<? super ImageView, Unit>)object);
                }
            }
            Object object2 = object2.binding;
            if (chat.isEmptyChat()) {
                Object object3 = object2;
                ((SlrItemMessagingChatBinding)object3).chatName.setText(R.string.slr_messaging_chat_await_friends);
                ((SlrItemMessagingChatBinding)object3).chatMessage.setText(R.string.slr_messaging_chat_link_shared);
            } else {
                Object object4 = object2;
                ((SlrItemMessagingChatBinding)object4).chatName.setText((CharSequence)chat.getChatName());
                ((SlrItemMessagingChatBinding)object4).chatMessage.setText((CharSequence)chat.getLastMessage());
            }
            ((SlrItemMessagingChatBinding)object2).chatTime.setText((CharSequence)chat.getChatTime());
            if (chat.getUnreadMessages() > 0) {
                Object object5 = object2;
                ((SlrItemMessagingChatBinding)object5).chatUnreadCount.show(chat.getUnreadMessages());
                MaterialTextView materialTextView = ((SlrItemMessagingChatBinding)object5).chatMessage;
                materialTextView.setTypeface(materialTextView.getTypeface(), 1);
                MaterialTextView materialTextView2 = ((SlrItemMessagingChatBinding)object5).chatMessage;
                Context context = materialTextView2.getContext();
                Context context2 = ((SlrItemMessagingChatBinding)object2).chatMessage.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"chatMessage.context");
                materialTextView2.setTextColor(ContextCompat.getColor((Context)context, (int)ViewExtensionsKt.resoleAttributeResId(context2, R.attr.slrLastUnreadMessageColor, R.color.slr_primaryBlue)));
            } else {
                Object object6 = object2;
                ((SlrItemMessagingChatBinding)object6).chatUnreadCount.hide();
                MaterialTextView materialTextView = ((SlrItemMessagingChatBinding)object6).chatMessage;
                materialTextView.setTypeface(materialTextView.getTypeface(), 0);
                MaterialTextView materialTextView3 = ((SlrItemMessagingChatBinding)object6).chatMessage;
                Context context = materialTextView3.getContext();
                Context context3 = ((SlrItemMessagingChatBinding)object2).chatMessage.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"chatMessage.context");
                materialTextView3.setTextColor(ContextCompat.getColor((Context)context, (int)ViewExtensionsKt.resoleAttributeResId(context3, R.attr.slrLastMessageColor, R.color.slr_gray900)));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\r\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ChatsDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "", "oldItemPosition", "newItemPosition", "", "areItemsTheSame", "getOldListSize", "getNewListSize", "areContentsTheSame", "", "Lio/streamlayer/sdk/messaging/chats/Chat;", "oldItems", "Ljava/util/List;", "newItems", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "sdk_originalRelease"})
    private static final class ChatsDiffCallback
    extends DiffUtil.Callback {
        @NotNull
        private final List<Chat> oldItems;
        @NotNull
        private final List<Chat> newItems;

        public ChatsDiffCallback(@NotNull List<Chat> list, @NotNull List<Chat> list2) {
            Intrinsics.checkNotNullParameter(list, (String)"oldItems");
            Intrinsics.checkNotNullParameter(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n).getChatId(), (Object)this.newItems.get(n2).getChatId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n), (Object)this.newItems.get(n2));
        }
    }
}

