/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.format;

import android.content.res.Resources;
import android.util.SparseArray;
import io.streamlayer.sdk.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class TweetDateUtils {
    static final SimpleDateFormat DATE_TIME_RFC822 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH);
    static final DateFormatter RELATIVE_DATE_FORMAT = new DateFormatter();
    static final long INVALID_DATE = -1L;

    private TweetDateUtils() {
    }

    public static long apiTimeToLong(String string2) {
        if (string2 == null) {
            return -1L;
        }
        try {
            return DATE_TIME_RFC822.parse(string2).getTime();
        }
        catch (ParseException parseException) {
            return -1L;
        }
    }

    public static boolean isValidTimestamp(String string2) {
        return TweetDateUtils.apiTimeToLong(string2) != -1L;
    }

    public static String dotPrefix(String string2) {
        return "\u2022 " + string2;
    }

    public static String getRelativeTimeString(Resources object, long l, long l2) {
        Date date;
        long l3 = l - l2;
        if (l3 >= 0L) {
            Date date2;
            if (l3 < 60000L) {
                int n = (int)(l3 / 1000L);
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n;
                return object.getQuantityString(R.plurals.slr_tw_time_secs, n, objectArray2);
            }
            if (l3 < 3600000L) {
                int n = (int)(l3 / 60000L);
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = n;
                return object.getQuantityString(R.plurals.slr_tw_time_mins, n, objectArray3);
            }
            if (l3 < 86400000L) {
                int n = (int)(l3 / 3600000L);
                Object[] objectArray = new Object[1];
                Object[] objectArray4 = objectArray;
                objectArray[0] = n;
                return object.getQuantityString(R.plurals.slr_tw_time_hours, n, objectArray4);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(l2);
            Date date3 = date2;
            date2 = new Date(l2);
            if (calendar.get(1) == calendar2.get(1)) {
                return RELATIVE_DATE_FORMAT.formatShortDateString((Resources)object, date3);
            }
            return RELATIVE_DATE_FORMAT.formatLongDateString((Resources)object, date3);
        }
        Resources resources = object;
        object = date;
        date = new Date(l2);
        return RELATIVE_DATE_FORMAT.formatLongDateString(resources, (Date)object);
    }

    static class DateFormatter {
        private final SparseArray<SimpleDateFormat> dateFormatArray;
        private Locale currentLocale;

        DateFormatter() {
            SparseArray sparseArray;
            DateFormatter dateFormatter = sparseArray;
            sparseArray = new SparseArray();
            v1.dateFormatArray = dateFormatter;
        }

        private synchronized DateFormat getDateFormat(Resources resources, int n) {
            Cloneable cloneable = ((DateFormatter)((Object)string2)).currentLocale;
            if (cloneable == null || cloneable != resources.getConfiguration().locale) {
                ((DateFormatter)((Object)string2)).currentLocale = resources.getConfiguration().locale;
                ((DateFormatter)((Object)string2)).dateFormatArray.clear();
            }
            if ((cloneable = (SimpleDateFormat)((DateFormatter)((Object)string2)).dateFormatArray.get(n)) == null) {
                SimpleDateFormat simpleDateFormat;
                DateFormatter dateFormatter = string2;
                String string2 = resources.getString(n);
                cloneable = simpleDateFormat;
                simpleDateFormat = new SimpleDateFormat(string2, Locale.getDefault());
                dateFormatter.dateFormatArray.put(n, (Object)cloneable);
            }
            return cloneable;
        }

        synchronized String formatLongDateString(Resources resources, Date date) {
            return this.getDateFormat(resources, R.string.slr_tw_relative_date_format_long).format(date);
        }

        synchronized String formatShortDateString(Resources resources, Date date) {
            return this.getDateFormat(resources, R.string.slr_tw_relative_date_format_short).format(date);
        }
    }
}

