/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.fragment.app.FragmentActivity;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.NavigationUtils;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.StreamLayerUI;
import io.streamlayer.sdk.base.InterfacesKt;
import io.streamlayer.sdk.base.SdkHost;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.sdk.model.notifications.NotificationBuilder;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.StatisticsDataOptions;
import io.streamlayer.sdk.repository.customsettings.CustomSettingsRepo;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006./0123B\t\b\u0002\u00a2\u0006\u0004\b,\u0010-J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002J\u001b\u0010\b\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015J\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bJ\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\rR\u001d\u0010&\u001a\u00020!8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R$\u0010(\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u00064"}, d2={"Lio/streamlayer/sdk/StreamLayerUI;", "", "Lio/streamlayer/sdk/StreamLayerUI$CustomTheme;", "theme", "setCustomTheme", "", "Lio/streamlayer/sdk/StreamLayerUI$CustomOverlay;", "overlay", "addCustomOverlays", "([Lio/streamlayer/sdk/StreamLayerUI$CustomOverlay;)Lio/streamlayer/sdk/StreamLayerUI;", "Lio/streamlayer/sdk/StreamLayerUI$CustomNotification;", "notification", "sendCustomNotification", "Landroidx/fragment/app/FragmentActivity;", "activity", "Lkotlin/Function1;", "Lio/streamlayer/sdk/StreamLayerUI$Options;", "Lkotlin/ExtensionFunctionType;", "reduce", "", "applyOptions", "", "isUiEnabled", "isSyncEnabled", "setPhoneContactsOptions", "", "fetchUrl", "", "refreshIntervalInMillis", "setStatisticsDataOptions", "Lio/streamlayer/sdk/StreamLayerUI$Overlay;", "showOverlay", "hideOverlay", "Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;", "repository$delegate", "Lkotlin/Lazy;", "getRepository", "()Lio/streamlayer/sdk/repository/customsettings/CustomSettingsRepo;", "repository", "<set-?>", "customTheme", "Lio/streamlayer/sdk/StreamLayerUI$CustomTheme;", "getCustomTheme$sdk_originalRelease", "()Lio/streamlayer/sdk/StreamLayerUI$CustomTheme;", "<init>", "()V", "CustomNotification", "CustomOverlay", "CustomTheme", "NotificationsStyle", "Options", "Overlay", "sdk_originalRelease"})
public final class StreamLayerUI {
    @NotNull
    public static final StreamLayerUI INSTANCE = new StreamLayerUI();
    @NotNull
    private static final Lazy repository$delegate = LazyKt.lazy((Function0)repository.2.INSTANCE);
    @NotNull
    private static CustomTheme customTheme = new CustomTheme(null, null, null, null, null, null, null, null, null, null, 1023, null);

    private StreamLayerUI() {
    }

    private final CustomSettingsRepo getRepository() {
        return (CustomSettingsRepo)repository$delegate.getValue();
    }

    @NotNull
    public final CustomTheme getCustomTheme$sdk_originalRelease() {
        return customTheme;
    }

    @NotNull
    public final StreamLayerUI setCustomTheme(@NotNull CustomTheme customTheme) {
        CustomTheme customTheme2 = customTheme;
        Intrinsics.checkNotNullParameter((Object)customTheme2, (String)"theme");
        StreamLayerUI.customTheme = customTheme2;
        return this;
    }

    @NotNull
    public final StreamLayerUI addCustomOverlays(@NotNull CustomOverlay[] customOverlayArray) {
        StreamLayerUI streamLayerUI = this;
        Intrinsics.checkNotNullParameter((Object)customOverlayArray, (String)"overlay");
        streamLayerUI.getRepository().addOverlays(customOverlayArray);
        return streamLayerUI;
    }

    @NotNull
    public final StreamLayerUI sendCustomNotification(@NotNull CustomNotification customNotification) {
        StreamLayerUI streamLayerUI = this;
        Intrinsics.checkNotNullParameter((Object)customNotification, (String)"notification");
        streamLayerUI.getRepository().sendNotification(customNotification);
        return streamLayerUI;
    }

    public final void applyOptions(@NotNull FragmentActivity fragmentActivity, @NotNull Function1<? super Options, Options> function1) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"activity");
        Intrinsics.checkNotNullParameter(function1, (String)"reduce");
        SdkHost sdkHost = InterfacesKt.findSdkHost(fragmentActivity);
        if (sdkHost != null) {
            sdkHost.setOptions((Options)function1.invoke((Object)sdkHost.getOptions()));
        }
    }

    public final void setPhoneContactsOptions(boolean bl, boolean bl2) {
        Session session2 = (Session)StreamLayer.INSTANCE.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null);
        session2.setPhoneContactsUiEnabled(bl);
        session2.setPhoneContactsSyncEnabled(bl2);
    }

    public final void setStatisticsDataOptions(@NotNull String string2, long l) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"fetchUrl");
        ((Session)StreamLayer.INSTANCE.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(Session.class), null, null)).setStatisticsDataOptions(new StatisticsDataOptions(EventType.Golf, string2, l));
    }

    public final void showOverlay(@NotNull FragmentActivity fragmentActivity, @NotNull Overlay overlay) {
        Overlay overlay2 = overlay;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)overlay2, (String)"overlay");
        if (Intrinsics.areEqual((Object)overlay2, (Object)Overlay.Statistics.INSTANCE) && (this = InterfacesKt.findSdkHost(fragmentActivity)) != null) {
            this.processDeepLink(new DeepLink(NavigationUtils.INSTANCE.buildStatisticsDeepLink(), Payload.ResetHistory.INSTANCE));
        }
    }

    public final void hideOverlay(@NotNull FragmentActivity fragmentActivity) {
        FragmentActivity fragmentActivity2 = fragmentActivity;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"activity");
        Object object = InterfacesKt.findSdkHost(fragmentActivity2);
        if (object != null && (object = object.getNavigator()) != null) {
            object.showOverlay(false);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0001\u0010\f\u001a\u00020\u0002\u0012\b\b\u0001\u0010\r\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b'\u0010(J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\t\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\b\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\nH\u00c6\u0003J1\u0010\u0010\u001a\u00020\u00002\b\b\u0003\u0010\f\u001a\u00020\u00022\b\b\u0003\u0010\r\u001a\u00020\u00022\b\b\u0003\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\nH\u00c6\u0001J\t\u0010\u0011\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001J\u0013\u0010\u0014\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003R\u0019\u0010\f\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\r\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0015\u001a\u0004\b\u0018\u0010\u0017R\u0019\u0010\u000e\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017R\u0019\u0010\u000f\u001a\u00020\n8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$CustomOverlay;", "", "", "position", "", "show", "showOnBottomMenu", "component1", "component2", "component3", "", "component4", "actionId", "titleId", "iconId", "fullClassName", "copy", "toString", "hashCode", "other", "equals", "I", "getActionId", "()I", "getTitleId", "getIconId", "Ljava/lang/String;", "getFullClassName", "()Ljava/lang/String;", "buttonPosition", "getButtonPosition", "setButtonPosition", "(I)V", "onBottomMenu", "Z", "getOnBottomMenu", "()Z", "setOnBottomMenu", "(Z)V", "<init>", "(IIILjava/lang/String;)V", "sdk_originalRelease"})
    public static final class CustomOverlay {
        private final int actionId;
        private final int titleId;
        private final int iconId;
        @NotNull
        private final String fullClassName;
        private int buttonPosition;
        private boolean onBottomMenu;

        public CustomOverlay(@IdRes int n, @StringRes int n2, @DrawableRes int n3, @NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"fullClassName");
            this.actionId = n;
            this.titleId = n2;
            this.iconId = n3;
            this.fullClassName = string2;
            this.buttonPosition = -1;
            this.onBottomMenu = true;
        }

        public static /* synthetic */ CustomOverlay copy$default(CustomOverlay customOverlay, int n, int n2, int n3, String string2, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = customOverlay.actionId;
            }
            if ((n4 & 2) != 0) {
                n2 = customOverlay.titleId;
            }
            if ((n4 & 4) != 0) {
                n3 = customOverlay.iconId;
            }
            if ((n4 & 8) != 0) {
                string2 = customOverlay.fullClassName;
            }
            return customOverlay.copy(n, n2, n3, string2);
        }

        public final int getActionId() {
            return this.actionId;
        }

        public final int getTitleId() {
            return this.titleId;
        }

        public final int getIconId() {
            return this.iconId;
        }

        @NotNull
        public final String getFullClassName() {
            return this.fullClassName;
        }

        public final int getButtonPosition() {
            return this.buttonPosition;
        }

        public final void setButtonPosition(int n) {
            this.buttonPosition = n;
        }

        public final boolean getOnBottomMenu() {
            return this.onBottomMenu;
        }

        public final void setOnBottomMenu(boolean bl) {
            this.onBottomMenu = bl;
        }

        @NotNull
        public final CustomOverlay position(int n) {
            CustomOverlay customOverlay = this;
            customOverlay.setButtonPosition(n);
            return customOverlay;
        }

        @NotNull
        public final CustomOverlay showOnBottomMenu(boolean bl) {
            CustomOverlay customOverlay = this;
            customOverlay.setOnBottomMenu(bl);
            return customOverlay;
        }

        public final int component1() {
            return this.actionId;
        }

        public final int component2() {
            return this.titleId;
        }

        public final int component3() {
            return this.iconId;
        }

        @NotNull
        public final String component4() {
            return this.fullClassName;
        }

        @NotNull
        public final CustomOverlay copy(@IdRes int n, @StringRes int n2, @DrawableRes int n3, @NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"fullClassName");
            return new CustomOverlay(n, n2, n3, string2);
        }

        @NotNull
        public String toString() {
            return "CustomOverlay(actionId=" + this.actionId + ", titleId=" + this.titleId + ", iconId=" + this.iconId + ", fullClassName=" + this.fullClassName + ')';
        }

        public int hashCode() {
            return ((Integer.hashCode(this.actionId) * 31 + Integer.hashCode(this.titleId)) * 31 + Integer.hashCode(this.iconId)) * 31 + this.fullClassName.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CustomOverlay)) {
                return false;
            }
            object = (CustomOverlay)object;
            if (this.actionId != ((CustomOverlay)object).actionId) {
                return false;
            }
            if (this.titleId != ((CustomOverlay)object).titleId) {
                return false;
            }
            if (this.iconId != ((CustomOverlay)object).iconId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fullClassName, (Object)((CustomOverlay)object).fullClassName);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001BO\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\n\b\u0003\u0010\u0010\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00028\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0006R\u001e\u0010\n\u001a\u0004\u0018\u00010\t8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\t8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\t8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\rR\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00028\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0004\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$CustomNotification;", "Lio/streamlayer/sdk/model/notifications/NotificationBuilder;", "", "title", "Ljava/lang/String;", "getTitle", "()Ljava/lang/String;", "description", "getDescription", "", "layoutId", "Ljava/lang/Integer;", "getLayoutId", "()Ljava/lang/Integer;", "actionId", "getActionId", "iconBackgroundColor", "getIconBackgroundColor", "iconUrl", "getIconUrl", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "sdk_originalRelease"})
    public static class CustomNotification
    implements NotificationBuilder {
        @Nullable
        private final String title;
        @Nullable
        private final String description;
        @Nullable
        private final Integer layoutId;
        @Nullable
        private final Integer actionId;
        @Nullable
        private final Integer iconBackgroundColor;
        @Nullable
        private final String iconUrl;

        public CustomNotification(@Nullable String string2, @Nullable String string3, @LayoutRes @Nullable Integer n, @IdRes @Nullable Integer n2, @ColorRes @Nullable Integer n3, @Nullable String string4) {
            this.title = string2;
            this.description = string3;
            this.layoutId = n;
            this.actionId = n2;
            this.iconBackgroundColor = n3;
            this.iconUrl = string4;
        }

        public /* synthetic */ CustomNotification(String string2, String string3, Integer n, Integer n2, Integer n3, String string4, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                string2 = null;
            }
            if ((n4 & 2) != 0) {
                string3 = null;
            }
            if ((n4 & 4) != 0) {
                n = null;
            }
            if ((n4 & 8) != 0) {
                n2 = null;
            }
            if ((n4 & 0x10) != 0) {
                n3 = null;
            }
            if ((n4 & 0x20) != 0) {
                string4 = null;
            }
            this(string2, string3, n, n2, n3, string4);
        }

        public CustomNotification() {
            this(null, null, null, null, null, null, 63, null);
        }

        @Override
        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @Nullable
        public Integer getLayoutId() {
            return this.layoutId;
        }

        @Override
        @Nullable
        public Integer getActionId() {
            return this.actionId;
        }

        @Override
        @Nullable
        public Integer getIconBackgroundColor() {
            return this.iconBackgroundColor;
        }

        @Override
        @Nullable
        public String getIconUrl() {
            return this.iconUrl;
        }

        @Override
        public void bindView(@NotNull View view2) {
            NotificationBuilder.DefaultImpls.bindView(this, view2);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$NotificationsStyle;", "", "<init>", "(Ljava/lang/String;I)V", "DESIGN_NUMBER_ONE", "DESIGN_NUMBER_TWO", "sdk_originalRelease"})
    public static enum NotificationsStyle {
        DESIGN_NUMBER_ONE,
        DESIGN_NUMBER_TWO;

    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B\u0081\u0001\b\u0007\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b.\u0010/J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u0004J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u0088\u0001\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\t\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0002H\u00d6\u0001J\u0013\u0010 \u001a\u00020\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003R\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010!\u001a\u0004\b\"\u0010\u0004R\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010!\u001a\u0004\b#\u0010\u0004R\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010!\u001a\u0004\b$\u0010\u0004R\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010!\u001a\u0004\b%\u0010\u0004R\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010!\u001a\u0004\b&\u0010\u0004R\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010!\u001a\u0004\b'\u0010\u0004R\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010!\u001a\u0004\b(\u0010\u0004R\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010!\u001a\u0004\b)\u0010\u0004R\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010!\u001a\u0004\b*\u0010\u0004R\u001b\u0010\u0018\u001a\u0004\u0018\u00010\r8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010+\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$CustomTheme;", "", "", "component1", "()Ljava/lang/Integer;", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "Lio/streamlayer/sdk/StreamLayerUI$NotificationsStyle;", "component10", "authTheme", "mainTheme", "profileTheme", "baseTheme", "watchPartyTheme", "inviteTheme", "predictionsTheme", "statisticsTheme", "messengerTheme", "notificationsStyle", "copy", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Lio/streamlayer/sdk/StreamLayerUI$NotificationsStyle;)Lio/streamlayer/sdk/StreamLayerUI$CustomTheme;", "", "toString", "hashCode", "other", "", "equals", "Ljava/lang/Integer;", "getAuthTheme", "getMainTheme", "getProfileTheme", "getBaseTheme", "getWatchPartyTheme", "getInviteTheme", "getPredictionsTheme", "getStatisticsTheme", "getMessengerTheme", "Lio/streamlayer/sdk/StreamLayerUI$NotificationsStyle;", "getNotificationsStyle", "()Lio/streamlayer/sdk/StreamLayerUI$NotificationsStyle;", "<init>", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Lio/streamlayer/sdk/StreamLayerUI$NotificationsStyle;)V", "sdk_originalRelease"})
    public static final class CustomTheme {
        @Nullable
        private final Integer authTheme;
        @Nullable
        private final Integer mainTheme;
        @Nullable
        private final Integer profileTheme;
        @Nullable
        private final Integer baseTheme;
        @Nullable
        private final Integer watchPartyTheme;
        @Nullable
        private final Integer inviteTheme;
        @Nullable
        private final Integer predictionsTheme;
        @Nullable
        private final Integer statisticsTheme;
        @Nullable
        private final Integer messengerTheme;
        @Nullable
        private final NotificationsStyle notificationsStyle;

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5, @Nullable Integer n6, @Nullable Integer n7, @Nullable Integer n8, @Nullable Integer n9, @Nullable NotificationsStyle notificationsStyle) {
            this.authTheme = n;
            this.mainTheme = n2;
            this.profileTheme = n3;
            this.baseTheme = n4;
            this.watchPartyTheme = n5;
            this.inviteTheme = n6;
            this.predictionsTheme = n7;
            this.statisticsTheme = n8;
            this.messengerTheme = n9;
            this.notificationsStyle = notificationsStyle;
        }

        public /* synthetic */ CustomTheme(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9, NotificationsStyle notificationsStyle, int n10, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n10 & 1) != 0) {
                n = null;
            }
            if ((n10 & 2) != 0) {
                n2 = null;
            }
            if ((n10 & 4) != 0) {
                n3 = null;
            }
            if ((n10 & 8) != 0) {
                n4 = null;
            }
            if ((n10 & 0x10) != 0) {
                n5 = null;
            }
            if ((n10 & 0x20) != 0) {
                n6 = null;
            }
            if ((n10 & 0x40) != 0) {
                n7 = null;
            }
            if ((n10 & 0x80) != 0) {
                n8 = null;
            }
            if ((n10 & 0x100) != 0) {
                n9 = null;
            }
            if ((n10 & 0x200) != 0) {
                notificationsStyle = null;
            }
            this(n, n2, n3, n4, n5, n6, n7, n8, n9, notificationsStyle);
        }

        public static /* synthetic */ CustomTheme copy$default(CustomTheme customTheme, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9, NotificationsStyle notificationsStyle, int n10, Object object) {
            if ((n10 & 1) != 0) {
                n = customTheme.authTheme;
            }
            if ((n10 & 2) != 0) {
                n2 = customTheme.mainTheme;
            }
            if ((n10 & 4) != 0) {
                n3 = customTheme.profileTheme;
            }
            if ((n10 & 8) != 0) {
                n4 = customTheme.baseTheme;
            }
            if ((n10 & 0x10) != 0) {
                n5 = customTheme.watchPartyTheme;
            }
            if ((n10 & 0x20) != 0) {
                n6 = customTheme.inviteTheme;
            }
            if ((n10 & 0x40) != 0) {
                n7 = customTheme.predictionsTheme;
            }
            if ((n10 & 0x80) != 0) {
                n8 = customTheme.statisticsTheme;
            }
            if ((n10 & 0x100) != 0) {
                n9 = customTheme.messengerTheme;
            }
            if ((n10 & 0x200) != 0) {
                notificationsStyle = customTheme.notificationsStyle;
            }
            return customTheme.copy(n, n2, n3, n4, n5, n6, n7, n8, n9, notificationsStyle);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5, @Nullable Integer n6, @Nullable Integer n7, @Nullable Integer n8, @Nullable Integer n9) {
            this(n, n2, n3, n4, n5, n6, n7, n8, n9, null, 512, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5, @Nullable Integer n6, @Nullable Integer n7, @Nullable Integer n8) {
            this(n, n2, n3, n4, n5, n6, n7, n8, null, null, 768, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5, @Nullable Integer n6, @Nullable Integer n7) {
            this(n, n2, n3, n4, n5, n6, n7, null, null, null, 896, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5, @Nullable Integer n6) {
            this(n, n2, n3, n4, n5, n6, null, null, null, null, 960, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5) {
            this(n, n2, n3, n4, n5, null, null, null, null, null, 992, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4) {
            this(n, n2, n3, n4, null, null, null, null, null, null, 1008, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3) {
            this(n, n2, n3, null, null, null, null, null, null, null, 1016, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n, @Nullable Integer n2) {
            this(n, n2, null, null, null, null, null, null, null, null, 1020, null);
        }

        @JvmOverloads
        public CustomTheme(@Nullable Integer n) {
            this(n, null, null, null, null, null, null, null, null, null, 1022, null);
        }

        @JvmOverloads
        public CustomTheme() {
            this(null, null, null, null, null, null, null, null, null, null, 1023, null);
        }

        @Nullable
        public final Integer getAuthTheme() {
            return this.authTheme;
        }

        @Nullable
        public final Integer getMainTheme() {
            return this.mainTheme;
        }

        @Nullable
        public final Integer getProfileTheme() {
            return this.profileTheme;
        }

        @Nullable
        public final Integer getBaseTheme() {
            return this.baseTheme;
        }

        @Nullable
        public final Integer getWatchPartyTheme() {
            return this.watchPartyTheme;
        }

        @Nullable
        public final Integer getInviteTheme() {
            return this.inviteTheme;
        }

        @Nullable
        public final Integer getPredictionsTheme() {
            return this.predictionsTheme;
        }

        @Nullable
        public final Integer getStatisticsTheme() {
            return this.statisticsTheme;
        }

        @Nullable
        public final Integer getMessengerTheme() {
            return this.messengerTheme;
        }

        @Nullable
        public final NotificationsStyle getNotificationsStyle() {
            return this.notificationsStyle;
        }

        @Nullable
        public final Integer component1() {
            return this.authTheme;
        }

        @Nullable
        public final Integer component2() {
            return this.mainTheme;
        }

        @Nullable
        public final Integer component3() {
            return this.profileTheme;
        }

        @Nullable
        public final Integer component4() {
            return this.baseTheme;
        }

        @Nullable
        public final Integer component5() {
            return this.watchPartyTheme;
        }

        @Nullable
        public final Integer component6() {
            return this.inviteTheme;
        }

        @Nullable
        public final Integer component7() {
            return this.predictionsTheme;
        }

        @Nullable
        public final Integer component8() {
            return this.statisticsTheme;
        }

        @Nullable
        public final Integer component9() {
            return this.messengerTheme;
        }

        @Nullable
        public final NotificationsStyle component10() {
            return this.notificationsStyle;
        }

        @NotNull
        public final CustomTheme copy(@Nullable Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5, @Nullable Integer n6, @Nullable Integer n7, @Nullable Integer n8, @Nullable Integer n9, @Nullable NotificationsStyle notificationsStyle) {
            return new CustomTheme(n, n2, n3, n4, n5, n6, n7, n8, n9, notificationsStyle);
        }

        @NotNull
        public String toString() {
            return "CustomTheme(authTheme=" + this.authTheme + ", mainTheme=" + this.mainTheme + ", profileTheme=" + this.profileTheme + ", baseTheme=" + this.baseTheme + ", watchPartyTheme=" + this.watchPartyTheme + ", inviteTheme=" + this.inviteTheme + ", predictionsTheme=" + this.predictionsTheme + ", statisticsTheme=" + this.statisticsTheme + ", messengerTheme=" + this.messengerTheme + ", notificationsStyle=" + (Object)((Object)this.notificationsStyle) + ')';
        }

        public int hashCode() {
            Integer n = this.authTheme;
            int n2 = (n == null ? 0 : ((Object)n).hashCode()) * 31;
            Integer n3 = this.mainTheme;
            int n4 = n3 == null ? 0 : ((Object)n3).hashCode();
            n2 = (n2 + n4) * 31;
            Integer n5 = this.profileTheme;
            int n6 = n5 == null ? 0 : ((Object)n5).hashCode();
            n2 = (n2 + n6) * 31;
            Integer n7 = this.baseTheme;
            int n8 = n7 == null ? 0 : ((Object)n7).hashCode();
            n2 = (n2 + n8) * 31;
            Integer n9 = this.watchPartyTheme;
            int n10 = n9 == null ? 0 : ((Object)n9).hashCode();
            n2 = (n2 + n10) * 31;
            Integer n11 = this.inviteTheme;
            int n12 = n11 == null ? 0 : ((Object)n11).hashCode();
            n2 = (n2 + n12) * 31;
            Integer n13 = this.predictionsTheme;
            int n14 = n13 == null ? 0 : ((Object)n13).hashCode();
            n2 = (n2 + n14) * 31;
            Integer n15 = this.statisticsTheme;
            int n16 = n15 == null ? 0 : ((Object)n15).hashCode();
            n2 = (n2 + n16) * 31;
            Integer n17 = this.messengerTheme;
            int n18 = n17 == null ? 0 : ((Object)n17).hashCode();
            int n19 = (n2 + n18) * 31;
            NotificationsStyle notificationsStyle = this.notificationsStyle;
            int n20 = notificationsStyle == null ? 0 : notificationsStyle.hashCode();
            return n19 + n20;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CustomTheme)) {
                return false;
            }
            object = (CustomTheme)object;
            if (!Intrinsics.areEqual((Object)this.authTheme, (Object)((CustomTheme)object).authTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mainTheme, (Object)((CustomTheme)object).mainTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.profileTheme, (Object)((CustomTheme)object).profileTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.baseTheme, (Object)((CustomTheme)object).baseTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.watchPartyTheme, (Object)((CustomTheme)object).watchPartyTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inviteTheme, (Object)((CustomTheme)object).inviteTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.predictionsTheme, (Object)((CustomTheme)object).predictionsTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statisticsTheme, (Object)((CustomTheme)object).statisticsTheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.messengerTheme, (Object)((CustomTheme)object).messengerTheme)) {
                return false;
            }
            return this.notificationsStyle == ((CustomTheme)object).notificationsStyle;
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0001\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$Overlay;", "", "<init>", "()V", "Statistics", "Lio/streamlayer/sdk/StreamLayerUI$Overlay$Statistics;", "sdk_originalRelease"})
    public static abstract class Overlay {
        private Overlay() {
        }

        public /* synthetic */ Overlay(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$Overlay$Statistics;", "Lio/streamlayer/sdk/StreamLayerUI$Overlay;", "<init>", "()V", "sdk_originalRelease"})
        public static final class Statistics
        extends Overlay {
            @NotNull
            public static final Statistics INSTANCE = new Statistics();

            private Statistics() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001:\u0002&'BW\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0013\u001a\u00020\t\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0004\b$\u0010%J\t\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0004\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\b\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\n\u001a\u00020\tH\u00c6\u0003J\t\u0010\f\u001a\u00020\u000bH\u00c6\u0003JY\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\u000bH\u00c6\u0001J\t\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001J\u0013\u0010\u001b\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003R\u0019\u0010\r\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001c\u001a\u0004\b\r\u0010\u001dR\u0019\u0010\u000e\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001c\u001a\u0004\b\u000e\u0010\u001dR\u0019\u0010\u000f\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001c\u001a\u0004\b\u000f\u0010\u001dR\u0019\u0010\u0010\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001c\u001a\u0004\b\u0010\u0010\u001dR\u0019\u0010\u0011\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u001c\u001a\u0004\b\u0011\u0010\u001dR\u0019\u0010\u0012\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u001c\u001a\u0004\b\u0012\u0010\u001dR\u0019\u0010\u0013\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0019\u0010\u0014\u001a\u00020\u000b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006("}, d2={"Lio/streamlayer/sdk/StreamLayerUI$Options;", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "Lio/streamlayer/sdk/StreamLayerUI$Options$Menu;", "component7", "Lio/streamlayer/sdk/StreamLayerUI$Options$Overlay;", "component8", "isLaunchButtonEnabled", "isWhoIsWatchingViewEnabled", "isInAppNotificationsEnabled", "isPredictionsPointsEnabled", "isWatchPartyButtonEnabled", "isTooltipsEnabled", "menu", "overlay", "copy", "", "toString", "", "hashCode", "other", "equals", "Z", "()Z", "Lio/streamlayer/sdk/StreamLayerUI$Options$Menu;", "getMenu", "()Lio/streamlayer/sdk/StreamLayerUI$Options$Menu;", "Lio/streamlayer/sdk/StreamLayerUI$Options$Overlay;", "getOverlay", "()Lio/streamlayer/sdk/StreamLayerUI$Options$Overlay;", "<init>", "(ZZZZZZLio/streamlayer/sdk/StreamLayerUI$Options$Menu;Lio/streamlayer/sdk/StreamLayerUI$Options$Overlay;)V", "Menu", "Overlay", "sdk_originalRelease"})
    public static final class Options {
        private final boolean isLaunchButtonEnabled;
        private final boolean isWhoIsWatchingViewEnabled;
        private final boolean isInAppNotificationsEnabled;
        private final boolean isPredictionsPointsEnabled;
        private final boolean isWatchPartyButtonEnabled;
        private final boolean isTooltipsEnabled;
        @NotNull
        private final Menu menu;
        @NotNull
        private final Overlay overlay;

        public Options(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, @NotNull Menu menu, @NotNull Overlay overlay) {
            Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
            Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
            this.isLaunchButtonEnabled = bl;
            this.isWhoIsWatchingViewEnabled = bl2;
            this.isInAppNotificationsEnabled = bl3;
            this.isPredictionsPointsEnabled = bl4;
            this.isWatchPartyButtonEnabled = bl5;
            this.isTooltipsEnabled = bl6;
            this.menu = menu;
            this.overlay = overlay;
        }

        public /* synthetic */ Options(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Menu menu, Overlay overlay, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            if ((n & 0x10) != 0) {
                bl5 = true;
            }
            if ((n & 0x20) != 0) {
                bl6 = true;
            }
            if ((n & 0x40) != 0) {
                Menu menu2;
                menu = menu2;
                menu2 = new Menu(false, false, 3, null);
            }
            if ((n & 0x80) != 0) {
                Overlay overlay2;
                overlay = overlay2;
                overlay2 = new Overlay(0, false, 3, null);
            }
            this(bl, bl2, bl3, bl4, bl5, bl6, menu, overlay);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Menu menu, Overlay overlay, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.isLaunchButtonEnabled;
            }
            if ((n & 2) != 0) {
                bl2 = options.isWhoIsWatchingViewEnabled;
            }
            if ((n & 4) != 0) {
                bl3 = options.isInAppNotificationsEnabled;
            }
            if ((n & 8) != 0) {
                bl4 = options.isPredictionsPointsEnabled;
            }
            if ((n & 0x10) != 0) {
                bl5 = options.isWatchPartyButtonEnabled;
            }
            if ((n & 0x20) != 0) {
                bl6 = options.isTooltipsEnabled;
            }
            if ((n & 0x40) != 0) {
                menu = options.menu;
            }
            if ((n & 0x80) != 0) {
                overlay = options.overlay;
            }
            return options.copy(bl, bl2, bl3, bl4, bl5, bl6, menu, overlay);
        }

        public Options() {
            this(false, false, false, false, false, false, null, null, 255, null);
        }

        public final boolean isLaunchButtonEnabled() {
            return this.isLaunchButtonEnabled;
        }

        public final boolean isWhoIsWatchingViewEnabled() {
            return this.isWhoIsWatchingViewEnabled;
        }

        public final boolean isInAppNotificationsEnabled() {
            return this.isInAppNotificationsEnabled;
        }

        public final boolean isPredictionsPointsEnabled() {
            return this.isPredictionsPointsEnabled;
        }

        public final boolean isWatchPartyButtonEnabled() {
            return this.isWatchPartyButtonEnabled;
        }

        public final boolean isTooltipsEnabled() {
            return this.isTooltipsEnabled;
        }

        @NotNull
        public final Menu getMenu() {
            return this.menu;
        }

        @NotNull
        public final Overlay getOverlay() {
            return this.overlay;
        }

        public final boolean component1() {
            return this.isLaunchButtonEnabled;
        }

        public final boolean component2() {
            return this.isWhoIsWatchingViewEnabled;
        }

        public final boolean component3() {
            return this.isInAppNotificationsEnabled;
        }

        public final boolean component4() {
            return this.isPredictionsPointsEnabled;
        }

        public final boolean component5() {
            return this.isWatchPartyButtonEnabled;
        }

        public final boolean component6() {
            return this.isTooltipsEnabled;
        }

        @NotNull
        public final Menu component7() {
            return this.menu;
        }

        @NotNull
        public final Overlay component8() {
            return this.overlay;
        }

        @NotNull
        public final Options copy(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, @NotNull Menu menu, @NotNull Overlay overlay) {
            Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
            Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
            return new Options(bl, bl2, bl3, bl4, bl5, bl6, menu, overlay);
        }

        @NotNull
        public String toString() {
            return "Options(isLaunchButtonEnabled=" + this.isLaunchButtonEnabled + ", isWhoIsWatchingViewEnabled=" + this.isWhoIsWatchingViewEnabled + ", isInAppNotificationsEnabled=" + this.isInAppNotificationsEnabled + ", isPredictionsPointsEnabled=" + this.isPredictionsPointsEnabled + ", isWatchPartyButtonEnabled=" + this.isWatchPartyButtonEnabled + ", isTooltipsEnabled=" + this.isTooltipsEnabled + ", menu=" + this.menu + ", overlay=" + this.overlay + ')';
        }

        public int hashCode() {
            int n = this.isLaunchButtonEnabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            n *= 31;
            int n2 = this.isWhoIsWatchingViewEnabled ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            boolean bl = this.isInAppNotificationsEnabled;
            n2 = bl ? 1 : 0;
            if (bl) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            boolean bl2 = this.isPredictionsPointsEnabled;
            n2 = bl2 ? 1 : 0;
            if (bl2) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            boolean bl3 = this.isWatchPartyButtonEnabled;
            n2 = bl3 ? 1 : 0;
            if (bl3) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            boolean bl4 = this.isTooltipsEnabled;
            n2 = bl4 ? 1 : 0;
            if (bl4) {
                n2 = 1;
            }
            return ((n + n2) * 31 + this.menu.hashCode()) * 31 + this.overlay.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Options)) {
                return false;
            }
            object = (Options)object;
            if (this.isLaunchButtonEnabled != ((Options)object).isLaunchButtonEnabled) {
                return false;
            }
            if (this.isWhoIsWatchingViewEnabled != ((Options)object).isWhoIsWatchingViewEnabled) {
                return false;
            }
            if (this.isInAppNotificationsEnabled != ((Options)object).isInAppNotificationsEnabled) {
                return false;
            }
            if (this.isPredictionsPointsEnabled != ((Options)object).isPredictionsPointsEnabled) {
                return false;
            }
            if (this.isWatchPartyButtonEnabled != ((Options)object).isWatchPartyButtonEnabled) {
                return false;
            }
            if (this.isTooltipsEnabled != ((Options)object).isTooltipsEnabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.menu, (Object)((Options)object).menu)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.overlay, (Object)((Options)object).overlay);
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0004\u001a\u00020\u0002H\u00c6\u0003J\u001d\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001J\t\u0010\t\u001a\u00020\bH\u00d6\u0001J\t\u0010\u000b\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\r\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003R\u0019\u0010\u0005\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u0005\u0010\u000fR\u0019\u0010\u0006\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u0006\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$Options$Menu;", "", "", "component1", "component2", "isAlwaysOpened", "isProfileEnabled", "copy", "", "toString", "", "hashCode", "other", "equals", "Z", "()Z", "<init>", "(ZZ)V", "sdk_originalRelease"})
        public static final class Menu {
            private final boolean isAlwaysOpened;
            private final boolean isProfileEnabled;

            public Menu(boolean bl, boolean bl2) {
                this.isAlwaysOpened = bl;
                this.isProfileEnabled = bl2;
            }

            public /* synthetic */ Menu(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = true;
                }
                this(bl, bl2);
            }

            public static /* synthetic */ Menu copy$default(Menu menu, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = menu.isAlwaysOpened;
                }
                if ((n & 2) != 0) {
                    bl2 = menu.isProfileEnabled;
                }
                return menu.copy(bl, bl2);
            }

            public Menu() {
                this(false, false, 3, null);
            }

            public final boolean isAlwaysOpened() {
                return this.isAlwaysOpened;
            }

            public final boolean isProfileEnabled() {
                return this.isProfileEnabled;
            }

            public final boolean component1() {
                return this.isAlwaysOpened;
            }

            public final boolean component2() {
                return this.isProfileEnabled;
            }

            @NotNull
            public final Menu copy(boolean bl, boolean bl2) {
                return new Menu(bl, bl2);
            }

            @NotNull
            public String toString() {
                return "Menu(isAlwaysOpened=" + this.isAlwaysOpened + ", isProfileEnabled=" + this.isProfileEnabled + ')';
            }

            public int hashCode() {
                int n = this.isAlwaysOpened ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                int n2 = n * 31;
                boolean bl = this.isProfileEnabled;
                n = bl ? 1 : 0;
                if (bl) {
                    n = 1;
                }
                return n2 + n;
            }

            public boolean equals(@Nullable Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Menu)) {
                    return false;
                }
                object = (Menu)object;
                if (this.isAlwaysOpened != ((Menu)object).isAlwaysOpened) {
                    return false;
                }
                return this.isProfileEnabled == ((Menu)object).isProfileEnabled;
            }
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\t\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0005\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\t\u0010\n\u001a\u00020\tH\u00d6\u0001J\t\u0010\u000b\u001a\u00020\u0002H\u00d6\u0001J\u0013\u0010\r\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003R\u0019\u0010\u0006\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0007\u001a\u00020\u00048\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0007\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/streamlayer/sdk/StreamLayerUI$Options$Overlay;", "", "", "component1", "", "component2", "height", "isStartSide", "copy", "", "toString", "hashCode", "other", "equals", "I", "getHeight", "()I", "Z", "()Z", "<init>", "(IZ)V", "sdk_originalRelease"})
        public static final class Overlay {
            private final int height;
            private final boolean isStartSide;

            public Overlay(int n, boolean bl) {
                this.height = n;
                this.isStartSide = bl;
            }

            public /* synthetic */ Overlay(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    n = 0;
                }
                if ((n2 & 2) != 0) {
                    bl = true;
                }
                this(n, bl);
            }

            public static /* synthetic */ Overlay copy$default(Overlay overlay, int n, boolean bl, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = overlay.height;
                }
                if ((n2 & 2) != 0) {
                    bl = overlay.isStartSide;
                }
                return overlay.copy(n, bl);
            }

            public Overlay() {
                this(0, false, 3, null);
            }

            public final int getHeight() {
                return this.height;
            }

            public final boolean isStartSide() {
                return this.isStartSide;
            }

            public final int component1() {
                return this.height;
            }

            public final boolean component2() {
                return this.isStartSide;
            }

            @NotNull
            public final Overlay copy(int n, boolean bl) {
                return new Overlay(n, bl);
            }

            @NotNull
            public String toString() {
                return "Overlay(height=" + this.height + ", isStartSide=" + this.isStartSide + ')';
            }

            public int hashCode() {
                Overlay overlay = this;
                int n = Integer.hashCode(overlay.height) * 31;
                int n2 = overlay.isStartSide ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Overlay)) {
                    return false;
                }
                object = (Overlay)object;
                if (this.height != ((Overlay)object).height) {
                    return false;
                }
                return this.isStartSide == ((Overlay)object).isStartSide;
            }
        }
    }
}

