/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.format.DateUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.emoji2.widget.EmojiTextView;
import androidx.lifecycle.LifecycleCoroutineScope;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewKt;
import androidx.transition.ChangeBounds;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.google.android.material.imageview.ShapeableImageView;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.common.utils.DateUtil;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.keyboard.emoji.EmojiData;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.databinding.SlrItemChatParticipantStatusBinding;
import io.streamlayer.sdk.databinding.SlrItemChatReceiverBinding;
import io.streamlayer.sdk.databinding.SlrItemChatSenderBinding;
import io.streamlayer.sdk.messaging.ChatHelper;
import io.streamlayer.sdk.messaging.Mode;
import io.streamlayer.sdk.messaging.chat.ChatMessagesAdapter;
import io.streamlayer.sdk.messaging.chat.ChatMessagesAdapterKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import java.util.Date;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006#$%&'(B\u001f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0014J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0014J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R*\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00198\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "viewType", "getLayoutId", "Landroid/view/View;", "view", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "getViewHolder", "position", "getItemViewType", "", "userId", "Ljava/lang/String;", "", "isStartSide", "Z", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ChatMessageActionListener;", "listener", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ChatMessageActionListener;", "isHideAnimationStarted", "()Z", "setHideAnimationStarted", "(Z)V", "Lio/streamlayer/sdk/messaging/Mode;", "value", "mode", "Lio/streamlayer/sdk/messaging/Mode;", "getMode", "()Lio/streamlayer/sdk/messaging/Mode;", "setMode", "(Lio/streamlayer/sdk/messaging/Mode;)V", "<init>", "(Ljava/lang/String;ZLio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ChatMessageActionListener;)V", "ChatMessageActionListener", "MessageParticipantStatusViewHolder", "MessageReceiverViewHolder", "MessageSenderViewHolder", "MessageViewHolder", "ViewHolder", "sdk_originalRelease"})
public final class ChatMessagesAdapter
extends GenericPagedListAdapter<ChatMessage> {
    @NotNull
    private final String userId;
    private final boolean isStartSide;
    @NotNull
    private final ChatMessageActionListener listener;
    private boolean isHideAnimationStarted;
    @NotNull
    private Mode mode;

    public ChatMessagesAdapter(@NotNull String string2, boolean bl, @NotNull ChatMessageActionListener chatMessageActionListener) {
        ChatMessagesAdapter chatMessagesAdapter = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)chatMessageActionListener, (String)"listener");
        super(ChatMessagesAdapterKt.access$getDiffItemCallback$p());
        this.userId = string2;
        this.isStartSide = bl;
        chatMessagesAdapter.listener = chatMessageActionListener;
        chatMessagesAdapter.mode = Mode.P2P;
    }

    public static final /* synthetic */ ChatMessage access$getItem(ChatMessagesAdapter chatMessagesAdapter, int n) {
        return (ChatMessage)chatMessagesAdapter.getItem(n);
    }

    public final boolean isHideAnimationStarted() {
        return this.isHideAnimationStarted;
    }

    public final void setHideAnimationStarted(boolean bl) {
        this.isHideAnimationStarted = bl;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"value");
        if (this.mode != mode) {
            this.mode = mode;
            this.notifyDataSetChanged();
        }
    }

    @Override
    protected int getLayoutId(int n) {
        return n != 0 ? (n != 1 ? (n != 3 ? 0 : R.layout.slr_item_chat_participant_status) : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_sender;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected GenericPagedListAdapter.GenericViewHolder<ChatMessage> getViewHolder(@NotNull View view2, int n) {
        void var2_6;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        if (n != 0) {
            if (n != 1) {
                MessageParticipantStatusViewHolder messageParticipantStatusViewHolder;
                if (n != 3) throw new RuntimeException(Intrinsics.stringPlus((String)"Unsupported item view type: ", (Object)n));
                MessageParticipantStatusViewHolder messageParticipantStatusViewHolder2 = messageParticipantStatusViewHolder;
                messageParticipantStatusViewHolder = new MessageParticipantStatusViewHolder(view2);
                return var2_6;
            } else {
                MessageReceiverViewHolder messageReceiverViewHolder;
                MessageReceiverViewHolder messageReceiverViewHolder2 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(view2);
            }
            return var2_6;
        } else {
            MessageSenderViewHolder messageSenderViewHolder;
            MessageSenderViewHolder messageSenderViewHolder2 = messageSenderViewHolder;
            messageSenderViewHolder = new MessageSenderViewHolder(view2);
        }
        return var2_6;
    }

    public int getItemViewType(int n) {
        block7: {
            int n2;
            block5: {
                block6: {
                    block4: {
                        ChatMessage chatMessage = (ChatMessage)this.getItem(n);
                        if (chatMessage == null) {
                            return super.getItemViewType(n);
                        }
                        ChatMessage chatMessage2 = chatMessage;
                        n = Intrinsics.areEqual((Object)chatMessage2.getSenderUserId(), (Object)this.userId) ? 1 : 0;
                        if (!chatMessage2.isStatusSubType()) break block4;
                        n2 = 3;
                        break block5;
                    }
                    if (n == 0) break block6;
                    n2 = 0;
                    break block5;
                }
                if (n != 0) break block7;
                n2 = 1;
            }
            return n2;
        }
        throw new RuntimeException("Unsupported state. isCurrentUser: " + (n != 0) + "; mode: " + (Object)((Object)this.mode));
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016R\u001c\u0010\u0007\u001a\u00020\u00068\u0004@\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ViewHolder;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "data", "", "bind", "", "isPortrait", "Z", "()Z", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public abstract class ViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<ChatMessage> {
        private final boolean isPortrait;

        public ViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)ChatMessagesAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            Context context = view2.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
            this.isPortrait = OtherExtensionsKt.isScreenPortrait(context);
        }

        protected final boolean isPortrait() {
            return this.isPortrait;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"data");
            SLRLog.INSTANCE.d("ChatViewModel", Intrinsics.stringPlus((String)"bind ", (Object)chatMessage));
            if (!viewHolder2.isPortrait) {
                ViewHolder viewHolder = viewHolder2;
                ViewHolder viewHolder2 = viewHolder.itemView;
                float f = viewHolder.ChatMessagesAdapter.this.isHideAnimationStarted() ? 0.0f : 1.0f;
                viewHolder2.setAlpha(f);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\b\u00a6\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010.\u001a\u00020\u0016\u00a2\u0006\u0004\b/\u00100J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0003H\u0004J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0003H\u0004J\b\u0010\f\u001a\u00020\u0007H&R\u001d\u0010\u0012\u001a\u00020\r8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0015\u001a\u00020\r8B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0014\u0010\u0011R\u001d\u0010\u001a\u001a\u00020\u00168B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0018\u0010\u0019R\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00168B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000f\u001a\u0004\b\u001c\u0010\u0019R\u001c\u0010\u001f\u001a\u00020\u001e8\u0004@\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001c\u0010$\u001a\u00020#8\u0004@\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u00020#8\u0004@\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b)\u0010'R\u001c\u0010*\u001a\u00020#8\u0004@\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b*\u0010%\u001a\u0004\b+\u0010'R\u0018\u0010-\u001a\u0004\u0018\u00010\u001e8&@&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\"\u00a8\u00061"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getPreviousMessage", "getNextMessage", "message", "", "bind", "", "isNextMessageSameSender", "isPreviousMessageSameSender", "setPreviousMessageSameSender", "Landroid/widget/TextView;", "chatTimestamp$delegate", "Lkotlin/Lazy;", "getChatTimestamp", "()Landroid/widget/TextView;", "chatTimestamp", "chatMessageContent$delegate", "getChatMessageContent", "chatMessageContent", "Landroid/view/View;", "chatMessageContainer$delegate", "getChatMessageContainer", "()Landroid/view/View;", "chatMessageContainer", "chatMessageLayout$delegate", "getChatMessageLayout", "chatMessageLayout", "Landroid/graphics/drawable/Drawable;", "defaultBackground", "Landroid/graphics/drawable/Drawable;", "getDefaultBackground", "()Landroid/graphics/drawable/Drawable;", "", "largeVerticalMargin", "I", "getLargeVerticalMargin", "()I", "smallVerticalMargin", "getSmallVerticalMargin", "defaultMessagePadding", "getDefaultMessagePadding", "getLastBackground", "lastBackground", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public abstract class MessageViewHolder
    extends ViewHolder {
        @NotNull
        private final Lazy chatTimestamp$delegate;
        @NotNull
        private final Lazy chatMessageContent$delegate;
        @NotNull
        private final Lazy chatMessageContainer$delegate;
        @NotNull
        private final Lazy chatMessageLayout$delegate;
        @NotNull
        private final Drawable defaultBackground;
        private final int largeVerticalMargin;
        private final int smallVerticalMargin;
        private final int defaultMessagePadding;
        final /* synthetic */ ChatMessagesAdapter this$0;

        public MessageViewHolder(@NotNull ChatMessagesAdapter chatMessagesAdapter, View view2) {
            MessageViewHolder messageViewHolder = this;
            Intrinsics.checkNotNullParameter((Object)((Object)chatMessagesAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            this.this$0 = chatMessagesAdapter;
            super(view2);
            messageViewHolder.chatTimestamp$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatTimestamp);
                }
            });
            messageViewHolder.chatMessageContent$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatMessageContent);
                }
            });
            messageViewHolder.chatMessageContainer$delegate = LazyKt.lazy((Function0)new Function0<View>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageContainer);
                }
            });
            messageViewHolder.chatMessageLayout$delegate = LazyKt.lazy((Function0)new Function0<View>(view2){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view2;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageLayout);
                }
            });
            Drawable drawable2 = messageViewHolder.getChatMessageContainer().getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"chatMessageContainer.background");
            messageViewHolder.defaultBackground = drawable2;
            this.largeVerticalMargin = (int)view2.getContext().getResources().getDimension(R.dimen.slr_chat_message_margin);
            this.smallVerticalMargin = (int)view2.getContext().getResources().getDimension(R.dimen.slr_chat_message_margin_small);
            this.defaultMessagePadding = view2.getContext().getResources().getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin);
        }

        private final TextView getChatTimestamp() {
            Object object = this.chatTimestamp$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chatTimestamp>(...)");
            return (TextView)object;
        }

        private final TextView getChatMessageContent() {
            Object object = this.chatMessageContent$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chatMessageContent>(...)");
            return (TextView)object;
        }

        private final View getChatMessageContainer() {
            Object object = this.chatMessageContainer$delegate.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chatMessageContainer>(...)");
            return (View)object;
        }

        private final View getChatMessageLayout() {
            return (View)this.chatMessageLayout$delegate.getValue();
        }

        @NotNull
        protected final Drawable getDefaultBackground() {
            return this.defaultBackground;
        }

        @Nullable
        public abstract Drawable getLastBackground();

        @Nullable
        protected final ChatMessage getPreviousMessage() {
            Object object;
            MessageViewHolder messageViewHolder = object;
            int n = messageViewHolder.getBindingAdapterPosition();
            try {
                object = Result.constructor-impl((Object)ChatMessagesAdapter.access$getItem(object.this$0, n + 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Nullable
        protected final ChatMessage getNextMessage() {
            Object object;
            MessageViewHolder messageViewHolder = object;
            int n = messageViewHolder.getBindingAdapterPosition();
            try {
                object = Result.constructor-impl((Object)ChatMessagesAdapter.access$getItem(object.this$0, n - 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        protected final int getLargeVerticalMargin() {
            return this.largeVerticalMargin;
        }

        protected final int getSmallVerticalMargin() {
            return this.smallVerticalMargin;
        }

        protected final int getDefaultMessagePadding() {
            return this.defaultMessagePadding;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            block11: {
                block7: {
                    block10: {
                        ViewGroup.LayoutParams layoutParams;
                        ChatMessage chatMessage2;
                        int n;
                        block8: {
                            block9: {
                                ViewGroup.LayoutParams layoutParams2;
                                EmojiData emojiData;
                                block6: {
                                    ChatMessage chatMessage3 = chatMessage;
                                    Intrinsics.checkNotNullParameter((Object)chatMessage3, (String)"message");
                                    super.bind(chatMessage3);
                                    if (chatMessage.getDate() != null) {
                                        this.getChatTimestamp().setText(DateUtils.getRelativeDateTimeString((Context)this.itemView.getContext(), (long)chatMessage.getDate().getTime(), (long)86400000L, (long)86400000L, (int)0));
                                    }
                                    Object object = this.getPreviousMessage();
                                    boolean bl = chatMessage.getDate() != null && ((object == null ? null : ((ChatMessage)object).getDate()) == null || !DateUtil.INSTANCE.isSameDay((Date)(object = ((ChatMessage)object).getDate()), chatMessage.getDate()));
                                    ViewExtensionsKt.visibleIf((View)this.getChatTimestamp(), bl);
                                    emojiData = EmojiData.INSTANCE;
                                    if (!emojiData.isEmojiOnly(chatMessage.getText())) break block6;
                                    int n2 = emojiData.getEmojiCount(chatMessage.getText());
                                    float f = n2 == 1 ? 60.0f : (n2 <= 3 ? 30.0f : this.itemView.getResources().getDimension(R.dimen.slr_ts_normal));
                                    MessageViewHolder messageViewHolder = this;
                                    messageViewHolder.getChatMessageContent().setTextSize(0, f);
                                    messageViewHolder.getChatMessageContainer().setBackground(this.defaultBackground);
                                    View view2 = messageViewHolder.getChatMessageContainer();
                                    int n3 = this.getDefaultMessagePadding();
                                    int n4 = view2.getPaddingTop();
                                    int n5 = this.getDefaultMessagePadding();
                                    int n6 = view2.getPaddingBottom();
                                    view2.setPadding(n3, n4, n5, n6);
                                    break block7;
                                }
                                MessageViewHolder messageViewHolder = this;
                                emojiData = messageViewHolder.getChatMessageContainer();
                                emojiData.setBackground(this.getDefaultBackground());
                                int n7 = this.getDefaultMessagePadding();
                                int n8 = emojiData.getPaddingTop();
                                n = this.getDefaultMessagePadding();
                                int n9 = emojiData.getPaddingBottom();
                                emojiData.setPadding(n7, n8, n, n9);
                                chatMessage2 = messageViewHolder.getPreviousMessage();
                                if (Intrinsics.areEqual((Object)(chatMessage2 == null ? null : chatMessage2.getSenderUserId()), (Object)chatMessage.getSenderUserId())) break block8;
                                chatMessage2 = this.getChatMessageLayout();
                                if (chatMessage2 == null) {
                                    chatMessage2 = this.getChatMessageContainer();
                                }
                                if ((layoutParams2 = chatMessage2.getLayoutParams()) == null) break block9;
                                ChatMessage chatMessage4 = chatMessage2;
                                chatMessage2 = (ConstraintLayout.LayoutParams)layoutParams2;
                                chatMessage2.setMargins(0, this.getLargeVerticalMargin(), 0, 0);
                                chatMessage4.setLayoutParams((ViewGroup.LayoutParams)chatMessage2);
                                break block10;
                            }
                            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                        }
                        chatMessage2 = this.getChatMessageLayout();
                        if (chatMessage2 == null) {
                            chatMessage2 = this.getChatMessageContainer();
                        }
                        if ((layoutParams = chatMessage2.getLayoutParams()) == null) break block11;
                        ChatMessage chatMessage5 = chatMessage2;
                        chatMessage2 = (ConstraintLayout.LayoutParams)layoutParams;
                        MessageViewHolder messageViewHolder = this;
                        int n10 = messageViewHolder.getSmallVerticalMargin();
                        n = messageViewHolder.getSmallVerticalMargin();
                        chatMessage2.setMargins(0, n10, 0, n);
                        chatMessage5.setLayoutParams((ViewGroup.LayoutParams)chatMessage2);
                    }
                    this.getChatMessageContent().setTextSize(0, this.itemView.getResources().getDimension(R.dimen.slr_ts_normal));
                }
                this.getChatMessageContent().setText((CharSequence)chatMessage.getText());
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final boolean isNextMessageSameSender(@NotNull ChatMessage chatMessage) {
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"message");
            ChatMessage chatMessage2 = ((MessageViewHolder)((Object)this)).getNextMessage();
            if (!Intrinsics.areEqual((Object)(chatMessage2 == null ? null : chatMessage2.getSenderUserId()), (Object)chatMessage.getSenderUserId())) return false;
            if ((this = ((MessageViewHolder)((Object)this)).getNextMessage()) == null) {
                return false;
            }
            if (((ChatMessage)this).isStatusSubType()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final boolean isPreviousMessageSameSender(@NotNull ChatMessage chatMessage) {
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"message");
            ChatMessage chatMessage2 = ((MessageViewHolder)((Object)this)).getPreviousMessage();
            if (!Intrinsics.areEqual((Object)(chatMessage2 == null ? null : chatMessage2.getSenderUserId()), (Object)chatMessage.getSenderUserId())) return false;
            if ((this = ((MessageViewHolder)((Object)this)).getPreviousMessage()) == null) {
                return false;
            }
            if (((ChatMessage)this).isStatusSubType()) return false;
            return true;
        }

        public abstract void setPreviousMessageSameSender();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001e\u0010\t\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\bH\u0016R\u0016\u0010\u000e\u001a\u00020\u00038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageSenderViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;", "Lio/streamlayer/sdk/databinding/SlrItemChatSenderBinding;", "", "hasNextMessage", "", "resId", "", "setMessageStatusIcon", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "message", "bind", "setPreviousMessageSameSender", "binding", "Lio/streamlayer/sdk/databinding/SlrItemChatSenderBinding;", "Landroid/widget/ImageView;", "chatAlertImage", "Landroid/widget/ImageView;", "Landroid/widget/TextView;", "sendingFailedText", "Landroid/widget/TextView;", "Landroid/graphics/drawable/Drawable;", "lastBackground", "Landroid/graphics/drawable/Drawable;", "getLastBackground", "()Landroid/graphics/drawable/Drawable;", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class MessageSenderViewHolder
    extends MessageViewHolder {
        @NotNull
        private final SlrItemChatSenderBinding binding;
        @NotNull
        private final ImageView chatAlertImage;
        @NotNull
        private final TextView sendingFailedText;
        @Nullable
        private final Drawable lastBackground;

        public MessageSenderViewHolder(View view2) {
            SlrItemChatSenderBinding slrItemChatSenderBinding;
            Intrinsics.checkNotNullParameter((Object)((Object)messageSenderViewHolder2.ChatMessagesAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(messageSenderViewHolder2.ChatMessagesAdapter.this, view2);
            SlrItemChatSenderBinding slrItemChatSenderBinding2 = slrItemChatSenderBinding = SlrItemChatSenderBinding.bind(view2);
            Intrinsics.checkNotNullExpressionValue((Object)slrItemChatSenderBinding2, (String)"bind(itemView)");
            messageSenderViewHolder2.binding = slrItemChatSenderBinding2;
            ImageView imageView2 = slrItemChatSenderBinding.alert;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.alert");
            messageSenderViewHolder2.chatAlertImage = imageView2;
            TextView textView = slrItemChatSenderBinding.sendingFailedMessage;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.sendingFailedMessage");
            messageSenderViewHolder2.sendingFailedText = textView;
            messageSenderViewHolder2.lastBackground = ContextCompat.getDrawable((Context)view2.getContext(), (int)R.drawable.slr_shape_chat_bubble_user_last);
            view2 = slrItemChatSenderBinding.chatMessageContainer;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"chatMessageContainer");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams != null) {
                MessageSenderViewHolder messageSenderViewHolder = messageSenderViewHolder2;
                MessageSenderViewHolder messageSenderViewHolder2 = (ConstraintLayout.LayoutParams)layoutParams;
                if (!messageSenderViewHolder.isPortrait() && messageSenderViewHolder2.ChatMessagesAdapter.this.isStartSide) {
                    messageSenderViewHolder2.setMarginEnd(ViewExtensionsKt.getDp(5.0f));
                }
                view2.setLayoutParams((ViewGroup.LayoutParams)messageSenderViewHolder2);
                slrItemChatSenderBinding.chatMessageContainer.setOnClickListener(arg_0 -> MessageSenderViewHolder.lambda-3$lambda-2(slrItemChatSenderBinding, arg_0));
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        private final void setMessageStatusIcon(SlrItemChatSenderBinding slrItemChatSenderBinding, boolean bl, @DrawableRes int n) {
            if (!bl) {
                AppCompatImageView appCompatImageView = slrItemChatSenderBinding.slChatMessageStatusIV;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"");
                ViewExtensionsKt.visible((View)appCompatImageView);
                appCompatImageView.setBackgroundResource(n);
            }
        }

        private static final void lambda-3$lambda-2$lambda-1(SlrItemChatSenderBinding slrItemChatSenderBinding) {
            SlrItemChatSenderBinding slrItemChatSenderBinding2 = slrItemChatSenderBinding;
            Intrinsics.checkNotNullParameter((Object)slrItemChatSenderBinding2, (String)"$this_with");
            AppCompatTextView appCompatTextView = slrItemChatSenderBinding2.slChatMessageTimeTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slChatMessageTimeTV");
            ViewExtensionsKt.showAnimate((View)appCompatTextView, false);
        }

        private static final void lambda-3$lambda-2(SlrItemChatSenderBinding slrItemChatSenderBinding, View view2) {
            SlrItemChatSenderBinding slrItemChatSenderBinding2 = slrItemChatSenderBinding;
            Intrinsics.checkNotNullParameter((Object)slrItemChatSenderBinding2, (String)"$this_with");
            AppCompatTextView appCompatTextView = slrItemChatSenderBinding2.slChatMessageTimeTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"slChatMessageTimeTV");
            ViewExtensionsKt.showAnimate((View)appCompatTextView, true);
            slrItemChatSenderBinding2.slChatMessageTimeTV.postDelayed(() -> MessageSenderViewHolder.lambda-3$lambda-2$lambda-1(slrItemChatSenderBinding), 1000L);
        }

        private static final void bind$lambda-10$lambda-6(ChatMessagesAdapter chatMessagesAdapter, ChatMessage chatMessage, View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)chatMessagesAdapter), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"$message");
            chatMessagesAdapter.listener.onAlert(chatMessage);
        }

        @Override
        @Nullable
        public Drawable getLastBackground() {
            return this.lastBackground;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            MessageSenderViewHolder messageSenderViewHolder = object4;
            ChatMessage chatMessage2 = chatMessage;
            Intrinsics.checkNotNullParameter((Object)chatMessage2, (String)"message");
            super.bind(chatMessage2);
            SlrItemChatSenderBinding slrItemChatSenderBinding = messageSenderViewHolder.binding;
            ChatMessagesAdapter chatMessagesAdapter = object4.ChatMessagesAdapter.this;
            MaterialTextView materialTextView = slrItemChatSenderBinding.slChatMessageReplyToTv;
            Intrinsics.checkNotNullExpressionValue((Object)materialTextView, (String)"slChatMessageReplyToTv");
            ViewExtensionsKt.gone((View)materialTextView);
            ConstraintLayout constraintLayout = slrItemChatSenderBinding.slChatMessageReplyContainer;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slChatMessageReplyContainer");
            ViewExtensionsKt.gone((View)constraintLayout);
            Object object = slrItemChatSenderBinding.chatMessageContainer;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatMessageContainer");
            Object object2 = object.getLayoutParams();
            if (object2 != null) {
                Object object3;
                ConstraintLayout constraintLayout2 = object;
                object = (ConstraintLayout.LayoutParams)object2;
                ((ConstraintLayout.LayoutParams)object2).topMargin = 0;
                constraintLayout2.setLayoutParams((ViewGroup.LayoutParams)object);
                object = chatMessage.getDate();
                if (object != null) {
                    slrItemChatSenderBinding.slChatMessageTimeTV.setText((CharSequence)DateUtil.INSTANCE.toShort((Date)object));
                }
                boolean bl = object4.isNextMessageSameSender(chatMessage);
                if (object4.isPreviousMessageSameSender(chatMessage) && (object2 = chatMessage.getStatus()) != (object3 = (object3 = object4.getPreviousMessage()) == null ? null : object3.getStatus())) {
                    chatMessagesAdapter.listener.onPreviousMessage(object4.getLayoutPosition() + 1);
                }
                boolean bl2 = object4.getNextMessage() != null;
                object3 = slrItemChatSenderBinding.chatMessageContainer;
                Drawable drawable2 = bl2 && bl ? object4.getDefaultBackground() : object4.getLastBackground();
                object3.setBackground(drawable2);
                if (bl2) {
                    AppCompatImageView appCompatImageView = slrItemChatSenderBinding.slChatMessageStatusIV;
                    Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slChatMessageStatusIV");
                    ViewExtensionsKt.gone((View)appCompatImageView);
                }
                switch (WhenMappings.$EnumSwitchMapping$0[chatMessage.getStatus().ordinal()]) {
                    default: {
                        MessageSenderViewHolder messageSenderViewHolder2 = object4;
                        AppCompatImageView appCompatImageView = slrItemChatSenderBinding.slChatMessageStatusIV;
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slChatMessageStatusIV");
                        ViewExtensionsKt.gone((View)appCompatImageView);
                        messageSenderViewHolder2.itemView.setAlpha(1.0f);
                        ViewExtensionsKt.gone((View)messageSenderViewHolder2.chatAlertImage);
                        ViewExtensionsKt.gone((View)messageSenderViewHolder2.sendingFailedText);
                        break;
                    }
                    case 5: {
                        MessageSenderViewHolder messageSenderViewHolder3 = object4;
                        AppCompatImageView appCompatImageView = slrItemChatSenderBinding.slChatMessageStatusIV;
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slChatMessageStatusIV");
                        ViewExtensionsKt.gone((View)appCompatImageView);
                        ViewExtensionsKt.gone((View)messageSenderViewHolder3.chatAlertImage);
                        ViewExtensionsKt.gone((View)messageSenderViewHolder3.sendingFailedText);
                        break;
                    }
                    case 4: {
                        MessageSenderViewHolder messageSenderViewHolder4 = object4;
                        AppCompatImageView appCompatImageView = slrItemChatSenderBinding.slChatMessageStatusIV;
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slChatMessageStatusIV");
                        ViewExtensionsKt.gone((View)appCompatImageView);
                        ViewExtensionsKt.visible((View)messageSenderViewHolder4.chatAlertImage);
                        ViewExtensionsKt.visible((View)messageSenderViewHolder4.sendingFailedText);
                        messageSenderViewHolder4.chatAlertImage.setOnClickListener(arg_0 -> MessageSenderViewHolder.bind$lambda-10$lambda-6(chatMessagesAdapter, chatMessage, arg_0));
                        break;
                    }
                    case 3: {
                        MessageSenderViewHolder messageSenderViewHolder5 = object4;
                        AppCompatImageView appCompatImageView = slrItemChatSenderBinding.slChatMessageStatusIV;
                        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"slChatMessageStatusIV");
                        ViewExtensionsKt.gone((View)appCompatImageView);
                        messageSenderViewHolder5.itemView.setAlpha(0.7f);
                        ViewExtensionsKt.gone((View)messageSenderViewHolder5.chatAlertImage);
                        ViewExtensionsKt.gone((View)messageSenderViewHolder5.sendingFailedText);
                        break;
                    }
                    case 2: {
                        if (!object4.isPortrait()) break;
                        object4.setMessageStatusIcon(slrItemChatSenderBinding, bl2, R.drawable.slr_ic_checked_circle);
                        break;
                    }
                    case 1: {
                        if (!object4.isPortrait()) break;
                        object4.setMessageStatusIcon(slrItemChatSenderBinding, bl2, R.drawable.slr_ic_unchecked_circle);
                    }
                }
                Object object4 = chatMessage.getAnyData();
                if (object4 != null) {
                    block21: {
                        SlrItemChatSenderBinding slrItemChatSenderBinding2 = slrItemChatSenderBinding;
                        SlrItemChatSenderBinding slrItemChatSenderBinding3 = slrItemChatSenderBinding2;
                        SlrItemChatSenderBinding slrItemChatSenderBinding4 = slrItemChatSenderBinding2;
                        SlrItemChatSenderBinding slrItemChatSenderBinding5 = slrItemChatSenderBinding2;
                        SlrItemChatSenderBinding slrItemChatSenderBinding6 = slrItemChatSenderBinding2;
                        SlrItemChatSenderBinding slrItemChatSenderBinding7 = slrItemChatSenderBinding2;
                        Object object5 = object4;
                        object4 = (Pair)object5;
                        MaterialTextView materialTextView2 = slrItemChatSenderBinding4.slChatMessageReplyToTv;
                        Resources resources = slrItemChatSenderBinding.getRoot().getResources();
                        int n = R.string.slr_chat_message_you_reply_to;
                        Object[] objectArray = new Object[1];
                        objectArray[0] = ((TinodeContact)object4.getFirst()).getChatName();
                        materialTextView2.setText((CharSequence)resources.getString(n, objectArray));
                        slrItemChatSenderBinding5.slChatMessageContentReply.setText((CharSequence)((ChatMessage)object4.getSecond()).getText());
                        MaterialTextView materialTextView3 = slrItemChatSenderBinding6.slChatMessageReplyToTv;
                        Intrinsics.checkNotNullExpressionValue((Object)materialTextView3, (String)"slChatMessageReplyToTv");
                        ViewExtensionsKt.visible((View)materialTextView3);
                        ConstraintLayout constraintLayout3 = slrItemChatSenderBinding7.slChatMessageReplyContainer;
                        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout3, (String)"slChatMessageReplyContainer");
                        ViewExtensionsKt.visible((View)constraintLayout3);
                        object4 = slrItemChatSenderBinding3.chatMessageContainer;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"chatMessageContainer");
                        chatMessage = object4.getLayoutParams();
                        if (chatMessage == null) break block21;
                        Object object6 = object4;
                        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)chatMessage;
                        ConstraintLayout.LayoutParams layoutParams2 = layoutParams;
                        ConstraintLayout.LayoutParams layoutParams3 = layoutParams;
                        int n2 = (int)slrItemChatSenderBinding.getRoot().getResources().getDimension(R.dimen.slr_chat_reply_message_top_margin);
                        layoutParams2.topMargin = n2;
                        object6.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
                        object4 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    try {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                    }
                    catch (Throwable throwable) {
                        object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Result.box-impl((Object)object4);
                }
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }

        @Override
        public void setPreviousMessageSameSender() {
            this.binding.chatMessageContainer.setBackground(this.getDefaultBackground());
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=3, d1={}, d2={})
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChatMessageStatus.values().length];
                nArray[ChatMessageStatus.Delivered.ordinal()] = 1;
                nArray[ChatMessageStatus.Read.ordinal()] = 2;
                nArray[ChatMessageStatus.Sending.ordinal()] = 3;
                nArray[ChatMessageStatus.Failed.ordinal()] = 4;
                nArray[ChatMessageStatus.Success.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageReceiverViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "message", "", "bind", "setPreviousMessageSameSender", "Lio/streamlayer/sdk/databinding/SlrItemChatReceiverBinding;", "binding", "Lio/streamlayer/sdk/databinding/SlrItemChatReceiverBinding;", "Landroid/graphics/drawable/Drawable;", "lastBackground", "Landroid/graphics/drawable/Drawable;", "getLastBackground", "()Landroid/graphics/drawable/Drawable;", "currentMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;Landroid/view/View;)V", "ReceiveMessageTouchListener", "sdk_originalRelease"})
    @SuppressLint(value={"ClickableViewAccessibility"})
    public final class MessageReceiverViewHolder
    extends MessageViewHolder {
        @NotNull
        private final SlrItemChatReceiverBinding binding;
        @Nullable
        private final Drawable lastBackground;
        @Nullable
        private ChatMessage currentMessage;

        public MessageReceiverViewHolder(View view2) {
            ReceiveMessageTouchListener receiveMessageTouchListener;
            Intrinsics.checkNotNullParameter((Object)ChatMessagesAdapter.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super((ChatMessagesAdapter)((Object)ChatMessagesAdapter.this), view2);
            ChatMessagesAdapter.this = SlrItemChatReceiverBinding.bind(view2);
            Intrinsics.checkNotNullExpressionValue((Object)ChatMessagesAdapter.this, (String)"bind(itemView)");
            this.binding = ChatMessagesAdapter.this;
            this.lastBackground = ContextCompat.getDrawable((Context)view2.getContext(), (int)R.drawable.slr_shape_chat_bubble_contact_last);
            Object object2 = ChatMessagesAdapter.this;
            ChatMessagesAdapter.this = receiveMessageTouchListener;
            receiveMessageTouchListener = new ReceiveMessageTouchListener(this);
            ((SlrItemChatReceiverBinding)object2).chatMessageContainer.setOnTouchListener((View.OnTouchListener)ChatMessagesAdapter.this);
            ((SlrItemChatReceiverBinding)object2).chatMessageContent.setOnTouchListener((View.OnTouchListener)ChatMessagesAdapter.this);
        }

        @Override
        @Nullable
        public Drawable getLastBackground() {
            return this.lastBackground;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            void var0_6;
            Object object;
            boolean bl;
            void var1_7;
            MessageReceiverViewHolder messageReceiverViewHolder = this;
            void v1 = var1_7;
            Intrinsics.checkNotNullParameter((Object)v1, (String)"message");
            super.bind((ChatMessage)v1);
            this.currentMessage = var1_7;
            Object object2 = var1_7.getSender();
            SlrItemChatReceiverBinding slrItemChatReceiverBinding = messageReceiverViewHolder.binding;
            ChatMessagesAdapter chatMessagesAdapter = messageReceiverViewHolder.ChatMessagesAdapter.this;
            boolean bl2 = messageReceiverViewHolder.getNextMessage() != null;
            SlrItemChatReceiverBinding slrItemChatReceiverBinding2 = slrItemChatReceiverBinding;
            ConstraintLayout constraintLayout = slrItemChatReceiverBinding2.slChatMessageReplyContainer;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"slChatMessageReplyContainer");
            ViewExtensionsKt.gone((View)constraintLayout);
            slrItemChatReceiverBinding2.chatMessageAuthorName.setCompoundDrawablesRelativeWithIntrinsicBounds(0, 0, 0, 0);
            List<ChatMessage> list2 = var1_7.getReplyEmoji();
            if (!(list2 == null || list2.isEmpty()) && ChatHelper.INSTANCE.isReplyEmojiEnable()) {
                EmojiTextView emojiTextView = slrItemChatReceiverBinding.slChatMessageEmojiReaction;
                List<ChatMessage> list3 = var1_7.getReplyEmoji();
                list3 = list3 == null || (list3 = (ChatMessage)CollectionsKt.first(list3)) == null ? null : ((ChatMessage)((Object)list3)).getText();
                emojiTextView.setText((CharSequence)((Object)list3));
                LinearLayoutCompat linearLayoutCompat = slrItemChatReceiverBinding.slChatMessageEmojiContainer;
                Intrinsics.checkNotNullExpressionValue((Object)linearLayoutCompat, (String)"slChatMessageEmojiContainer");
                list3 = var1_7.getReplyEmoji();
                bl = list3 != null && !list3.isEmpty();
                ViewExtensionsKt.visibleIf((View)linearLayoutCompat, bl);
            }
            boolean bl3 = this.isPreviousMessageSameSender((ChatMessage)var1_7);
            bl = this.isNextMessageSameSender((ChatMessage)var1_7);
            SlrItemChatReceiverBinding slrItemChatReceiverBinding3 = slrItemChatReceiverBinding;
            ImageView imageView2 = slrItemChatReceiverBinding3.chatMessageAuthorAvatar;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"chatMessageAuthorAvatar");
            ViewExtensionsKt.visibleIfElse$default((View)imageView2, bl ^ true, 0, 2, null);
            ConstraintLayout constraintLayout2 = slrItemChatReceiverBinding3.chatMessageContainer;
            Drawable drawable2 = !bl ? this.getLastBackground() : this.getDefaultBackground();
            constraintLayout2.setBackground(drawable2);
            if (object2 != null) {
                if (!bl) {
                    ImageView imageView3 = slrItemChatReceiverBinding.chatMessageAuthorAvatar;
                    Intrinsics.checkNotNullExpressionValue((Object)imageView3, (String)"chatMessageAuthorAvatar");
                    ProfileExtensionsKt.loadContactAvatar(imageView3, (TinodeContact)object2);
                }
                if (!bl3) {
                    slrItemChatReceiverBinding.chatMessageAuthorName.setText((CharSequence)((TinodeContact)object2).getChatName());
                }
                object2 = slrItemChatReceiverBinding.chatMessageAuthorName;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"chatMessageAuthorName");
                bl = chatMessagesAdapter.getMode() == Mode.Group && !bl3;
                ViewExtensionsKt.visibleIf((View)object2, bl);
            }
            if (bl3) {
                void var6_20;
                object2 = var1_7.getStatus();
                ChatMessage chatMessage2 = this.getPreviousMessage();
                if (chatMessage2 == null) {
                    Object var6_18 = null;
                } else {
                    ChatMessageStatus chatMessageStatus = chatMessage2.getStatus();
                }
                if (object2 != var6_20) {
                    chatMessagesAdapter.listener.onPreviousMessage(this.getLayoutPosition() + 1);
                }
            }
            if (!bl2 && !this.isPortrait()) {
                View view2 = this.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView");
                ViewExtensionsKt.showAnimate(view2, true);
            }
            if ((object = var1_7.getAnyData()) == null) {
                return;
            }
            SlrItemChatReceiverBinding slrItemChatReceiverBinding9 = slrItemChatReceiverBinding;
            slrItemChatReceiverBinding9 = slrItemChatReceiverBinding9;
            slrItemChatReceiverBinding9 = slrItemChatReceiverBinding4;
            slrItemChatReceiverBinding9 = slrItemChatReceiverBinding4;
            slrItemChatReceiverBinding9 = slrItemChatReceiverBinding4;
            slrItemChatReceiverBinding9 = slrItemChatReceiverBinding4;
            Object object3 = object;
            Pair pair = (Pair)object3;
            slrItemChatReceiverBinding6.chatMessageAuthorName.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.slr_ic_chat_you_reply, 0, 0, 0);
            slrItemChatReceiverBinding7.slChatMessageContentReply.setText((CharSequence)((ChatMessage)pair.getSecond()).getText());
            ShapeableImageView shapeableImageView = slrItemChatReceiverBinding8.slChatMessageReplyAvatar;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)shapeableImageView, (String)"slChatMessageReplyAvatar");
                ProfileExtensionsKt.loadContactAvatar((ImageView)shapeableImageView, (TinodeContact)pair.getFirst());
                slrItemChatReceiverBinding9.slChatMessageReplyName.setText((CharSequence)((TinodeContact)pair.getFirst()).getChatName());
                ConstraintLayout constraintLayout3 = slrItemChatReceiverBinding5.slChatMessageReplyContainer;
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout3, (String)"slChatMessageReplyContainer");
                ViewExtensionsKt.visible((View)constraintLayout3);
                Object object4 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Result.box-impl((Object)var0_6);
        }

        @Override
        public void setPreviousMessageSameSender() {
            SlrItemChatReceiverBinding slrItemChatReceiverBinding = this.binding;
            ImageView imageView2 = slrItemChatReceiverBinding.chatMessageAuthorAvatar;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"chatMessageAuthorAvatar");
            ViewExtensionsKt.invisible((View)imageView2);
            slrItemChatReceiverBinding.chatMessageContainer.setBackground(this.getDefaultBackground());
        }

        @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\u001c\u0010\f\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016R\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00148B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageReceiverViewHolder$ReceiveMessageTouchListener;", "Landroid/view/View$OnTouchListener;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "currentMessage", "", "startShowPopUp", "animationHideReply", "Landroid/view/View;", "v", "Landroid/view/MotionEvent;", "event", "", "onTouch", "", "prevX", "F", "maxMargin", "Lkotlinx/coroutines/Job;", "hideReplyJob", "Lkotlinx/coroutines/Job;", "Landroidx/lifecycle/LifecycleCoroutineScope;", "lifecycleScope$delegate", "Lkotlin/Lazy;", "getLifecycleScope", "()Landroidx/lifecycle/LifecycleCoroutineScope;", "lifecycleScope", "", "swipeThreshold", "I", "<init>", "(Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageReceiverViewHolder;)V", "sdk_originalRelease"})
        public final class ReceiveMessageTouchListener
        implements View.OnTouchListener {
            private float prevX;
            private float maxMargin;
            @Nullable
            private Job hideReplyJob;
            @Nullable
            private Job startShowPopUp;
            @NotNull
            private final Lazy lifecycleScope$delegate;
            private final int swipeThreshold;
            final /* synthetic */ MessageReceiverViewHolder this$0;

            public ReceiveMessageTouchListener(MessageReceiverViewHolder messageReceiverViewHolder) {
                ReceiveMessageTouchListener receiveMessageTouchListener = this;
                MessageReceiverViewHolder messageReceiverViewHolder2 = messageReceiverViewHolder;
                Intrinsics.checkNotNullParameter((Object)((Object)messageReceiverViewHolder2), (String)"this$0");
                this.this$0 = messageReceiverViewHolder2;
                receiveMessageTouchListener.maxMargin = messageReceiverViewHolder.binding.getRoot().getResources().getDimension(R.dimen.slr_chat_message_reply_margin) + messageReceiverViewHolder.binding.getRoot().getResources().getDimension(R.dimen.slr_chat_reply_button);
                receiveMessageTouchListener.lifecycleScope$delegate = LazyKt.lazy((Function0)new Function0<LifecycleCoroutineScope>(messageReceiverViewHolder){
                    final /* synthetic */ MessageReceiverViewHolder this$0;
                    {
                        this.this$0 = messageReceiverViewHolder;
                        super(0);
                    }

                    @Nullable
                    public final LifecycleCoroutineScope invoke() {
                        ConstraintLayout constraintLayout = MessageReceiverViewHolder.access$getBinding$p(this_.this$0).getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                        lifecycleScope.2 this_ = ViewKt.findViewTreeLifecycleOwner((View)constraintLayout);
                        return this_ == null ? null : LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)this_);
                    }
                });
                receiveMessageTouchListener.swipeThreshold = 15;
            }

            private final LifecycleCoroutineScope getLifecycleScope() {
                return (LifecycleCoroutineScope)this.lifecycleScope$delegate.getValue();
            }

            private final void startShowPopUp(ChatMessage chatMessage) {
                Object object = this.startShowPopUp;
                if (object != null) {
                    Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
                }
                object = this.getLifecycleScope();
                if (object == null) {
                    chatMessage = null;
                } else {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
                    Job job = object;
                    object = function2;
                    MessageReceiverViewHolder messageReceiverViewHolder = this.this$0;
                    function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(chatMessage, messageReceiverViewHolder.ChatMessagesAdapter.this, messageReceiverViewHolder, null){
                        int label;
                        final /* synthetic */ ChatMessage $currentMessage;
                        final /* synthetic */ ChatMessagesAdapter this$0;
                        final /* synthetic */ MessageReceiverViewHolder this$1;
                        {
                            this.$currentMessage = chatMessage;
                            this.this$0 = chatMessagesAdapter;
                            this.this$1 = messageReceiverViewHolder;
                            super(2, continuation);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            int n = this_.label;
                            if (n != 0) {
                                if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                ResultKt.throwOnFailure((Object)object);
                            } else {
                                ResultKt.throwOnFailure((Object)object);
                                this_.label = 1;
                                if (DelayKt.delay((long)500L, (Continuation)this_) == object2) {
                                    return object2;
                                }
                            }
                            if (this_.$currentMessage == null || ChatMessagesAdapter.access$getListener$p(this_.this$0) == null) return Unit.INSTANCE;
                            ChatMessageActionListener chatMessageActionListener = ChatMessagesAdapter.access$getListener$p(this_.this$0);
                            startShowPopUp.1 v1 = this_;
                            startShowPopUp.1 this_ = MessageReceiverViewHolder.access$getBinding$p(v1.this$1).getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)this_), (String)"binding.root");
                            chatMessageActionListener.onMessageReaction((View)this_, v1.$currentMessage);
                            return Unit.INSTANCE;
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                            startShowPopUp.1 v0 = object2;
                            Object object2 = v0.$currentMessage;
                            object = v0.this$0;
                            MessageReceiverViewHolder messageReceiverViewHolder = v0.this$1;
                            return new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                            return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                        }
                    };
                    chatMessage = BuildersKt.launch$default((CoroutineScope)job, null, null, (Function2)object, (int)3, null);
                }
                this.startShowPopUp = chatMessage;
            }

            private final void animationHideReply() {
                ConstraintSet constraintSet = new ConstraintSet();
                Object object = object.this$0;
                constraintSet.clone(((MessageReceiverViewHolder)((Object)object)).binding.getRoot());
                constraintSet.setMargin(((MessageReceiverViewHolder)((Object)object)).binding.chatMessageLayout.getId(), 6, 0);
                Object object2 = object;
                ConstraintLayout constraintLayout = ((MessageReceiverViewHolder)((Object)object2)).binding.getRoot();
                ChangeBounds changeBounds = new ChangeBounds();
                changeBounds.setDuration(100L);
                TransitionManager.beginDelayedTransition((ViewGroup)constraintLayout, (Transition)changeBounds);
                constraintSet.applyTo(((MessageReceiverViewHolder)((Object)object2)).binding.getRoot());
            }

            public static final /* synthetic */ void access$animationHideReply(ReceiveMessageTouchListener receiveMessageTouchListener) {
                receiveMessageTouchListener.animationHideReply();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean onTouch(@Nullable View view2, @Nullable MotionEvent motionEvent) {
                void var2_16;
                if (var2_16 == null) return true;
                int n = var2_16.getAction();
                if (n != 0) {
                    void var1_15;
                    LifecycleCoroutineScope lifecycleCoroutineScope;
                    if (n != 2) return true;
                    Job job = this.hideReplyJob;
                    if (job != null) {
                        Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    }
                    if (Math.abs(Math.abs(var2_16.getRawX()) - Math.abs(this.prevX)) > (float)this.swipeThreshold) {
                        Job job2 = this.startShowPopUp;
                        if (job2 != null) {
                            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                        }
                        ConstraintLayout constraintLayout = ((MessageReceiverViewHolder)this.this$0).binding.chatMessageLayout;
                        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.chatMessageLayout");
                        ViewGroup.LayoutParams layoutParams = constraintLayout.getLayoutParams();
                        int n2 = layoutParams instanceof ViewGroup.MarginLayoutParams ? MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)layoutParams)) : 0;
                        if ((float)n2 <= this.maxMargin) {
                            ConstraintLayout constraintLayout2 = ((MessageReceiverViewHolder)this.this$0).binding.chatMessageLayout;
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.chatMessageLayout");
                            ViewGroup.LayoutParams layoutParams2 = constraintLayout2.getLayoutParams();
                            if (layoutParams2 == null) throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                            ConstraintLayout.LayoutParams layoutParams3 = (ConstraintLayout.LayoutParams)layoutParams2;
                            layoutParams3.setMarginStart(layoutParams3.getMarginStart() + 30);
                            constraintLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
                        } else {
                            ChatMessage chatMessage;
                            ConstraintLayout constraintLayout3 = ((MessageReceiverViewHolder)this.this$0).binding.chatMessageLayout;
                            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout3, (String)"binding.chatMessageLayout");
                            ViewGroup.LayoutParams layoutParams4 = constraintLayout3.getLayoutParams();
                            if ((float)(layoutParams4 instanceof ViewGroup.MarginLayoutParams ? MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)layoutParams4)) : 0) >= this.maxMargin && (chatMessage = this.this$0.currentMessage) != null) {
                                this.this$0.ChatMessagesAdapter.this.listener.onReply(chatMessage);
                            }
                        }
                        this.prevX = var2_16.getRawX();
                    }
                    if ((lifecycleCoroutineScope = this.getLifecycleScope()) == null) {
                        Object var1_12 = null;
                    } else {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ ReceiveMessageTouchListener this$0;
                            {
                                this.this$0 = receiveMessageTouchListener;
                                super(2, continuation);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                int n = this.label;
                                if (n != 0) {
                                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    ResultKt.throwOnFailure((Object)object);
                                } else {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    if (DelayKt.delay((long)150L, (Continuation)this) == object2) {
                                        return object2;
                                    }
                                }
                                ReceiveMessageTouchListener.access$animationHideReply(this.this$0);
                                return Unit.INSTANCE;
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                                return new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                        Job job3 = BuildersKt.launch$default((CoroutineScope)lifecycleCoroutineScope, null, null, (Function2)function22, (int)3, null);
                    }
                    this.hideReplyJob = var1_15;
                    return true;
                } else {
                    this.prevX = var2_16.getRawX();
                    if (!ChatHelper.INSTANCE.isReactionToMessageEnable()) return true;
                    ReceiveMessageTouchListener receiveMessageTouchListener = this;
                    receiveMessageTouchListener.startShowPopUp(receiveMessageTouchListener.this$0.currentMessage);
                }
                return true;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$MessageParticipantStatusViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ViewHolder;", "Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "data", "", "bind", "Landroidx/appcompat/widget/AppCompatTextView;", "status", "Landroidx/appcompat/widget/AppCompatTextView;", "Landroid/view/View;", "itemView", "<init>", "(Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class MessageParticipantStatusViewHolder
    extends ViewHolder {
        @NotNull
        private final AppCompatTextView status;

        public MessageParticipantStatusViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)((Object)ChatMessagesAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
            AppCompatTextView appCompatTextView = SlrItemChatParticipantStatusBinding.bind((View)view2).slChatMessageParticipantStatusTV;
            Intrinsics.checkNotNullExpressionValue((Object)appCompatTextView, (String)"bind(itemView).slChatMessageParticipantStatusTV");
            this.status = appCompatTextView;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            Object object;
            ChatMessage chatMessage2 = chatMessage;
            Intrinsics.checkNotNullParameter((Object)chatMessage2, (String)"data");
            boolean bl = Intrinsics.areEqual((Object)chatMessage2.getSenderUserId(), (Object)object.ChatMessagesAdapter.this.userId);
            AppCompatTextView appCompatTextView = object.status;
            String string2 = chatMessage.getSubtype();
            if (Intrinsics.areEqual((Object)string2, (Object)"join_chat")) {
                if (bl) {
                    object = object.itemView.getResources().getString(R.string.slr_chat_user_you_joined);
                } else {
                    object = object.itemView.getResources();
                    int n = R.string.slr_chat_user_joined;
                    Object[] objectArray = new Object[1];
                    int n2 = 0;
                    Object object2 = chatMessage.getSender();
                    object2 = object2 == null ? null : ((TinodeContact)object2).getChatName();
                    objectArray[n2] = object2;
                    object = object.getString(n, objectArray);
                }
            } else if (Intrinsics.areEqual((Object)string2, (Object)"left_chat")) {
                if (bl) {
                    object = object.itemView.getResources().getString(R.string.slr_chat_user_you_left);
                } else {
                    object = object.itemView.getResources();
                    int n = R.string.slr_chat_user_left;
                    Object[] objectArray = new Object[1];
                    int n3 = 0;
                    Object object3 = chatMessage.getSender();
                    object3 = object3 == null ? null : ((TinodeContact)object3).getChatName();
                    objectArray[n3] = object3;
                    object = object.getString(n, objectArray);
                }
            } else {
                object = null;
            }
            appCompatTextView.setText((CharSequence)object);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H&J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/messaging/chat/ChatMessagesAdapter$ChatMessageActionListener;", "", "", "position", "", "onPreviousMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "message", "onAlert", "onReply", "Landroid/view/View;", "anchorView", "onMessageReaction", "sdk_originalRelease"})
    public static interface ChatMessageActionListener {
        public void onPreviousMessage(int var1);

        public void onAlert(@NotNull ChatMessage var1);

        public void onReply(@NotNull ChatMessage var1);

        public void onMessageReaction(@NotNull View var1, @NotNull ChatMessage var2);
    }
}

