/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.Index;
import com.google.gson.annotations.SerializedName;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\t\b\u0081\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0015\u001a\u00020\n\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\bT\u0010UJ\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\t\u0010\b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003Je\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003R\u001c\u0010\u0013\u001a\u00020\u00078\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010 \u001a\u0004\b!\u0010\"R\u001c\u0010\u0014\u001a\u00020\u00078\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010 \u001a\u0004\b#\u0010\"R\"\u0010\u0015\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001b\u0010\u0016\u001a\u0004\u0018\u00010\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010)\u001a\u0004\b*\u0010+R\u0019\u0010\u0017\u001a\u00020\u00078\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010 \u001a\u0004\b,\u0010\"R\u001c\u0010\u0018\u001a\u00020\u00078\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010 \u001a\u0004\b-\u0010\"R\u001c\u0010\u0019\u001a\u00020\u00078\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010 \u001a\u0004\b.\u0010\"R\u001c\u0010\u001a\u001a\u00020\u00078\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010 \u001a\u0004\b/\u0010\"R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R0\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u0001058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010<\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010 \u001a\u0004\b=\u0010\"\"\u0004\b>\u0010?R$\u0010A\u001a\u0004\u0018\u00010@8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR$\u0010G\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR*\u0010N\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010M8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010S\u00a8\u0006V"}, d2={"Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "status", "updateStatus", "", "isStatusSubType", "", "component1", "component2", "", "component3", "Ljava/util/Date;", "component4", "component5", "component6", "component7", "component8", "component9", "topicId", "senderUserId", "seqId", "date", "text", "type", "subtype", "replyTo", "copy", "toString", "hashCode", "other", "equals", "Ljava/lang/String;", "getTopicId", "()Ljava/lang/String;", "getSenderUserId", "I", "getSeqId", "()I", "setSeqId", "(I)V", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "getText", "getType", "getSubtype", "getReplyTo", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "getStatus", "()Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "setStatus", "(Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;)V", "", "head", "Ljava/util/Map;", "getHead", "()Ljava/util/Map;", "setHead", "(Ljava/util/Map;)V", "id", "getId", "setId", "(Ljava/lang/String;)V", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "sender", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "getSender", "()Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "setSender", "(Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;)V", "anyData", "Ljava/lang/Object;", "getAnyData", "()Ljava/lang/Object;", "setAnyData", "(Ljava/lang/Object;)V", "", "replyEmoji", "Ljava/util/List;", "getReplyEmoji", "()Ljava/util/List;", "setReplyEmoji", "(Ljava/util/List;)V", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;)V", "sdk_originalRelease"})
@Entity(indices={@Index(value={"chatMessageTopicId", "uuid", "date", "text"})}, primaryKeys={"chatMessageTopicId", "uuid"})
public final class ChatMessage {
    @ColumnInfo(name="chatMessageTopicId")
    @NotNull
    private final String topicId;
    @SerializedName(value="senderId")
    @NotNull
    private final String senderUserId;
    @SerializedName(value="seq")
    @ColumnInfo(name="remoteSeqId")
    private int seqId;
    @Nullable
    private final Date date;
    @NotNull
    private final String text;
    @SerializedName(value="x-slr-type")
    @NotNull
    private final String type;
    @SerializedName(value="x-slr-subtype")
    @NotNull
    private final String subtype;
    @SerializedName(value="x-slr-reply")
    @NotNull
    private final String replyTo;
    @NotNull
    private ChatMessageStatus status;
    @SerializedName(value="head")
    @Ignore
    @Nullable
    private Map<String, String> head;
    @ColumnInfo(name="uuid")
    @NotNull
    private String id;
    @Ignore
    @Nullable
    private TinodeContact sender;
    @Ignore
    @Nullable
    private Object anyData;
    @Ignore
    @Nullable
    private List<ChatMessage> replyEmoji;

    public ChatMessage(@NotNull String string2, @NotNull String string3, int n, @Nullable Date date, @NotNull String string4, @NotNull String string5, @NotNull String string6, @NotNull String string7, @NotNull ChatMessageStatus chatMessageStatus) {
        ChatMessage chatMessage = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"senderUserId");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"text");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string6, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)string7, (String)"replyTo");
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        this.topicId = string2;
        this.senderUserId = string3;
        this.seqId = n;
        this.date = date;
        this.text = string4;
        this.type = string5;
        this.subtype = string6;
        this.replyTo = string7;
        chatMessage.status = chatMessageStatus;
        String string8 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"randomUUID().toString()");
        chatMessage.id = string8;
    }

    public /* synthetic */ ChatMessage(String string2, String string3, int n, Date date, String string4, String string5, String string6, String string7, ChatMessageStatus chatMessageStatus, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            date = null;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "";
        }
        if ((n2 & 0x20) != 0) {
            string5 = "";
        }
        if ((n2 & 0x40) != 0) {
            string6 = "";
        }
        if ((n2 & 0x80) != 0) {
            string7 = "";
        }
        if ((n2 & 0x100) != 0) {
            chatMessageStatus = ChatMessageStatus.Uninitialized;
        }
        this(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    public static /* synthetic */ ChatMessage copy$default(ChatMessage chatMessage, String string2, String string3, int n, Date date, String string4, String string5, String string6, String string7, ChatMessageStatus chatMessageStatus, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = chatMessage.topicId;
        }
        if ((n2 & 2) != 0) {
            string3 = chatMessage.senderUserId;
        }
        if ((n2 & 4) != 0) {
            n = chatMessage.seqId;
        }
        if ((n2 & 8) != 0) {
            date = chatMessage.date;
        }
        if ((n2 & 0x10) != 0) {
            string4 = chatMessage.text;
        }
        if ((n2 & 0x20) != 0) {
            string5 = chatMessage.type;
        }
        if ((n2 & 0x40) != 0) {
            string6 = chatMessage.subtype;
        }
        if ((n2 & 0x80) != 0) {
            string7 = chatMessage.replyTo;
        }
        if ((n2 & 0x100) != 0) {
            chatMessageStatus = chatMessage.status;
        }
        return chatMessage.copy(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    @NotNull
    public final String getTopicId() {
        return this.topicId;
    }

    @NotNull
    public final String getSenderUserId() {
        return this.senderUserId;
    }

    public final int getSeqId() {
        return this.seqId;
    }

    public final void setSeqId(int n) {
        this.seqId = n;
    }

    @Nullable
    public final Date getDate() {
        return this.date;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final String getReplyTo() {
        return this.replyTo;
    }

    @NotNull
    public final ChatMessageStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"<set-?>");
        this.status = chatMessageStatus;
    }

    @Nullable
    public final Map<String, String> getHead() {
        return this.head;
    }

    public final void setHead(@Nullable Map<String, String> map2) {
        this.head = map2;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.id = string2;
    }

    @Nullable
    public final TinodeContact getSender() {
        return this.sender;
    }

    public final void setSender(@Nullable TinodeContact tinodeContact) {
        this.sender = tinodeContact;
    }

    @Nullable
    public final Object getAnyData() {
        return this.anyData;
    }

    public final void setAnyData(@Nullable Object object) {
        this.anyData = object;
    }

    @Nullable
    public final List<ChatMessage> getReplyEmoji() {
        return this.replyEmoji;
    }

    public final void setReplyEmoji(@Nullable List<ChatMessage> list2) {
        this.replyEmoji = list2;
    }

    @NotNull
    public final ChatMessage updateStatus(@NotNull ChatMessageStatus chatMessageStatus) {
        ChatMessage chatMessage = this;
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        chatMessage.setStatus(chatMessageStatus);
        return chatMessage;
    }

    public final boolean isStatusSubType() {
        return ArraysKt.contains((Object[])new String[]{"left_chat", "join_chat"}, (Object)this.subtype);
    }

    @NotNull
    public final String component1() {
        return this.topicId;
    }

    @NotNull
    public final String component2() {
        return this.senderUserId;
    }

    public final int component3() {
        return this.seqId;
    }

    @Nullable
    public final Date component4() {
        return this.date;
    }

    @NotNull
    public final String component5() {
        return this.text;
    }

    @NotNull
    public final String component6() {
        return this.type;
    }

    @NotNull
    public final String component7() {
        return this.subtype;
    }

    @NotNull
    public final String component8() {
        return this.replyTo;
    }

    @NotNull
    public final ChatMessageStatus component9() {
        return this.status;
    }

    @NotNull
    public final ChatMessage copy(@NotNull String string2, @NotNull String string3, int n, @Nullable Date date, @NotNull String string4, @NotNull String string5, @NotNull String string6, @NotNull String string7, @NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"senderUserId");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"text");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string6, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)string7, (String)"replyTo");
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        return new ChatMessage(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    @NotNull
    public String toString() {
        return "ChatMessage(topicId=" + this.topicId + ", senderUserId=" + this.senderUserId + ", seqId=" + this.seqId + ", date=" + this.date + ", text=" + this.text + ", type=" + this.type + ", subtype=" + this.subtype + ", replyTo=" + this.replyTo + ", status=" + (Object)((Object)this.status) + ')';
    }

    public int hashCode() {
        ChatMessage chatMessage = this;
        int n = ((chatMessage.topicId.hashCode() * 31 + this.senderUserId.hashCode()) * 31 + Integer.hashCode(this.seqId)) * 31;
        Date date = chatMessage.date;
        int n2 = date == null ? 0 : date.hashCode();
        return (((((n + n2) * 31 + this.text.hashCode()) * 31 + this.type.hashCode()) * 31 + this.subtype.hashCode()) * 31 + this.replyTo.hashCode()) * 31 + this.status.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChatMessage)) {
            return false;
        }
        object = (ChatMessage)object;
        if (!Intrinsics.areEqual((Object)this.topicId, (Object)((ChatMessage)object).topicId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.senderUserId, (Object)((ChatMessage)object).senderUserId)) {
            return false;
        }
        if (this.seqId != ((ChatMessage)object).seqId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)((ChatMessage)object).date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((ChatMessage)object).text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((ChatMessage)object).type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subtype, (Object)((ChatMessage)object).subtype)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.replyTo, (Object)((ChatMessage)object).replyTo)) {
            return false;
        }
        return this.status == ((ChatMessage)object).status;
    }
}

