/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.messaging.Topic;
import io.streamlayer.sdk.model.messaging.TopicPrivateData;
import io.streamlayer.sdk.model.messaging.TopicPublicData;
import io.streamlayer.sdk.model.messaging.TopicType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pbx.Model;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u0002*\u0004\u0018\u00010\u0005H\u0000\u001a\f\u0010\t\u001a\u00020\b*\u00020\u0007H\u0000\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\b*\u00020\f2\n\b\u0002\u0010\u0001\u001a\u0004\u0018\u00010\u0000H\u0000\u001a\u000e\u0010\u000f\u001a\u00020\u000e*\u0004\u0018\u00010\rH\u0000\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\u0010H\u0000\"\u0016\u0010\u0011\u001a\u00020\u00008\u0000@\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0016\u0010\u0013\u001a\u00020\u00008\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\"\u0016\u0010\u0014\u001a\u00020\u00008\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"", "topicId", "", "isP2PTopic", "isGroupTopic", "Lio/streamlayer/sdk/model/messaging/Access;", "isOwner", "Lio/streamlayer/sdk/model/messaging/ChatRelation;", "Lio/streamlayer/sdk/model/messaging/Topic;", "toDomain", "Lpbx/Model$TopicSub;", "toTopic", "Lpbx/Model$ServerMeta;", "Lio/streamlayer/sdk/model/messaging/TopicPublicData;", "Lio/streamlayer/sdk/model/messaging/TopicType;", "toTopicType", "Lpbx/Model$AccessMode;", "TAG_WP", "Ljava/lang/String;", "P2P_PREFIX", "GROUP_PREFIX", "sdk_originalRelease"})
public final class TopicKt {
    @NotNull
    public static final String TAG_WP = "voiceChatDev7:";
    @NotNull
    private static final String P2P_PREFIX = "usr";
    @NotNull
    private static final String GROUP_PREFIX = "grp";

    public static final boolean isP2PTopic(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"topicId");
        return StringsKt.startsWith$default((String)string3, (String)P2P_PREFIX, (boolean)false, (int)2, null);
    }

    public static final boolean isGroupTopic(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"topicId");
        return StringsKt.startsWith$default((String)string3, (String)GROUP_PREFIX, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOwner(@Nullable Access access) {
        if (access == null) {
            return false;
        }
        if (!StringsKt.contains$default((CharSequence)access.getGiven(), (CharSequence)"O", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Topic toDomain(@NotNull ChatRelation iterator) {
        boolean bl;
        ArrayList arrayList;
        Iterator iterator2 = iterator;
        Intrinsics.checkNotNullParameter(iterator2, (String)"<this>");
        Object object = CollectionsKt.toSet(((ChatRelation)((Object)iterator2)).getChatParticipantCrossRef());
        for (TinodeContact tinodeContact : ((ChatRelation)((Object)iterator2)).getParticipants()) {
            Access access;
            void var5_18;
            ChatParticipantCrossRef chatParticipantCrossRef;
            block10: {
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Object t = iterator3.next();
                    ChatParticipantCrossRef chatParticipantCrossRef2 = (ChatParticipantCrossRef)t;
                    if (!Intrinsics.areEqual((Object)tinodeContact.getChatUserId(), (Object)chatParticipantCrossRef2.getChatUserId())) continue;
                    break block10;
                }
                Object var5_20 = null;
            }
            if ((chatParticipantCrossRef = (ChatParticipantCrossRef)var5_18) == null || (access = chatParticipantCrossRef.getAccess()) == null) continue;
            tinodeContact.setAccess(access);
        }
        Iterator iterator4 = iterator;
        object = ((ChatRelation)((Object)iterator4)).getData();
        ((Topic)object).setParticipants(((ChatRelation)((Object)iterator)).getParticipants());
        Iterator iterator5 = arrayList;
        arrayList = new ArrayList();
        for (Object t : ((ChatRelation)((Object)iterator4)).getMessages()) {
            ChatMessage chatMessage = (ChatMessage)t;
            if (!(chatMessage.getStatus() != ChatMessageStatus.Failed && !chatMessage.isStatusSubType())) continue;
            iterator5.add(t);
        }
        if (!(iterator5 = iterator5.iterator()).hasNext()) {
            iterator5 = null;
        } else {
            void var3_7;
            Iterator iterator6 = iterator5;
            Object t = iterator6.next();
            if (iterator6.hasNext()) {
                int n = ((ChatMessage)t).getSeqId();
                do {
                    Object t2;
                    int n2;
                    int n3;
                    if (n3 >= (n2 = ((ChatMessage)(t2 = iterator5.next())).getSeqId())) continue;
                    Object t3 = t2;
                    n3 = n2;
                } while (iterator5.hasNext());
            }
            iterator5 = var3_7;
        }
        ((Topic)object).setLastMessage((ChatMessage)((Object)iterator5));
        iterator = ((ChatRelation)((Object)iterator)).getMessages();
        if (!(iterator instanceof Collection) || !iterator.isEmpty()) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                if (!(Intrinsics.areEqual((Object)((ChatMessage)iterator.next()).getType(), (Object)"invite") ^ true)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        Object object2 = object;
        ((Topic)object2).setHasMessages(bl);
        return object2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Topic toTopic(@NotNull Model.TopicSub object) {
        void var0_4;
        Topic topic2;
        Date date;
        Date date2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Object object2 = GsonUtil.INSTANCE;
        TopicPublicData topicPublicData = (TopicPublicData)((GsonUtil)object2).getDefaultGson().fromJson(object.getPublic().toStringUtf8(), TopicPublicData.class);
        object2 = (TopicPrivateData)((GsonUtil)object2).getDefaultGson().fromJson(object.getPrivate().toStringUtf8(), TopicPrivateData.class);
        String string2 = object.getTopic();
        String string3 = topicPublicData == null ? null : topicPublicData.getFn();
        if (string3 == null && (topicPublicData == null || (string3 = topicPublicData.getTitle()) == null)) {
            string3 = "";
        }
        Object object3 = object;
        int n = object3.getSeqId();
        int n2 = object3.getReadId();
        int n3 = object3.getRecvId();
        Date date3 = date2;
        date2 = new Date(object.getUpdatedAt());
        Date date4 = date;
        date = new Date(object.getTouchedAt());
        TopicType topicType = TopicKt.toTopicType(topicPublicData);
        Model.AccessMode accessMode = object.getAcs();
        Intrinsics.checkNotNullExpressionValue((Object)accessMode, (String)"this.acs");
        Access access = TopicKt.toDomain(accessMode);
        Topic topic3 = topic2;
        String string4 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"topic");
        topic2 = new Topic(string4, string3, n, n2, n3, date3, date4, access, topicType, (TopicPrivateData)object2);
        if (topicPublicData == null) {
            Object var0_2 = null;
        } else {
            String string5 = topicPublicData.getWatchPartyStreamId();
        }
        Topic topic4 = topic3;
        topic4.setWatchPartyStreamId((String)var0_4);
        return topic4;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Topic toTopic(@NotNull Model.ServerMeta object, @Nullable String string2) {
        void var0_4;
        Topic topic2;
        Date date;
        Date date2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        GsonUtil gsonUtil = GsonUtil.INSTANCE;
        TopicPublicData topicPublicData = (TopicPublicData)gsonUtil.getDefaultGson().fromJson(object.getDesc().getPublic().toStringUtf8(), TopicPublicData.class);
        TopicPrivateData topicPrivateData = (TopicPrivateData)gsonUtil.getDefaultGson().fromJson(object.getDesc().getPrivate().toStringUtf8(), TopicPrivateData.class);
        if (string3 == null) {
            string3 = object.getTopic();
        }
        String string4 = topicPublicData == null ? null : topicPublicData.getFn();
        if (string4 == null && (topicPublicData == null || (string4 = topicPublicData.getTitle()) == null)) {
            string4 = "";
        }
        Object object2 = object;
        int n = object2.getDesc().getSeqId();
        int n2 = object2.getDesc().getReadId();
        int n3 = object2.getDesc().getRecvId();
        Date date3 = date2;
        date2 = new Date(object.getDesc().getUpdatedAt());
        Date date4 = date;
        date = new Date(object.getDesc().getTouchedAt());
        TopicType topicType = TopicKt.toTopicType(topicPublicData);
        Model.AccessMode accessMode = object.getDesc().getAcs();
        Intrinsics.checkNotNullExpressionValue((Object)accessMode, (String)"this.desc.acs");
        Access access = TopicKt.toDomain(accessMode);
        Topic topic3 = topic2;
        String string5 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"topicId ?: this.topic");
        topic2 = new Topic(string5, string4, n, n2, n3, date3, date4, access, topicType, topicPrivateData);
        if (topicPublicData == null) {
            Object var0_2 = null;
        } else {
            String string6 = topicPublicData.getWatchPartyStreamId();
        }
        Topic topic4 = topic3;
        topic4.setWatchPartyStreamId((String)var0_4);
        return topic4;
    }

    public static /* synthetic */ Topic toTopic$default(Model.ServerMeta serverMeta, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return TopicKt.toTopic(serverMeta, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final TopicType toTopicType(@Nullable TopicPublicData list2) {
        TopicType topicType;
        String string2;
        if (list2 != null && (string2 = ((TopicPublicData)((Object)list2)).getFantasyGroupId()) != null && string2.length() > 0) {
            topicType = TopicType.MANAGED_WP;
            return topicType;
        }
        if (list2 != null && (list2 = ((TopicPublicData)((Object)list2)).getTags()) != null && list2.contains(TAG_WP)) {
            topicType = TopicType.WP;
            return topicType;
        }
        topicType = TopicType.CHAT;
        return topicType;
    }

    @NotNull
    public static final Access toDomain(@NotNull Model.AccessMode object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Model.AccessMode accessMode = object;
        object = accessMode.getWant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"want");
        String string2 = accessMode.getGiven();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"given");
        return new Access((String)object, string2);
    }
}

