/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import com.google.gson.JsonSyntaxException;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.NavigationUtils;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.base.InterfacesKt;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.deeplink.ReferralLink;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.InviteData;
import io.streamlayer.sdk.model.deeplink.Payload;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\f\u0010\u0006\u001a\u00020\u0002*\u00020\u0002H\u0002J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010J3\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001f\u001a\u00020\u0002*\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u000b8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u000b8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010!\u00a8\u0006%"}, d2={"Lio/streamlayer/sdk/deeplink/DeepLinkHandler;", "", "Landroid/content/Intent;", "intent", "Lio/streamlayer/sdk/model/deeplink/DeepLink;", "getDeepLink", "clearDeeplink", "Landroidx/fragment/app/FragmentActivity;", "activity", "", "handleDeepLink", "", "json", "Lio/streamlayer/sdk/model/deeplink/InviteData;", "getInvite", "data", "Landroid/content/Context;", "context", "", "handleInvite", "Lio/streamlayer/sdk/deeplink/DeepLinkRoute;", "route", "Landroid/net/Uri;", "destinationUri", "Lio/streamlayer/sdk/model/deeplink/Payload;", "payload", "buildDeepLinkIntent$sdk_originalRelease", "(Landroid/content/Context;Lio/streamlayer/sdk/deeplink/DeepLinkRoute;Landroid/net/Uri;Lio/streamlayer/sdk/model/deeplink/Payload;)Landroid/content/Intent;", "buildDeepLinkIntent", "applyDeepLink$sdk_originalRelease", "(Landroid/content/Intent;Landroid/net/Uri;Lio/streamlayer/sdk/model/deeplink/Payload;)Landroid/content/Intent;", "applyDeepLink", "DEEP_LINK_URI_DATA", "Ljava/lang/String;", "DEEP_LINK_PAYLOAD_DATA", "<init>", "()V", "sdk_originalRelease"})
public final class DeepLinkHandler {
    @NotNull
    public static final DeepLinkHandler INSTANCE = new DeepLinkHandler();
    @NotNull
    private static final String DEEP_LINK_URI_DATA = "slr_deep_link_uri_data";
    @NotNull
    private static final String DEEP_LINK_PAYLOAD_DATA = "slr_deep_link_payload_data";

    private DeepLinkHandler() {
    }

    private final DeepLink getDeepLink(Intent intent) {
        Object object = (Uri)intent.getParcelableExtra(DEEP_LINK_URI_DATA);
        if (object == null) {
            object = null;
        } else {
            DeepLink deepLink;
            DeepLink deepLink2 = deepLink;
            deepLink = new DeepLink((Uri)object, (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA));
            object = deepLink2;
        }
        return object;
    }

    private final Intent clearDeeplink(Intent intent) {
        Intent intent2 = intent;
        intent2.removeExtra(DEEP_LINK_URI_DATA);
        intent2.removeExtra(DEEP_LINK_PAYLOAD_DATA);
        return intent2;
    }

    public final boolean handleDeepLink(@NotNull Intent intent, @NotNull FragmentActivity object) {
        FragmentActivity fragmentActivity = object;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"activity");
        Object object2 = InterfacesKt.findSdkHost(fragmentActivity);
        if (object2 == null) {
            object2 = null;
        } else {
            boolean bl;
            object = INSTANCE;
            DeepLink deepLink = ((DeepLinkHandler)object).getDeepLink(intent);
            if (deepLink == null) {
                bl = false;
            } else {
                SLRLog sLRLog = SLRLog.INSTANCE;
                String string2 = "DeepLinkHandler";
                StringBuilder stringBuilder = new StringBuilder().append("processDeepLink  hasSdkSchema=");
                Uri uri = intent.getData();
                boolean bl2 = Intrinsics.areEqual((Object)(uri == null ? null : uri.getScheme()), (Object)"streamlayer");
                sLRLog.i(string2, stringBuilder.append(bl2).append(' ').append(deepLink.getUri()).append(' ').append(deepLink.getPayload()).toString());
                super.clearDeeplink(intent);
                object2.processDeepLink(deepLink);
                bl = true;
            }
            object2 = bl;
        }
        if (object2 != null) {
            return (Boolean)object2;
        }
        throw new IllegalStateException("StreamLayerFragment is not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
    }

    @Nullable
    public final InviteData getInvite(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"json");
        try {
            object = ((ReferralLink)GsonUtil.INSTANCE.getDefaultGson().fromJson(string2, ReferralLink.class)).getData();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            object = null;
        }
        return object;
    }

    public final void handleInvite(@NotNull InviteData inviteData, @NotNull Context object) {
        Payload.Invite invite2;
        Context context = object;
        DeepLinkHandler deepLinkHandler = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)inviteData, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SLRLog.INSTANCE.i("DeepLinkHandler", Intrinsics.stringPlus((String)"handleReferralLink link=", (Object)inviteData));
        Object object2 = DeepLinkRoute.INVITE;
        object = invite2;
        invite2 = new Payload.Invite(inviteData);
        context.startActivity(deepLinkHandler.buildDeepLinkIntent$sdk_originalRelease(context2, (DeepLinkRoute)((Object)object2), NavigationUtils.INSTANCE.buildInviteDeepLink(), (Payload)object));
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalRelease(@NotNull Context context, @NotNull DeepLinkRoute deepLinkRoute, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)deepLinkRoute), (String)"route");
        return this.applyDeepLink$sdk_originalRelease(new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName() + deepLinkRoute.getValue()))), uri, payload);
    }

    @NotNull
    public final Intent applyDeepLink$sdk_originalRelease(@NotNull Intent intent, @Nullable Uri uri, @Nullable Payload payload) {
        Intent intent2 = intent;
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"<this>");
        intent2.putExtra(DEEP_LINK_URI_DATA, (Parcelable)uri);
        intent2.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent2;
    }
}

