/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.TopicKt;
import io.streamlayer.sdk.model.messaging.TopicPrivateData;
import io.streamlayer.sdk.model.messaging.TopicType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0081\b\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0017\u001a\u00020\b\u0012\b\b\u0002\u0010\u0018\u001a\u00020\b\u0012\b\b\u0002\u0010\u0019\u001a\u00020\b\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\bV\u0010WJ\u0013\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0007\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\t\u001a\u00020\bH\u00c6\u0003J\t\u0010\n\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000b\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003Ju\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u00112\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001c\u0010\u0015\u001a\u00020\u00058\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\"\u001a\u0004\b#\u0010$R\u0019\u0010\u0016\u001a\u00020\u00058\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\"\u001a\u0004\b%\u0010$R\"\u0010\u0017\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0019\u0010\u0018\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010&\u001a\u0004\b+\u0010(R\u0019\u0010\u0019\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010&\u001a\u0004\b,\u0010(R\u001b\u0010\u001a\u001a\u0004\u0018\u00010\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010-\u001a\u0004\b.\u0010/R\u001b\u0010\u001b\u001a\u0004\u0018\u00010\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010-\u001a\u0004\b0\u0010/R\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u000f8\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001c\u00101\u001a\u0004\b2\u00103R\u0019\u0010\u001d\u001a\u00020\u00118\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001d\u00104\u001a\u0004\b5\u00106R\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00138\u0006@\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001e\u00107\u001a\u0004\b8\u00109R$\u0010:\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010\"\u001a\u0004\b;\u0010$\"\u0004\b<\u0010=R(\u0010@\u001a\b\u0012\u0004\u0012\u00020?0>8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER$\u0010G\u001a\u0004\u0018\u00010F8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\"\u0010M\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0013\u0010S\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\bS\u0010PR\u0013\u0010T\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\bT\u0010PR\u0013\u0010U\u001a\u00020\u00038F@\u0006\u00a2\u0006\u0006\u001a\u0004\bU\u0010P\u00a8\u0006X"}, d2={"Lio/streamlayer/sdk/model/messaging/Topic;", "", "other", "", "equals", "", "component1", "component2", "", "component3", "component4", "component5", "Ljava/util/Date;", "component6", "component7", "Lio/streamlayer/sdk/model/messaging/Access;", "component8", "Lio/streamlayer/sdk/model/messaging/TopicType;", "component9", "Lio/streamlayer/sdk/model/messaging/TopicPrivateData;", "component10", "chatId", "name", "seq", "readSeq", "recvSeq", "updatedAt", "touchedAt", "access", "type", "privateData", "copy", "toString", "hashCode", "Ljava/lang/String;", "getChatId", "()Ljava/lang/String;", "getName", "I", "getSeq", "()I", "setSeq", "(I)V", "getReadSeq", "getRecvSeq", "Ljava/util/Date;", "getUpdatedAt", "()Ljava/util/Date;", "getTouchedAt", "Lio/streamlayer/sdk/model/messaging/Access;", "getAccess", "()Lio/streamlayer/sdk/model/messaging/Access;", "Lio/streamlayer/sdk/model/messaging/TopicType;", "getType", "()Lio/streamlayer/sdk/model/messaging/TopicType;", "Lio/streamlayer/sdk/model/messaging/TopicPrivateData;", "getPrivateData", "()Lio/streamlayer/sdk/model/messaging/TopicPrivateData;", "watchPartyStreamId", "getWatchPartyStreamId", "setWatchPartyStreamId", "(Ljava/lang/String;)V", "", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "participants", "Ljava/util/List;", "getParticipants", "()Ljava/util/List;", "setParticipants", "(Ljava/util/List;)V", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "lastMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getLastMessage", "()Lio/streamlayer/sdk/model/messaging/ChatMessage;", "setLastMessage", "(Lio/streamlayer/sdk/model/messaging/ChatMessage;)V", "hasMessages", "Z", "getHasMessages", "()Z", "setHasMessages", "(Z)V", "isOwner", "isWPTopic", "isMuted", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIILjava/util/Date;Ljava/util/Date;Lio/streamlayer/sdk/model/messaging/Access;Lio/streamlayer/sdk/model/messaging/TopicType;Lio/streamlayer/sdk/model/messaging/TopicPrivateData;)V", "sdk_originalRelease"})
@Entity
public final class Topic {
    @PrimaryKey
    @NotNull
    private final String chatId;
    @NotNull
    private final String name;
    private int seq;
    private final int readSeq;
    private final int recvSeq;
    @Nullable
    private final Date updatedAt;
    @Nullable
    private final Date touchedAt;
    @Embedded
    @Nullable
    private final Access access;
    @NotNull
    private final TopicType type;
    @Embedded
    @Nullable
    private final TopicPrivateData privateData;
    @Nullable
    private String watchPartyStreamId;
    @Ignore
    @NotNull
    private List<TinodeContact> participants;
    @Ignore
    @Nullable
    private ChatMessage lastMessage;
    @Ignore
    private boolean hasMessages;

    public Topic(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable Access access, @NotNull TopicType topicType, @Nullable TopicPrivateData topicPrivateData) {
        Topic topic2 = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)topicType), (String)"type");
        this.chatId = string2;
        this.name = string3;
        this.seq = n;
        this.readSeq = n2;
        this.recvSeq = n3;
        this.updatedAt = date;
        this.touchedAt = date2;
        this.access = access;
        this.type = topicType;
        topic2.privateData = topicPrivateData;
        topic2.participants = CollectionsKt.emptyList();
    }

    public /* synthetic */ Topic(String string2, String string3, int n, int n2, int n3, Date date, Date date2, Access access, TopicType topicType, TopicPrivateData topicPrivateData, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            date = null;
        }
        if ((n4 & 0x40) != 0) {
            date2 = null;
        }
        if ((n4 & 0x80) != 0) {
            access = null;
        }
        if ((n4 & 0x100) != 0) {
            topicType = TopicType.CHAT;
        }
        if ((n4 & 0x200) != 0) {
            topicPrivateData = null;
        }
        this(string2, string3, n, n2, n3, date, date2, access, topicType, topicPrivateData);
    }

    public static /* synthetic */ Topic copy$default(Topic topic2, String string2, String string3, int n, int n2, int n3, Date date, Date date2, Access access, TopicType topicType, TopicPrivateData topicPrivateData, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string2 = topic2.chatId;
        }
        if ((n4 & 2) != 0) {
            string3 = topic2.name;
        }
        if ((n4 & 4) != 0) {
            n = topic2.seq;
        }
        if ((n4 & 8) != 0) {
            n2 = topic2.readSeq;
        }
        if ((n4 & 0x10) != 0) {
            n3 = topic2.recvSeq;
        }
        if ((n4 & 0x20) != 0) {
            date = topic2.updatedAt;
        }
        if ((n4 & 0x40) != 0) {
            date2 = topic2.touchedAt;
        }
        if ((n4 & 0x80) != 0) {
            access = topic2.access;
        }
        if ((n4 & 0x100) != 0) {
            topicType = topic2.type;
        }
        if ((n4 & 0x200) != 0) {
            topicPrivateData = topic2.privateData;
        }
        return topic2.copy(string2, string3, n, n2, n3, date, date2, access, topicType, topicPrivateData);
    }

    @NotNull
    public final String getChatId() {
        return this.chatId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSeq() {
        return this.seq;
    }

    public final void setSeq(int n) {
        this.seq = n;
    }

    public final int getReadSeq() {
        return this.readSeq;
    }

    public final int getRecvSeq() {
        return this.recvSeq;
    }

    @Nullable
    public final Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public final Date getTouchedAt() {
        return this.touchedAt;
    }

    @Nullable
    public final Access getAccess() {
        return this.access;
    }

    @NotNull
    public final TopicType getType() {
        return this.type;
    }

    @Nullable
    public final TopicPrivateData getPrivateData() {
        return this.privateData;
    }

    @Nullable
    public final String getWatchPartyStreamId() {
        return this.watchPartyStreamId;
    }

    public final void setWatchPartyStreamId(@Nullable String string2) {
        this.watchPartyStreamId = string2;
    }

    public final boolean isOwner() {
        return TopicKt.isOwner(this.access);
    }

    public final boolean isWPTopic() {
        Object object = object.type;
        return object == TopicType.WP || object == TopicType.MANAGED_WP;
    }

    @NotNull
    public final List<TinodeContact> getParticipants() {
        return this.participants;
    }

    public final void setParticipants(@NotNull List<TinodeContact> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.participants = list2;
    }

    @Nullable
    public final ChatMessage getLastMessage() {
        return this.lastMessage;
    }

    public final void setLastMessage(@Nullable ChatMessage chatMessage) {
        this.lastMessage = chatMessage;
    }

    public final boolean getHasMessages() {
        return this.hasMessages;
    }

    public final void setHasMessages(boolean bl) {
        this.hasMessages = bl;
    }

    public final boolean isMuted() {
        TopicPrivateData topicPrivateData = ((Topic)((Object)topicPrivateData)).privateData;
        return topicPrivateData == null ? false : topicPrivateData.getMute();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        void var3_17;
        void var2_9;
        void var3_13;
        void var2_5;
        if (!(object instanceof Topic)) return false;
        object = (Topic)object;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Topic)object).name)) return false;
        if (!Intrinsics.areEqual((Object)this.chatId, (Object)((Topic)object).chatId)) return false;
        if (this.seq != ((Topic)object).seq) return false;
        if (this.readSeq != ((Topic)object).readSeq) return false;
        if (this.recvSeq != ((Topic)object).recvSeq) return false;
        ChatMessage chatMessage = this.lastMessage;
        if (chatMessage == null) {
            Object var2_3 = null;
        } else {
            Integer n = chatMessage.getSeqId();
        }
        ChatMessage chatMessage2 = ((Topic)object).lastMessage;
        if (chatMessage2 == null) {
            Object var3_11 = null;
        } else {
            Integer n = chatMessage2.getSeqId();
        }
        if (!Intrinsics.areEqual((Object)var2_5, (Object)var3_13)) return false;
        ChatMessage chatMessage3 = this.lastMessage;
        if (chatMessage3 == null) {
            Object var2_7 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage3.getStatus();
        }
        ChatMessage chatMessage4 = ((Topic)object).lastMessage;
        if (chatMessage4 == null) {
            Object var3_15 = null;
        } else {
            ChatMessageStatus chatMessageStatus = chatMessage4.getStatus();
        }
        if (var2_9 != var3_17) return false;
        if (!Intrinsics.areEqual(this.participants, ((Topic)object).participants)) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final int component3() {
        return this.seq;
    }

    public final int component4() {
        return this.readSeq;
    }

    public final int component5() {
        return this.recvSeq;
    }

    @Nullable
    public final Date component6() {
        return this.updatedAt;
    }

    @Nullable
    public final Date component7() {
        return this.touchedAt;
    }

    @Nullable
    public final Access component8() {
        return this.access;
    }

    @NotNull
    public final TopicType component9() {
        return this.type;
    }

    @Nullable
    public final TopicPrivateData component10() {
        return this.privateData;
    }

    @NotNull
    public final Topic copy(@NotNull String string2, @NotNull String string3, int n, int n2, int n3, @Nullable Date date, @Nullable Date date2, @Nullable Access access, @NotNull TopicType topicType, @Nullable TopicPrivateData topicPrivateData) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)topicType), (String)"type");
        return new Topic(string2, string3, n, n2, n3, date, date2, access, topicType, topicPrivateData);
    }

    @NotNull
    public String toString() {
        return "Topic(chatId=" + this.chatId + ", name=" + this.name + ", seq=" + this.seq + ", readSeq=" + this.readSeq + ", recvSeq=" + this.recvSeq + ", updatedAt=" + this.updatedAt + ", touchedAt=" + this.touchedAt + ", access=" + this.access + ", type=" + (Object)((Object)this.type) + ", privateData=" + this.privateData + ')';
    }

    public int hashCode() {
        Topic topic2 = this;
        int n = ((((topic2.chatId.hashCode() * 31 + this.name.hashCode()) * 31 + Integer.hashCode(this.seq)) * 31 + Integer.hashCode(this.readSeq)) * 31 + Integer.hashCode(this.recvSeq)) * 31;
        Date date = topic2.updatedAt;
        int n2 = date == null ? 0 : date.hashCode();
        n = (n + n2) * 31;
        Date date2 = this.touchedAt;
        int n3 = date2 == null ? 0 : date2.hashCode();
        n = (n + n3) * 31;
        Access access = this.access;
        int n4 = access == null ? 0 : access.hashCode();
        int n5 = ((n + n4) * 31 + this.type.hashCode()) * 31;
        TopicPrivateData topicPrivateData = this.privateData;
        int n6 = topicPrivateData == null ? 0 : topicPrivateData.hashCode();
        return n5 + n6;
    }
}

