/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.database;

import androidx.room.TypeConverter;
import com.google.gson.reflect.TypeToken;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.advertising.AdvertisingVideo;
import io.streamlayer.sdk.model.analytics.AnalyticsEventType;
import io.streamlayer.sdk.model.calls.WatchPartyParticipantStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.TopicType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0017H\u0007J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0006H\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u0007J \u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0007J\u001a\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0014\u0010!\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0019\u0010%\u001a\u0004\u0018\u00010\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0016H\u0007\u00a8\u0006("}, d2={"Lio/streamlayer/common/data/database/Converters;", "", "()V", "advertisingImagesToString", "", "items", "", "Lio/streamlayer/sdk/model/advertising/AdvertisingImage;", "advertisingVideosToString", "Lio/streamlayer/sdk/model/advertising/AdvertisingVideo;", "analyticsEventTypeToString", "value", "Lio/streamlayer/sdk/model/analytics/AnalyticsEventType;", "chatStatusToString", "eventType", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "dateToString", "", "date", "Ljava/util/Date;", "(Ljava/util/Date;)Ljava/lang/Long;", "intToTopicType", "Lio/streamlayer/sdk/model/messaging/TopicType;", "", "participantStatusesToString", "Lio/streamlayer/sdk/model/calls/WatchPartyParticipantStatus;", "stringListToString", "list", "stringMapToString", "", "stringToAdvertisingImages", "stringToAdvertisingVideos", "stringToAnalyticsEventType", "stringToChatStatus", "stringToParticipantStatuses", "stringToStringList", "stringToStringMap", "timestampToDate", "(Ljava/lang/Long;)Ljava/util/Date;", "topicTypeToInt", "sdk_originalRelease"})
public final class Converters {
    @TypeConverter
    @Nullable
    public final Date timestampToDate(@Nullable Long l) {
        Object object;
        if (l != null) {
            Date date;
            object = date;
            date = new Date(l);
        } else {
            object = (Date)((Object)l);
        }
        return object;
    }

    @TypeConverter
    @Nullable
    public final Long dateToString(@Nullable Date date) {
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    @TypeConverter
    @Nullable
    public final List<String> stringToStringList(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends String>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String stringListToString(@Nullable List<String> list2) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list2);
    }

    @TypeConverter
    @Nullable
    public final ChatMessageStatus stringToChatStatus(@Nullable String string) {
        return string != null ? ChatMessageStatus.valueOf(string) : null;
    }

    @TypeConverter
    @Nullable
    public final String chatStatusToString(@Nullable ChatMessageStatus chatMessageStatus) {
        return chatMessageStatus != null ? chatMessageStatus.name() : null;
    }

    @TypeConverter
    @Nullable
    public final Map<String, String> stringToStringMap(@Nullable String string) {
        Type type2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
        return (Map)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String stringMapToString(@Nullable Map<String, String> map2) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(map2);
    }

    @TypeConverter
    @Nullable
    public final List<AdvertisingImage> stringToAdvertisingImages(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends AdvertisingImage>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String advertisingImagesToString(@Nullable List<AdvertisingImage> list2) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list2);
    }

    @TypeConverter
    @Nullable
    public final List<AdvertisingVideo> stringToAdvertisingVideos(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends AdvertisingVideo>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String advertisingVideosToString(@Nullable List<AdvertisingVideo> list2) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list2);
    }

    @TypeConverter
    @Nullable
    public final List<WatchPartyParticipantStatus> stringToParticipantStatuses(@Nullable String string) {
        Type type2 = new TypeToken<List<? extends WatchPartyParticipantStatus>>(){}.getType();
        return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(string, type2);
    }

    @TypeConverter
    @Nullable
    public final String participantStatusesToString(@Nullable List<WatchPartyParticipantStatus> list2) {
        return GsonUtil.INSTANCE.getDefaultGson().toJson(list2);
    }

    @TypeConverter
    @NotNull
    public final AnalyticsEventType stringToAnalyticsEventType(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"value");
        return AnalyticsEventType.valueOf(string2);
    }

    @TypeConverter
    @NotNull
    public final String analyticsEventTypeToString(@NotNull AnalyticsEventType analyticsEventType) {
        AnalyticsEventType analyticsEventType2 = analyticsEventType;
        Intrinsics.checkNotNullParameter((Object)((Object)analyticsEventType2), (String)"value");
        return analyticsEventType2.name();
    }

    @TypeConverter
    public final int topicTypeToInt(@NotNull TopicType topicType) {
        TopicType topicType2 = topicType;
        Intrinsics.checkNotNullParameter((Object)((Object)topicType2), (String)"value");
        return topicType2.ordinal();
    }

    @TypeConverter
    @NotNull
    public final TopicType intToTopicType(int n) {
        TopicType topicType2;
        block3: {
            for (TopicType topicType2 : TopicType.values()) {
                if (!(topicType2.ordinal() == n)) {
                    continue;
                }
                break block3;
            }
            topicType2 = null;
        }
        if (topicType2 == null) {
            topicType2 = TopicType.CHAT;
        }
        return topicType2;
    }
}

