/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import com.google.gson.JsonSyntaxException;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.NavigationUtils;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.base.InterfacesKt;
import io.streamlayer.sdk.base.SdkHost;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.deeplink.ReferralLink;
import io.streamlayer.sdk.model.deeplink.DeepLink;
import io.streamlayer.sdk.model.deeplink.InviteData;
import io.streamlayer.sdk.model.deeplink.Payload;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tJ%\u0010\u001e\u001a\u00020\u0007*\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u001fJ\f\u0010 \u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/streamlayer/sdk/deeplink/DeepLinkHandler;", "", "()V", "DEEP_LINK_PAYLOAD_DATA", "", "DEEP_LINK_URI_DATA", "buildDeepLinkIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "route", "Lio/streamlayer/sdk/deeplink/DeepLinkRoute;", "destinationUri", "Landroid/net/Uri;", "payload", "Lio/streamlayer/sdk/model/deeplink/Payload;", "buildDeepLinkIntent$sdk_originalRelease", "getDeepLink", "Lio/streamlayer/sdk/model/deeplink/DeepLink;", "intent", "getInvite", "Lio/streamlayer/sdk/model/deeplink/InviteData;", "json", "handleDeepLink", "", "activity", "Landroidx/fragment/app/FragmentActivity;", "handleInvite", "", "data", "applyDeepLink", "applyDeepLink$sdk_originalRelease", "clearDeeplink", "sdk_originalRelease"})
public final class DeepLinkHandler {
    @NotNull
    public static final DeepLinkHandler INSTANCE = new DeepLinkHandler();
    @NotNull
    private static final String DEEP_LINK_URI_DATA = "slr_deep_link_uri_data";
    @NotNull
    private static final String DEEP_LINK_PAYLOAD_DATA = "slr_deep_link_payload_data";

    private DeepLinkHandler() {
    }

    private final DeepLink getDeepLink(Intent intent) {
        DeepLink deepLink;
        DeepLinkHandler deepLinkHandler = (Uri)intent.getParcelableExtra(DEEP_LINK_URI_DATA);
        if (deepLinkHandler != null) {
            DeepLink deepLink2;
            deepLink = deepLink2;
            deepLink2 = new DeepLink((Uri)deepLinkHandler, (Payload)intent.getSerializableExtra(DEEP_LINK_PAYLOAD_DATA));
        } else {
            deepLink = null;
        }
        return deepLink;
    }

    private final Intent clearDeeplink(Intent intent) {
        Intent intent2 = intent;
        intent2.removeExtra(DEEP_LINK_URI_DATA);
        intent2.removeExtra(DEEP_LINK_PAYLOAD_DATA);
        return intent2;
    }

    public final boolean handleDeepLink(@NotNull Intent intent, @NotNull FragmentActivity object) {
        FragmentActivity fragmentActivity = object;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"activity");
        SdkHost sdkHost = InterfacesKt.findSdkHost(fragmentActivity);
        if (sdkHost != null) {
            boolean bl;
            object = INSTANCE;
            DeepLink deepLink = ((DeepLinkHandler)object).getDeepLink(intent);
            if (deepLink != null) {
                SLRLog sLRLog = SLRLog.INSTANCE;
                String string2 = "DeepLinkHandler";
                StringBuilder stringBuilder = new StringBuilder().append("processDeepLink  hasSdkSchema=");
                Uri uri = intent.getData();
                boolean bl2 = Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)"streamlayer");
                sLRLog.i(string2, stringBuilder.append(bl2).append(' ').append(deepLink.getUri()).append(' ').append(deepLink.getPayload()).toString());
                super.clearDeeplink(intent);
                sdkHost.processDeepLink(deepLink);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        throw new IllegalStateException("StreamLayerFragment is not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
    }

    @Nullable
    public final InviteData getInvite(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"json");
        try {
            object = ((ReferralLink)GsonUtil.INSTANCE.getDefaultGson().fromJson(string2, ReferralLink.class)).getData();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            object = null;
        }
        return object;
    }

    public final void handleInvite(@NotNull InviteData inviteData, @NotNull Context object) {
        Payload.Invite invite2;
        Context context = object;
        DeepLinkHandler deepLinkHandler = object2;
        Context context2 = object;
        Intrinsics.checkNotNullParameter((Object)inviteData, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SLRLog.INSTANCE.i("DeepLinkHandler", "handleReferralLink link=" + inviteData);
        Object object2 = DeepLinkRoute.INVITE;
        object = invite2;
        invite2 = new Payload.Invite(inviteData);
        context.startActivity(deepLinkHandler.buildDeepLinkIntent$sdk_originalRelease(context2, (DeepLinkRoute)((Object)object2), NavigationUtils.INSTANCE.buildInviteDeepLink(), (Payload)object));
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalRelease(@NotNull Context context, @NotNull DeepLinkRoute deepLinkRoute, @Nullable Uri uri, @Nullable Payload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)deepLinkRoute), (String)"route");
        return this.applyDeepLink$sdk_originalRelease(new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName() + deepLinkRoute.getValue()))), uri, payload);
    }

    @NotNull
    public final Intent applyDeepLink$sdk_originalRelease(@NotNull Intent intent, @Nullable Uri uri, @Nullable Payload payload) {
        Intent intent2 = intent;
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"<this>");
        intent2.putExtra(DEEP_LINK_URI_DATA, (Parcelable)uri);
        intent2.putExtra(DEEP_LINK_PAYLOAD_DATA, (Serializable)payload);
        return intent2;
    }
}

