/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import io.streamlayer.sdk.model.notifications.Notification;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\ba\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0019\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH'J\u001f\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\fH'J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH'J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u0012H'J\b\u0010\u0013\u001a\u00020\u0003H'J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H'J\u0016\u0010\u0016\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH'J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lio/streamlayer/sdk/repository/notifications/NotificationDao;", "", "deleteAllNotifications", "", "deleteNotification", "item", "Lio/streamlayer/sdk/model/notifications/Notification;", "(Lio/streamlayer/sdk/model/notifications/Notification;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sourceUniqueId", "", "deleteNotifications", "items", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteNotificationsByType", "types", "getNotification", "getNotifications", "Lkotlinx/coroutines/flow/Flow;", "safeDeleteAllNotifications", "saveNotification", "", "saveNotifications", "updateNotifications", "sdk_originalRelease"})
@Dao
public interface NotificationDao {
    @Insert(onConflict=5)
    public void saveNotifications(@NotNull List<Notification> var1);

    @Insert(onConflict=1)
    public long saveNotification(@NotNull Notification var1);

    @Update
    public void updateNotifications(@NotNull List<Notification> var1);

    @Query(value="SELECT * FROM Notification ORDER BY Notification.id DESC, Notification.date DESC")
    @NotNull
    public Flow<List<Notification>> getNotifications();

    @Delete
    @Nullable
    public Object deleteNotifications(@NotNull List<Notification> var1, @NotNull Continuation<? super Unit> var2);

    @Delete
    @Nullable
    public Object deleteNotification(@NotNull Notification var1, @NotNull Continuation<? super Unit> var2);

    public void deleteAllNotifications();

    @Query(value="DELETE FROM Notification")
    public void safeDeleteAllNotifications();

    @Query(value="DELETE FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    public void deleteNotification(@NotNull String var1);

    @Query(value="SELECT * FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    @Nullable
    public Notification getNotification(@NotNull String var1);

    @Query(value="DELETE FROM Notification WHERE _type in (:types)")
    public void deleteNotificationsByType(@NotNull List<String> var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void deleteAllNotifications(@NotNull NotificationDao notificationDao) {
            new Thread(() -> DefaultImpls.deleteAllNotifications$lambda-0(notificationDao)).start();
        }

        private static void deleteAllNotifications$lambda-0(NotificationDao notificationDao) {
            NotificationDao notificationDao2 = notificationDao;
            Intrinsics.checkNotNullParameter((Object)notificationDao2, (String)"this$0");
            notificationDao2.safeDeleteAllNotifications();
        }
    }
}

