/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import coil.ImageLoader;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetMedia;
import io.streamlayer.sdk.twitter.Input;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001PB-\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u00100\u001a\u00020\u0017H\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\nH\u0002J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u0014H\u0002J\u0016\u00106\u001a\u00020\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J0\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\nH\u0002J\b\u0010=\u001a\u00020\u0017H\u0002J \u0010>\u001a\u00020\u00172\u0006\u00108\u001a\u00020\n2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\nH\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\nH\u0002J\u0010\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020GH\u0016J0\u0010H\u001a\u00020\u00172\u0006\u0010I\u001a\u00020\u00042\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\nH\u0014J\u0018\u0010J\u001a\u00020\u00172\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\nH\u0014J\u0014\u0010K\u001a\u00020\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u001a\u0010L\u001a\u00020\u00172\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u000104H\u0002R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR7\u0010\u001c\u001a\u001f\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006Q"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetPhotoView;", "Landroid/widget/FrameLayout;", "Landroid/view/View$OnClickListener;", "showSinglePhoto", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(ZLandroid/content/Context;Landroid/util/AttributeSet;I)V", "imageCount", "imageViews", "", "Landroidx/appcompat/widget/AppCompatImageView;", "[Landroidx/appcompat/widget/AppCompatImageView;", "mediaDividerSize", "mediaEntities", "", "Lio/streamlayer/sdk/model/social/TweetMedia;", "onMediaLoaded", "Lkotlin/Function0;", "", "getOnMediaLoaded", "()Lkotlin/jvm/functions/Function0;", "setOnMediaLoaded", "(Lkotlin/jvm/functions/Function0;)V", "onPhotoClicked", "Lkotlin/Function1;", "Lio/streamlayer/sdk/twitter/Input;", "Lkotlin/ParameterName;", "name", "input", "getOnPhotoClicked", "()Lkotlin/jvm/functions/Function1;", "setOnPhotoClicked", "(Lkotlin/jvm/functions/Function1;)V", "getShowSinglePhoto", "()Z", "setShowSinglePhoto", "(Z)V", "tweet", "Lio/streamlayer/sdk/model/social/Tweet;", "getTweet", "()Lio/streamlayer/sdk/model/social/Tweet;", "setTweet", "(Lio/streamlayer/sdk/model/social/Tweet;)V", "clearImageViews", "getOrCreateImageView", "index", "getSizedImagePath", "", "mediaEntity", "initializeImageViews", "layoutImage", "i", "left", "top", "right", "bottom", "layoutImages", "measureImageView", "width", "height", "measureImages", "Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "widthMeasureSpec", "heightMeasureSpec", "onClick", "view", "Landroid/view/View;", "onLayout", "changed", "onMeasure", "setMedia", "setMediaImage", "imageView", "Landroid/widget/ImageView;", "imagePath", "Size", "sdk_originalRelease"})
final class TweetPhotoView
extends FrameLayout
implements View.OnClickListener {
    private boolean showSinglePhoto;
    @NotNull
    private final AppCompatImageView[] imageViews;
    @NotNull
    private List<TweetMedia> mediaEntities;
    private final int mediaDividerSize;
    private int imageCount;
    @Nullable
    private Function1<? super Input, Unit> onPhotoClicked;
    public Tweet tweet;
    @Nullable
    private Function0<Unit> onMediaLoaded;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    @JvmOverloads
    public TweetPhotoView(boolean bl, @NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        TweetPhotoView tweetPhotoView = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        super(context, attributeSet, n);
        tweetPhotoView.showSinglePhoto = bl;
        tweetPhotoView.imageViews = new AppCompatImageView[4];
        tweetPhotoView.mediaEntities = CollectionsKt.emptyList();
        tweetPhotoView.mediaDividerSize = ViewExtensionsKt.getDp(1.0f);
    }

    public /* synthetic */ TweetPhotoView(boolean bl, Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            attributeSet = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(bl, context, attributeSet, n);
    }

    private final Size measureImages(int n, int n2) {
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getSize((int)n2);
        int n3 = this.mediaDividerSize;
        int n4 = (n - n3) / 2;
        n3 = (n2 - n3) / 2;
        switch (this.imageCount) {
            default: {
                break;
            }
            case 4: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n3);
                tweetPhotoView.measureImageView(1, n4, n3);
                tweetPhotoView.measureImageView(2, n4, n3);
                tweetPhotoView.measureImageView(3, n4, n3);
                break;
            }
            case 3: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n2);
                tweetPhotoView.measureImageView(1, n4, n3);
                tweetPhotoView.measureImageView(2, n4, n3);
                break;
            }
            case 2: {
                TweetPhotoView tweetPhotoView = this;
                tweetPhotoView.measureImageView(0, n4, n2);
                tweetPhotoView.measureImageView(1, n4, n2);
                break;
            }
            case 1: {
                this.measureImageView(0, n, n2);
            }
        }
        return Size.Companion.fromSize(n, n2);
    }

    private final void measureImageView(int n, int n2, int n3) {
        TweetPhotoView tweetPhotoView = tweetPhotoView.imageViews[n];
        if (tweetPhotoView != null) {
            int n4 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
            tweetPhotoView.measure(n4, View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
        }
    }

    private final void layoutImages() {
        TweetPhotoView tweetPhotoView = this;
        int n = tweetPhotoView.getMeasuredWidth();
        TweetPhotoView tweetPhotoView2 = this;
        int n2 = tweetPhotoView2.getMeasuredHeight();
        int n3 = tweetPhotoView2.mediaDividerSize;
        int n4 = (n - n3) / 2;
        int n5 = n3;
        n3 = (n2 - n3) / 2;
        int n6 = n4 + n5;
        switch (tweetPhotoView.imageCount) {
            default: {
                break;
            }
            case 4: {
                TweetPhotoView tweetPhotoView3 = this;
                TweetPhotoView tweetPhotoView4 = this;
                tweetPhotoView4.layoutImage(0, 0, 0, n4, n3);
                int n7 = n3 + tweetPhotoView4.mediaDividerSize;
                tweetPhotoView3.layoutImage(2, 0, n7, n4, n2);
                tweetPhotoView3.layoutImage(1, n6, 0, n, n3);
                n7 = n3 + tweetPhotoView3.mediaDividerSize;
                this.layoutImage(3, n6, n7, n, n2);
                break;
            }
            case 3: {
                TweetPhotoView tweetPhotoView5 = this;
                tweetPhotoView5.layoutImage(0, 0, 0, n4, n2);
                tweetPhotoView5.layoutImage(1, n6, 0, n, n3);
                int n8 = n3 + tweetPhotoView5.mediaDividerSize;
                this.layoutImage(2, n6, n8, n, n2);
                break;
            }
            case 2: {
                TweetPhotoView tweetPhotoView6 = this;
                tweetPhotoView6.layoutImage(0, 0, 0, n4, n2);
                this.layoutImage(1, n4 + tweetPhotoView6.mediaDividerSize, 0, n, n2);
                break;
            }
            case 1: {
                this.layoutImage(0, 0, 0, n, n2);
            }
        }
    }

    private final void layoutImage(int n, int n2, int n3, int n4, int n5) {
        TweetPhotoView tweetPhotoView = tweetPhotoView.imageViews[n];
        if (tweetPhotoView != null) {
            if (tweetPhotoView.getLeft() == n2 && tweetPhotoView.getTop() == n3 && tweetPhotoView.getRight() == n4 && tweetPhotoView.getBottom() == n5) {
                return;
            }
            tweetPhotoView.layout(n2, n3, n4, n5);
        }
    }

    private final void clearImageViews() {
        AppCompatImageView[] appCompatImageViewArray = this.imageViews;
        int n = this.imageViews.length;
        for (int i = 0; i < n; ++i) {
            AppCompatImageView appCompatImageView = appCompatImageViewArray[i];
            if (appCompatImageView == null) continue;
            ViewExtensionsKt.gone((View)appCompatImageView);
        }
        this.imageCount = 0;
    }

    private final void initializeImageViews(List<TweetMedia> list2) {
        int n;
        this.imageCount = n = Math.min(4, list2.size());
        for (int i = 0; i < n; ++i) {
            TweetPhotoView tweetPhotoView = this;
            AppCompatImageView appCompatImageView = this.getOrCreateImageView(i);
            tweetPhotoView.setMediaImage((ImageView)appCompatImageView, tweetPhotoView.getSizedImagePath(list2.get(i)));
        }
    }

    private final AppCompatImageView getOrCreateImageView(int n) {
        AppCompatImageView appCompatImageView = this.imageViews[n];
        if (appCompatImageView == null) {
            FrameLayout.LayoutParams layoutParams;
            AppCompatImageView appCompatImageView2;
            appCompatImageView = appCompatImageView2;
            appCompatImageView2 = new AppCompatImageView(this.getContext());
            if (this.showSinglePhoto) {
                FrameLayout.LayoutParams layoutParams2;
                layoutParams = layoutParams2;
                layoutParams2 = new FrameLayout.LayoutParams(-1, -2);
            } else {
                layoutParams = this.generateDefaultLayoutParams();
            }
            appCompatImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            appCompatImageView.setOnClickListener((View.OnClickListener)this);
            this.imageViews[n] = appCompatImageView;
            this.addView((View)appCompatImageView, n);
        } else {
            TweetPhotoView tweetPhotoView = this;
            tweetPhotoView.measureImageView(n, 0, 0);
            tweetPhotoView.layoutImage(n, 0, 0, 0, 0);
        }
        appCompatImageView.setVisibility(0);
        appCompatImageView.setTag((Object)n);
        if (this.showSinglePhoto) {
            appCompatImageView.setAdjustViewBounds(true);
        }
        return appCompatImageView;
    }

    private final String getSizedImagePath(TweetMedia tweetMedia) {
        return this.imageCount > 1 ? tweetMedia.getMediaUrlHttps() + ":small" : tweetMedia.getMediaUrlHttps();
    }

    private final void setMediaImage(ImageView imageView2, String string2) {
        if (!this.showSinglePhoto) {
            imageView2.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        Intrinsics.checkNotNullExpressionValue((Object)imageView2.getContext(), (String)"context");
        ImageLoader imageLoader = (ImageLoader)StreamLayer.INSTANCE.getKoin$sdk_originalRelease().getScopeRegistry().getRootScope().get(Reflection.getOrCreateKotlinClass(ImageLoader.class), null, null);
        Context context = imageView2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        ImageRequest.Builder builder = new ImageRequest.Builder(context).data((Object)string2).target(imageView2);
        builder.error(R.drawable.slr_ic_tw_photo_error_dark);
        builder.listener(new ImageRequest.Listener(this, imageView2, this){
            final /* synthetic */ TweetPhotoView this$0;
            final /* synthetic */ ImageView $imageView$inlined;
            {
                this.this$0 = tweetPhotoView;
                this.$imageView$inlined = imageView2;
            }

            public void onStart(@NotNull ImageRequest imageRequest) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
            }

            public void onCancel(@NotNull ImageRequest imageRequest) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
            }

            public void onError(@NotNull ImageRequest imageRequest, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                if (!this.this$0.getShowSinglePhoto()) {
                    this.$imageView$inlined.setScaleType(ImageView.ScaleType.FIT_CENTER);
                }
                if ((this = this.this$0.getOnMediaLoaded()) != null) {
                    this.invoke();
                }
            }

            public void onSuccess(@NotNull ImageRequest imageRequest, @NotNull ImageResult.Metadata metadata) {
                Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"request");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Function0<Unit> function0 = function0.this$0.getOnMediaLoaded();
                if (function0 != null) {
                    function0.invoke();
                }
            }
        });
        imageLoader.enqueue(builder.build());
    }

    @JvmOverloads
    public TweetPhotoView(boolean bl, @NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(bl, context, attributeSet, 0, 8, null);
    }

    @JvmOverloads
    public TweetPhotoView(boolean bl, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(bl, context, null, 0, 12, null);
    }

    public final boolean getShowSinglePhoto() {
        return this.showSinglePhoto;
    }

    public final void setShowSinglePhoto(boolean bl) {
        this.showSinglePhoto = bl;
    }

    @Nullable
    public final Function1<Input, Unit> getOnPhotoClicked() {
        return this.onPhotoClicked;
    }

    public final void setOnPhotoClicked(@Nullable Function1<? super Input, Unit> function1) {
        this.onPhotoClicked = function1;
    }

    @NotNull
    public final Tweet getTweet() {
        Object object = object.tweet;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tweet");
        return null;
    }

    public final void setTweet(@NotNull Tweet tweet) {
        Intrinsics.checkNotNullParameter((Object)tweet, (String)"<set-?>");
        this.tweet = tweet;
    }

    @Nullable
    public final Function0<Unit> getOnMediaLoaded() {
        return this.onMediaLoaded;
    }

    public final void setOnMediaLoaded(@Nullable Function0<Unit> function0) {
        this.onMediaLoaded = function0;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.showSinglePhoto) {
            super.onLayout(bl, n, n2, n3, n4);
        } else if (this.imageCount > 0) {
            this.layoutImages();
        }
    }

    protected void onMeasure(int n, int n2) {
        if (this.showSinglePhoto) {
            super.onMeasure(n, n2);
        } else {
            Size size = this.imageCount > 0 ? this.measureImages(n, n2) : Size.Companion.getEMPTY();
            Size size2 = size;
            int n3 = size2.getWidth();
            this.setMeasuredDimension(n3, size2.getHeight());
        }
    }

    public void onClick(@NotNull View object) {
        View view2 = object;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        object = view2.getTag();
        if (object != null) {
            int n = (Integer)object;
            Object object2 = object4.onPhotoClicked;
            if (object2 != null) {
                ArrayList<String> arrayList;
                Object object3 = object4.mediaEntities;
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object3, (int)10));
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    arrayList2.add(((TweetMedia)object3.next()).getMediaUrlHttps());
                }
                Function1<? super Input, Unit> function1 = object2;
                TweetPhotoView tweetPhotoView = object4;
                Object object4 = tweetPhotoView.getTweet().getMetaData().getAccount();
                object2 = StringsKt.replace$default((String)tweetPhotoView.getTweet().getMetaData().getAccountImage(), (String)"_normal", (String)"_reasonably_small", (boolean)false, (int)4, null);
                function1.invoke((Object)new Input(n, (List<String>)arrayList2, (String)object4, (String)object2));
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public final void setMedia(@NotNull List<TweetMedia> list2) {
        List<TweetMedia> list3 = list2;
        Intrinsics.checkNotNullParameter(list3, (String)"mediaEntities");
        if (list3.isEmpty()) {
            return;
        }
        if (Intrinsics.areEqual(list2, function0.mediaEntities)) {
            Function0<Unit> function0 = function0.onMediaLoaded;
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
        Function0<Unit> function0 = function0;
        function0.mediaEntities = list2;
        super.clearImageViews();
        super.initializeImageViews(list2);
        function0.requestLayout();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 != null) {
                map2.put(n, view2);
            } else {
                view2 = null;
            }
        }
        return view2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u001b\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "Companion", "sdk_originalRelease"})
    private static final class Size {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Size EMPTY = new Size(0, 0, 3, null);
        private final int width;
        private final int height;

        private Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public /* synthetic */ Size(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            this(n, n2);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size$Companion;", "", "()V", "EMPTY", "Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "getEMPTY", "()Lio/streamlayer/sdk/twitter/view/TweetPhotoView$Size;", "fromSize", "w", "", "h", "sdk_originalRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final Size getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final Size fromSize(int n, int n2) {
                Object object;
                n = Math.max(n, 0);
                n2 = Math.max(n2, 0);
                if (n == 0 && n2 == 0) {
                    object = ((Companion)object).getEMPTY();
                } else {
                    Size size;
                    object = size;
                    size = new Size(n, n2, null);
                }
                return object;
            }
        }
    }
}

