/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.twitter.view.internal.media;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import io.streamlayer.common.media.MediaProvider;
import io.streamlayer.sdk.VideoPlayer;
import io.streamlayer.sdk.VideoPlayerProvider;
import io.streamlayer.sdk.VideoPlayerView;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideo;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoComponent;
import io.streamlayer.sdk.twitter.view.internal.media.TweetVideoPlayerCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\tH\u0096\u0001J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\t\u0010 \u001a\u00020\u001fH\u0096\u0001J\u0011\u0010!\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0096\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/streamlayer/sdk/twitter/view/internal/media/TweetPlayerViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoPlayerCache;", "tweetVideoComponent", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;", "mediaProvider", "Lio/streamlayer/common/media/MediaProvider;", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideoComponent;Lio/streamlayer/common/media/MediaProvider;)V", "releaseOnCleared", "", "getReleaseOnCleared", "()Z", "setReleaseOnCleared", "(Z)V", "tweetVideo", "Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "getTweetVideo", "()Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;", "setTweetVideo", "(Lio/streamlayer/sdk/twitter/view/internal/media/TweetVideo;)V", "getPlayer", "Lio/streamlayer/sdk/VideoPlayer;", "video", "forceCreate", "getVideoPlayerView", "Lio/streamlayer/sdk/VideoPlayerView;", "context", "Landroid/content/Context;", "type", "Lio/streamlayer/sdk/VideoPlayerView$Type;", "onCleared", "", "release", "releasePlayer", "sdk_originalRelease"})
public final class TweetPlayerViewModel
extends ViewModel
implements TweetVideoPlayerCache {
    @NotNull
    private final TweetVideoComponent tweetVideoComponent;
    @NotNull
    private MediaProvider mediaProvider;
    private boolean releaseOnCleared;
    @Nullable
    private TweetVideo tweetVideo;

    public TweetPlayerViewModel(@NotNull TweetVideoComponent tweetVideoComponent, @NotNull MediaProvider mediaProvider) {
        Intrinsics.checkNotNullParameter((Object)tweetVideoComponent, (String)"tweetVideoComponent");
        Intrinsics.checkNotNullParameter((Object)mediaProvider, (String)"mediaProvider");
        this.tweetVideoComponent = tweetVideoComponent;
        this.mediaProvider = mediaProvider;
        this.releaseOnCleared = true;
    }

    @Override
    @Nullable
    public VideoPlayer getPlayer(@NotNull TweetVideo tweetVideo, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        return this.tweetVideoComponent.getPlayer(tweetVideo, bl);
    }

    @Override
    public void release() {
        this.tweetVideoComponent.release();
    }

    @Override
    public void releasePlayer(@NotNull TweetVideo tweetVideo) {
        Intrinsics.checkNotNullParameter((Object)tweetVideo, (String)"video");
        this.tweetVideoComponent.releasePlayer(tweetVideo);
    }

    public final boolean getReleaseOnCleared() {
        return this.releaseOnCleared;
    }

    public final void setReleaseOnCleared(boolean bl) {
        this.releaseOnCleared = bl;
    }

    @Nullable
    public final TweetVideo getTweetVideo() {
        return this.tweetVideo;
    }

    public final void setTweetVideo(@Nullable TweetVideo tweetVideo) {
        this.tweetVideo = tweetVideo;
    }

    @Nullable
    public final VideoPlayerView getVideoPlayerView(@NotNull Context context, @NotNull VideoPlayerView.Type type2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        VideoPlayerProvider videoPlayerProvider = ((TweetPlayerViewModel)((Object)videoPlayerProvider)).mediaProvider.getVideoPlayerProvider();
        return videoPlayerProvider != null ? videoPlayerProvider.getVideoPlayerView(context, type2) : null;
    }

    protected void onCleared() {
        TweetPlayerViewModel tweetPlayerViewModel = this;
        super.onCleared();
        if (tweetPlayerViewModel.releaseOnCleared) {
            this.release();
        }
    }
}

