/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.google.gson.Gson;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.data.workes.OnPushMessageWorker;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.utils.GsonUtil;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.deeplink.DeepLinkHandler;
import io.streamlayer.sdk.deeplink.DeepLinkRoute;
import io.streamlayer.sdk.model.deeplink.Payload;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageHead;
import io.streamlayer.sdk.model.messaging.ChatMessageHeadPayload;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.TopicKt;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationKt;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000eJ(\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002J&\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/Session;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "(Landroid/content/Context;Lio/streamlayer/common/session/Session;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;)V", "getNotificationTag", "", "handlePushMessage", "", "data", "", "showSystemNotification", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "payload", "Lio/streamlayer/sdk/model/deeplink/Payload;", "groupKey", "updateSummary", "pendingIntent", "Landroid/app/PendingIntent;", "Companion", "sdk_originalRelease"})
public final class PushNotificationsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Session session;
    @NotNull
    private final MessagingRepo messagingRepo;

    public PushNotificationsService(@NotNull Context context, @NotNull Session session2, @NotNull MessagingRepo messagingRepo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)messagingRepo, (String)"messagingRepo");
        this.context = context;
        this.session = session2;
        this.messagingRepo = messagingRepo;
    }

    private final void showSystemNotification(Notification notification, Payload payload, String string2) {
        Long l = notification.getId();
        int n = l != null ? (int)l.longValue() : notification.hashCode();
        Context context = ((PushNotificationsService)((Object)string3)).context;
        DeepLinkRoute deepLinkRoute = DeepLinkRoute.MAIN;
        Uri uri = NotificationKt.deepLink(notification);
        payload = DeepLinkHandler.INSTANCE.buildDeepLinkIntent$sdk_originalRelease(context, deepLinkRoute, uri, payload);
        int n2 = Build.VERSION.SDK_INT >= 31 ? 0xC000000 : 0x8000000;
        payload = PendingIntent.getActivity((Context)((PushNotificationsService)((Object)string3)).context, (int)n, (Intent)payload, (int)n2);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(((PushNotificationsService)((Object)string3)).context, NotificationChannelsHelper.Channel.streamlayer_high.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)((PushNotificationsService)((Object)string3)).context, (int)R.color.slr_push_color)).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, Notific\u2026notification.description)");
        if (payload != null) {
            builder.setContentIntent((PendingIntent)payload);
        }
        if (string2 != null) {
            builder.setGroup(((PushNotificationsService)((Object)string3)).context.getPackageName() + '.' + string2);
        }
        PushNotificationsService pushNotificationsService = string3;
        pushNotificationsService.updateSummary(notification, string2, (PendingIntent)payload);
        String string3 = ((PushNotificationsService)((Object)string3)).getNotificationTag();
        notification = builder.build();
        NotificationManagerCompat.from((Context)pushNotificationsService.context).notify(string3, n, (android.app.Notification)notification);
    }

    static /* synthetic */ void showSystemNotification$default(PushNotificationsService pushNotificationsService, Notification notification, Payload payload, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            payload = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        pushNotificationsService.showSystemNotification(notification, payload, string2);
    }

    private final void updateSummary(Notification notification, String string2, PendingIntent object) {
        notification = new NotificationCompat.Builder(pushNotificationsService2.context, NotificationChannelsHelper.Channel.streamlayer_high.name()).setSmallIcon(R.drawable.slr_ic_logo).setColor(ContextCompat.getColor((Context)pushNotificationsService2.context, (int)R.color.slr_push_color)).setGroupSummary(true).setAutoCancel(true).setCategory("msg").setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getDescription()).setGroupAlertBehavior(2).setOnlyAlertOnce(true);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(context, Notific\u2026  .setOnlyAlertOnce(true)");
        if (object != null) {
            notification.setContentIntent((PendingIntent)object);
        }
        if (string2 != null) {
            notification.setGroup(pushNotificationsService2.context.getPackageName() + '.' + string2);
        }
        PushNotificationsService pushNotificationsService = pushNotificationsService2;
        PushNotificationsService pushNotificationsService2 = NotificationManagerCompat.from((Context)pushNotificationsService.context);
        object = pushNotificationsService.getNotificationTag();
        int n = string2 != null ? string2.hashCode() : 0;
        PushNotificationsService pushNotificationsService3 = pushNotificationsService2;
        pushNotificationsService2 = notification.build();
        pushNotificationsService3.notify((String)object, n, (android.app.Notification)pushNotificationsService2);
    }

    static /* synthetic */ void updateSummary$default(PushNotificationsService pushNotificationsService, Notification notification, String string2, PendingIntent pendingIntent, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        pushNotificationsService.updateSummary(notification, string2, pendingIntent);
    }

    private final String getNotificationTag() {
        return this.context.getPackageName() + "StreamLayer";
    }

    public final void handlePushMessage(@NotNull Map<String, String> map2) {
        Data.Builder builder;
        OneTimeWorkRequest.Builder builder2;
        Object object;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter(map2, (String)"data");
        if (!pushNotificationsService.session.isLoggedIn()) {
            return;
        }
        Object object2 = map2.get("category");
        Object object3 = GsonUtil.INSTANCE.getDefaultGson();
        Object object4 = (Intrinsics.areEqual((Object)object2, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object2, (Object)"sl_watch_party")) ? (ChatMessage)object3.fromJson(map2.get("extra"), ChatMessage.class) : null;
        object3 = (Intrinsics.areEqual((Object)object2, (Object)"sl_chat") ? true : Intrinsics.areEqual((Object)object2, (Object)"sl_watch_party")) ? (ChatMessageHeadPayload)object3.fromJson(map2.get("extra"), ChatMessageHeadPayload.class) : null;
        object2 = Intrinsics.areEqual((Object)object2, (Object)"sl_chat") ? NotificationType.Chat : (Intrinsics.areEqual((Object)object2, (Object)"sl_watch_party") ? NotificationType.WatchParty : NotificationType.Universal);
        int n = object4 instanceof ChatMessage;
        if (n != 0) {
            pairArray = NotificationUtilKt.toNotification((ChatMessage)object4, (NotificationType)((Object)object2));
            object = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()] == 1 ? Long.valueOf((long)((ChatMessage)object4).getTopicId().hashCode() + (long)((ChatMessage)object4).getSeqId()) : Long.valueOf(((ChatMessage)object4).getTopicId().hashCode());
            pairArray.setId((Long)object);
        } else {
            Pair[] pairArray2;
            pairArray = pairArray2;
            object = ((Enum)object2).name();
            pairArray2 = new Notification(null, null, null, (String)object, null, null, null, null, 247, null);
        }
        if (object3 instanceof ChatMessageHeadPayload) {
            if (ChatMessageKt.isWave((ChatMessageHeadPayload)object3)) {
                Gson gson = object3;
                object = gson.getHead();
                object = object != null ? ((ChatMessageHead)object).getEventId() : null;
                object3 = new Payload.Wave((String)object);
            } else {
                Payload.Notification notification;
                object3 = notification;
                notification = new Payload.Notification((NotificationType)((Object)object2), false, 2, null);
            }
        } else {
            object3 = null;
        }
        object = n != 0 ? ((ChatMessage)object4).getTopicId() : "general_group";
        Object object5 = map2.get("title");
        if (object5 != null) {
            pairArray.setTitle((String)object5);
        }
        if ((object5 = map2.get("body")) != null) {
            pairArray.setDescription((String)object5);
        }
        object5 = SLRLog.INSTANCE;
        ((SLRLog)object5).i("PushNotificationsService", "handlePush " + map2);
        if (n != 0 && object2 == NotificationType.Chat) {
            if (TopicKt.isP2PTopic(((ChatMessage)object4).getTopicId())) {
                return;
            }
            if (TopicKt.isGroupTopic(((ChatMessage)object4).getTopicId()) && ((ChatMessage)object4).getSeqId() == 0) {
                return;
            }
            map2 = ((ChatMessage)object4).getHead();
            if (map2 != null && map2.containsKey("x-slr-subtype")) {
                map2 = ((ChatMessage)object4).getHead();
                map2 = map2 != null ? map2.get("x-slr-subtype") : null;
                if (Intrinsics.areEqual(map2, (Object)"left_chat")) {
                    pairArray.setDescription(pushNotificationsService.context.getString(R.string.slr_chat_user_left, new Object[]{pairArray.getTitle()}));
                } else if (Intrinsics.areEqual((Object)map2, (Object)"join_chat")) {
                    pairArray.setDescription(pushNotificationsService.context.getString(R.string.slr_chat_user_joined, new Object[]{pairArray.getTitle()}));
                }
            }
        }
        int n2 = ((NotificationUtil)((Object)(map2 = NotificationUtil.INSTANCE))).isNotificationEnabled$sdk_originalRelease(pushNotificationsService.session, (Notification)pairArray) && !((NotificationUtil)((Object)map2)).isAppInForeground() ? 1 : 0;
        Boolean bl = pushNotificationsService.messagingRepo.isTopicMuted((String)object);
        boolean bl2 = bl != null ? bl : false;
        ((SLRLog)object5).i("PushNotificationsService", "isMuted " + bl2);
        if (n2 != 0 && !bl2) {
            pushNotificationsService.showSystemNotification((Notification)pairArray, (Payload)object3, (String)object);
        }
        int n3 = n;
        PushNotificationsService pushNotificationsService = WorkManager.getInstance((Context)pushNotificationsService.context);
        object3 = builder2;
        builder2 = new OneTimeWorkRequest.Builder(OnPushMessageWorker.class);
        n = 3;
        Pair[] pairArray3 = new Pair[3];
        pairArray = pairArray3;
        pairArray[0] = TuplesKt.to((Object)"need_send_analytics", (Object)(n2 != 0));
        pairArray3[1] = TuplesKt.to((Object)"notification_type", (Object)((Enum)object2).name());
        n2 = 2;
        object2 = "topic_id";
        object4 = n3 != 0 ? ((ChatMessage)object4).getTopicId() : null;
        pairArray[n2] = TuplesKt.to((Object)object2, (Object)object4);
        Data.Builder builder3 = builder;
        builder = new Data.Builder();
        for (int i = 0; i < n; ++i) {
            Pair pair = pairArray[i];
            object4 = (String)pair.getFirst();
            builder3.put((String)object4, pair.getSecond());
        }
        Object object6 = object3;
        Data data = builder3.build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"dataBuilder.build()");
        object6.setInputData(data);
        pushNotificationsService.enqueue(object6.build());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lio/streamlayer/common/data/notifications/PushNotificationsService$Companion;", "", "()V", "isStreamLayerPush", "", "data", "", "", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final boolean isStreamLayerPush(@NotNull Map<String, String> map2) {
            Map<String, String> map3 = map2;
            Intrinsics.checkNotNullParameter(map3, (String)"data");
            return map3.containsKey("category") && ArraysKt.contains((Object[])new String[]{"sl_chat", "sl_watch_party"}, (Object)map2.get("category"));
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.Chat.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

