/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.call.CallSettings;
import com.voximplant.sdk.call.ICall;
import com.voximplant.sdk.call.ICallListener;
import com.voximplant.sdk.call.VideoCodec;
import com.voximplant.sdk.call.VideoFlags;
import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.data.voximplant.AuthError;
import io.streamlayer.common.data.voximplant.VoxClientManagerKt;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.sdk.model.auth.VoximplantUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0013\u001a\u00020\u000e2\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fJ\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\n\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0002J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u000eJ\b\u0010#\u001a\u00020\u000eH\u0016J\b\u0010$\u001a\u00020\u000eH\u0016J\u0012\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u0010H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u00101\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\u0012J\u000e\u00103\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/streamlayer/common/data/voximplant/VoxClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "client", "Lcom/voximplant/sdk/client/IClient;", "(Lcom/voximplant/sdk/client/IClient;)V", "getClient", "()Lcom/voximplant/sdk/client/IClient;", "listeners", "", "Lio/streamlayer/common/data/voximplant/VoxClientManager$Listener;", "reconnectCompletion", "Lkotlin/Function1;", "Lio/streamlayer/common/data/voximplant/AuthError;", "", "servers", "", "voximplantUser", "Lio/streamlayer/sdk/model/auth/VoximplantUser;", "connect", "completion", "createCall", "Lcom/voximplant/sdk/call/ICall;", "topicId", "isVideoEnabled", "", "listener", "Lcom/voximplant/sdk/call/ICallListener;", "endCall", "call", "getSubscribedListener", "internalConnectAndLogin", "login", "user", "logout", "onConnectionClosed", "onConnectionEstablished", "onConnectionFailed", "p0", "onLoginFailed", "reason", "Lcom/voximplant/sdk/client/LoginError;", "onLoginSuccessful", "displayName", "authParams", "Lcom/voximplant/sdk/client/AuthParams;", "onOneTimeKeyGenerated", "key", "onRefreshTokenFailed", "onRefreshTokenSuccess", "register", "unregister", "Listener", "sdk_originalRelease"})
public final class VoxClientManager
implements IClientSessionListener,
IClientLoginListener {
    @NotNull
    private final IClient client;
    @Nullable
    private VoximplantUser voximplantUser;
    @NotNull
    private final List<String> servers;
    @Nullable
    private Function1<? super AuthError, Unit> reconnectCompletion;
    @NotNull
    private final List<Listener> listeners;

    public VoxClientManager(@NotNull IClient object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        IClient iClient = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"client");
        this.client = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.servers = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.listeners = object;
        iClient.setClientLoginListener((IClientLoginListener)this);
        iClient.setClientSessionListener((IClientSessionListener)this);
    }

    private final Listener getSubscribedListener() {
        Object var1_1;
        block1: {
            for (Object e : ((VoxClientManager)this).listeners) {
                var1_1 = e;
                if (!((Listener)e).isSubscribed()) continue;
                break block1;
            }
            var1_1 = null;
        }
        return var1_1;
    }

    public static /* synthetic */ void connect$default(VoxClientManager voxClientManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        voxClientManager.connect((Function1<? super AuthError, Unit>)function1);
    }

    private final void internalConnectAndLogin() {
        Object object = SLRLog.INSTANCE;
        ((SLRLog)object).i("VoxClientManager", "internalConnectAndLogin " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.DISCONNECTED) {
            ((SLRLog)object).i("VoxClientManager", "internalConnectAndLogin init connect");
            IClient iClient = this.client;
            boolean bl = false;
            try {
                iClient.connect(bl, this.servers);
            }
            catch (IllegalStateException illegalStateException) {
                this.onConnectionFailed(AuthError.NetworkIssues.getDescription());
            }
        }
        if (this.client.getClientState() == ClientState.CONNECTED) {
            Unit unit;
            SLRLog.INSTANCE.i("VoxClientManager", "internalConnectAndLogin init login");
            object = this.voximplantUser;
            if (object != null) {
                Object object2 = object;
                object = ((VoximplantUser)object2).getUsername();
                this.client.login((String)object, ((VoximplantUser)object2).getPassword());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                this.onLoginFailed(LoginError.INVALID_USERNAME);
            }
        }
    }

    @NotNull
    public final IClient getClient() {
        return this.client;
    }

    public final void register(@NotNull Listener listener2, @Nullable VoximplantUser voximplantUser2) {
        VoxClientManager voxClientManager = this;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SLRLog.INSTANCE.d("VoxClientManager", "register " + listener2 + ' ' + voximplantUser2);
        boolean bl = voxClientManager.listeners.isEmpty();
        if (voxClientManager.listeners.isEmpty() ^ true) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).updateSubscription(false);
            }
        }
        this.listeners.add(listener2);
        listener2.updateSubscription(true);
        if (bl && voximplantUser2 != null) {
            this.login(voximplantUser2);
        }
    }

    public final void unregister(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        SLRLog.INSTANCE.d("VoxClientManager", "unregister " + listener2);
        this.listeners.remove(listener2);
        listener2.updateSubscription(false);
        if (this.listeners.isEmpty()) {
            this.logout();
        } else {
            ((Listener)CollectionsKt.last(this.listeners)).updateSubscription(true);
        }
    }

    public final void login(@NotNull VoximplantUser voximplantUser2) {
        Intrinsics.checkNotNullParameter((Object)voximplantUser2, (String)"user");
        SLRLog.INSTANCE.i("VoxClientManager", "login " + voximplantUser2 + ' ' + this.client.getClientState());
        if (Intrinsics.areEqual((Object)this.voximplantUser, (Object)voximplantUser2)) {
            return;
        }
        this.voximplantUser = voximplantUser2;
        this.internalConnectAndLogin();
    }

    public final void logout() {
        SLRLog.INSTANCE.i("VoxClientManager", "logout " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
        this.voximplantUser = null;
    }

    public final void connect(@Nullable Function1<? super AuthError, Unit> function1) {
        SLRLog.INSTANCE.i("VoxClientManager", "connect " + this.client.getClientState());
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            if (function1 != null) {
                function1.invoke(null);
            }
            return;
        }
        if (this.voximplantUser == null) {
            if (function1 != null) {
                function1.invoke((Object)AuthError.InvalidUsername);
            }
            return;
        }
        this.reconnectCompletion = function1;
        this.internalConnectAndLogin();
    }

    public void onConnectionEstablished() {
        this.internalConnectAndLogin();
    }

    public void onConnectionFailed(@Nullable String function1) {
        SLRLog.INSTANCE.i("VoxClientManager", "onConnectionFailed " + (String)function1);
        function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionFailed(AuthError.NetworkIssues);
        }
        if ((function1 = this.reconnectCompletion) != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onConnectionClosed() {
        SLRLog.INSTANCE.i("VoxClientManager", "onConnectionClosed");
        Function1<? super AuthError, Unit> function1 = this.getSubscribedListener();
        if (function1 != null) {
            function1.onConnectionClosed();
        }
        if ((function1 = this.reconnectCompletion) != null) {
            function1.invoke((Object)AuthError.NetworkIssues);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginSuccessful(@NotNull String function1, @Nullable AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"displayName");
        SLRLog.INSTANCE.i("VoxClientManager", "onLoginSuccessful " + (String)function1);
        function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(null);
        }
        this.reconnectCompletion = null;
    }

    public void onLoginFailed(@NotNull LoginError object) {
        LoginError loginError = object;
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
        object = VoxClientManagerKt.access$makeAuthError(loginError);
        SLRLog.INSTANCE.i("VoxClientManager", "onLoginFailed " + object);
        Function1<? super AuthError, Unit> function1 = this.reconnectCompletion;
        if (function1 != null) {
            function1.invoke(object);
        }
        this.reconnectCompletion = null;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkNotNullParameter((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
    }

    @Nullable
    public final ICall createCall(@NotNull String string2, boolean bl, @Nullable ICallListener iCallListener) {
        CallSettings callSettings;
        VoxClientManager voxClientManager = voxClientManager2;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        SLRLog.INSTANCE.i("VoxClientManager", "createCall " + string2);
        VoxClientManager voxClientManager2 = callSettings;
        new CallSettings().videoFlags = new VideoFlags(true, bl);
        new CallSettings().preferredVideoCodec = VideoCodec.AUTO;
        voxClientManager2 = voxClientManager.client.callConference("conf_" + string2, (CallSettings)voxClientManager2);
        if (voxClientManager2 != null) {
            VoxClientManager voxClientManager3 = voxClientManager2;
            voxClientManager3.addCallListener(iCallListener);
            voxClientManager3.start();
        }
        return voxClientManager2;
    }

    public final void endCall(@NotNull ICall iCall, @Nullable ICallListener iCallListener) {
        Intrinsics.checkNotNullParameter((Object)iCall, (String)"call");
        if (iCallListener != null) {
            iCall.removeCallListener(iCallListener);
        }
        iCall.hangup(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/common/data/voximplant/VoxClientManager$Listener;", "", "isSubscribed", "", "onConnectionClosed", "", "onConnectionFailed", "error", "Lio/streamlayer/common/data/voximplant/AuthError;", "updateSubscription", "isActive", "sdk_originalRelease"})
    public static interface Listener {
        public boolean isSubscribed();

        public void updateSubscription(boolean var1);

        public void onConnectionFailed(@NotNull AuthError var1);

        public void onConnectionClosed();
    }
}

