/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.keyboard;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.google.android.material.textview.MaterialTextView;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.keyboard.EmojiLayout;
import io.streamlayer.common.views.keyboard.KeyboardEmojiView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.StreamLayerUI;
import io.streamlayer.sdk.messaging.ChatHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0004*+,-B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u0014J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020!J\u0006\u0010(\u001a\u00020!J\u0006\u0010)\u001a\u00020!R\u0015\u0010\t\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "adapter", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "getAdapter", "()Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "editText", "Landroidx/appcompat/widget/AppCompatEditText;", "getEditText", "()Landroidx/appcompat/widget/AppCompatEditText;", "setEditText", "(Landroidx/appcompat/widget/AppCompatEditText;)V", "inputKeyboardEventListener", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$InputKeyboardEventListener;", "keyboardPages", "", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Pages;", "pager", "Landroidx/viewpager2/widget/ViewPager2;", "getPager", "()Landroidx/viewpager2/widget/ViewPager2;", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "getTabLayout", "()Lcom/google/android/material/tabs/TabLayout;", "hide", "", "setInputKeyboardEventListener", "listener", "setKeyboardVisibility", "value", "", "show", "showEmoji", "showStickers", "Adapter", "InputKeyboardEventListener", "LayoutKeyboardConfiguration", "Pages", "sdk_originalRelease"})
public final class KeyboardEmojiView
extends ConstraintLayout {
    @NotNull
    private final TabLayout tabLayout;
    @NotNull
    private final ViewPager2 pager;
    @NotNull
    private final List<Pages> keyboardPages;
    @NotNull
    private final Adapter adapter;
    @Nullable
    private AppCompatEditText editText;
    @Nullable
    private InputKeyboardEventListener inputKeyboardEventListener;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    @JvmOverloads
    public KeyboardEmojiView(@NotNull Context context, @Nullable AttributeSet object, int n) {
        ViewPager2 viewPager2;
        Adapter adapter2;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        super(context, (AttributeSet)object, n);
        object = arrayList;
        arrayList = new ArrayList();
        Object object2 = ChatHelper.INSTANCE;
        if (object2.isStickersEnable()) {
            object.add(Pages.STICKERS);
        }
        if (object2.isEmojiEnable()) {
            object.add(Pages.EMOJI);
        }
        if (object2.isGifsEnable()) {
            object.add(Pages.GIFS);
        }
        KeyboardEmojiView keyboardEmojiView = this;
        keyboardEmojiView.keyboardPages = object;
        object2 = adapter2;
        keyboardEmojiView.adapter = new Adapter((List<? extends Pages>)object);
        Integer n2 = StreamLayerUI.INSTANCE.getCustomTheme$sdk_originalRelease().getMessengerTheme();
        int n3 = n2 != null ? n2 : R.style.StreamLayerSDK_ChatTheme;
        KeyboardEmojiView keyboardEmojiView2 = this;
        Object object3 = object;
        object3(context, n3);
        LayoutInflater.from((Context)object3).inflate(R.layout.slr_layout_keyboard, (ViewGroup)this, true);
        View view2 = keyboardEmojiView2.findViewById(R.id.tab_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.tab_layout)");
        object = (TabLayout)view2;
        keyboardEmojiView2.tabLayout = object;
        View view3 = keyboardEmojiView2.findViewById(R.id.pager);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.pager)");
        this.pager = viewPager2 = (ViewPager2)view3;
        viewPager2.setAdapter((RecyclerView.Adapter)object2);
        new TabLayoutMediator((TabLayout)object, viewPager2, (arg_0, arg_1) -> KeyboardEmojiView._init_$lambda-1(context, this, arg_0, arg_1)).attach();
    }

    public /* synthetic */ KeyboardEmojiView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public KeyboardEmojiView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public KeyboardEmojiView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void _init_$lambda-1(Context context, KeyboardEmojiView keyboardEmojiView, TabLayout.Tab tab, int n) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)((Object)keyboardEmojiView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        tab.setIcon(ContextCompat.getDrawable((Context)context, (int)keyboardEmojiView.keyboardPages.get(n).getIdRes()));
    }

    @NotNull
    public final TabLayout getTabLayout() {
        return this.tabLayout;
    }

    @NotNull
    public final ViewPager2 getPager() {
        return this.pager;
    }

    @NotNull
    public final Adapter getAdapter() {
        return this.adapter;
    }

    @Nullable
    public final AppCompatEditText getEditText() {
        return this.editText;
    }

    public final void setEditText(@Nullable AppCompatEditText appCompatEditText) {
        this.editText = appCompatEditText;
    }

    public final void showEmoji() {
        KeyboardEmojiView keyboardEmojiView = this;
        keyboardEmojiView.show();
        keyboardEmojiView.pager.setCurrentItem(1, false);
    }

    public final void showStickers() {
        KeyboardEmojiView keyboardEmojiView = this;
        keyboardEmojiView.show();
        keyboardEmojiView.pager.setCurrentItem(0, false);
    }

    public final void setKeyboardVisibility(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public final void show() {
        Context context = inputKeyboardEventListener.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(inputKeyboardEventListener.getWindowToken(), 0);
        }
        if ((inputMethodManager = inputKeyboardEventListener.getLayoutParams()) != null) {
            inputMethodManager = (ConstraintLayout.LayoutParams)inputMethodManager;
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = LayoutKeyboardConfiguration.INSTANCE;
            Context context2 = inputKeyboardEventListener.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            if (layoutKeyboardConfiguration.getHeight(context2) != 0) {
                Context context3 = inputKeyboardEventListener.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                inputMethodManager.height = layoutKeyboardConfiguration.getHeight(context3);
            }
            KeyboardEmojiView keyboardEmojiView = inputKeyboardEventListener;
            keyboardEmojiView.setVisibility(0);
            keyboardEmojiView.setLayoutParams((ViewGroup.LayoutParams)inputMethodManager);
            InputKeyboardEventListener inputKeyboardEventListener = keyboardEmojiView.inputKeyboardEventListener;
            if (inputKeyboardEventListener != null) {
                inputKeyboardEventListener.onKeyboardVisible(true);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
    }

    public final void hide() {
        KeyboardEmojiView keyboardEmojiView = inputKeyboardEventListener;
        keyboardEmojiView.setVisibility(8);
        InputKeyboardEventListener inputKeyboardEventListener = keyboardEmojiView.inputKeyboardEventListener;
        if (inputKeyboardEventListener != null) {
            inputKeyboardEventListener.onKeyboardVisible(false);
        }
    }

    public final void setInputKeyboardEventListener(@Nullable InputKeyboardEventListener inputKeyboardEventListener) {
        this.inputKeyboardEventListener = inputKeyboardEventListener;
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int n) {
        Map<Integer, View> map2 = this._$_findViewCache;
        View view2 = map2.get(n);
        if (view2 == null) {
            view2 = this.findViewById(n);
            if (view2 != null) {
                map2.put(n, view2);
            } else {
                view2 = null;
            }
        }
        return view2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Pages;", "", "idRes", "", "(Ljava/lang/String;II)V", "getIdRes", "()I", "STICKERS", "EMOJI", "GIFS", "sdk_originalRelease"})
    public static final class Pages
    extends Enum<Pages> {
        public static final /* enum */ Pages STICKERS;
        public static final /* enum */ Pages EMOJI;
        public static final /* enum */ Pages GIFS;
        private static final /* synthetic */ Pages[] $VALUES;
        private final int idRes;

        private Pages(int n2) {
            this.idRes = n2;
        }

        public static Pages[] values() {
            return (Pages[])$VALUES.clone();
        }

        public static Pages valueOf(String string2) {
            return Enum.valueOf(Pages.class, string2);
        }

        private static final /* synthetic */ Pages[] $values() {
            return new Pages[]{STICKERS, EMOJI, GIFS};
        }

        static {
            int n = R.drawable.slr_ic_chat_attach;
            STICKERS = new Pages(n);
            n = R.drawable.slr_ic_emoji_tab;
            EMOJI = new Pages(n);
            n = R.drawable.slr_ic_gif_tab;
            GIFS = new Pages(n);
            $VALUES = Pages.$values();
        }

        public final int getIdRes() {
            return this.idRes;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u0010\u0012\f\u0012\n0\u0002R\u00060\u0000R\u00020\u00030\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n0\u0002R\u00060\u0000R\u00020\u00032\u0006\u0010\r\u001a\u00020\tH\u0016J \u0010\u000e\u001a\n0\u0002R\u00060\u0000R\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter$PageVH;", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "pages", "", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Pages;", "(Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;Ljava/util/List;)V", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "PageVH", "sdk_originalRelease"})
    public final class Adapter
    extends RecyclerView.Adapter<PageVH> {
        @NotNull
        private final List<Pages> pages;

        public Adapter(List<? extends Pages> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"pages");
            this.pages = list2;
        }

        @NotNull
        public PageVH onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
            FrameLayout frameLayout;
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
            FrameLayout frameLayout2 = frameLayout;
            new FrameLayout(viewGroup.getContext()).setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
            return new PageVH(this, (ViewGroup)frameLayout2);
        }

        public void onBindViewHolder(@NotNull PageVH pageVH, int n) {
            RecyclerView recyclerView;
            Intrinsics.checkNotNullParameter((Object)((Object)pageVH), (String)"holder");
            int n2 = WhenMappings.$EnumSwitchMapping$0[object.pages.get(n).ordinal()];
            if (n2 != 1) {
                if (n2 == 2) {
                    MaterialTextView materialTextView;
                    MaterialTextView materialTextView2;
                    ViewGroup viewGroup = pageVH.getParent();
                    MaterialTextView materialTextView3 = materialTextView2 = materialTextView;
                    materialTextView3(object.KeyboardEmojiView.this.getContext());
                    Context context = materialTextView2.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    materialTextView3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, LayoutKeyboardConfiguration.INSTANCE.getHeight(context)));
                    materialTextView3.setGravity(17);
                    materialTextView.setText((CharSequence)object.pages.get(n).name());
                    viewGroup.addView((View)materialTextView);
                }
            } else {
                ViewGroup viewGroup = pageVH.getParent();
                Context context = object.KeyboardEmojiView.this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                EmojiLayout emojiLayout = new EmojiLayout(context, null, 0, 6, null);
                KeyboardEmojiView keyboardEmojiView = object.KeyboardEmojiView.this;
                emojiLayout.setId(View.generateViewId());
                emojiLayout.setEditText(keyboardEmojiView.getEditText());
                emojiLayout.setPager(keyboardEmojiView.getPager());
                viewGroup.addView((View)emojiLayout);
            }
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = LayoutKeyboardConfiguration.INSTANCE;
            Context context = object.KeyboardEmojiView.this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (layoutKeyboardConfiguration.getHeight(context) != 0 && (recyclerView = pageVH.getList()) != null) {
                Object object = object.KeyboardEmojiView.this;
                ViewGroup.LayoutParams layoutParams = recyclerView.getLayoutParams();
                if (layoutParams != null) {
                    ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
                    Context context2 = object.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                    layoutParams2.height = layoutKeyboardConfiguration.getHeight(context2) - pageVH.getParent().getResources().getDimensionPixelSize(R.dimen.slr_keyboard_tab_height) - pageVH.getParent().getResources().getDimensionPixelSize(R.dimen.slr_emoji_tab_height);
                    recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                } else {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                }
            }
        }

        public int getItemCount() {
            return this.pages.size();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter$PageVH;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "(Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$Adapter;Landroid/view/ViewGroup;)V", "list", "Landroidx/recyclerview/widget/RecyclerView;", "getList", "()Landroidx/recyclerview/widget/RecyclerView;", "list$delegate", "Lkotlin/Lazy;", "getParent", "()Landroid/view/ViewGroup;", "sdk_originalRelease"})
        public final class PageVH
        extends RecyclerView.ViewHolder {
            @NotNull
            private final ViewGroup parent;
            @NotNull
            private final Lazy list$delegate;
            final /* synthetic */ Adapter this$0;

            public PageVH(@NotNull Adapter adapter2, ViewGroup viewGroup) {
                PageVH pageVH = this;
                Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
                this.this$0 = adapter2;
                super((View)viewGroup);
                pageVH.parent = viewGroup;
                pageVH.list$delegate = LazyKt.lazy((Function0)new Function0<RecyclerView>(this){
                    final /* synthetic */ PageVH this$0;
                    {
                        this.this$0 = pageVH;
                        super(0);
                    }

                    public final RecyclerView invoke() {
                        return (RecyclerView)this.this$0.getParent().findViewById(R.id.list_item);
                    }
                });
            }

            @NotNull
            public final ViewGroup getParent() {
                return this.parent;
            }

            @Nullable
            public final RecyclerView getList() {
                return (RecyclerView)this.list$delegate.getValue();
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Pages.values().length];
                nArray[Pages.EMOJI.ordinal()] = 1;
                nArray[Pages.GIFS.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$InputKeyboardEventListener;", "", "onKeyboardVisible", "", "value", "", "sdk_originalRelease"})
    public static interface InputKeyboardEventListener {
        public void onKeyboardVisible(boolean var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardEmojiView$LayoutKeyboardConfiguration;", "", "()V", "KEYBOARD_HEIGHT_LAND", "", "KEYBOARD_HEIGHT_PORT", "KEYBOARD_PREF", "keyboardHeightLandscape", "", "getKeyboardHeightLandscape", "()I", "setKeyboardHeightLandscape", "(I)V", "keyboardHeightPortrait", "getKeyboardHeightPortrait", "setKeyboardHeightPortrait", "getHeight", "context", "Landroid/content/Context;", "getNavigationBarHeight", "initKeyboardHeight", "", "parent", "Landroid/view/ViewGroup;", "activity", "Landroidx/fragment/app/FragmentActivity;", "setupKeyboardHeight", "height", "sdk_originalRelease"})
    public static final class LayoutKeyboardConfiguration {
        @NotNull
        public static final LayoutKeyboardConfiguration INSTANCE = new LayoutKeyboardConfiguration();
        private static int keyboardHeightPortrait;
        private static int keyboardHeightLandscape;
        @NotNull
        private static final String KEYBOARD_PREF = "keyboard_pref";
        @NotNull
        private static final String KEYBOARD_HEIGHT_PORT = "height_port";
        @NotNull
        private static final String KEYBOARD_HEIGHT_LAND = "height_land";

        private LayoutKeyboardConfiguration() {
        }

        private static final WindowInsetsCompat initKeyboardHeight$lambda-0(ViewGroup viewGroup, View view2, WindowInsetsCompat windowInsetsCompat) {
            Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"$parent");
            viewGroup = viewGroup.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)viewGroup, (String)"parent.context");
            INSTANCE.setupKeyboardHeight((Context)viewGroup, windowInsetsCompat.getInsets((int)WindowInsetsCompat.Type.ime()).bottom);
            return windowInsetsCompat;
        }

        public final void initKeyboardHeight(@NotNull ViewGroup viewGroup) {
            ViewGroup viewGroup2 = viewGroup;
            Intrinsics.checkNotNullParameter((Object)viewGroup2, (String)"parent");
            ViewCompat.setOnApplyWindowInsetsListener((View)viewGroup2, (arg_0, arg_1) -> LayoutKeyboardConfiguration.initKeyboardHeight$lambda-0(viewGroup2, arg_0, arg_1));
        }

        public final void initKeyboardHeight(@NotNull FragmentActivity fragmentActivity) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = layoutKeyboardConfiguration2;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            Intrinsics.checkNotNullParameter((Object)fragmentActivity2, (String)"activity");
            View view2 = fragmentActivity2.findViewById(0x1020002);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"activity.findViewById(android.R.id.content)");
            LayoutKeyboardConfiguration layoutKeyboardConfiguration2 = (ViewGroup)view2;
            if (layoutKeyboardConfiguration.getHeight((Context)fragmentActivity2) != 0) {
                return;
            }
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener((ViewGroup)layoutKeyboardConfiguration2, fragmentActivity){
                final /* synthetic */ ViewGroup $rootContent;
                final /* synthetic */ FragmentActivity $activity;
                {
                    this.$rootContent = viewGroup;
                    this.$activity = fragmentActivity;
                }

                private static final void onGlobalLayout$lambda-1(FragmentActivity fragmentActivity, ViewGroup viewGroup, initKeyboardHeight.layoutListener.1 var2_2) {
                    Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"$activity");
                    Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"$rootContent");
                    Intrinsics.checkNotNullParameter((Object)var2_2, (String)"this$0");
                    int n = fragmentActivity.getResources().getConfiguration().orientation == 1 ? 1 : 0;
                    int n2 = n != 0 ? LayoutKeyboardConfiguration.INSTANCE.getNavigationBarHeight((Context)fragmentActivity) : 0;
                    WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)viewGroup);
                    if (windowInsetsCompat != null) {
                        boolean bl = windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime());
                        SLRLog sLRLog = SLRLog.INSTANCE;
                        sLRLog.d("ChatViewModel", "KeyboardPopUp isPortrait " + (n != 0));
                        sLRLog.d("ChatViewModel", "KeyboardPopUp navigationBarHeight " + n2);
                        sLRLog.d("ChatViewModel", "KeyboardPopUp imeVisible " + bl);
                        if (bl) {
                            int n3 = n;
                            SLRLog sLRLog2 = sLRLog;
                            WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
                            n = windowInsetsCompat2.getInsets((int)WindowInsetsCompat.Type.ime()).bottom - n2;
                            sLRLog2.d("ChatViewModel", "KeyboardPopUp navigationBars " + windowInsetsCompat2.getInsets((int)WindowInsetsCompat.Type.navigationBars()).bottom);
                            sLRLog2.d("ChatViewModel", "KeyboardPopUp imeHeight " + n);
                            if ((n3 == 0 || n <= fragmentActivity.getResources().getDisplayMetrics().heightPixels / 2) && n != 0 && n >= fragmentActivity.getResources().getDisplayMetrics().heightPixels / 4) {
                                LayoutKeyboardConfiguration.INSTANCE.setupKeyboardHeight((Context)fragmentActivity, n);
                                viewGroup.getRootView().getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)var2_2);
                            } else {
                                return;
                            }
                        }
                    }
                }

                public void onGlobalLayout() {
                    ViewGroup viewGroup = this.$rootContent;
                    viewGroup.postDelayed(() -> initKeyboardHeight.layoutListener.1.onGlobalLayout$lambda-1(this.$activity, viewGroup, this), 100L);
                }
            };
            layoutKeyboardConfiguration2.getRootView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
        }

        public final void setupKeyboardHeight(@NotNull Context context, int n) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (n != 0) {
                Context context2 = context;
                LayoutKeyboardConfiguration layoutKeyboardConfiguration = context2.getSharedPreferences(KEYBOARD_PREF, 0).edit();
                Intrinsics.checkNotNullExpressionValue((Object)layoutKeyboardConfiguration, (String)"context.getSharedPrefere\u2026text.MODE_PRIVATE).edit()");
                if (context2.getResources().getConfiguration().orientation == 1) {
                    keyboardHeightPortrait = n;
                    layoutKeyboardConfiguration.putInt(KEYBOARD_HEIGHT_PORT, n).apply();
                } else {
                    keyboardHeightLandscape = n;
                    layoutKeyboardConfiguration.putInt(KEYBOARD_HEIGHT_LAND, n).apply();
                }
            }
        }

        public final int getNavigationBarHeight(@NotNull Context context) {
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return context2.getResources().getDimensionPixelSize(context.getResources().getIdentifier("navigation_bar_height", "dimen", "android"));
        }

        public final int getHeight(@NotNull Context context) {
            int n;
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            LayoutKeyboardConfiguration layoutKeyboardConfiguration = context2.getSharedPreferences(KEYBOARD_PREF, 0);
            Intrinsics.checkNotNullExpressionValue((Object)layoutKeyboardConfiguration, (String)"context.getSharedPrefere\u2026EF, Context.MODE_PRIVATE)");
            if (context2.getResources().getConfiguration().orientation == 1) {
                if (keyboardHeightPortrait == 0) {
                    keyboardHeightPortrait = layoutKeyboardConfiguration.getInt(KEYBOARD_HEIGHT_PORT, 0);
                }
                SLRLog.INSTANCE.d("ChatViewModel", "LayoutKeyboardConfiguration keyboardHeightPortrait " + keyboardHeightPortrait);
                n = keyboardHeightPortrait;
            } else {
                if (keyboardHeightLandscape == 0) {
                    keyboardHeightLandscape = layoutKeyboardConfiguration.getInt(KEYBOARD_HEIGHT_LAND, 0);
                }
                SLRLog.INSTANCE.d("ChatViewModel", "LayoutKeyboardConfiguration keyboardHeightLandscape " + keyboardHeightLandscape);
                n = keyboardHeightLandscape;
            }
            return n;
        }

        public final int getKeyboardHeightPortrait() {
            return keyboardHeightPortrait;
        }

        public final void setKeyboardHeightPortrait(int n) {
            keyboardHeightPortrait = n;
        }

        public final int getKeyboardHeightLandscape() {
            return keyboardHeightLandscape;
        }

        public final void setKeyboardHeightLandscape(int n) {
            keyboardHeightLandscape = n;
        }
    }
}

