/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views.keyboard;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.PopupWindow;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import io.streamlayer.common.utils.SLRLog;
import io.streamlayer.common.views.keyboard.KeyboardEmojiView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020!J\b\u0010(\u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0014\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardPopUp;", "", "activityView", "Landroid/view/View;", "rootView", "Landroid/view/ViewGroup;", "editText", "Landroidx/appcompat/widget/AppCompatEditText;", "(Landroid/view/View;Landroid/view/ViewGroup;Landroidx/appcompat/widget/AppCompatEditText;)V", "getActivityView", "()Landroid/view/View;", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "dismissListener", "Lio/streamlayer/common/views/keyboard/KeyboardPopUp$KeyboardDismissListener;", "getEditText", "()Landroidx/appcompat/widget/AppCompatEditText;", "isPortrait", "", "()Z", "isVisible", "setVisible", "(Z)V", "keyboardEmojiView", "Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "getKeyboardEmojiView", "()Lio/streamlayer/common/views/keyboard/KeyboardEmojiView;", "popUp", "Landroid/widget/PopupWindow;", "getRootView", "()Landroid/view/ViewGroup;", "hide", "", "setOnDismissListener", "listener", "setRootBottomMargin", "margin", "", "show", "showPopup", "KeyboardDismissListener", "sdk_originalRelease"})
public final class KeyboardPopUp {
    @NotNull
    private final View activityView;
    @Nullable
    private final ViewGroup rootView;
    @NotNull
    private final AppCompatEditText editText;
    private final Context context;
    @NotNull
    private final PopupWindow popUp;
    @Nullable
    private KeyboardDismissListener dismissListener;
    @NotNull
    private final KeyboardEmojiView keyboardEmojiView;
    private boolean isVisible;

    public KeyboardPopUp(@NotNull View view2, @Nullable ViewGroup viewGroup, @NotNull AppCompatEditText appCompatEditText) {
        KeyboardPopUp keyboardPopUp;
        KeyboardPopUp keyboardPopUp2;
        KeyboardEmojiView keyboardEmojiView;
        PopupWindow popupWindow;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"activityView");
        Intrinsics.checkNotNullParameter((Object)appCompatEditText, (String)"editText");
        object.activityView = view2;
        object.rootView = viewGroup;
        object.editText = appCompatEditText;
        viewGroup = view2.getContext();
        object.context = viewGroup;
        PopupWindow popupWindow2 = popupWindow;
        KeyboardPopUp keyboardPopUp3 = object;
        PopupWindow popupWindow3 = popupWindow2;
        PopupWindow popupWindow4 = popupWindow2;
        popupWindow4((Context)viewGroup);
        object.popUp = popupWindow4;
        Object object = keyboardEmojiView;
        ViewGroup viewGroup2 = viewGroup;
        Intrinsics.checkNotNullExpressionValue((Object)viewGroup2, (String)"context");
        super((Context)viewGroup2, null, 0, 6, null);
        keyboardEmojiView.setEditText(appCompatEditText);
        keyboardPopUp2.keyboardEmojiView = keyboardEmojiView;
        view2.postDelayed(() -> KeyboardPopUp._init_$lambda-1(keyboardPopUp2), 100L);
        popupWindow3.setFocusable(true);
        popupWindow3.setInputMethodMode(2);
        popupWindow3.setContentView((View)object);
        popupWindow3.setWidth(-1);
        popupWindow3.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        popupWindow3.setOutsideTouchable(false);
        popupWindow3.setFocusable(false);
        popupWindow.setOnDismissListener(() -> KeyboardPopUp.lambda-4$lambda-2(keyboardPopUp3));
        appCompatEditText.setOnTouchListener((arg_0, arg_1) -> KeyboardPopUp.lambda-4$lambda-3(keyboardPopUp, arg_0, arg_1));
    }

    private final boolean isPortrait() {
        return this.context.getResources().getConfiguration().orientation == 1;
    }

    private final void showPopup() {
        this.editText.post(() -> KeyboardPopUp.showPopup$lambda-6(this));
    }

    private final void setRootBottomMargin(int n) {
        SLRLog sLRLog = SLRLog.INSTANCE;
        sLRLog.d("ChatViewModel", "KeyboardPopUp setRootBottomMargin " + n);
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)keyboardPopUp2.activityView);
        if (windowInsetsCompat != null) {
            boolean bl = windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime());
            sLRLog.d("ChatViewModel", "KeyboardPopUp imeVisible " + bl);
            if (bl && (keyboardPopUp2 = keyboardPopUp2.rootView) != null) {
                sLRLog = keyboardPopUp2.getLayoutParams();
                if (sLRLog != null) {
                    KeyboardPopUp keyboardPopUp = keyboardPopUp2;
                    KeyboardPopUp keyboardPopUp2 = (ViewGroup.MarginLayoutParams)sLRLog;
                    ((ViewGroup.MarginLayoutParams)sLRLog).bottomMargin = n;
                    keyboardPopUp.setLayoutParams((ViewGroup.LayoutParams)keyboardPopUp2);
                } else {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
            }
        }
    }

    private static final void _init_$lambda-1(KeyboardPopUp keyboardPopUp) {
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        Context context = keyboardPopUp.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        if (KeyboardEmojiView.LayoutKeyboardConfiguration.INSTANCE.getHeight(context) == 0) {
            KeyboardPopUp keyboardPopUp2 = keyboardPopUp;
            keyboardPopUp2.editText.requestFocus();
            Context context2 = keyboardPopUp2.context;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)context2, InputMethodManager.class);
            if (inputMethodManager != null) {
                inputMethodManager.showSoftInput((View)keyboardPopUp.editText, 0);
            }
        }
    }

    private static final void lambda-4$lambda-2(KeyboardPopUp object) {
        KeyboardPopUp keyboardPopUp = object;
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        keyboardPopUp.isVisible = false;
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)keyboardPopUp.activityView);
        if (windowInsetsCompat != null && !windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime())) {
            ((KeyboardPopUp)object).setRootBottomMargin(0);
        }
        if ((object = ((KeyboardPopUp)object).dismissListener) != null) {
            object.onKeyboardDismiss();
        }
    }

    private static final boolean lambda-4$lambda-3(KeyboardPopUp keyboardPopUp, View view2, MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        if (motionEvent.getAction() == 1) {
            view2.requestFocus();
            keyboardPopUp.popUp.dismiss();
        }
        return false;
    }

    private static final void showPopup$lambda-6$lambda-5(KeyboardPopUp keyboardPopUp) {
        KeyboardPopUp keyboardPopUp2 = keyboardPopUp;
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp2, (String)"this$0");
        keyboardPopUp2.editText.requestFocus();
    }

    private static final void showPopup$lambda-6(KeyboardPopUp keyboardPopUp) {
        Intrinsics.checkNotNullParameter((Object)keyboardPopUp, (String)"this$0");
        SLRLog sLRLog = SLRLog.INSTANCE;
        sLRLog.d("ChatViewModel", "KeyboardPopUp show " + keyboardPopUp.isVisible + " isPortrait " + keyboardPopUp.isPortrait());
        Context context = keyboardPopUp.context;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int n = KeyboardEmojiView.LayoutKeyboardConfiguration.INSTANCE.getHeight(context);
        sLRLog.d("ChatViewModel", "KeyboardPopUp show " + n);
        if (n == 0) {
            Context context2 = keyboardPopUp.context;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            sLRLog = (InputMethodManager)ContextCompat.getSystemService((Context)context2, InputMethodManager.class);
            if (sLRLog != null) {
                sLRLog.showSoftInput((View)keyboardPopUp.editText, 2);
            }
            keyboardPopUp.showPopup();
            return;
        }
        KeyboardPopUp keyboardPopUp2 = keyboardPopUp;
        int n2 = keyboardPopUp.context.getResources().getDisplayMetrics().heightPixels;
        keyboardPopUp2.popUp.showAtLocation(keyboardPopUp.activityView, 0, 0, n2);
        if (!keyboardPopUp2.editText.hasFocus()) {
            keyboardPopUp.editText.postDelayed(() -> KeyboardPopUp.showPopup$lambda-6$lambda-5(keyboardPopUp), 50L);
        }
    }

    @NotNull
    public final View getActivityView() {
        return this.activityView;
    }

    @Nullable
    public final ViewGroup getRootView() {
        return this.rootView;
    }

    @NotNull
    public final AppCompatEditText getEditText() {
        return this.editText;
    }

    @NotNull
    public final KeyboardEmojiView getKeyboardEmojiView() {
        return this.keyboardEmojiView;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public final void setOnDismissListener(@Nullable KeyboardDismissListener keyboardDismissListener) {
        this.dismissListener = keyboardDismissListener;
    }

    public final void show() {
        Object object;
        SLRLog.INSTANCE.d("ChatViewModel", "KeyboardPopUp show " + this.isVisible + " isPortrait " + this.isPortrait());
        this.isVisible = true;
        if (!this.isPortrait()) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.setRootBottomMargin(KeyboardEmojiView.LayoutKeyboardConfiguration.INSTANCE.getHeight(context));
        }
        if (this.editText.requestFocus()) {
            Context context = this.context;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            object = (InputMethodManager)ContextCompat.getSystemService((Context)context, InputMethodManager.class);
            if (object != null) {
                object.showSoftInput((View)this.editText, 2);
            }
        }
        if ((object = this.context.getSystemService("input_method")) != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            inputMethodManager.restartInput((View)this.editText);
            inputMethodManager.showSoftInput((View)this.editText, 0);
            this.showPopup();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    public final void hide() {
        KeyboardPopUp keyboardPopUp = this;
        keyboardPopUp.isVisible = false;
        keyboardPopUp.popUp.dismiss();
        if (!keyboardPopUp.isPortrait()) {
            this.setRootBottomMargin(0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/common/views/keyboard/KeyboardPopUp$KeyboardDismissListener;", "", "onKeyboardDismiss", "", "sdk_originalRelease"})
    public static interface KeyboardDismissListener {
        public void onKeyboardDismiss();
    }
}

