/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.model.messaging;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.Index;
import com.google.gson.annotations.SerializedName;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0081\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010<\u001a\u00020\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\u000eH\u00c6\u0003Je\u0010E\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010I\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010J\u001a\u00020GJ\t\u0010K\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR \u0010\u0010\u001a\u0004\u0018\u00010\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R,\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R&\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010#8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0016\u0010\f\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001fR \u0010)\u001a\u0004\u0018\u00010*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001fR\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0016\u0010\u000b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001fR\u0016\u0010\n\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001f\u00a8\u0006M"}, d2={"Lio/streamlayer/sdk/model/messaging/ChatMessage;", "", "topicId", "", "senderUserId", "seqId", "", "date", "Ljava/util/Date;", "text", "type", "subtype", "replyTo", "status", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;)V", "anyData", "getAnyData", "()Ljava/lang/Object;", "setAnyData", "(Ljava/lang/Object;)V", "getDate", "()Ljava/util/Date;", "head", "", "getHead", "()Ljava/util/Map;", "setHead", "(Ljava/util/Map;)V", "id", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "replyEmoji", "", "getReplyEmoji", "()Ljava/util/List;", "setReplyEmoji", "(Ljava/util/List;)V", "getReplyTo", "sender", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "getSender", "()Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "setSender", "(Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;)V", "getSenderUserId", "getSeqId", "()I", "setSeqId", "(I)V", "getStatus", "()Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "setStatus", "(Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;)V", "getSubtype", "getText", "getTopicId", "getType", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "isStatusSubType", "toString", "updateStatus", "sdk_originalRelease"})
@Entity(indices={@Index(value={"chatMessageTopicId", "uuid", "date", "text"})}, primaryKeys={"chatMessageTopicId", "uuid"})
public final class ChatMessage {
    @ColumnInfo(name="chatMessageTopicId")
    @NotNull
    private final String topicId;
    @SerializedName(value="senderId")
    @NotNull
    private final String senderUserId;
    @SerializedName(value="seq")
    @ColumnInfo(name="remoteSeqId")
    private int seqId;
    @Nullable
    private final Date date;
    @NotNull
    private final String text;
    @SerializedName(value="x-slr-type")
    @NotNull
    private final String type;
    @SerializedName(value="x-slr-subtype")
    @NotNull
    private final String subtype;
    @SerializedName(value="x-slr-reply")
    @NotNull
    private final String replyTo;
    @NotNull
    private ChatMessageStatus status;
    @SerializedName(value="head")
    @Ignore
    @Nullable
    private Map<String, String> head;
    @ColumnInfo(name="uuid")
    @NotNull
    private String id;
    @Ignore
    @Nullable
    private TinodeContact sender;
    @Ignore
    @Nullable
    private Object anyData;
    @Ignore
    @Nullable
    private List<ChatMessage> replyEmoji;

    public ChatMessage(@NotNull String string2, @NotNull String string3, int n, @Nullable Date date, @NotNull String string4, @NotNull String string5, @NotNull String string6, @NotNull String string7, @NotNull ChatMessageStatus chatMessageStatus) {
        ChatMessage chatMessage = this;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"senderUserId");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"text");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string6, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)string7, (String)"replyTo");
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        this.topicId = string2;
        this.senderUserId = string3;
        this.seqId = n;
        this.date = date;
        this.text = string4;
        this.type = string5;
        this.subtype = string6;
        this.replyTo = string7;
        chatMessage.status = chatMessageStatus;
        String string8 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"randomUUID().toString()");
        chatMessage.id = string8;
    }

    public /* synthetic */ ChatMessage(String string2, String string3, int n, Date date, String string4, String string5, String string6, String string7, ChatMessageStatus chatMessageStatus, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            date = null;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "";
        }
        if ((n2 & 0x20) != 0) {
            string5 = "";
        }
        if ((n2 & 0x40) != 0) {
            string6 = "";
        }
        if ((n2 & 0x80) != 0) {
            string7 = "";
        }
        if ((n2 & 0x100) != 0) {
            chatMessageStatus = ChatMessageStatus.Uninitialized;
        }
        this(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    public static /* synthetic */ ChatMessage copy$default(ChatMessage chatMessage, String string2, String string3, int n, Date date, String string4, String string5, String string6, String string7, ChatMessageStatus chatMessageStatus, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = chatMessage.topicId;
        }
        if ((n2 & 2) != 0) {
            string3 = chatMessage.senderUserId;
        }
        if ((n2 & 4) != 0) {
            n = chatMessage.seqId;
        }
        if ((n2 & 8) != 0) {
            date = chatMessage.date;
        }
        if ((n2 & 0x10) != 0) {
            string4 = chatMessage.text;
        }
        if ((n2 & 0x20) != 0) {
            string5 = chatMessage.type;
        }
        if ((n2 & 0x40) != 0) {
            string6 = chatMessage.subtype;
        }
        if ((n2 & 0x80) != 0) {
            string7 = chatMessage.replyTo;
        }
        if ((n2 & 0x100) != 0) {
            chatMessageStatus = chatMessage.status;
        }
        return chatMessage.copy(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    @NotNull
    public final String getTopicId() {
        return this.topicId;
    }

    @NotNull
    public final String getSenderUserId() {
        return this.senderUserId;
    }

    public final int getSeqId() {
        return this.seqId;
    }

    public final void setSeqId(int n) {
        this.seqId = n;
    }

    @Nullable
    public final Date getDate() {
        return this.date;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final String getReplyTo() {
        return this.replyTo;
    }

    @NotNull
    public final ChatMessageStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"<set-?>");
        this.status = chatMessageStatus;
    }

    @Nullable
    public final Map<String, String> getHead() {
        return this.head;
    }

    public final void setHead(@Nullable Map<String, String> map2) {
        this.head = map2;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.id = string2;
    }

    @Nullable
    public final TinodeContact getSender() {
        return this.sender;
    }

    public final void setSender(@Nullable TinodeContact tinodeContact) {
        this.sender = tinodeContact;
    }

    @Nullable
    public final Object getAnyData() {
        return this.anyData;
    }

    public final void setAnyData(@Nullable Object object) {
        this.anyData = object;
    }

    @Nullable
    public final List<ChatMessage> getReplyEmoji() {
        return this.replyEmoji;
    }

    public final void setReplyEmoji(@Nullable List<ChatMessage> list2) {
        this.replyEmoji = list2;
    }

    @NotNull
    public final ChatMessage updateStatus(@NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        this.status = chatMessageStatus;
        return this;
    }

    public final boolean isStatusSubType() {
        return ArraysKt.contains((Object[])new String[]{"left_chat", "join_chat"}, (Object)this.subtype);
    }

    @NotNull
    public final String component1() {
        return this.topicId;
    }

    @NotNull
    public final String component2() {
        return this.senderUserId;
    }

    public final int component3() {
        return this.seqId;
    }

    @Nullable
    public final Date component4() {
        return this.date;
    }

    @NotNull
    public final String component5() {
        return this.text;
    }

    @NotNull
    public final String component6() {
        return this.type;
    }

    @NotNull
    public final String component7() {
        return this.subtype;
    }

    @NotNull
    public final String component8() {
        return this.replyTo;
    }

    @NotNull
    public final ChatMessageStatus component9() {
        return this.status;
    }

    @NotNull
    public final ChatMessage copy(@NotNull String string2, @NotNull String string3, int n, @Nullable Date date, @NotNull String string4, @NotNull String string5, @NotNull String string6, @NotNull String string7, @NotNull ChatMessageStatus chatMessageStatus) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"topicId");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"senderUserId");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"text");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"type");
        Intrinsics.checkNotNullParameter((Object)string6, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)string7, (String)"replyTo");
        Intrinsics.checkNotNullParameter((Object)((Object)chatMessageStatus), (String)"status");
        return new ChatMessage(string2, string3, n, date, string4, string5, string6, string7, chatMessageStatus);
    }

    @NotNull
    public String toString() {
        return "ChatMessage(topicId=" + this.topicId + ", senderUserId=" + this.senderUserId + ", seqId=" + this.seqId + ", date=" + this.date + ", text=" + this.text + ", type=" + this.type + ", subtype=" + this.subtype + ", replyTo=" + this.replyTo + ", status=" + (Object)((Object)this.status) + ')';
    }

    public int hashCode() {
        ChatMessage chatMessage = this;
        int n = ((chatMessage.topicId.hashCode() * 31 + this.senderUserId.hashCode()) * 31 + Integer.hashCode(this.seqId)) * 31;
        Date date = chatMessage.date;
        int n2 = date == null ? 0 : date.hashCode();
        return (((((n + n2) * 31 + this.text.hashCode()) * 31 + this.type.hashCode()) * 31 + this.subtype.hashCode()) * 31 + this.replyTo.hashCode()) * 31 + this.status.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChatMessage)) {
            return false;
        }
        object = (ChatMessage)object;
        if (!Intrinsics.areEqual((Object)this.topicId, (Object)((ChatMessage)object).topicId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.senderUserId, (Object)((ChatMessage)object).senderUserId)) {
            return false;
        }
        if (this.seqId != ((ChatMessage)object).seqId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)((ChatMessage)object).date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((ChatMessage)object).text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((ChatMessage)object).type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subtype, (Object)((ChatMessage)object).subtype)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.replyTo, (Object)((ChatMessage)object).replyTo)) {
            return false;
        }
        return this.status == ((ChatMessage)object).status;
    }
}

