/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.video.voximplant.texture;

import android.graphics.SurfaceTexture;
import android.view.TextureView;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class TextureEglRenderer
extends EglRenderer
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "TextureEglRenderer";
    private RendererCommon.RendererEvents rendererEvents;
    private final Object layoutLock;
    private boolean isRenderingPaused;
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;

    public TextureEglRenderer(String string2) {
        super(string2);
        Object object;
        Object object2 = object;
        object = new Object();
        v1.layoutLock = object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame videoFrame) {
        TextureEglRenderer textureEglRenderer = this;
        Object object = textureEglRenderer.layoutLock;
        synchronized (object) {
            if (!textureEglRenderer.isRenderingPaused) {
                RendererCommon.RendererEvents rendererEvents;
                if (!this.isFirstFrameRendered) {
                    TextureEglRenderer textureEglRenderer2 = this;
                    textureEglRenderer2.isFirstFrameRendered = true;
                    textureEglRenderer2.logD("Reporting first rendered frame.");
                    rendererEvents = textureEglRenderer2.rendererEvents;
                    if (rendererEvents != null) {
                        rendererEvents.onFirstFrameRendered();
                    }
                }
                if (this.rotatedFrameWidth != videoFrame.getRotatedWidth() || this.rotatedFrameHeight != videoFrame.getRotatedHeight() || this.frameRotation != videoFrame.getRotation()) {
                    TextureEglRenderer textureEglRenderer3 = this;
                    textureEglRenderer3.logD("Reporting frame resolution changed to " + videoFrame.getBuffer().getWidth() + "x" + videoFrame.getBuffer().getHeight() + " with rotation " + videoFrame.getRotation());
                    rendererEvents = textureEglRenderer3.rendererEvents;
                    if (rendererEvents != null) {
                        VideoFrame videoFrame2 = videoFrame;
                        int n = videoFrame2.getBuffer().getWidth();
                        int n2 = videoFrame2.getBuffer().getHeight();
                        int n3 = videoFrame2.getRotation();
                        rendererEvents.onFrameResolutionChanged(n, n2, n3);
                    }
                    this.rotatedFrameWidth = videoFrame.getRotatedWidth();
                    this.rotatedFrameHeight = videoFrame.getRotatedHeight();
                    this.frameRotation = videoFrame.getRotation();
                }
            }
            return;
        }
    }

    private void logD(String string2) {
        Logging.d((String)TAG, (String)(this.name + ": " + string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(EglBase.Context object, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        Object object2 = object;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        object = this.layoutLock;
        TextureEglRenderer textureEglRenderer = this;
        synchronized (object) {
            textureEglRenderer.isFirstFrameRendered = false;
            textureEglRenderer.rotatedFrameWidth = 0;
            textureEglRenderer.rotatedFrameHeight = 0;
            textureEglRenderer.frameRotation = 0;
        }
        super.init((EglBase.Context)object2, nArray, glDrawer);
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, null, nArray, glDrawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float f) {
        Object object = this.layoutLock;
        synchronized (object) {
            boolean bl = f == 0.0f;
            this.isRenderingPaused = bl;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            super.setFpsReduction(f);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disableFpsReduction() {
        TextureEglRenderer textureEglRenderer = this;
        Object object = textureEglRenderer.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        super.disableFpsReduction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pauseVideo() {
        TextureEglRenderer textureEglRenderer = this;
        Object object = textureEglRenderer.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        super.pauseVideo();
    }

    public void onFrame(VideoFrame videoFrame) {
        TextureEglRenderer textureEglRenderer = this;
        textureEglRenderer.updateFrameDimensionsAndReportEvents(videoFrame);
        super.onFrame(videoFrame);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        this.logD("onSurfaceTextureAvailable: " + surfaceTexture + " size: " + n + "x" + n2);
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(surfaceTexture);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        this.logD("onSurfaceTextureSizeChanged: " + surfaceTexture + " size: " + n + "x" + n2);
        ThreadUtils.checkIsOnMainThread();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.logD("onSurfaceTextureDestroyed: " + surfaceTexture);
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.releaseEglSurface(countDownLatch::countDown);
        ThreadUtils.awaitUninterruptibly((CountDownLatch)countDownLatch);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }
}

