/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.extensions.ViewExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.baseball.BaseballSummary;
import io.streamlayer.sdk.model.sports.baseball.Hitting;
import io.streamlayer.sdk.model.sports.baseball.Pitching;
import io.streamlayer.sdk.statistics.baseball.BoxScoreItem;
import io.streamlayer.sdk.statistics.baseball.DividerItem;
import io.streamlayer.sdk.statistics.baseball.PointsItem;
import io.streamlayer.sdk.statistics.baseball.TeamItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001b\u001c\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "data", "", "Lio/streamlayer/sdk/statistics/baseball/BoxScoreItem;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "team", "Lio/streamlayer/sdk/model/sports/EventTeam;", "isHomeTeam", "", "summary", "Lio/streamlayer/sdk/model/sports/baseball/BaseballSummary;", "DividerViewHolder", "PointsViewHolder", "TeamViewHolder", "sdk_originalVoximplantRelease"})
public final class BaseballBoxScoreAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private List<? extends BoxScoreItem> data;

    public BaseballBoxScoreAdapter(@NotNull Context context) {
        BaseballBoxScoreAdapter baseballBoxScoreAdapter = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        baseballBoxScoreAdapter.context = context;
        baseballBoxScoreAdapter.data = CollectionsKt.emptyList();
    }

    public final void setData(@NotNull EventTeam iterator, boolean bl, @NotNull BaseballSummary object) {
        ArrayList<? extends BoxScoreItem> arrayList;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"team");
        Intrinsics.checkNotNullParameter((Object)object, (String)"summary");
        ArrayList<? extends BoxScoreItem> arrayList2 = arrayList;
        EventTeam eventTeam = iterator;
        iterator = eventTeam.getLogo();
        new ArrayList<BoxScoreItem>().add(new TeamItem((String)((Object)iterator), eventTeam.getName()));
        String string2 = this.context.getString(R.string.slr_statistics_baseball_box_score_hitting_title);
        iterator = string2;
        BaseballBoxScoreAdapter baseballBoxScoreAdapter = this;
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"context.getString(R.stri\u2026_box_score_hitting_title)");
        iterator = baseballBoxScoreAdapter.context.getString(R.string.slr_statistics_baseball_box_score_hitting_hits_per_bat);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"context.getString(R.stri\u2026ore_hitting_hits_per_bat)");
        Object object2 = baseballBoxScoreAdapter.context.getString(R.string.slr_statistics_baseball_box_score_hitting_runs);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.getString(R.stri\u2026l_box_score_hitting_runs)");
        String string3 = baseballBoxScoreAdapter.context.getString(R.string.slr_statistics_baseball_box_score_hitting_runs_batted_in);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026e_hitting_runs_batted_in)");
        String string4 = baseballBoxScoreAdapter.context.getString(R.string.slr_statistics_baseball_box_score_hitting_walks);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.stri\u2026_box_score_hitting_walks)");
        String string5 = baseballBoxScoreAdapter.context.getString(R.string.slr_statistics_baseball_box_score_hitting_batting_average);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.getString(R.stri\u2026_hitting_batting_average)");
        arrayList2.add(new PointsItem(string2, (String)((Object)iterator), (String)object2, string3, string4, string5, 0));
        iterator = (bl ? ((BaseballSummary)object).getHomeTeam().getHitting() : ((BaseballSummary)object).getAwayTeam().getHitting()).iterator();
        while (iterator.hasNext()) {
            Object object3 = object2 = (Hitting)iterator.next();
            object2 = ((Hitting)object3).getPlayerName();
            string3 = ((Hitting)object3).getHitsPerBat();
            string4 = ((Hitting)object3).getRuns();
            string5 = ((Hitting)object3).getRunsBattedIn();
            String string6 = ((Hitting)object3).getWalks();
            String string7 = ((Hitting)object3).getBattingAverage();
            arrayList2.add(new PointsItem((String)object2, string3, string4, string5, string6, string7, 2));
        }
        ArrayList<? extends BoxScoreItem> arrayList3 = arrayList2;
        arrayList3.add(new DividerItem(0, 1, null));
        String string8 = this.context.getString(R.string.slr_statistics_baseball_box_score_pitching_title);
        iterator = string8;
        BaseballBoxScoreAdapter baseballBoxScoreAdapter2 = this;
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"context.getString(R.stri\u2026box_score_pitching_title)");
        iterator = baseballBoxScoreAdapter2.context.getString(R.string.slr_statistics_baseball_box_score_pitching_innings_pitched);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"context.getString(R.stri\u2026pitching_innings_pitched)");
        Object object4 = baseballBoxScoreAdapter2.context.getString(R.string.slr_statistics_baseball_box_score_pitching_hits_by_pitch);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.getString(R.stri\u2026e_pitching_hits_by_pitch)");
        object2 = baseballBoxScoreAdapter2.context.getString(R.string.slr_statistics_baseball_box_score_pitching_earned_runs);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.getString(R.stri\u2026ore_pitching_earned_runs)");
        string3 = baseballBoxScoreAdapter2.context.getString(R.string.slr_statistics_baseball_box_score_pitching_walks);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026box_score_pitching_walks)");
        string4 = baseballBoxScoreAdapter2.context.getString(R.string.slr_statistics_baseball_box_score_pitching_strikeouts);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.stri\u2026core_pitching_strikeouts)");
        arrayList3.add(new PointsItem(string8, (String)((Object)iterator), (String)object4, (String)object2, string3, string4, 0));
        iterator = (bl ? ((BaseballSummary)object).getHomeTeam().getPitching() : ((BaseballSummary)object).getAwayTeam().getPitching()).iterator();
        while (iterator.hasNext()) {
            Object object5 = object4 = (Pitching)iterator.next();
            object4 = ((Pitching)object5).getPlayerName();
            object = ((Pitching)object5).getInningsPitched();
            object2 = ((Pitching)object5).getHitsByPitch();
            string3 = ((Pitching)object5).getEarnedRuns();
            string4 = ((Pitching)object5).getWalks();
            string5 = ((Pitching)object5).getStrikeouts();
            arrayList2.add(new PointsItem((String)object4, (String)object, (String)object2, string3, string4, string5, 2));
        }
        this.data = arrayList2;
        this.notifyDataSetChanged();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"parent");
        switch (n) {
            default: {
                throw new RuntimeException("Unsupported viewType: " + n);
            }
            case 3: {
                DividerViewHolder dividerViewHolder;
                viewHolder = dividerViewHolder;
                dividerViewHolder = new DividerViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_box_score_divider));
                break;
            }
            case 1: {
                TeamViewHolder teamViewHolder;
                viewHolder = teamViewHolder;
                teamViewHolder = new TeamViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_box_score_team));
                break;
            }
            case 0: 
            case 2: {
                PointsViewHolder pointsViewHolder;
                viewHolder = pointsViewHolder;
                pointsViewHolder = new PointsViewHolder(ViewExtensionsKt.inflate(viewGroup, R.layout.slr_item_statistics_baseball_box_score_points));
            }
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        return this.data.get(n).getViewType();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof TeamViewHolder && object instanceof TeamItem) {
            ((TeamViewHolder)viewHolder).bind((TeamItem)object);
        } else if (viewHolder instanceof PointsViewHolder && object instanceof PointsItem) {
            ((PointsViewHolder)viewHolder).bind((PointsItem)object);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter$TeamViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;Landroid/view/View;)V", "bind", "", "item", "Lio/streamlayer/sdk/statistics/baseball/TeamItem;", "sdk_originalVoximplantRelease"})
    public final class TeamViewHolder
    extends RecyclerView.ViewHolder {
        public TeamViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull TeamItem teamItem) {
            Intrinsics.checkNotNullParameter((Object)teamItem, (String)"item");
            View view2 = this.itemView;
            ImageView imageView2 = (ImageView)view2.findViewById(R.id.slBaseballBoxScoreTeamLogo);
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"slBaseballBoxScoreTeamLogo");
            ViewExtensionsKt.loadUrl$default(imageView2, teamItem.getIcon(), false, null, null, 12, null);
            ((TextView)view2.findViewById(R.id.slBaseballBoxScoreTeamName)).setText((CharSequence)teamItem.getName());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter$PointsViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;Landroid/view/View;)V", "bind", "", "item", "Lio/streamlayer/sdk/statistics/baseball/PointsItem;", "sdk_originalVoximplantRelease"})
    public final class PointsViewHolder
    extends RecyclerView.ViewHolder {
        public PointsViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }

        public final void bind(@NotNull PointsItem pointsItem) {
            PointsItem pointsItem2 = pointsItem;
            Intrinsics.checkNotNullParameter((Object)pointsItem, (String)"item");
            PointsViewHolder pointsViewHolder = pointsViewHolder.itemView;
            ((TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn1)).setText((CharSequence)pointsItem.getHitting());
            ((TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn2)).setText((CharSequence)pointsItem.getHitsPerBat());
            ((TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn3)).setText((CharSequence)pointsItem.getRuns());
            ((TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn4)).setText((CharSequence)pointsItem.getRunsBattedIn());
            ((TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn5)).setText((CharSequence)pointsItem.getWalks());
            ((TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn6)).setText((CharSequence)pointsItem.getBattingAverage());
            pointsItem = pointsViewHolder.getContext();
            int n = pointsItem2.getViewType() == 0 ? R.color.slr_white : R.color.slr_gray900;
            PointsViewHolder pointsViewHolder2 = pointsViewHolder;
            int n2 = ContextCompat.getColor((Context)pointsItem, (int)n);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn1)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn2)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn3)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn4)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn5)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn6)).setTextColor(n2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter$DividerViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;Landroid/view/View;)V", "sdk_originalVoximplantRelease"})
    public final class DividerViewHolder
    extends RecyclerView.ViewHolder {
        public DividerViewHolder(View view2) {
            Intrinsics.checkNotNullParameter((Object)view2, (String)"itemView");
            super(view2);
        }
    }
}

