/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.video;

import android.content.Context;
import com.voximplant.sdk.call.IVideoStream;
import io.streamlayer.common.data.video.VideoRenderer;
import io.streamlayer.common.data.video.voximplant.VoximplantCallManager;
import io.streamlayer.common.data.video.voximplant.VoximplantClientManager;
import io.streamlayer.common.data.video.voximplant.VoximplantSurfaceView;
import io.streamlayer.common.data.video.voximplant.VoximplantTextureView;
import io.streamlayer.common.data.video.voximplant.VoximplantVideoStreamProvider;
import io.streamlayer.common.extensions.OtherExtensionsKt;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.model.auth.User;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/common/data/video/VoximplantVideoCall;", "Lio/streamlayer/common/data/video/voximplant/VoximplantCallManager;", "Lio/streamlayer/common/data/video/voximplant/VoximplantVideoStreamProvider;", "eglBase", "Lorg/webrtc/EglBase;", "session", "Lio/streamlayer/common/session/Session;", "clientManager", "Lio/streamlayer/common/data/video/voximplant/VoximplantClientManager;", "context", "Landroid/content/Context;", "(Lorg/webrtc/EglBase;Lio/streamlayer/common/session/Session;Lio/streamlayer/common/data/video/voximplant/VoximplantClientManager;Landroid/content/Context;)V", "getEglBase", "()Lorg/webrtc/EglBase;", "create", "Lio/streamlayer/common/data/video/VideoRenderer;", "getStream", "Lcom/voximplant/sdk/call/IVideoStream;", "userId", "", "isLocal", "", "sdk_originalVoximplantRelease"})
final class VoximplantVideoCall
extends VoximplantCallManager
implements VoximplantVideoStreamProvider {
    @NotNull
    private final EglBase eglBase;
    @NotNull
    private final Session session;

    public VoximplantVideoCall(@NotNull EglBase eglBase, @NotNull Session session2, @NotNull VoximplantClientManager voximplantClientManager, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)eglBase, (String)"eglBase");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)voximplantClientManager, (String)"clientManager");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(voximplantClientManager, session2, context);
        this.eglBase = eglBase;
        this.session = session2;
    }

    @Override
    @NotNull
    public EglBase getEglBase() {
        return this.eglBase;
    }

    @Override
    @NotNull
    public VideoRenderer create(@NotNull Context context) {
        VideoRenderer videoRenderer;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (OtherExtensionsKt.isScreenPortrait(context2)) {
            VoximplantSurfaceView voximplantSurfaceView;
            videoRenderer = voximplantSurfaceView;
            new VoximplantSurfaceView(context, null, 2, null).setVideoStreamProvider(this);
        } else {
            VoximplantTextureView voximplantTextureView;
            videoRenderer = voximplantTextureView;
            new VoximplantTextureView(context, null, 2, null).setVideoStreamProvider(this);
        }
        return videoRenderer;
    }

    @Override
    @Nullable
    public IVideoStream getStream(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"userId");
        return this.getVideosCache().get(string2);
    }

    @Override
    public boolean isLocal(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"userId");
        User user2 = ((VoximplantVideoCall)((Object)user2)).session.getUser();
        return Intrinsics.areEqual((Object)(user2 != null ? user2.getId() : null), (Object)string2);
    }
}

